/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JList;

public class ListRolloverSelectionAdapter
extends MouseMotionAdapter {
    private final JList list;

    public ListRolloverSelectionAdapter(JList list) {
        this.list = list;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int index;
        if (this.list.isEnabled() && (index = this.list.locationToIndex(e.getPoint())) != this.list.getSelectedIndex()) {
            this.list.setSelectedIndex(index);
        }
    }

    public static ListRolloverSelectionAdapter install(JList list) {
        ListRolloverSelectionAdapter.uninstall(list);
        ListRolloverSelectionAdapter adapter = new ListRolloverSelectionAdapter(list);
        list.addMouseMotionListener(adapter);
        return adapter;
    }

    public static void uninstall(JList list) {
        for (MouseMotionListener listener : list.getMouseMotionListeners()) {
            if (!(listener instanceof ListRolloverSelectionAdapter)) continue;
            list.removeMouseMotionListener(listener);
        }
    }

    public static boolean isInstalled(JList list) {
        for (MouseMotionListener listener : list.getMouseMotionListeners()) {
            if (!(listener instanceof ListRolloverSelectionAdapter)) continue;
            return true;
        }
        return false;
    }
}

