/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.extended.layout.ToolbarLayout;
import com.alee.global.StyleConstants;
import com.alee.laf.menu.MenuBarStyle;
import com.alee.laf.menu.WebMenuBarStyle;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.BorderMethods;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

public class WebMenuBarUI
extends BasicMenuBarUI
implements ShapeProvider,
BorderMethods {
    private Color topBgColor = WebMenuBarStyle.topBgColor;
    private Color bottomBgColor = WebMenuBarStyle.bottomBgColor;
    private boolean undecorated = WebMenuBarStyle.undecorated;
    private int round = WebMenuBarStyle.round;
    private int shadeWidth = WebMenuBarStyle.shadeWidth;
    private MenuBarStyle menuBarStyle = WebMenuBarStyle.menuBarStyle;
    private Color borderColor = WebMenuBarStyle.borderColor;

    public static ComponentUI createUI(JComponent c) {
        return new WebMenuBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.menuBar);
        LookAndFeel.installProperty(this.menuBar, "opaque", Boolean.FALSE);
        this.menuBar.setLayout(new ToolbarLayout(0));
        this.updateBorder();
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.menuBar, this.getShadeWidth(), this.getRound());
    }

    @Override
    public void updateBorder() {
        if (SwingUtils.isPreserveBorders(this.menuBar)) {
            return;
        }
        Insets insets = !this.undecorated ? (this.menuBarStyle.equals((Object)MenuBarStyle.attached) ? new Insets(0, 0, 1 + this.shadeWidth, 0) : new Insets(1 + this.shadeWidth, 1 + this.shadeWidth, 1 + this.shadeWidth, 1 + this.shadeWidth)) : new Insets(0, 0, 0, 0);
        this.menuBar.setBorder(LafUtils.createWebBorder(insets));
    }

    public Color getTopBgColor() {
        return this.topBgColor;
    }

    public void setTopBgColor(Color topBgColor) {
        this.topBgColor = topBgColor;
    }

    public Color getBottomBgColor() {
        return this.bottomBgColor;
    }

    public void setBottomBgColor(Color bottomBgColor) {
        this.bottomBgColor = bottomBgColor;
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean undecorated) {
        this.undecorated = undecorated;
        this.updateBorder();
    }

    public MenuBarStyle getMenuBarStyle() {
        return this.menuBarStyle;
    }

    public void setMenuBarStyle(MenuBarStyle menuBarStyle) {
        this.menuBarStyle = menuBarStyle;
        this.updateBorder();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateBorder();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (!this.undecorated) {
            Graphics2D g2d = (Graphics2D)g;
            if (this.menuBarStyle == MenuBarStyle.attached) {
                Line2D.Double border = new Line2D.Double(0.0, c.getHeight() - 1 - this.shadeWidth, c.getWidth() - 1, c.getHeight() - 1 - this.shadeWidth);
                GraphicsUtils.drawShade(g2d, border, StyleConstants.shadeColor, this.shadeWidth);
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.topBgColor, 0.0f, c.getHeight(), this.bottomBgColor));
                g2d.fillRect(0, 0, c.getWidth(), c.getHeight() - this.shadeWidth);
                g2d.setPaint(this.borderColor);
                g2d.draw(border);
            } else {
                LafUtils.drawWebStyle(g2d, c, StyleConstants.shadeColor, this.shadeWidth, this.round, true, true, this.borderColor);
            }
        }
    }
}

