/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.laf.table.WebTable;
import com.alee.laf.table.WebTableCorner;
import com.alee.laf.table.WebTableStyle;
import com.alee.laf.table.editors.WebBooleanEditor;
import com.alee.laf.table.editors.WebDateEditor;
import com.alee.laf.table.editors.WebGenericEditor;
import com.alee.laf.table.editors.WebNumberEditor;
import com.alee.laf.table.renderers.WebBooleanRenderer;
import com.alee.laf.table.renderers.WebDateRenderer;
import com.alee.laf.table.renderers.WebDoubleRenderer;
import com.alee.laf.table.renderers.WebIconRenderer;
import com.alee.laf.table.renderers.WebNumberRenderer;
import com.alee.laf.table.renderers.WebTableCellRenderer;
import com.alee.managers.tooltip.ToolTipProvider;
import com.alee.utils.CompareUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.AncestorAdapter;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.event.AncestorEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;

public class WebTableUI
extends BasicTableUI {
    protected AncestorAdapter ancestorAdapter;
    protected MouseAdapter mouseAdapter;
    private Color scrollPaneBackgroundColor = WebTableStyle.scrollPaneBackgroundColor;
    protected Point rolloverCell;

    public Color getScrollPaneBackgroundColor() {
        return this.scrollPaneBackgroundColor;
    }

    public void setScrollPaneBackgroundColor(Color scrollPaneBackgroundColor) {
        this.scrollPaneBackgroundColor = scrollPaneBackgroundColor;
    }

    public static ComponentUI createUI(JComponent c) {
        return new WebTableUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.table);
        LookAndFeel.installProperty(this.table, "opaque", Boolean.FALSE);
        this.table.setFillsViewportHeight(false);
        this.table.setBackground(WebTableStyle.background);
        this.table.setForeground(WebTableStyle.foreground);
        this.table.setSelectionBackground(WebTableStyle.selectionBackground);
        this.table.setSelectionForeground(WebTableStyle.selectionForeground);
        this.table.setRowHeight(WebTableStyle.rowHeight);
        this.table.setShowHorizontalLines(WebTableStyle.showHorizontalLines);
        this.table.setShowVerticalLines(WebTableStyle.showVerticalLines);
        this.table.setIntercellSpacing(WebTableStyle.cellsSpacing);
        this.table.setDefaultRenderer(Object.class, new WebTableCellRenderer());
        this.table.setDefaultRenderer(Number.class, new WebNumberRenderer());
        this.table.setDefaultRenderer(Double.class, new WebDoubleRenderer());
        this.table.setDefaultRenderer(Float.class, new WebDoubleRenderer());
        this.table.setDefaultRenderer(Date.class, new WebDateRenderer());
        this.table.setDefaultRenderer(Icon.class, new WebIconRenderer());
        this.table.setDefaultRenderer(ImageIcon.class, new WebIconRenderer());
        this.table.setDefaultRenderer(Boolean.class, new WebBooleanRenderer());
        this.table.setDefaultEditor(Object.class, new WebGenericEditor());
        this.table.setDefaultEditor(Number.class, new WebNumberEditor());
        this.table.setDefaultEditor(Boolean.class, new WebBooleanEditor());
        this.table.setDefaultEditor(Date.class, new WebDateEditor());
        this.configureEnclosingScrollPaneUI(this.table);
        this.ancestorAdapter = new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                WebTableUI.this.configureEnclosingScrollPaneUI(WebTableUI.this.table);
            }
        };
        this.table.addAncestorListener(this.ancestorAdapter);
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                this.updateMouseover(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.updateMouseover(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.clearMouseover();
            }

            private void updateMouseover(MouseEvent e) {
                Point point = e.getPoint();
                Point cell = new Point(WebTableUI.this.table.columnAtPoint(point), WebTableUI.this.table.rowAtPoint(point));
                if (cell.x != -1 && cell.y != -1) {
                    if (!CompareUtils.equals(WebTableUI.this.rolloverCell, cell)) {
                        this.updateRolloverCell(WebTableUI.this.rolloverCell, cell);
                    }
                } else {
                    this.clearMouseover();
                }
            }

            private void clearMouseover() {
                if (WebTableUI.this.rolloverCell != null) {
                    this.updateRolloverCell(WebTableUI.this.rolloverCell, null);
                }
            }

            private void updateRolloverCell(Point oldCell, Point newCell) {
                WebTableUI.this.rolloverCell = newCell;
                ToolTipProvider<? extends WebTable> provider = WebTableUI.this.getToolTipProvider();
                if (provider != null) {
                    int oldIndex = oldCell != null ? oldCell.y : -1;
                    int oldColumn = oldCell != null ? oldCell.x : -1;
                    int newIndex = newCell != null ? newCell.y : -1;
                    int newColumn = newCell != null ? newCell.x : -1;
                    provider.rolloverCellChanged((WebTable)WebTableUI.this.table, oldIndex, oldColumn, newIndex, newColumn);
                }
            }
        };
        this.table.addMouseListener(this.mouseAdapter);
        this.table.addMouseMotionListener(this.mouseAdapter);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.table.removeMouseListener(this.mouseAdapter);
        this.table.removeMouseMotionListener(this.mouseAdapter);
        this.table.removeAncestorListener(this.ancestorAdapter);
        super.uninstallUI(c);
    }

    protected ToolTipProvider<? extends WebTable> getToolTipProvider() {
        return this.table != null && this.table instanceof WebTable ? ((WebTable)this.table).getToolTipProvider() : null;
    }

    protected void configureEnclosingScrollPaneUI(JTable table) {
        JScrollPane scrollPane = SwingUtils.getScrollPane(table);
        if (scrollPane != null) {
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != table) {
                return;
            }
            scrollPane.getViewport().setBackground(this.scrollPaneBackgroundColor);
            scrollPane.setCorner("UPPER_LEADING_CORNER", new WebTableCorner(false));
            scrollPane.setCorner("UPPER_TRAILING_CORNER", new WebTableCorner(true));
        }
    }
}

