/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.hotkey;

import com.alee.laf.label.WebLabel;
import com.alee.managers.hotkey.ButtonHotkeyRunnable;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyCondition;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.hotkey.HotkeyInfo;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.language.data.TooltipWay;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.compare.Filter;
import com.alee.utils.text.TextProvider;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

public class HotkeyManager {
    public static final String COMPONENT_HOTKEYS_LIST_KEY = "hotkeys.list";
    public static final String CONTAINER_HOTKEY_CONDITIONS_LIST_KEY = "hotkey.conditions.list";
    protected static final String HOTKEYS_SEPARATOR = ", ";
    protected static final TextProvider<HotkeyInfo> HOTKEY_TEXT_PROVIDER = new TextProvider<HotkeyInfo>(){

        @Override
        public String provide(HotkeyInfo object) {
            return object.getHotkeyData().toString();
        }
    };
    protected static final Filter<HotkeyInfo> HOTKEY_DISPLAY_FILTER = new Filter<HotkeyInfo>(){

        @Override
        public boolean accept(HotkeyInfo object) {
            return !object.isHidden();
        }
    };
    protected static final Object sync = new Object();
    protected static boolean hotkeysEnabled = true;
    protected static boolean transferFocus = false;
    protected static Map<JComponent, WeakReference<List<HotkeyInfo>>> hotkeys = new WeakHashMap<JComponent, WeakReference<List<HotkeyInfo>>>();
    protected static List<HotkeyInfo> globalHotkeys = new ArrayList<HotkeyInfo>(2);
    protected static Map<JComponent, WeakReference<List<HotkeyCondition>>> containerConditions = new WeakHashMap<JComponent, WeakReference<List<HotkeyCondition>>>();
    protected static boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            XmlUtils.processAnnotations(HotkeyData.class);
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (hotkeysEnabled && event instanceof KeyEvent) {
                        KeyEvent e = (KeyEvent)event;
                        if (e.isConsumed() || e.getID() != 401) {
                            return;
                        }
                        if (!HotkeyManager.hotkeyForEventExists(e)) {
                            return;
                        }
                        HotkeyManager.processHotkeys(e);
                    }
                }
            }, 8L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<Component, List<HotkeyInfo>> copyComponentHotkeys() {
        Object object = sync;
        synchronized (object) {
            HashMap<Component, List<HotkeyInfo>> copy = new HashMap<Component, List<HotkeyInfo>>(hotkeys.size());
            for (Map.Entry<JComponent, WeakReference<List<HotkeyInfo>>> entry : hotkeys.entrySet()) {
                List hotkeys;
                JComponent component = entry.getKey();
                WeakReference<List<HotkeyInfo>> value = entry.getValue();
                List list = hotkeys = value != null ? (List)value.get() : null;
                if (component == null || hotkeys == null || hotkeys.isEmpty()) continue;
                copy.put(component, CollectionUtils.copy(hotkeys));
            }
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<JComponent, List<HotkeyCondition>> copyContainerConditions() {
        Object object = sync;
        synchronized (object) {
            HashMap<JComponent, List<HotkeyCondition>> copy = new HashMap<JComponent, List<HotkeyCondition>>(containerConditions.size());
            for (Map.Entry<JComponent, WeakReference<List<HotkeyCondition>>> entry : containerConditions.entrySet()) {
                List conditions;
                JComponent component = entry.getKey();
                WeakReference<List<HotkeyCondition>> value = entry.getValue();
                List list = conditions = value != null ? (List)value.get() : null;
                if (component == null || conditions == null || conditions.isEmpty()) continue;
                copy.put(component, conditions);
            }
            return copy;
        }
    }

    protected static boolean hotkeyForEventExists(KeyEvent keyEvent) {
        int hotkeyHash = SwingUtils.hotkeyToString(keyEvent).hashCode();
        for (HotkeyInfo hotkeyInfo : globalHotkeys) {
            if (hotkeyInfo.getHotkeyData().hashCode() != hotkeyHash) continue;
            return true;
        }
        for (Map.Entry entry : HotkeyManager.copyComponentHotkeys().entrySet()) {
            for (HotkeyInfo hotkeyInfo : (List)entry.getValue()) {
                if (hotkeyInfo.getHotkeyData().hashCode() != hotkeyHash) continue;
                return true;
            }
        }
        return false;
    }

    protected static void processHotkeys(KeyEvent e) {
        Map<Component, List<HotkeyInfo>> hotkeysCopy = HotkeyManager.copyComponentHotkeys();
        for (HotkeyInfo hotkeyInfo : globalHotkeys) {
            HotkeyManager.processHotkey(e, hotkeyInfo);
        }
        for (Map.Entry entry : hotkeysCopy.entrySet()) {
            for (HotkeyInfo hotkeyInfo : (List)entry.getValue()) {
                HotkeyManager.processHotkey(e, hotkeyInfo);
            }
        }
    }

    protected static void processHotkey(KeyEvent e, HotkeyInfo hotkeyInfo) {
        JComponent forComponent = hotkeyInfo.getForComponent();
        if (forComponent == null) {
            if (hotkeyInfo.getHotkeyData().isTriggered(e) && hotkeyInfo.getAction() != null) {
                SwingUtils.invokeLater(hotkeyInfo.getAction(), e);
            }
        } else {
            Component topComponent = hotkeyInfo.getTopComponent();
            Component component = topComponent = topComponent != null ? topComponent : SwingUtils.getWindowAncestor(forComponent);
            if (SwingUtils.hasFocusOwner(topComponent) && hotkeyInfo.getHotkeyData().isTriggered(e) && hotkeyInfo.getAction() != null && HotkeyManager.meetsParentConditions(forComponent)) {
                if (transferFocus) {
                    ((Component)forComponent).requestFocusInWindow();
                }
                SwingUtils.invokeLater(hotkeyInfo.getAction(), e);
            }
        }
    }

    protected static boolean meetsParentConditions(Component forComponent) {
        for (Map.Entry<JComponent, List<HotkeyCondition>> entry : HotkeyManager.copyContainerConditions().entrySet()) {
            if (!entry.getKey().isAncestorOf(forComponent)) continue;
            for (HotkeyCondition condition : entry.getValue()) {
                if (condition.checkCondition(forComponent)) continue;
                return false;
            }
        }
        return true;
    }

    public static HotkeyInfo registerHotkey(HotkeyData hotkeyData, HotkeyRunnable action) {
        HotkeyInfo hotkeyInfo = new HotkeyInfo();
        hotkeyInfo.setHidden(true);
        hotkeyInfo.setHotkeyData(hotkeyData);
        hotkeyInfo.setAction(action);
        HotkeyManager.cacheHotkey(hotkeyInfo);
        return hotkeyInfo;
    }

    public static HotkeyInfo registerHotkey(JComponent forComponent, HotkeyData hotkeyData, HotkeyRunnable action) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData, action);
    }

    public static HotkeyInfo registerHotkey(JComponent forComponent, HotkeyData hotkeyData, HotkeyRunnable action, boolean hidden) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData, action, hidden);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, JComponent forComponent, HotkeyData hotkeyData, HotkeyRunnable action) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, action, false);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, JComponent forComponent, HotkeyData hotkeyData, HotkeyRunnable action, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, action, false, tooltipWay);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, JComponent forComponent, HotkeyData hotkeyData, HotkeyRunnable action, boolean hidden) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, action, hidden, null);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, JComponent forComponent, HotkeyData hotkeyData, HotkeyRunnable action, boolean hidden, TooltipWay tooltipWay) {
        HotkeyInfo hotkeyInfo = new HotkeyInfo();
        hotkeyInfo.setHidden(hidden);
        hotkeyInfo.setTopComponent(topComponent);
        hotkeyInfo.setForComponent(forComponent);
        hotkeyInfo.setHotkeyData(hotkeyData);
        hotkeyInfo.setHotkeyDisplayWay(tooltipWay);
        hotkeyInfo.setAction(action);
        HotkeyManager.cacheHotkey(hotkeyInfo);
        return hotkeyInfo;
    }

    public static HotkeyInfo registerHotkey(AbstractButton forComponent, HotkeyData hotkeyData) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData);
    }

    public static HotkeyInfo registerHotkey(AbstractButton forComponent, HotkeyData hotkeyData, boolean hidden) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData, hidden);
    }

    public static HotkeyInfo registerHotkey(AbstractButton forComponent, HotkeyData hotkeyData, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData, tooltipWay);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, AbstractButton forComponent, HotkeyData hotkeyData) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, false);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, AbstractButton forComponent, HotkeyData hotkeyData, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, HotkeyManager.createAction(forComponent), false, tooltipWay);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, AbstractButton forComponent, HotkeyData hotkeyData, boolean hidden) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, HotkeyManager.createAction(forComponent), hidden, null);
    }

    protected static HotkeyRunnable createAction(AbstractButton forComponent) {
        return new ButtonHotkeyRunnable(forComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setComponentHotkeyDisplayWay(JComponent component, TooltipWay tooltipWay) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyInfo> hotkeys = HotkeyManager.getComponentHotkeysCache(component);
            if (hotkeys != null) {
                for (HotkeyInfo hotkeyInfo : hotkeys) {
                    hotkeyInfo.setHotkeyDisplayWay(tooltipWay);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addContainerHotkeyCondition(JComponent container, HotkeyCondition hotkeyCondition) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyCondition> clist = HotkeyManager.getContainerHotkeyConditionsCache(container);
            if (clist == null) {
                clist = new ArrayList<HotkeyCondition>(1);
                container.putClientProperty(CONTAINER_HOTKEY_CONDITIONS_LIST_KEY, clist);
                containerConditions.put(container, new WeakReference<List<HotkeyCondition>>(clist));
            }
            clist.add(hotkeyCondition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContainerHotkeyCondition(JComponent container, HotkeyCondition hotkeyCondition) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyCondition> clist = HotkeyManager.getContainerHotkeyConditionsCache(container);
            if (clist != null) {
                clist.remove(hotkeyCondition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContainerHotkeyConditions(JComponent container, List<HotkeyCondition> hotkeyConditions) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyCondition> clist = HotkeyManager.getContainerHotkeyConditionsCache(container);
            if (clist != null) {
                clist.removeAll(hotkeyConditions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContainerHotkeyConditions(JComponent container) {
        Object object = sync;
        synchronized (object) {
            container.putClientProperty(CONTAINER_HOTKEY_CONDITIONS_LIST_KEY, null);
            containerConditions.remove(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<HotkeyCondition> getContainerHotkeyConditionsCache(JComponent container) {
        Object object = sync;
        synchronized (object) {
            WeakReference<List<HotkeyCondition>> reference = containerConditions.get(container);
            return reference != null ? (List)reference.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HotkeyCondition> getContainerHotkeyConditions(JComponent container) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyCondition> list = HotkeyManager.getContainerHotkeyConditionsCache(container);
            return list != null ? CollectionUtils.copy(list) : new ArrayList<HotkeyCondition>();
        }
    }

    public static void unregisterHotkey(HotkeyInfo hotkeyInfo) {
        HotkeyManager.clearHotkeyCache(hotkeyInfo);
    }

    public static void unregisterHotkeys(JComponent component) {
        HotkeyManager.clearHotkeysCache(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cacheHotkey(HotkeyInfo hotkeyInfo) {
        Object object = sync;
        synchronized (object) {
            JComponent forComponent = hotkeyInfo.getForComponent();
            if (forComponent != null) {
                List<HotkeyInfo> hlist = HotkeyManager.getComponentHotkeysCache(hotkeyInfo.getForComponent());
                if (hlist == null) {
                    hlist = new ArrayList<HotkeyInfo>(1);
                    forComponent.putClientProperty(COMPONENT_HOTKEYS_LIST_KEY, hlist);
                    hotkeys.put(forComponent, new WeakReference<List<HotkeyInfo>>(hlist));
                }
                hlist.add(hotkeyInfo);
            } else if (!globalHotkeys.contains(hotkeyInfo)) {
                globalHotkeys.add(hotkeyInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearHotkeyCache(HotkeyInfo hotkeyInfo) {
        if (hotkeyInfo != null) {
            Object object = sync;
            synchronized (object) {
                JComponent forComponent = hotkeyInfo.getForComponent();
                if (forComponent != null) {
                    List<HotkeyInfo> hlist = HotkeyManager.getComponentHotkeysCache(forComponent);
                    if (hlist != null) {
                        hlist.remove(hotkeyInfo);
                    }
                } else {
                    globalHotkeys.remove(hotkeyInfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearHotkeysCache(List<HotkeyInfo> hotkeysInfo) {
        if (hotkeysInfo != null && !hotkeysInfo.isEmpty()) {
            Object object = sync;
            synchronized (object) {
                for (HotkeyInfo hotkeyInfo : hotkeysInfo) {
                    HotkeyManager.clearHotkeyCache(hotkeyInfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearHotkeysCache(JComponent component) {
        Object object = sync;
        synchronized (object) {
            component.putClientProperty(COMPONENT_HOTKEYS_LIST_KEY, null);
            hotkeys.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<HotkeyInfo> getComponentHotkeysCache(JComponent forComponent) {
        Object object = sync;
        synchronized (object) {
            WeakReference<List<HotkeyInfo>> reference = hotkeys.get(forComponent);
            return reference != null ? (List)reference.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HotkeyInfo> getComponentHotkeys(JComponent component) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyInfo> list = HotkeyManager.getComponentHotkeysCache(component);
            return list != null ? CollectionUtils.copy(list) : new ArrayList<HotkeyInfo>();
        }
    }

    public static void showComponentHotkeys() {
        TooltipManager.hideAllTooltips();
        for (Window window : Window.getWindows()) {
            HotkeyManager.showComponentHotkeys(window);
        }
    }

    public static void showComponentHotkeys(Component component) {
        TooltipManager.hideAllTooltips();
        HotkeyManager.showComponentHotkeys(SwingUtils.getWindowAncestor(component));
    }

    protected static void showComponentHotkeys(Window window) {
        LinkedHashSet<JComponent> shown = new LinkedHashSet<JComponent>();
        for (Map.Entry<Component, List<HotkeyInfo>> entry : HotkeyManager.copyComponentHotkeys().entrySet()) {
            for (HotkeyInfo hotkeyInfo : entry.getValue()) {
                JComponent forComponent;
                if (hotkeyInfo.isHidden() || (forComponent = hotkeyInfo.getForComponent()) == null || shown.contains(forComponent) || !forComponent.isVisible() || !forComponent.isShowing() || SwingUtils.getWindowAncestor(forComponent) != window) continue;
                WebLabel tip = new WebLabel(HotkeyManager.getComponentHotkeysString(forComponent));
                tip.setStyleId("custom-tooltip-hotkey-label");
                tip.setBoldFont();
                TooltipManager.showOneTimeTooltip((Component)forComponent, null, tip, hotkeyInfo.getHotkeyDisplayWay());
                shown.add(forComponent);
            }
        }
    }

    public static void installShowAllHotkeysAction(JComponent topComponent) {
        HotkeyManager.installShowAllHotkeysAction(topComponent, Hotkey.F1);
    }

    public static void installShowAllHotkeysAction(final JComponent topComponent, HotkeyData hotkeyData) {
        HotkeyManager.registerHotkey((Component)topComponent, topComponent, hotkeyData, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent e) {
                HotkeyManager.showComponentHotkeys(topComponent);
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getComponentHotkeysString(JComponent component) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyInfo> hotkeys = HotkeyManager.getComponentHotkeysCache(component);
            return TextUtils.listToString(hotkeys, HOTKEYS_SEPARATOR, HOTKEY_TEXT_PROVIDER, HOTKEY_DISPLAY_FILTER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableHotkeys() {
        Object object = sync;
        synchronized (object) {
            hotkeysEnabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableHotkeys() {
        Object object = sync;
        synchronized (object) {
            hotkeysEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTransferFocus() {
        Object object = sync;
        synchronized (object) {
            return transferFocus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTransferFocus(boolean transferFocus) {
        Object object = sync;
        synchronized (object) {
            HotkeyManager.transferFocus = transferFocus;
        }
    }
}

