/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.plugin.data;

import com.alee.managers.plugin.Plugin;
import com.alee.managers.plugin.data.PluginInformation;
import com.alee.managers.plugin.data.PluginStatus;
import java.io.File;
import javax.swing.ImageIcon;

public class DetectedPlugin<T extends Plugin> {
    private final String pluginFolder;
    private final String pluginFileName;
    private final PluginInformation information;
    private final ImageIcon logo;
    private PluginStatus status;
    private String failureCause;
    private Throwable exception;
    private String exceptionMessage;
    private T plugin;

    public DetectedPlugin(String pluginFolder, String pluginFileName, PluginInformation information, ImageIcon logo) {
        this.pluginFolder = pluginFolder;
        this.pluginFileName = pluginFileName;
        this.information = information;
        this.logo = logo;
        this.status = PluginStatus.detected;
    }

    public String getPluginFolder() {
        return this.pluginFolder;
    }

    public String getPluginFileName() {
        return this.pluginFileName;
    }

    public File getFile() {
        return new File(this.pluginFolder, this.pluginFileName);
    }

    public PluginInformation getInformation() {
        return this.information;
    }

    public ImageIcon getLogo() {
        return this.logo;
    }

    public PluginStatus getStatus() {
        return this.status;
    }

    public void setStatus(PluginStatus status) {
        this.status = status;
    }

    public String getFailureCause() {
        return this.failureCause;
    }

    public void setFailureCause(String failureCause) {
        this.failureCause = failureCause;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public String getFailureHtmlText() {
        return "<html><b>" + this.failureCause + "</b>" + (this.exceptionMessage != null || this.exception != null ? "<br>" + (this.exceptionMessage != null ? this.exceptionMessage : this.exception.toString()) : "") + "</html>";
    }

    public T getPlugin() {
        return this.plugin;
    }

    public void setPlugin(T plugin) {
        this.plugin = plugin;
    }

    public String toString() {
        return this.information + ", Status: " + (Object)((Object)this.status) + (this.status == PluginStatus.failed ? ", Cause: " + this.failureCause : "");
    }
}

