/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.popup;

import com.alee.extended.painter.Painter;
import com.alee.managers.popup.PopupLayer;
import com.alee.managers.popup.PopupStyle;
import com.alee.managers.popup.ShadeLayer;
import com.alee.managers.popup.WebPopup;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;

public class PopupManager {
    protected static final Map<JRootPane, ShadeLayer> shadeLayers = new HashMap<JRootPane, ShadeLayer>();
    protected static final Map<JRootPane, PopupLayer> popupLayers = new HashMap<JRootPane, PopupLayer>();
    protected static PopupStyle defaultPopupStyle = PopupStyle.bordered;

    public static void hideAllPopups() {
        for (ShadeLayer shadeLayer : shadeLayers.values()) {
            shadeLayer.hideAllPopups();
        }
        for (PopupLayer popupLayer : popupLayers.values()) {
            popupLayer.hideAllPopups();
        }
    }

    public static void hideAllPopups(JComponent component) {
        PopupManager.hideAllPopups(SwingUtils.getRootPane(component));
    }

    public static void hideAllPopups(JRootPane rootPane) {
        if (shadeLayers.containsKey(rootPane)) {
            shadeLayers.get(rootPane).hideAllPopups();
        }
        if (popupLayers.containsKey(rootPane)) {
            popupLayers.get(rootPane).hideAllPopups();
        }
    }

    public static PopupStyle getDefaultPopupStyle() {
        return defaultPopupStyle;
    }

    public static void setDefaultPopupStyle(PopupStyle style) {
        defaultPopupStyle = style;
    }

    public static Painter getDefaultPopupPainter() {
        return defaultPopupStyle.getPainter();
    }

    public static void showPopup(Component component, WebPopup popup) {
        PopupManager.showPopup(component, popup, true);
    }

    public static void showPopup(Component component, WebPopup popup, boolean transferFocus) {
        JRootPane rootPane = SwingUtils.getRootPane(component);
        if (rootPane != null) {
            PopupManager.showPopup(rootPane, popup, transferFocus);
        }
    }

    public static void showPopup(JRootPane rootPane, WebPopup popup, boolean transferFocus) {
        PopupManager.getPopupLayer(rootPane).showPopup(popup);
        if (transferFocus) {
            popup.transferFocus();
        }
    }

    public static void showModalPopup(Component component, WebPopup popup, boolean hfill, boolean vfill) {
        PopupManager.showModalPopup(component, popup, hfill, vfill, false);
    }

    public static void showModalPopup(Component component, WebPopup popup, boolean hfill, boolean vfill, boolean blockClose) {
        JRootPane rootPane = SwingUtils.getRootPane(component);
        if (rootPane != null) {
            PopupManager.showModalPopup(rootPane, popup, hfill, vfill, blockClose);
        }
    }

    public static void showModalPopup(JRootPane rootPane, WebPopup popup, boolean hfill, boolean vfill) {
        PopupManager.showModalPopup(rootPane, popup, hfill, vfill, false);
    }

    public static void showModalPopup(JRootPane rootPane, WebPopup popup, boolean hfill, boolean vfill, boolean blockClose) {
        PopupManager.hideAllPopups(rootPane);
        ShadeLayer shadeLayer = PopupManager.getShadeLayer(rootPane);
        shadeLayer.setBlockClose(blockClose);
        shadeLayer.showPopup(popup, hfill, vfill);
        popup.transferFocus();
    }

    public static PopupLayer getPopupLayer(Component component) {
        return PopupManager.getPopupLayer(SwingUtils.getRootPane(component));
    }

    public static PopupLayer getPopupLayer(JRootPane rootPane) {
        if (rootPane == null) {
            throw new RuntimeException("JRootPane for PopupLayer cannot be found");
        }
        if (popupLayers.containsKey(rootPane)) {
            return popupLayers.get(rootPane);
        }
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        if (layeredPane == null) {
            throw new RuntimeException("Popup layer can be installed only into window or applet with JLayeredPane");
        }
        PopupLayer popupLayer = new PopupLayer();
        PopupManager.installPopupLayer(popupLayer, rootPane, layeredPane);
        popupLayers.put(rootPane, popupLayer);
        return popupLayer;
    }

    public static ShadeLayer getShadeLayer(JRootPane rootPane) {
        if (rootPane == null) {
            throw new RuntimeException("JRootPane for PopupLayer cannot be found");
        }
        if (shadeLayers.containsKey(rootPane)) {
            return shadeLayers.get(rootPane);
        }
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        if (layeredPane == null) {
            throw new RuntimeException("Popup layer can be installed only into window or applet with JLayeredPane");
        }
        ShadeLayer shadeLayer = new ShadeLayer();
        PopupManager.installPopupLayer(shadeLayer, rootPane, layeredPane);
        shadeLayers.put(rootPane, shadeLayer);
        return shadeLayer;
    }

    protected static void installPopupLayer(final PopupLayer popupLayer, JRootPane rootPane, final JLayeredPane layeredPane) {
        popupLayer.setBounds(0, 0, layeredPane.getWidth(), layeredPane.getHeight());
        popupLayer.setVisible(true);
        layeredPane.add((Component)popupLayer, JLayeredPane.PALETTE_LAYER);
        layeredPane.revalidate();
        layeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                popupLayer.setBounds(0, 0, layeredPane.getWidth(), layeredPane.getHeight());
                popupLayer.revalidate();
            }
        });
        Window window = SwingUtils.getWindowAncestor(rootPane);
        if (window != null) {
            window.addWindowStateListener(new WindowStateListener(){

                @Override
                public void windowStateChanged(WindowEvent e) {
                    popupLayer.setBounds(0, 0, layeredPane.getWidth(), layeredPane.getHeight());
                    popupLayer.revalidate();
                }
            });
        }
    }
}

