/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.skin.web;

import com.alee.laf.combobox.WebComboBoxUI;
import com.alee.laf.menu.PopupMenuPainter;
import com.alee.laf.menu.PopupMenuType;
import com.alee.laf.menu.PopupMenuWay;
import com.alee.laf.menu.WebMenuItemUI;
import com.alee.laf.menu.WebMenuUI;
import com.alee.laf.menu.WebPopupMenuStyle;
import com.alee.laf.menu.WebPopupMenuUI;
import com.alee.managers.style.skin.web.PopupStyle;
import com.alee.managers.style.skin.web.WebPopupPainter;
import com.alee.utils.ReflectUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicComboPopup;

public class WebPopupMenuPainter<E extends JPopupMenu>
extends WebPopupPainter<E>
implements PopupMenuPainter<E> {
    protected int menuSpacing = WebPopupMenuStyle.menuSpacing;
    protected boolean fixLocation = WebPopupMenuStyle.fixLocation;
    protected PopupMenuWay popupMenuWay = null;
    protected PopupMenuType popupMenuType = null;

    public int getMenuSpacing() {
        return this.menuSpacing;
    }

    @Override
    public void setMenuSpacing(int spacing) {
        this.menuSpacing = spacing;
    }

    public boolean isFixLocation() {
        return this.fixLocation;
    }

    @Override
    public void setFixLocation(boolean fix) {
        this.fixLocation = fix;
    }

    @Override
    public void setPopupMenuWay(PopupMenuWay way) {
        this.popupMenuWay = way;
    }

    @Override
    public void setPopupMenuType(PopupMenuType type) {
        this.popupMenuType = type;
        if (this.popupMenuType == PopupMenuType.menuBarSubMenu) {
            this.setPopupStyle(PopupStyle.simple);
        }
    }

    @Override
    public Insets getMargin(E c) {
        Insets margin = super.getMargin(c);
        margin.top += this.round;
        margin.bottom += this.round;
        return margin;
    }

    @Override
    protected void paintTransparentPopup(Graphics2D g2d, E popupMenu) {
        Dimension menuSize = ((Component)popupMenu).getSize();
        this.paintShade(g2d, popupMenu, menuSize);
        this.paintBackground(g2d, popupMenu, menuSize);
        this.paintDropdownCornerFill(g2d, popupMenu, menuSize);
        this.paintBorder(g2d, popupMenu, menuSize);
    }

    protected void paintDropdownCornerFill(Graphics2D g2d, E popupMenu, Dimension menuSize) {
        if (this.popupStyle == PopupStyle.dropdown && this.round == 0) {
            boolean stick;
            boolean top = this.cornerSide == 1;
            WebPopupMenuUI pmui = (WebPopupMenuUI)((JPopupMenu)popupMenu).getUI();
            boolean bl = top ? pmui.getMargin().top + this.margin.top == 0 : (stick = pmui.getMargin().bottom + this.margin.bottom == 0);
            if (stick) {
                JMenuItem menuItem;
                int zIndex = top ? 0 : ((Container)popupMenu).getComponentCount() - 1;
                Component component = ((Container)popupMenu).getComponent(zIndex);
                if (popupMenu instanceof BasicComboPopup) {
                    if (component instanceof JScrollPane) {
                        WebComboBoxUI ui;
                        JScrollPane scrollPane = (JScrollPane)component;
                        JList list = (JList)scrollPane.getViewport().getView();
                        if (top && list.getSelectedIndex() == 0) {
                            WebComboBoxUI ui2 = this.geComboBoxUI(popupMenu);
                            if (ui2 != null) {
                                g2d.setPaint(ui2.getNorthCornerFill());
                                g2d.fill(this.getDropdownCornerShape(popupMenu, menuSize, true));
                            }
                        } else if (!top && list.getSelectedIndex() == list.getModel().getSize() - 1 && (ui = this.geComboBoxUI(popupMenu)) != null) {
                            g2d.setPaint(ui.getSouthCornerFill());
                            g2d.fill(this.getDropdownCornerShape(popupMenu, menuSize, true));
                        }
                    }
                } else if (component instanceof JMenuItem && (menuItem = (JMenuItem)component).isEnabled() && (menuItem.getModel().isArmed() || menuItem.isSelected())) {
                    if (menuItem.getUI() instanceof WebMenuUI) {
                        WebMenuUI ui = (WebMenuUI)menuItem.getUI();
                        g2d.setPaint(top ? ui.getNorthCornerFill() : ui.getSouthCornerFill());
                        g2d.fill(this.getDropdownCornerShape(popupMenu, menuSize, true));
                    } else if (menuItem.getUI() instanceof WebMenuItemUI) {
                        WebMenuItemUI ui = (WebMenuItemUI)menuItem.getUI();
                        g2d.setPaint(top ? ui.getNorthCornerFill() : ui.getSouthCornerFill());
                        g2d.fill(this.getDropdownCornerShape(popupMenu, menuSize, true));
                    }
                }
            }
        }
    }

    protected WebComboBoxUI geComboBoxUI(E popupMenu) {
        JComboBox comboBox = (JComboBox)ReflectUtils.getFieldValueSafely(popupMenu, "comboBox");
        return comboBox != null && comboBox.getUI() instanceof WebComboBoxUI ? (WebComboBoxUI)comboBox.getUI() : null;
    }

    @Override
    public Point preparePopupMenu(E popupMenu, Component invoker, int x, int y) {
        boolean ltr = invoker.getComponentOrientation().isLeftToRight();
        int n = this.relativeCorner = ltr ? 0 : Integer.MAX_VALUE;
        if (invoker != null) {
            Point los = invoker.isShowing() ? invoker.getLocationOnScreen() : null;
            boolean fixLocation = this.fixLocation && invoker.isShowing();
            int sideWidth = this.getSideWidth();
            if (invoker instanceof JMenu) {
                if (invoker.getParent() instanceof JPopupMenu) {
                    this.setPopupStyle(PopupStyle.simple);
                    if (fixLocation) {
                        x += (los.x <= x ? -1 : 1) * (this.transparent ? sideWidth - this.menuSpacing : -this.menuSpacing);
                        y += (los.y <= y ? -1 : 1) * (this.transparent ? sideWidth + 1 + this.round : this.round);
                    }
                } else if (!WebPopupMenuStyle.dropdownStyleForMenuBar) {
                    this.setPopupStyle(PopupStyle.simple);
                    if (fixLocation) {
                        x += (los.x <= x ? -1 : 1) * (this.transparent ? sideWidth - this.menuSpacing : -this.menuSpacing);
                        y -= this.transparent ? sideWidth + this.round + 1 : this.round;
                    }
                } else {
                    this.setPopupStyle(PopupStyle.dropdown);
                    int n2 = this.cornerSide = los.y <= y ? 1 : 3;
                    if (fixLocation) {
                        x += (los.x <= x ? -1 : 1) * (this.transparent ? sideWidth : 0);
                        y += (los.y <= y ? -1 : 1) * (this.transparent ? sideWidth - this.cornerWidth : 0);
                    }
                    this.relativeCorner = los.x + invoker.getWidth() / 2 - x;
                }
            } else {
                boolean dropdown;
                boolean bl = dropdown = this.popupStyle == PopupStyle.dropdown;
                if (invoker instanceof JComboBox && ((Component)popupMenu).getName().equals("ComboPopup.popup")) {
                    int n3 = this.cornerSide = los.y <= y ? 1 : 3;
                    if (fixLocation) {
                        x += this.transparent ? -sideWidth : 0;
                        if (this.cornerSide == 1) {
                            y -= this.transparent ? sideWidth - (dropdown ? this.cornerWidth : 0) : 0;
                        } else {
                            int ih = invoker.getPreferredSize().height;
                            y -= ih + (this.transparent ? sideWidth - (dropdown ? this.cornerWidth : 0) : 0);
                        }
                    }
                    this.relativeCorner = los.x + invoker.getWidth() / 2 - x;
                } else if (fixLocation && this.popupMenuWay != null) {
                    Dimension ps = ((JComponent)popupMenu).getPreferredSize();
                    Dimension is = invoker.getSize();
                    int cornerShear = dropdown ? sideWidth - this.cornerWidth : 0;
                    switch (this.popupMenuWay) {
                        case aboveStart: {
                            x = (ltr ? los.x : los.x + is.width - ps.width) + (this.transparent ? (ltr ? -sideWidth : sideWidth) : 0);
                            y = los.y - ps.height + cornerShear;
                            this.relativeCorner = ltr ? 0 : Integer.MAX_VALUE;
                            break;
                        }
                        case aboveMiddle: {
                            x = los.x + is.width / 2 - ps.width / 2;
                            y = los.y - ps.height + cornerShear;
                            this.relativeCorner = los.x + invoker.getWidth() / 2 - x;
                            break;
                        }
                        case aboveEnd: {
                            x = (ltr ? los.x + is.width - ps.width : los.x) + (this.transparent ? (ltr ? sideWidth : -sideWidth) : 0);
                            y = los.y - ps.height + cornerShear;
                            this.relativeCorner = ltr ? Integer.MAX_VALUE : 0;
                            break;
                        }
                        case belowStart: {
                            x = (ltr ? los.x : los.x + is.width - ps.width) + (this.transparent ? (ltr ? -sideWidth : sideWidth) : 0);
                            y = los.y + is.height - cornerShear;
                            this.relativeCorner = ltr ? 0 : Integer.MAX_VALUE;
                            break;
                        }
                        case belowMiddle: {
                            x = los.x + is.width / 2 - ps.width / 2;
                            y = los.y + is.height - cornerShear;
                            this.relativeCorner = los.x + invoker.getWidth() / 2 - x;
                            break;
                        }
                        case belowEnd: {
                            x = (ltr ? los.x + is.width - ps.width : los.x) + (this.transparent ? (ltr ? sideWidth : -sideWidth) : 0);
                            y = los.y + is.height - cornerShear;
                            this.relativeCorner = ltr ? Integer.MAX_VALUE : 0;
                        }
                    }
                    this.cornerSide = this.popupMenuWay.getCornerSide();
                }
            }
        }
        this.popupMenuWay = null;
        return new Point(x, y);
    }
}

