/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.tooltip;

import com.alee.managers.language.data.TooltipWay;
import com.alee.managers.tooltip.ToolTipProvider;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.utils.swing.WebTimer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public abstract class AbstractToolTipProvider<T extends JComponent>
implements ToolTipProvider<T> {
    private WebCustomTooltip tooltip;
    private WebTimer delayTimer;

    @Override
    public long getDelay() {
        return TooltipManager.getDefaultDelay();
    }

    @Override
    public WebCustomTooltip getToolTip(T component, Object value, int index, int column, boolean isSelected) {
        String text = this.getToolTipText(component, value, index, column, isSelected);
        TooltipWay direction = this.getDirection(component, value, index, column, isSelected);
        return new WebCustomTooltip((Component)component, text, direction);
    }

    public TooltipWay getDirection(T component, Object value, int index, int column, boolean isSelected) {
        return TooltipWay.trailing;
    }

    public abstract String getToolTipText(T var1, Object var2, int var3, int var4, boolean var5);

    @Override
    public void rolloverCellChanged(T component, int oldIndex, int oldColumn, int newIndex, int newColumn) {
        if (this.delayTimer != null) {
            this.delayTimer.stop();
        }
        if (this.tooltip != null) {
            this.tooltip.closeTooltip();
        }
        if (newIndex != -1 && newColumn != -1) {
            long delay = this.getDelay();
            if (delay <= 0L) {
                this.showTooltip(component, newIndex, newColumn);
            } else {
                this.delayTimer = WebTimer.delay(delay, new ActionListener((JComponent)component, newIndex, newColumn){
                    final /* synthetic */ JComponent val$component;
                    final /* synthetic */ int val$newIndex;
                    final /* synthetic */ int val$newColumn;
                    {
                        this.val$component = jComponent;
                        this.val$newIndex = n;
                        this.val$newColumn = n2;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractToolTipProvider.this.showTooltip(this.val$component, this.val$newIndex, this.val$newColumn);
                    }
                });
            }
        }
    }

    protected void showTooltip(T component, int index, int column) {
        Object value = this.getValue(component, index, column);
        boolean selected = this.isSelected(component, index, column);
        this.tooltip = this.getToolTip(component, value, index, column, selected);
        this.tooltip.setRelativeToBounds(this.getSourceBounds(component, value, index, column, selected));
        TooltipManager.showOneTimeTooltip(this.tooltip);
    }

    protected abstract Object getValue(T var1, int var2, int var3);

    protected abstract boolean isSelected(T var1, int var2, int var3);
}

