/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.global.GlobalConstants;
import com.alee.global.StyleConstants;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.TimeUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public final class DebugUtils {
    public static void initTimeDebugInfo() {
        if (GlobalConstants.DEBUG) {
            TimeUtils.pinNanoTime();
        }
    }

    public static void paintTimeDebugInfo(Graphics g) {
        if (GlobalConstants.DEBUG) {
            DebugUtils.paintDebugInfoImpl((Graphics2D)g);
        }
    }

    public static void paintTimeDebugInfo(Graphics2D g2d) {
        if (GlobalConstants.DEBUG) {
            DebugUtils.paintDebugInfoImpl(g2d);
        }
    }

    private static void paintDebugInfoImpl(Graphics2D g2d) {
        double ms = (float)TimeUtils.getPassedNanoTime() / 1000000.0f;
        String micro = "" + StyleConstants.DEBUG_FORMAT.format(ms);
        Rectangle cb = g2d.getClip().getBounds();
        Font font = g2d.getFont();
        g2d.setFont(StyleConstants.DEBUG_FONT);
        Object aa = GraphicsUtils.setupAntialias(g2d);
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(micro) + 4;
        int h = fm.getHeight();
        g2d.setPaint(Color.BLACK);
        g2d.fillRect(cb.x + cb.width - w, cb.y, w, h);
        g2d.setPaint(Color.WHITE);
        g2d.drawString(micro, cb.x + cb.width - w + 2, cb.y + h - fm.getDescent());
        GraphicsUtils.restoreAntialias(g2d, aa);
        g2d.setFont(font);
    }

    public static void paintBorderDebugInfo(Graphics g, JComponent c) {
        DebugUtils.paintBorderDebugInfo(g, c, Color.RED);
    }

    public static void paintBorderDebugInfo(Graphics g, JComponent c, Color color) {
        Insets margin = c.getInsets();
        g.setColor(color);
        g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
        g.drawRect(margin.left, margin.top, c.getWidth() - margin.left - margin.right - 1, c.getHeight() - margin.top - margin.bottom - 1);
    }
}

