/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.global.StyleConstants;
import com.alee.managers.log.Log;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Shape;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIDefaults;

public final class ProprietaryUtils {
    public static final int LIGHT_WEIGHT_POPUP = 0;
    public static final int MEDIUM_WEIGHT_POPUP = 1;
    public static final int HEAVY_WEIGHT_POPUP = 2;
    private static boolean windowTransparencyAllowed = true;
    private static boolean windowShapeAllowed = false;
    private static boolean allowLinuxTransparency = false;

    public static boolean isAllowLinuxTransparency() {
        return allowLinuxTransparency;
    }

    public static void setAllowLinuxTransparency(boolean allow) {
        allowLinuxTransparency = allow;
    }

    public static void setupUIDefaults(UIDefaults table) {
        try {
            Class su2 = ReflectUtils.getClass("sun.swing.SwingUtilities2");
            Object aaProperty = ReflectUtils.getStaticFieldValue(su2, "AA_TEXT_PROPERTY_KEY");
            Class aaTextInfo = ReflectUtils.getInnerClass(su2, "AATextInfo");
            Object aaValue = ReflectUtils.callStaticMethod(aaTextInfo, "getAATextInfo", true);
            table.put(aaProperty, aaValue);
        }
        catch (ClassNotFoundException e) {
            Log.error(ProprietaryUtils.class, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            Log.error(ProprietaryUtils.class, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.error(ProprietaryUtils.class, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.error(ProprietaryUtils.class, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.error(ProprietaryUtils.class, (Throwable)e);
        }
    }

    public static boolean isWindowTransparencyAllowed() {
        try {
            if (windowTransparencyAllowed) {
                Class au = ReflectUtils.getClass("com.sun.awt.AWTUtilities");
                Class t = ReflectUtils.getInnerClass(au, "Translucency");
                Object ppt = ReflectUtils.getStaticFieldValue(t, "PERPIXEL_TRANSPARENT");
                Boolean wts = (Boolean)ReflectUtils.callStaticMethod(au, "isWindowTranslucencySupported", new Object[0]);
                Boolean tc = (Boolean)ReflectUtils.callStaticMethod(au, "isTranslucencyCapable", SystemUtils.getGraphicsConfiguration());
                Boolean ppts = (Boolean)ReflectUtils.callStaticMethod(au, "isTranslucencySupported", ppt);
                return wts != false && tc != false && ppts != false && (SystemUtils.isWindows() || SystemUtils.isMac() || SystemUtils.isSolaris() || SystemUtils.isUnix() && allowLinuxTransparency);
            }
            return false;
        }
        catch (Throwable e) {
            return SystemUtils.isWindows() || SystemUtils.isMac() || SystemUtils.isSolaris() || SystemUtils.isUnix() && allowLinuxTransparency;
        }
    }

    public static void setWindowTransparencyAllowed(boolean allowed) {
        windowTransparencyAllowed = allowed;
    }

    public static boolean isWindowShapeAllowed() {
        try {
            if (windowShapeAllowed) {
                Class au = ReflectUtils.getClass("com.sun.awt.AWTUtilities");
                Class t = ReflectUtils.getInnerClass(au, "Translucency");
                Object ppt = ReflectUtils.getStaticFieldValue(t, "PERPIXEL_TRANSPARENT");
                Boolean wts = (Boolean)ReflectUtils.callStaticMethod(au, "isWindowShapingSupported", new Object[0]);
                Boolean ppts = (Boolean)ReflectUtils.callStaticMethod(au, "isTranslucencySupported", ppt);
                return wts != false && ppts != false;
            }
            return false;
        }
        catch (Throwable e) {
            return windowShapeAllowed;
        }
    }

    public static void setWindowShapeAllowed(boolean allowed) {
        windowShapeAllowed = allowed;
    }

    public static void setWindowOpaque(Window window, boolean opaque) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                if (SystemUtils.isJava7orAbove()) {
                    ProprietaryUtils.setupOpacityBackgroundColor(opaque, window);
                } else {
                    ReflectUtils.callStaticMethod("com.sun.awt.AWTUtilities", "setWindowOpaque", window, opaque);
                }
                JRootPane rootPane = SwingUtils.getRootPane(window);
                if (rootPane != null) {
                    ProprietaryUtils.setupOpacityBackgroundColor(opaque, rootPane);
                    rootPane.setOpaque(opaque);
                    Container container = rootPane.getContentPane();
                    if (container != null) {
                        ProprietaryUtils.setupOpacityBackgroundColor(opaque, container);
                        if (container instanceof JComponent) {
                            ((JComponent)container).setOpaque(opaque);
                        }
                    }
                    rootPane.repaint();
                }
            }
            catch (Throwable e) {
                Log.error(ProprietaryUtils.class, e);
            }
        }
    }

    protected static void setupOpacityBackgroundColor(boolean opaque, Component component) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Color bg = opaque ? StyleConstants.backgroundColor : StyleConstants.transparent;
        ReflectUtils.callMethod(component, "setBackground", bg);
    }

    public static boolean isWindowOpaque(Window window) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                Color bg;
                Boolean isOpaque = SystemUtils.isJava7orAbove() ? Boolean.valueOf((bg = (Color)ReflectUtils.callMethod(window, "getBackground", new Object[0])).getAlpha() == 255) : (Boolean)ReflectUtils.callStaticMethod("com.sun.awt.AWTUtilities", "isWindowOpaque", window);
                return isOpaque != null ? isOpaque : true;
            }
            catch (Throwable e) {
                Log.error(ProprietaryUtils.class, e);
            }
        }
        return true;
    }

    public static void setWindowOpacity(Window window, float opacity) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                if (SystemUtils.isJava7orAbove()) {
                    ReflectUtils.callMethod(window, "setOpacity", Float.valueOf(opacity));
                } else {
                    ReflectUtils.callStaticMethod("com.sun.awt.AWTUtilities", "setWindowOpacity", window, Float.valueOf(opacity));
                }
            }
            catch (Throwable e) {
                Log.error(ProprietaryUtils.class, e);
            }
        }
    }

    public static float getWindowOpacity(Window window) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                Float opacity = SystemUtils.isJava7orAbove() ? (Float)ReflectUtils.callMethod(window, "getOpacity", new Object[0]) : (Float)ReflectUtils.callStaticMethod("com.sun.awt.AWTUtilities", "getWindowOpacity", window);
                return opacity != null ? opacity.floatValue() : 1.0f;
            }
            catch (Throwable e) {
                Log.error(ProprietaryUtils.class, e);
            }
        }
        return 1.0f;
    }

    public static void setWindowShape(Window window, Shape shape) {
        if (window != null && ProprietaryUtils.isWindowShapeAllowed()) {
            try {
                if (SystemUtils.isJava7orAbove()) {
                    ReflectUtils.callMethod(window, "setShape", shape);
                } else {
                    ReflectUtils.callStaticMethod("com.sun.awt.AWTUtilities", "setWindowShape", window, shape);
                }
            }
            catch (Throwable e) {
                Log.error(ProprietaryUtils.class, e);
            }
        }
    }

    public static Shape getWindowShape(Window window) {
        if (window != null && ProprietaryUtils.isWindowShapeAllowed()) {
            try {
                Shape shape = SystemUtils.isJava7orAbove() ? (Shape)ReflectUtils.callMethod(window, "getShape", new Object[0]) : (Shape)ReflectUtils.callStaticMethod("com.sun.awt.AWTUtilities", "getWindowShape", window);
                return shape;
            }
            catch (Throwable e) {
                Log.error(ProprietaryUtils.class, e);
            }
        }
        return null;
    }

    public static Popup createHeavyweightPopup(Component invoker, Component content, int x, int y) {
        return (Popup)ReflectUtils.callMethodSafely(PopupFactory.getSharedInstance(), "getPopup", invoker, content, x, y, 2);
    }
}

