/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.managers.log.Log;
import com.alee.utils.zip.UnzipListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ZipUtils {
    public static boolean unzip(String archive, String dst) {
        return ZipUtils.unzip(archive, dst, null);
    }

    public static boolean unzip(String archive, String dst, UnzipListener listener) {
        return ZipUtils.unzip(new File(archive), new File(dst), listener);
    }

    public static boolean unzip(File archive, File dst) {
        return ZipUtils.unzip(archive, dst, null);
    }

    public static boolean unzip(File archive, File dst, UnzipListener listener) {
        try {
            ZipFile zipFile = new ZipFile(archive);
            if (listener != null) {
                listener.sizeDetermined(zipFile.size());
            }
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            int index = 0;
            while (entries.hasMoreElements()) {
                File extractToFile;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    extractToFile = new File(dst, entry.getName());
                    extractToFile.mkdirs();
                } else {
                    extractToFile = new File(dst, entry.getName());
                    extractToFile.getParentFile().mkdirs();
                    extractToFile.createNewFile();
                    ZipUtils.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(extractToFile)));
                }
                if (listener == null) continue;
                listener.fileUnzipped(entry, extractToFile, index);
                ++index;
            }
            zipFile.close();
            return true;
        }
        catch (Throwable e) {
            Log.error(ZipUtils.class, e);
            return false;
        }
    }

    public static String getZipEntryFileName(ZipEntry zipEntry) {
        String name = zipEntry.getName();
        return name.substring(name.lastIndexOf("/") + 1);
    }

    public static String getZipEntryFileLocation(ZipEntry zipEntry) {
        String name = zipEntry.getName();
        return name.substring(0, name.lastIndexOf("/") + 1);
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }
}

