/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.collection;

import com.alee.utils.CollectionUtils;
import com.alee.utils.collection.ValuesTableConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@XStreamAlias(value="ValuesTable")
@XStreamConverter(value=ValuesTableConverter.class)
public class ValuesTable<K, V>
implements Serializable {
    protected List<K> keys;
    protected List<V> values;
    protected Map<K, V> valuesByKeys;
    protected Map<V, K> keysByValues;

    public ValuesTable() {
        this(10);
    }

    public ValuesTable(int initialCapacity) {
        this.keys = new ArrayList<K>(initialCapacity);
        this.values = new ArrayList<V>(initialCapacity);
        this.valuesByKeys = new HashMap(initialCapacity);
        this.keysByValues = new HashMap<V, K>(initialCapacity);
    }

    public List<K> getKeys() {
        return CollectionUtils.copy(this.keys);
    }

    public List<V> getValues() {
        return CollectionUtils.copy(this.values);
    }

    public void addAll(Map<K, V> data) {
        this.putAll(data);
    }

    public void putAll(Map<K, V> data) {
        for (Map.Entry<K, V> entry : data.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void addAll(ValuesTable<K, V> data) {
        this.putAll(data);
    }

    public void putAll(ValuesTable<K, V> data) {
        for (int i = 0; i < data.size(); ++i) {
            this.put(data.getKey(i), data.getValue(i));
        }
    }

    public void add(K key, V value) {
        this.put(key, value);
    }

    public void put(K key, V value) {
        this.put(this.size(), key, value);
    }

    public void add(int index, K key, V value) {
        this.put(index, key, value);
    }

    public void put(int index, K key, V value) {
        int existingKeyIndex = -1;
        if (this.containsKey(key)) {
            existingKeyIndex = this.indexOfKey(key);
        }
        int existingValueIndex = -1;
        if (this.containsValue(value)) {
            existingValueIndex = this.indexOfValue(value);
        }
        if (existingKeyIndex != -1 || existingValueIndex != -1) {
            if (existingKeyIndex > existingValueIndex) {
                if (existingKeyIndex != -1) {
                    this.removeExistingEntry(existingKeyIndex);
                }
                if (existingValueIndex != -1) {
                    this.removeExistingEntry(existingValueIndex);
                }
            } else {
                if (existingValueIndex != -1) {
                    this.removeExistingEntry(existingValueIndex);
                }
                if (existingKeyIndex != -1) {
                    this.removeExistingEntry(existingKeyIndex);
                }
            }
        }
        if (existingKeyIndex != -1 && existingKeyIndex < index && existingValueIndex != -1 && existingValueIndex < index) {
            index -= 2;
        } else if (existingKeyIndex != -1 && existingKeyIndex < index || existingValueIndex != -1 && existingValueIndex < index) {
            --index;
        }
        this.addEntry(index, key, value);
    }

    public void remove(K key) {
        this.removeByKey(key);
    }

    public void removeByKey(K key) {
        this.remove(this.indexOfKey(key));
    }

    public void removeByValue(V value) {
        this.remove(this.indexOfValue(value));
    }

    public void remove(int index) {
        if (index < 0 || index >= this.keys.size()) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
        this.removeExistingEntry(index);
    }

    private void addEntry(int index, K key, V value) {
        this.keys.add(index, key);
        this.values.add(index, value);
        this.valuesByKeys.put(key, value);
        this.keysByValues.put(value, key);
    }

    protected void removeExistingEntry(int index) {
        K rk = this.keys.remove(index);
        V rv = this.values.remove(index);
        this.valuesByKeys.remove(rk);
        this.keysByValues.remove(rv);
    }

    public V get(int index) {
        return this.getValue((K)index);
    }

    public V getValue(int index) {
        return this.values.get(index);
    }

    public K getKey(int index) {
        return this.keys.get(index);
    }

    public V get(K key) {
        return this.getValue(key);
    }

    public V getValue(K key) {
        return this.valuesByKeys.get(key);
    }

    public K getKey(V value) {
        return this.keysByValues.get(value);
    }

    public boolean contains(K key) {
        return this.valuesByKeys.containsKey(key);
    }

    public boolean containsKey(K key) {
        return this.valuesByKeys.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.keysByValues.containsKey(value);
    }

    public int indexOf(K key) {
        return this.indexOfKey(key);
    }

    public int indexOfKey(K key) {
        return this.keys.indexOf(key);
    }

    public int indexOfValue(V value) {
        return this.values.indexOf(value);
    }

    public int size() {
        return this.keys.size();
    }

    protected String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size();
    }
}

