/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class WindowFollowAdapter
extends ComponentAdapter {
    protected final Window followingWindow;
    protected final Window parentWindow;
    protected boolean enabled = true;
    protected Point lastLocation;

    public WindowFollowAdapter(Window followingWindow, Window parentWindow) {
        this.followingWindow = followingWindow;
        this.parentWindow = parentWindow;
        this.lastLocation = parentWindow.getLocation();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void updateLastLocation() {
        this.lastLocation = this.parentWindow.getLocation();
    }

    public Window getFollowingWindow() {
        return this.followingWindow;
    }

    public Window getParentWindow() {
        return this.parentWindow;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateLastLocation();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.isEnabled() && this.followingWindow != null && this.parentWindow != null) {
            Point nl = this.parentWindow.getLocation();
            Point fwl = this.followingWindow.getLocation();
            this.followingWindow.setLocation(fwl.x + nl.x - this.lastLocation.x, fwl.y + nl.y - this.lastLocation.y);
            this.lastLocation = nl;
        }
    }

    public static WindowFollowAdapter install(Window followingWindow, Window parentWindow) {
        WindowFollowAdapter windowFollowAdapter = new WindowFollowAdapter(followingWindow, parentWindow);
        parentWindow.addComponentListener(windowFollowAdapter);
        return windowFollowAdapter;
    }

    public static void uninstall(Window parentWindow, WindowFollowAdapter windowFollowAdapter) {
        parentWindow.removeComponentListener(windowFollowAdapter);
    }
}

