package com.fangxuele.tool.push.ui.form;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import lombok.Getter;

import javax.swing.*;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import java.awt.*;
import java.io.IOException;

/**
 * <pre>
 * HelpForm
 * </pre>
 *
 * @author <a href="https://github.com/rememberber">RememBerBer</a>
 * @since 2019/5/6.
 */
@Getter
public class HelpForm {
    private JPanel helpPanel;
    private JTextPane helpTextPane;
    private JLabel labelOnlineHelp;

    private static HelpForm helpForm;

    private HelpForm() {
    }

    public static HelpForm getInstance() {
        if (helpForm == null) {
            helpForm = new HelpForm();
        }
        return helpForm;
    }

    /**
     * 初始化使用帮助tab
     */
    public static void init() {
        helpForm = getInstance();

        try {
            helpForm.getHelpTextPane().setEditable(false);
            HTMLEditorKit kit = new HTMLEditorKit();
            helpForm.getHelpTextPane().setEditorKit(kit);
            StyleSheet styleSheet = kit.getStyleSheet();
            styleSheet.addRule("h2{color:#FBC87A;}");
            helpForm.getHelpTextPane().setContentType("text/html; charset=utf-8");
            helpForm.getHelpTextPane().setPage(MainWindow.class.getResource("/page/help.html"));
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    {
// GUI initializer generated by IntelliJ IDEA GUI Designer
// >>> IMPORTANT!! <<<
// DO NOT EDIT OR ADD ANY CODE HERE!
        $$$setupUI$$$();
    }

    /**
     * Method generated by IntelliJ IDEA GUI Designer
     * >>> IMPORTANT!! <<<
     * DO NOT edit this method OR call it in your code!
     *
     * @noinspection ALL
     */
    private void $$$setupUI$$$() {
        helpPanel = new JPanel();
        helpPanel.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        final JScrollPane scrollPane1 = new JScrollPane();
        helpPanel.add(scrollPane1, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_WANT_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_WANT_GROW, null, null, null, 0, false));
        helpTextPane = new JTextPane();
        helpTextPane.setDoubleBuffered(true);
        helpTextPane.setEditable(false);
        helpTextPane.setMargin(new Insets(10, 30, 10, 10));
        helpTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        helpTextPane.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        scrollPane1.setViewportView(helpTextPane);
        final JPanel panel1 = new JPanel();
        panel1.setLayout(new GridLayoutManager(1, 1, new Insets(0, 10, 0, 0), -1, -1));
        helpPanel.add(panel1, new GridConstraints(1, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        labelOnlineHelp = new JLabel();
        labelOnlineHelp.setText("<html>如有更多问题请添加issue或邮件rememberber@163.com</html>");
        panel1.add(labelOnlineHelp, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
    }

    /**
     * @noinspection ALL
     */
    public JComponent $$$getRootComponent$$$() {
        return helpPanel;
    }
}
