<p align="center">
  <a href="//macacajs.github.io">
    <img
      alt="Macaca"
      src="https://macacajs.github.io/macaca-logo/svg/monkey.svg"
      width="200"
    />
  </a>
</p>

---

# Macaca

[English Edition](README.md)

Macaca 是一套面向用户端软件的测试解决方案，提供了自动化驱动，环境配套，周边工具，集成方案，旨在解决`终端`上的测试、自动化、性能等方面的问题。

> Macaca 是 Monkey 的一种，含义引自(Monkey Test)，取灵动、敏捷之意。

## 多端支持

随着移动时代和智能终端时代的到来，为给用户带来更优质、完整的体验，我们的产品已经遍布各终端，同时单一的运行时架构往往不能满足工程的需要。Macaca 支持主流的移动技术平台 iOS，Android，以及两大平台的混合运行时 `Webview`，也支持以往的桌面端浏览器。

> Macaca 的底层设计便于端的横向扩展，会根据开发平台提供的测试驱动及时调整集成方案。

## 系统架构

![](https://macacajs.com/assets/88fe9010gy1g1k8o53d0ej20wb0ggwgu.jpg)

## 社区生态

![](https://macacajs.com/assets/88fe9010gy1g1u1juuz3hj20rz0kwafl.jpg)

## 标准化

Macaca 提供了标准化的驱动层，消除了各技术平台测试技术栈的差异。用户只需要遵从 [W3C webdriver 标准](//w3c.github.io/webdriver/webdriver-spec.html)即可多端无忧，理解成本降低。

## 多语言栈支持

Macaca 提供 [Node.js](https://macacajs.com/guide/nodejs.html)，[Java](https://macacajs.com/guide/java.html) 和 [Python](https://macacajs.com/guide/python.html) 三大主流的语言栈，方便工程师和所在团队选择合适的开发语言。

由于 Macaca 的工具链基于 Node.js，这个因素使得 Node.js 技术栈提供的支持和周边工具会相对多。Java 与 Python 有大量用实践，社区共享与贡献较多，也是很好的选择。

## 集成和融合

Macaca 提供了多种持续集成方案和功能模块，方便集成到研发和测试的各个环节。

## 源代码

模块源代码位于[macacajs](https://github.com/macacajs).

因为模块众多，推荐从[官网](https://macacajs.github.io)开始阅读。

## 帮助支持

- [官网](//macacajs.github.io/zh)
- [示例集合](//github.com/macaca-sample)
- [重要里程碑](//macacajs.github.io/zh/guide/roadmap.html)
- [社区精华](//github.com/macacajs/awesome-macaca)
- [社区支持](//macacajs.github.io/zh/guide/support.html)

## License

The MIT License (MIT)
