/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.proxy;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.pool.Hook;
import org.vibur.dbcp.pool.HookHolder;
import org.vibur.dbcp.proxy.ChildObjectInvocationHandler;
import org.vibur.dbcp.proxy.ExceptionCollector;
import org.vibur.dbcp.proxy.Proxy;
import org.vibur.dbcp.stcache.StatementCache;
import org.vibur.dbcp.stcache.StatementHolder;
import org.vibur.dbcp.util.JdbcUtils;

class StatementInvocationHandler
extends ChildObjectInvocationHandler<Connection, Statement>
implements Hook.StatementProceedingPoint {
    private final StatementHolder statement;
    private final StatementCache statementCache;
    private final ViburConfig config;
    private final Deque<ResultSet> currentResultSets = new ArrayDeque<ResultSet>();
    private final Hook.StatementExecution[] executionHooks;
    private final Hook.StatementExecution firstHook;
    private int hookIdx = 0;
    private final boolean logSqlQueryParams;
    private final List<Object[]> sqlQueryParams;

    StatementInvocationHandler(StatementHolder statement, StatementCache statementCache, Connection connProxy, ViburConfig config, ExceptionCollector exceptionCollector) {
        super(statement.rawStatement(), connProxy, "getConnection", config, exceptionCollector);
        this.statement = statement;
        this.statementCache = statementCache;
        this.config = config;
        HookHolder.InvocationHooksAccessor invocationHooksAccessor = (HookHolder.InvocationHooksAccessor)((Object)config.getInvocationHooks());
        this.executionHooks = invocationHooksAccessor.onStatementExecution();
        this.firstHook = this.executionHooks.length > 0 ? this.executionHooks[0] : this;
        this.logSqlQueryParams = config.isIncludeQueryParameters() && (this.executionHooks.length > 0 || invocationHooksAccessor.onResultSetRetrieval().length > 0);
        this.sqlQueryParams = this.logSqlQueryParams ? new ArrayList() : null;
    }

    @Override
    Object unrestrictedInvoke(Statement proxy, Method method, Object[] args) throws SQLException {
        String methodName = method.getName();
        if (methodName == "close") {
            return this.processClose(method, args);
        }
        if (methodName == "isClosed") {
            return this.isClosed();
        }
        return super.unrestrictedInvoke(proxy, method, args);
    }

    @Override
    Object restrictedInvoke(Statement proxy, Method method, Object[] args) throws SQLException {
        String methodName = method.getName();
        if (methodName.startsWith("set")) {
            return this.processSet(method, args);
        }
        if (methodName.startsWith("execute")) {
            return this.processExecute(proxy, method, args);
        }
        if (methodName == "getMoreResults") {
            return this.processMoreResults(method, args);
        }
        if (methodName == "getResultSet" || methodName == "getGeneratedKeys") {
            return this.newProxiedResultSet(proxy, method, args, this.statement.getSqlQuery());
        }
        if (methodName == "cancel") {
            return this.processCancel(method, args);
        }
        return super.restrictedInvoke(proxy, method, args);
    }

    private Object processClose(Method method, Object[] args) throws SQLException {
        if (!this.close()) {
            return null;
        }
        this.closeAllResultSets();
        if (this.statementCache != null && this.statementCache.restore(this.statement, this.config.isClearSQLWarnings())) {
            return null;
        }
        return this.targetInvoke(method, args);
    }

    private Object processCancel(Method method, Object[] args) throws SQLException {
        if (this.statementCache != null) {
            this.statementCache.remove(this.statement);
        }
        return this.targetInvoke(method, args);
    }

    private Object processSet(Method method, Object[] args) throws SQLException {
        if (this.logSqlQueryParams && args != null && args.length >= 2) {
            this.addSqlQueryParams(method, args);
        }
        return this.targetInvoke(method, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processExecute(Statement proxy, Method method, Object[] args) throws SQLException {
        this.closeAllResultSets();
        if (this.statement.getSqlQuery() == null && args != null && args.length >= 1) {
            this.statement.setSqlQuery((String)args[0]);
        }
        try {
            Object object = this.firstHook.on(proxy, method, args, this.statement.getSqlQuery(), this.sqlQueryParams, this);
            return object;
        }
        finally {
            this.prepareForNextExecution();
        }
    }

    private Object processMoreResults(Method method, Object[] args) throws SQLException {
        int current = 3;
        if (args != null && args.length == 1) {
            current = (Integer)args[0];
        }
        if (current == 1) {
            JdbcUtils.quietClose(this.currentResultSets.pollLast());
        } else if (current == 3) {
            this.closeAllResultSets();
        }
        return this.targetInvoke(method, args);
    }

    private void prepareForNextExecution() {
        if (this.sqlQueryParams != null) {
            this.sqlQueryParams.clear();
        }
        this.hookIdx = 0;
    }

    private ResultSet newProxiedResultSet(Statement proxy, Method method, Object[] args, String sqlQuery) throws SQLException {
        ResultSet rawResultSet = (ResultSet)this.targetInvoke(method, args);
        return this.addResultSet(Proxy.newProxyResultSet(rawResultSet, proxy, sqlQuery, this.sqlQueryParams, this.config, this));
    }

    private void addSqlQueryParams(Method method, Object[] args) {
        Object[] params = new Object[args.length + 1];
        params[0] = method.getName().substring(3);
        System.arraycopy(args, 0, params, 1, args.length);
        this.sqlQueryParams.add(params);
    }

    private ResultSet addResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            this.currentResultSets.addLast(resultSet);
        }
        return resultSet;
    }

    private void closeAllResultSets() {
        ResultSet next;
        while ((next = this.currentResultSets.pollFirst()) != null) {
            JdbcUtils.quietClose(next);
        }
    }

    @Override
    public Object on(Statement proxy, Method method, Object[] args, String sqlQuery, List<Object[]> sqlQueryParams, Hook.StatementProceedingPoint proceed) throws SQLException {
        if (++this.hookIdx < this.executionHooks.length) {
            return this.executionHooks[this.hookIdx].on(proxy, method, args, sqlQuery, sqlQueryParams, this);
        }
        return this.doProcessExecute(proxy, method, args);
    }

    private Object doProcessExecute(Statement proxy, Method method, Object[] args) throws SQLException {
        if (method.getName() == "executeQuery") {
            return this.newProxiedResultSet(proxy, method, args, this.statement.getSqlQuery());
        }
        return this.targetInvoke(method, args);
    }
}

