package act.view.rythm;

/*-
 * #%L
 * ACT Framework
 * %%
 * Copyright (C) 2014 - 2017 ActFramework
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.rythmengine.extension.IFormatter;

import java.util.Locale;

public class JodaDateTimeFormatter implements IFormatter {
    @Override
    public String format(Object o, String pattern, Locale locale, String timezone) {
        if (o instanceof ReadableInstant) {
            return JodaTransformers.format((ReadableInstant) o, pattern, locale, timezone);
        } else if (o instanceof ReadablePartial) {
            return JodaTransformers.format((ReadablePartial) o, pattern, locale, timezone);
        }
        return null;
    }
}
