package io.github.ramerf.wind.core.metadata;

import java.util.HashMap;
import java.util.Map;
import lombok.Data;

/**
 * 表名与数据库表信息映射.
 *
 * @author Tang Xiaofeng
 * @since 2020.08.20
 */
@Data
public class NameTableInformation {
  private Map<String, TableInformation> tables = new HashMap<>();

  public void addTableInformation(TableInformation tableInformation) {
    tables.put(tableInformation.getName(), tableInformation);
  }

  public TableInformation getTableInformation(TableInformation table) {
    return tables.get(table.getName());
  }

  public TableInformation getTableInformation(String tableName) {
    return tables.get(tableName);
  }
}
