<!--- Copyright (C) Lightbend Inc. <https://www.lightbend.com> -->
# Javascript Routing

The play router is able to generate Javascript code to handle routing from Javascript running client side back to your application. The Javascript router aids in refactoring your application. If you change the structure of your URLs or parameter names your Javascript gets automatically updated to use that new structure.

## Generating a Javascript router

The first step to using Play's Javascript router is to generate it. The router will only expose the routes that you explicitly declare thus minimizing the size of the Javascript code.

There are two ways to generate a Javascript router. One is to embed the router in the HTML page using template directives. The other is to generate Javascript resources in an action that can be downloaded, cached and shared between pages.

### Embedded router

An embedded router can be generated using the ``@javascriptRouter`` directive inside a Twirl template. This is typically done inside the main decorating template.

@[javascript-embedded-router](code/javaEmbeddedRouter.scala.html)

The first parameter is the name of the global variable that the router will be placed in. The second parameter is the list of Javascript routes that should be included in this router.

### Router resource

A router resource can be generated by creating an action that invokes the router generator. It has a similar syntax to embedding the router in a template:

@[javascript-router-resource-imports](code/javaguide/binder/controllers/Application.java)

@[javascript-router-resource](code/javaguide/binder/controllers/Application.java)
    
Then, add the corresponding route:

@[javascript-router-routes](code/javaguide.binder.routes)

Having implemented this action, and adding it to your routes file, you can then include it as a resource in your templates:

```html
<script type="text/javascript" src="@routes.Application.javascriptRoutes"></script>
``` 

## Using the router

Using jQuery as an example, making a call is as simple as:

```javascript
$.ajax(jsRoutes.controllers.Users.get(someId))
  .done( /*...*/ )
  .fail( /*...*/ );
```

The router also makes a few other properties available including the ``url`` and the ``type`` (the HTTP method). For example the above call to jQuery's ajax function can also be made like:

```javascript
var r = jsRoutes.controllers.Users.get(someId);
$.ajax({url: r.url, type: r.type, success: /*...*/, error: /*...*/ });
```

The above approach is required where other properties need setting such as success, error, context etc.

The ``absoluteURL`` and the ``webSocketURL`` are methods (not properties) which return the complete url string. A Websocket connection can be made like:

```javascript
var r = jsRoutes.controllers.Users.list();
var ws = new WebSocket(r.webSocketURL());
ws.onmessage = function(msg) {
        /*...*/
};
```

## jQuery ajax method support

> **Note:** Built-in support for jQuery's ajax function will be removed in a future release. This section on the built-in support is provided for reference purposes only. Please do not use the router's ajax function in new code and consider upgrading existing code as soon as possible. The previous section on using the router documents how jQuery should be used.

If jQuery isn't your thing, or if you'd like to decorate the jQuery ajax method in some way, you can provide a function to the router to use to perform ajax queries. This function must accept the object that is passed to the ``ajax`` router method, and should expect the router to have set the ``type`` and ``url`` properties on it to the appropriate method and url for the router request.

To define this function, in your action pass the ``ajaxMethod`` method parameter, eg:

@[javascript-router-resource-custom-method](code/javaguide/binder/controllers/Application.java)
