/**
大陆仔 iPush 轮播程序 （支持响应式设计）
author:Adam
website:daluzai.net
cteate date:2013-08-13
last update:2013-08-13
this function must run the jquery v1.72

Ipush 是有大陆仔仔开发的一套基于jQuery 的JS轮播程序，他完全符合当前流行的响应式设计，可跨平台使用。同时，在移动端还可以支持单指触发事件切换播放顺序。
该插件功能强大，可以支持三种播放形式调用：

极简播放形式：没有播放操作按钮，由系统自动轮播；
迷你播放模式：即支持用户操作播放上一张图片和下一张图片；
高级播放模式：即支持用户任意切换轮播图片。
三种模式，系统均有内置模式，同时也支持用户自定义模式。
*/

(function($){
	//ipush 容器对象
	var _ipush_case;
	//显示图片容器对象
	var _img_case;
	//显示对象宽度
	var _width=0;
	//显示对象高度
	var _height=0;
	//播放图片的集合
	var _playArr;
	//当前播放进度
	var _playCurrent=1;
	//interval key
	var _interval_key;
	//配置参数
	var _matchOption={};
	//随机一个key作为表示
	var _randomKey=Math.round(Math.random()*999999);
	
	//-api 显示播放组建(需要手动添加，因此默认为false)
	var _iPush_config={
		iPush_config:false,
		ipush_config_case:'ipush_config_case_'+_randomKey,
		ipush_display_group:'dd',
		ipush_display_current:'ipush_config_case_'+_randomKey+'_current'
	}
	//-api 显示迷你播放组建(需要手动添加，因为默认为false)
	var _iPush_mini_config={
		iPush_mini_config:false,
		ipush_mini_config_up:'ipush_mini_config_up_'+_randomKey,
		ipush_mini_config_next:'ipush_mini_config_next_'+_randomKey	
	}
	//-api 移动&平板设备手势操作对象
	var _ipush_toch_obj={};
	
	/**
		基本功能接口
	*/
	$.dlz_iPush=function(init){
		//初始化参数
		var defaultOption ={
			ipush_obj:'ipush_case',
			main_obj:'.ipush_main_case',
			main_group:'dd',
			intervalTime:4000,
			animateTime:1000
		}
		//替换初始化参数
		_matchOption=$.extend(defaultOption,init);
		//系统初始化架构
		initSystem();
		//系统自动播放
		start_interval();
		//鼠标在对象上即停止播放，离开后继续播放 
		$(_ipush_case).hover(
			function(){
				stop_interval();
			},
			function(){
				start_interval();
			}
		);
	}
	
	/**
	-api 显示迷你播放组建
	*/
	
	$.dlz_iPush_mini_config=function(init){
		//通知程序启动该接口
		_iPush_mini_config.iPush_mini_config=init;
		/**
			系统自带控制播放组建
		*/
		if(_iPush_mini_config.iPush_mini_config==true){
			//构造系统必须的驱动
			var s1='.'+_iPush_mini_config.ipush_mini_config_up+',.'+_iPush_mini_config.ipush_mini_config_up+':visited,.'+_iPush_mini_config.ipush_mini_config_next+',.'+_iPush_mini_config.ipush_mini_config_up+':visited{font-size: 60px;font-family:Verdana, Geneva, sans-serif;color: #333;display: block;width: 60px;height: 60px;line-height: 48px;cursor: pointer;text-align: center;text-decoration:none;}';
			var s2='.'+_iPush_mini_config.ipush_mini_config_up+':hover ,.'+_iPush_mini_config.ipush_mini_config_next+':hover {background: #999;color: #FFF;text-decoration:none;}';
			var s3='.'+_iPush_mini_config.ipush_mini_config_up+'{position: absolute;left: 10px;top: 50%;}';
			var s4='.'+_iPush_mini_config.ipush_mini_config_next+'{position: absolute;right: 10px;top: 50%;}';
			//追加到容器中
			$(_ipush_case).prepend('<style>'+s1+s2+s3+s4+'</style>');
			//构造组建架构
			var html='<a href="javascript:void(0);" class="'+_iPush_mini_config.ipush_mini_config_up+'">&lt;</a> <a href="javascript:void(0);" class="'+_iPush_mini_config.ipush_mini_config_next+'">&gt;</a>';
			//追加到容器中
			$(_ipush_case).append(html);
		}
		/**
			用户自定义接口
		*/
		else{
			//接口配置错误
			if(typeof(_iPush_mini_config.iPush_mini_config) !=='object'){
				alert('您的配置参数不正确\n 如果用自定义参数应该是一个对象传递参数配置\n详情可以使用 $.dlz_iPush_help(); 手册来查询');
				return false;
			}
			//初始化参数
			var defaultOption={
				display_mini_config_up:_iPush_mini_config.ipush_mini_config_up,
				display_mini_config_next:_iPush_mini_config.ipush_mini_config_next
			}
			//替换初始化参数
			var config_matchOption=$.extend(defaultOption,init);
			//统一标识变量后续操作方便
			_iPush_mini_config.ipush_mini_config_up=config_matchOption.display_mini_config_up;
			_iPush_mini_config.ipush_mini_config_next=config_matchOption.display_mini_config_next;
		}
		//上一页
		_ipush_case.find('.'+_iPush_mini_config.ipush_mini_config_up).click(function(){
			_playCurrent=_playCurrent-2;
			play();
		});
		//下一页
		_ipush_case.find('.'+_iPush_mini_config.ipush_mini_config_next).click(function(){
			_playCurrent=_playCurrent;
			play();
		});
	}
	
	/**
		启动控制按钮播放接口
	*/
	$.dlz_iPush_config=function(init){
		//通知程序启动该接口
		_iPush_config.iPush_config=init;
		/**
			系统自带控制播放组建
		*/
		if(_iPush_config.iPush_config==true){
			//构造系统必须的驱动
			var s1='.'+_iPush_config.ipush_config_case+'{position:absolute;left:0;right:0;bottom:20px;text-align:center;}';
			var s2='.'+_iPush_config.ipush_config_case+' '+_iPush_config.ipush_display_group+'{width:10px;height:10px;margin:5px;display:inline-block;font-size:0px;line-height:0px;overflow:hidden;background:#FFF;border-radius:10px;border:2px solid #666;box-shadow:0 1px 7px rgba(0,0,0,0.75);cursor:pointer;}';
			var s3='.'+_iPush_config.ipush_config_case+' '+_iPush_config.ipush_display_group+':hover'+',.'+_iPush_config.ipush_config_case+' .'+_iPush_config.ipush_display_current+'{background:#666;border:2px solid #FFF;}';
			$(_ipush_case).prepend('<style>'+s1+s2+s3+'</style>');
			//构造组建架构
			var html='<dl id="'+_iPush_config.ipush_config_case+'" class="'+_iPush_config.ipush_config_case+'">';			
			for(var i=0;i<_playArr.length;i++){
				html+='<'+_iPush_config.ipush_display_group+'></'+_iPush_config.ipush_display_group+'>';
			}
			html=html+'</dl>';
			//追加到容器中
			$(_ipush_case).append(html);
		}
		/**
			用户自定义接口
		*/
		else{
			//接口配置错误
			if(typeof(_iPush_config.iPush_config) !=='object'){
				alert('您的配置参数不正确\n 如果用自定义参数应该是一个对象传递参数配置\n详情可以使用 $.dlz_iPush_help(); 手册来查询');
				return false;
			}
			//初始化参数
			var defaultOption={
				display_config:_iPush_config.ipush_config_case,
				display_group:_iPush_config.ipush_display_group,
				display_current:_iPush_config.ipush_display_current
			}
			//替换初始化参数
			var config_matchOption=$.extend(defaultOption,init);
			//统一标识变量后续操作方便
			_iPush_config.ipush_config_case=config_matchOption.display_config;
			_iPush_config.ipush_display_group=config_matchOption.display_group;
			_iPush_config.ipush_display_current=config_matchOption.display_current;
		}
		//载入状态处理函数
		dlz_iPush_config_current(_playCurrent-1);
		//用户操作播放
		dlz_iPush_config_event();
	}
	
	/**
		移动&平板设备手势操作接口使用
	*/
	$.dlz_iPush_touch=function (){
		document.getElementById(_matchOption.ipush_obj).addEventListener("touchstart",dlz_iPush_touch_start,false);
		document.getElementById(_matchOption.ipush_obj).addEventListener("touchmove",dlz_iPush_touch_move,false);
		document.getElementById(_matchOption.ipush_obj).addEventListener("touchend",dlz_iPush_touch_end,false);
	}
	
	/**
		大陆仔 响应式轮播系统 帮助手册
	*/
	$.dlz_iPush_help=function(){
		var html='<h1 style="font-size:16px;"><a href="http://mojing.org/daluzai/ipush.shtml" target="_blank"><b>大陆仔响应式轮播系统</b>帮助手册,点击查看</a></h1>';
		$(_ipush_case).after(html);
	}
	
	/**
		系统初始化架构
	*/
	function initSystem(){
		//获取ipush 容器对象
		_ipush_case=$('#'+_matchOption.ipush_obj);
		//获取图片容器对象
		_img_case=_ipush_case.find(_matchOption.main_obj);
		//获取播放图片的集合
		_playArr=_img_case.find(_matchOption.main_group);
		//获取对象宽度
		_width='100';
		//获取对象高度
		_height='auto';
		//设置对象属相
		_ipush_case.css({'position':'relative','width':_width+'%','height':_height,'overflow':'hidden'});
		//设置图片和显示图片容器的属性
		_img_case.css({'position':'relative','width':_width*(_playArr.length)+'%','height':_height,'overflow':'hidden'});
		_playArr.css({'float':'left','width':_width/(_playArr.length)+'%','overflow':'hidden'})
		_playArr.find('img').css({'display':'block'});
	}
	/**
		过度动画功能
	*/
	function animate(to){
		$(_img_case).animate(
			{
			  left:to+'%'
			},_matchOption.animateTime
		);
	}	
	/**
		轮播动画功能
	*/
	function start_interval(){
		_interval_key=setInterval(function(){
			play();			
		},_matchOption.intervalTime);
	}
	/**
		停止轮播动画功能
	*/
	function stop_interval(){
		clearInterval(_interval_key);
	}
	
	/**
		播放核心函数
	*/
	function play(){
		//初始化动画参数
		var to=0;		
		//最后一张
		if(_playCurrent>=_playArr.length){
			_playCurrent=0;
			to=0;
		}else{
			to=-100*(_playCurrent);
		}
		//最前边的
		if(_playCurrent<0){			
			_playCurrent=_playArr.length-1;
			to=-100*(_playArr.length-1);
		}
		//播放进度
		dlz_iPush_config_current(_playCurrent);
		//创建动画
		animate(to);	
		//累加播放
		_playCurrent=_playCurrent+1;
	}
	/**
		播放进度
		@仅供 $.dlz_iPush_config 接口使用
	*/
	function dlz_iPush_config_current(current){
		if(_iPush_config.iPush_config == false){
			return false;
		}
		//回复所有状态
		$('#'+_iPush_config.ipush_config_case).find(_iPush_config.ipush_display_group).removeClass(_iPush_config.ipush_display_current);
		//寻找当前状态
		$('#'+_iPush_config.ipush_config_case).find(_iPush_config.ipush_display_group).each(function(index) {
			if(index==current){
				$(this).addClass(_iPush_config.ipush_display_current);
			}
		});
	}
	/**
		用户操作播放
		@仅供 $.dlz_iPush_config 接口使用
	*/
	function dlz_iPush_config_event(){
		if(_iPush_config.iPush_config == false){
			return false;
		}
		$('#'+_iPush_config.ipush_config_case).find(_iPush_config.ipush_display_group).each(function(index) {
			$(this).click(function(){
				//暂停轮播
				stop_interval();	
				//设置将要跳转的进度				
				_playCurrent=index;
				//播放
				play();
			})
		});
	}
	/**
		移动&平板设备手势操作监听单指触动开始函数
		@仅供 $.dlz_iPush_touch 接口使用
	*/
	function dlz_iPush_touch_start(event) {
		//暂停轮播
		stop_interval();
		event.preventDefault();
		_ipush_toch_obj.startX= event.targetTouches[0].pageX;
		_ipush_toch_obj.startY= event.targetTouches[0].pageY;
	}
	/**
		移动&平板设备手势操作监听单指触动过程函数
		@仅供 $.dlz_iPush_touch 接口使用
	*/
	function dlz_iPush_touch_move(event){
		event.preventDefault();
		_ipush_toch_obj.moveX=event.targetTouches[0].pageX;
		_ipush_toch_obj.moveY=event.targetTouches[0].pageY;		
	}
	/**
		移动&平板设备手势操作监听单指触动结束函数
		@仅供 $.dlz_iPush_touch 接口使用
	*/
	function dlz_iPush_touch_end(){
		if(_ipush_toch_obj.moveX-_ipush_toch_obj.startX>0){
			//设置将要跳转的进度				
			_playCurrent=_playCurrent-2;
			//播放
			play();
		}else{
			//播放
			play();
		}
		//开始轮播
		start_interval();
	}	
})(jQuery)