/*
 * Copyright ©2018 vbill.cn.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * </p>
 */

package cn.vbill.middleware.porter.common.cluster.event;

import cn.vbill.middleware.porter.common.cluster.client.ClusterClient;
import cn.vbill.middleware.porter.common.cluster.event.command.ClusterCommand;

import java.util.function.BiConsumer;

/**
 * @author: zhangkewei[zhang_kw@suixingpay.com]
 * @date: 2019年03月13日 17:45
 * @version: V1.0
 * @review: zkevin/2019年03月13日 17:45
 */
public class ClusterListenerEventExecutor {
    private BiConsumer<ClusterCommand, ClusterClient> consumer;

    private ClusterClient client;
    private Class bindClass;
    private ClusterListenerEventType bindEvent;

    public ClusterListenerEventExecutor(Class  bindClass, ClusterListenerEventType bindEvent) {
        this.bindClass = bindClass;
        this.bindEvent = bindEvent;
    }

    public ClusterListenerEventExecutor bind(BiConsumer<ClusterCommand, ClusterClient> consumer, ClusterClient client) {
        return bind(consumer).bind(client);
    }

    public ClusterListenerEventExecutor bind(BiConsumer<ClusterCommand, ClusterClient> consumer) {
        this.consumer = consumer;
        return this;
    }

    public ClusterListenerEventExecutor bind(ClusterClient client) {
        this.client = client;
        return this;
    }


    public void execute(ClusterCommand clusterCommand) {
        consumer.accept(clusterCommand, client);
    }

    public ClusterClient getClient() {
        return client;
    }

    public Class getBindClass() {
        return bindClass;
    }

    public ClusterListenerEventType getBindEvent() {
        return bindEvent;
    }
}