
interface BNNSActivation {
	function: BNNSActivationFunction;
	alpha: number;
	beta: number;
	iscale: number;
	ioffset: number;
	ishift: number;
	iscale_per_channel: interop.Pointer | interop.Reference<number>;
	ioffset_per_channel: interop.Pointer | interop.Reference<number>;
	ishift_per_channel: interop.Pointer | interop.Reference<number>;
}
declare var BNNSActivation: interop.StructType<BNNSActivation>;

declare const enum BNNSActivationFunction {

	Identity = 0,

	RectifiedLinear = 1,

	LeakyRectifiedLinear = 2,

	Sigmoid = 3,

	Tanh = 4,

	ScaledTanh = 5,

	Abs = 6,

	Linear = 7,

	Clamp = 8,

	IntegerLinearSaturate = 9,

	IntegerLinearSaturatePerChannel = 10,

	Softmax = 11,

	GELUApproximation = 12,

	Gumbel = 13,

	GumbelMax = 14,

	HardSigmoid = 15,

	Softplus = 16,

	Softsign = 17,

	ELU = 18,

	ClampedLeakyRectifiedLinear = 19,

	LinearWithBias = 20,

	LogSoftmax = 21,

	LogSigmoid = 22,

	SELU = 23,

	CELU = 24,

	HardShrink = 25,

	SoftShrink = 26,

	TanhShrink = 27,

	Threshold = 28,

	PReLUPerChannel = 29,

	GELUApproximation2 = 30
}

declare function BNNSApplyMultiheadAttention(F: interop.Pointer | interop.Reference<any>, batch_size: number, query: interop.Pointer | interop.Reference<any>, query_stride: number, key: interop.Pointer | interop.Reference<any>, key_stride: number, key_mask: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, key_mask_stride: number, value: interop.Pointer | interop.Reference<any>, value_stride: number, output: interop.Pointer | interop.Reference<any>, output_stride: number, add_to_attention: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, backprop_cache_size: interop.Pointer | interop.Reference<number>, backprop_cache: interop.Pointer | interop.Reference<any>, workspace_size: interop.Pointer | interop.Reference<number>, workspace: interop.Pointer | interop.Reference<any>): number;

declare function BNNSApplyMultiheadAttentionBackward(F: interop.Pointer | interop.Reference<any>, batch_size: number, query: interop.Pointer | interop.Reference<any>, query_stride: number, query_param_delta: interop.Pointer | interop.Reference<BNNSMHAProjectionParameters>, key: interop.Pointer | interop.Reference<any>, key_stride: number, key_mask: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, key_mask_stride: number, key_param_delta: interop.Pointer | interop.Reference<BNNSMHAProjectionParameters>, value: interop.Pointer | interop.Reference<any>, value_stride: number, value_param_delta: interop.Pointer | interop.Reference<BNNSMHAProjectionParameters>, add_to_attention: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, key_attn_bias_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, value_attn_bias_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, output: interop.Pointer | interop.Reference<any>, output_stride: number, output_param_delta: interop.Pointer | interop.Reference<BNNSMHAProjectionParameters>, backprop_cache_size: number, backprop_cache: interop.Pointer | interop.Reference<any>, workspace_size: interop.Pointer | interop.Reference<number>, workspace: interop.Pointer | interop.Reference<any>): number;

interface BNNSArithmeticBinary {
	in1: BNNSNDArrayDescriptor;
	in1_type: BNNSDescriptorType;
	in2: BNNSNDArrayDescriptor;
	in2_type: BNNSDescriptorType;
	out: BNNSNDArrayDescriptor;
	out_type: BNNSDescriptorType;
}
declare var BNNSArithmeticBinary: interop.StructType<BNNSArithmeticBinary>;

declare function BNNSArithmeticFilterApplyBackwardBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, number_of_inputs: number, _in: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<any>>, in_stride: interop.Pointer | interop.Reference<number>, in_delta: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>>, in_delta_stride: interop.Pointer | interop.Reference<number>, out: interop.Pointer | interop.Reference<any>, out_stride: number, out_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, out_delta_stride: number): number;

declare function BNNSArithmeticFilterApplyBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, number_of_inputs: number, _in: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<any>>, in_stride: interop.Pointer | interop.Reference<number>, out: interop.Pointer | interop.Reference<any>, out_stride: number): number;

declare const enum BNNSArithmeticFunction {

	Add = 0,

	Subtract = 1,

	Multiply = 2,

	Divide = 3,

	SquareRoot = 4,

	ReciprocalSquareRoot = 5,

	Ceil = 6,

	Floor = 7,

	Round = 8,

	Sin = 9,

	Cos = 10,

	Tan = 11,

	Asin = 12,

	Acos = 13,

	Atan = 14,

	Sinh = 15,

	Cosh = 16,

	Tanh = 17,

	Asinh = 18,

	Acosh = 19,

	Atanh = 20,

	Pow = 21,

	Exp = 22,

	Exp2 = 23,

	Log = 24,

	Log2 = 25,

	MultiplyNoNaN = 26,

	DivideNoNaN = 27
}

interface BNNSArithmeticUnary {
	in: BNNSNDArrayDescriptor;
	in_type: BNNSDescriptorType;
	out: BNNSNDArrayDescriptor;
	out_type: BNNSDescriptorType;
}
declare var BNNSArithmeticUnary: interop.StructType<BNNSArithmeticUnary>;

declare function BNNSCompareTensor(in0: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, in1: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, op: BNNSRelationalOperator, out: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>): number;

declare function BNNSComputeLSTMTrainingCacheCapacity(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersLSTM>): number;

interface BNNSConvolutionLayerParameters {
	x_stride: number;
	y_stride: number;
	x_padding: number;
	y_padding: number;
	k_width: number;
	k_height: number;
	in_channels: number;
	out_channels: number;
	weights: BNNSLayerData;
	bias: BNNSLayerData;
	activation: BNNSActivation;
}
declare var BNNSConvolutionLayerParameters: interop.StructType<BNNSConvolutionLayerParameters>;

declare function BNNSCopy(dest: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, src: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): number;

declare const enum BNNSDataLayout {

	LayoutVector = 65536,

	Layout1DLastMajor = 98304,

	Layout1DFirstMajor = 98305,

	LayoutRowMajorMatrix = 131072,

	LayoutColumnMajorMatrix = 131073,

	Layout2DLastMajor = 163840,

	Layout2DFirstMajor = 163841,

	LayoutImageCHW = 196608,

	Layout3DLastMajor = 229376,

	Layout3DFirstMajor = 229377,

	LayoutConvolutionWeightsOIHW = 262144,

	LayoutConvolutionWeightsOIHrWr = 262145,

	LayoutConvolutionWeightsIOHrWr = 262146,

	LayoutConvolutionWeightsOIHW_Pack32 = 262160,

	Layout4DLastMajor = 294912,

	Layout4DFirstMajor = 294913,

	Layout5DLastMajor = 360448,

	Layout5DFirstMajor = 360449,

	Layout6DLastMajor = 425984,

	Layout6DFirstMajor = 425985,

	Layout7DLastMajor = 491520,

	Layout7DFirstMajor = 491521,

	Layout8DLastMajor = 557056,

	Layout8DFirstMajor = 557057
}

declare const enum BNNSDataType {

	FloatBit = 65536,

	Float16 = 65552,

	Float32 = 65568,

	IntBit = 131072,

	Int1 = 131073,

	Int2 = 131074,

	Int4 = 131076,

	Int8 = 131080,

	Int16 = 131088,

	Int32 = 131104,

	UIntBit = 262144,

	UInt1 = 262145,

	UInt2 = 262146,

	UInt4 = 262148,

	UInt8 = 262152,

	UInt16 = 262160,

	UInt32 = 262176,

	IndexedBit = 524288,

	Indexed1 = 524289,

	Indexed2 = 524290,

	Indexed4 = 524292,

	Indexed8 = 524296,

	MiscellaneousBit = 1048576,

	Boolean = 1048584
}

declare const enum BNNSDescriptorType {

	Constant = 0,

	Sample = 1,

	Parameter = 2
}

declare function BNNSDirectApplyActivationBatch(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersActivation>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>, batch_size: number, in_stride: number, out_stride: number): number;

declare function BNNSDirectApplyBroadcastMatMul(transA: boolean, transB: boolean, alpha: number, inputA: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, inputB: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, output: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): void;

declare function BNNSDirectApplyInTopK(K: number, axis: number, batch_size: number, input: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, input_batch_stride: number, test_indices: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, test_indices_batch_stride: number, output: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, output_batch_stride: number, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): number;

declare function BNNSDirectApplyLSTMBatchBackward(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersLSTM>, layer_delta_params: interop.Pointer | interop.Reference<BNNSLayerParametersLSTM>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>, training_cache_ptr: interop.Pointer | interop.Reference<any>, training_cache_capacity: number): number;

declare function BNNSDirectApplyLSTMBatchTrainingCaching(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersLSTM>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>, training_cache_ptr: interop.Pointer | interop.Reference<any>, training_cache_capacity: number): number;

declare function BNNSDirectApplyReduction(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersReduction>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): number;

declare function BNNSDirectApplyTopK(K: number, axis: number, batch_size: number, input: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, input_batch_stride: number, best_values: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, best_values_batch_stride: number, best_indices: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, best_indices_batch_stride: number, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): number;

declare function BNNSFilterApply(filter: interop.Pointer | interop.Reference<any>, _in: interop.Pointer | interop.Reference<any>, out: interop.Pointer | interop.Reference<any>): number;

declare function BNNSFilterApplyBackwardBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, _in: interop.Pointer | interop.Reference<any>, in_stride: number, in_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, in_delta_stride: number, out: interop.Pointer | interop.Reference<any>, out_stride: number, out_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, out_delta_stride: number, weights_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, bias_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>): number;

declare function BNNSFilterApplyBackwardTwoInputBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, inA: interop.Pointer | interop.Reference<any>, inA_stride: number, inA_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, inA_delta_stride: number, inB: interop.Pointer | interop.Reference<any>, inB_stride: number, inB_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, inB_delta_stride: number, out: interop.Pointer | interop.Reference<any>, out_stride: number, out_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, out_delta_stride: number, weights_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, bias_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>): number;

declare function BNNSFilterApplyBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, _in: interop.Pointer | interop.Reference<any>, in_stride: number, out: interop.Pointer | interop.Reference<any>, out_stride: number): number;

declare function BNNSFilterApplyTwoInput(filter: interop.Pointer | interop.Reference<any>, inA: interop.Pointer | interop.Reference<any>, inB: interop.Pointer | interop.Reference<any>, out: interop.Pointer | interop.Reference<any>): number;

declare function BNNSFilterApplyTwoInputBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, inA: interop.Pointer | interop.Reference<any>, inA_stride: number, inB: interop.Pointer | interop.Reference<any>, inB_stride: number, out: interop.Pointer | interop.Reference<any>, out_stride: number): number;

declare function BNNSFilterCreateConvolutionLayer(in_desc: interop.Pointer | interop.Reference<BNNSImageStackDescriptor>, out_desc: interop.Pointer | interop.Reference<BNNSImageStackDescriptor>, layer_params: interop.Pointer | interop.Reference<BNNSConvolutionLayerParameters>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateFullyConnectedLayer(in_desc: interop.Pointer | interop.Reference<BNNSVectorDescriptor>, out_desc: interop.Pointer | interop.Reference<BNNSVectorDescriptor>, layer_params: interop.Pointer | interop.Reference<BNNSFullyConnectedLayerParameters>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateFusedLayer(number_of_fused_filters: number, filter_type: interop.Pointer | interop.Reference<BNNSFilterType>, layer_params: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<any>>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerActivation(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersActivation>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerArithmetic(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersArithmetic>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerBroadcastMatMul(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersBroadcastMatMul>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerConvolution(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersConvolution>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerDropout(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersDropout>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerFullyConnected(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersFullyConnected>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerGram(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersGram>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerLoss(layer_params: interop.Pointer | interop.Reference<any>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerMultiheadAttention(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersMultiheadAttention>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerNormalization(normType: BNNSFilterType, layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersNormalization>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerPadding(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersPadding>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerPermute(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersPermute>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerPooling(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersPooling>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerReduction(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersReduction>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerResize(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersResize>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerTensorContraction(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersTensorContraction>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateLayerTransposedConvolution(layer_params: interop.Pointer | interop.Reference<BNNSLayerParametersConvolution>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreatePoolingLayer(in_desc: interop.Pointer | interop.Reference<BNNSImageStackDescriptor>, out_desc: interop.Pointer | interop.Reference<BNNSImageStackDescriptor>, layer_params: interop.Pointer | interop.Reference<BNNSPoolingLayerParameters>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterCreateVectorActivationLayer(in_desc: interop.Pointer | interop.Reference<BNNSVectorDescriptor>, out_desc: interop.Pointer | interop.Reference<BNNSVectorDescriptor>, activation: interop.Pointer | interop.Reference<BNNSActivation>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): interop.Pointer | interop.Reference<any>;

declare function BNNSFilterDestroy(filter: interop.Pointer | interop.Reference<any>): void;

interface BNNSFilterParameters {
	flags: number;
	n_threads: number;
	alloc_memory: interop.FunctionReference<(p1: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<any>>, p2: number, p3: number) => number>;
	free_memory: interop.FunctionReference<(p1: interop.Pointer | interop.Reference<any>) => void>;
}
declare var BNNSFilterParameters: interop.StructType<BNNSFilterParameters>;

declare const enum BNNSFilterType {

	Convolution = 0,

	FullyConnected = 1,

	BatchNorm = 2,

	InstanceNorm = 3,

	LayerNorm = 4,

	GroupNorm = 5,

	TransposedConvolution = 6
}

declare const enum BNNSFlags {

	UseClientPtr = 1
}

interface BNNSFullyConnectedLayerParameters {
	in_size: number;
	out_size: number;
	weights: BNNSLayerData;
	bias: BNNSLayerData;
	activation: BNNSActivation;
}
declare var BNNSFullyConnectedLayerParameters: interop.StructType<BNNSFullyConnectedLayerParameters>;

declare function BNNSFusedFilterApplyBackwardBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, _in: interop.Pointer | interop.Reference<any>, in_stride: number, in_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, in_delta_stride: number, out: interop.Pointer | interop.Reference<any>, out_stride: number, out_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, out_delta_stride: number, delta_parameters: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>>): number;

declare function BNNSFusedFilterApplyBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, _in: interop.Pointer | interop.Reference<any>, in_stride: number, out: interop.Pointer | interop.Reference<any>, out_stride: number, training: boolean): number;

declare function BNNSGetPointer(filter: interop.Pointer | interop.Reference<any>, target: BNNSPointerSpecifier): BNNSNDArrayDescriptor;

interface BNNSImageStackDescriptor {
	width: number;
	height: number;
	channels: number;
	row_stride: number;
	image_stride: number;
	data_type: BNNSDataType;
	data_scale: number;
	data_bias: number;
}
declare var BNNSImageStackDescriptor: interop.StructType<BNNSImageStackDescriptor>;

declare const enum BNNSInterpolationMethod {

	Nearest = 0,

	Linear = 1
}

interface BNNSLSTMDataDescriptor {
	data_desc: BNNSNDArrayDescriptor;
	hidden_desc: BNNSNDArrayDescriptor;
	cell_state_desc: BNNSNDArrayDescriptor;
}
declare var BNNSLSTMDataDescriptor: interop.StructType<BNNSLSTMDataDescriptor>;

interface BNNSLSTMGateDescriptor {
	iw_desc: interop.Reference<BNNSNDArrayDescriptor>;
	hw_desc: BNNSNDArrayDescriptor;
	cw_desc: BNNSNDArrayDescriptor;
	b_desc: BNNSNDArrayDescriptor;
	activation: BNNSActivation;
}
declare var BNNSLSTMGateDescriptor: interop.StructType<BNNSLSTMGateDescriptor>;

interface BNNSLayerData {
	data: interop.Pointer | interop.Reference<any>;
	data_type: BNNSDataType;
	data_scale: number;
	data_bias: number;
	data_table: interop.Pointer | interop.Reference<number>;
}
declare var BNNSLayerData: interop.StructType<BNNSLayerData>;

declare const enum BNNSLayerFlags {

	LSTMBidirectional = 1,

	LSTMDefaultActivations = 2
}

interface BNNSLayerParametersActivation {
	i_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	activation: BNNSActivation;
	axis_flags: number;
}
declare var BNNSLayerParametersActivation: interop.StructType<BNNSLayerParametersActivation>;

interface BNNSLayerParametersArithmetic {
	arithmetic_function: BNNSArithmeticFunction;
	arithmetic_function_fields: interop.Pointer | interop.Reference<any>;
	activation: BNNSActivation;
}
declare var BNNSLayerParametersArithmetic: interop.StructType<BNNSLayerParametersArithmetic>;

interface BNNSLayerParametersBroadcastMatMul {
	alpha: number;
	beta: number;
	transA: boolean;
	transB: boolean;
	quadratic: boolean;
	a_is_weights: boolean;
	b_is_weights: boolean;
	iA_desc: BNNSNDArrayDescriptor;
	iB_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
}
declare var BNNSLayerParametersBroadcastMatMul: interop.StructType<BNNSLayerParametersBroadcastMatMul>;

interface BNNSLayerParametersConvolution {
	i_desc: BNNSNDArrayDescriptor;
	w_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	bias: BNNSNDArrayDescriptor;
	activation: BNNSActivation;
	x_stride: number;
	y_stride: number;
	x_dilation_stride: number;
	y_dilation_stride: number;
	x_padding: number;
	y_padding: number;
	groups: number;
	pad: interop.Reference<number>;
}
declare var BNNSLayerParametersConvolution: interop.StructType<BNNSLayerParametersConvolution>;

interface BNNSLayerParametersDropout {
	i_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	rate: number;
	seed: number;
	control: number;
}
declare var BNNSLayerParametersDropout: interop.StructType<BNNSLayerParametersDropout>;

interface BNNSLayerParametersFullyConnected {
	i_desc: BNNSNDArrayDescriptor;
	w_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	bias: BNNSNDArrayDescriptor;
	activation: BNNSActivation;
}
declare var BNNSLayerParametersFullyConnected: interop.StructType<BNNSLayerParametersFullyConnected>;

interface BNNSLayerParametersGram {
	alpha: number;
	i_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
}
declare var BNNSLayerParametersGram: interop.StructType<BNNSLayerParametersGram>;

interface BNNSLayerParametersLSTM {
	input_size: number;
	hidden_size: number;
	batch_size: number;
	num_layers: number;
	seq_len: number;
	dropout: number;
	lstm_flags: number;
	sequence_descriptor: BNNSNDArrayDescriptor;
	input_descriptor: BNNSLSTMDataDescriptor;
	output_descriptor: BNNSLSTMDataDescriptor;
	input_gate: BNNSLSTMGateDescriptor;
	forget_gate: BNNSLSTMGateDescriptor;
	candidate_gate: BNNSLSTMGateDescriptor;
	output_gate: BNNSLSTMGateDescriptor;
	hidden_activation: BNNSActivation;
}
declare var BNNSLayerParametersLSTM: interop.StructType<BNNSLayerParametersLSTM>;

interface BNNSLayerParametersLossBase {
	function: BNNSLossFunction;
	i_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	reduction: BNNSLossReductionFunction;
}
declare var BNNSLayerParametersLossBase: interop.StructType<BNNSLayerParametersLossBase>;

interface BNNSLayerParametersLossHuber {
	function: BNNSLossFunction;
	i_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	reduction: BNNSLossReductionFunction;
	huber_delta: number;
}
declare var BNNSLayerParametersLossHuber: interop.StructType<BNNSLayerParametersLossHuber>;

interface BNNSLayerParametersLossSigmoidCrossEntropy {
	function: BNNSLossFunction;
	i_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	reduction: BNNSLossReductionFunction;
	label_smooth: number;
}
declare var BNNSLayerParametersLossSigmoidCrossEntropy: interop.StructType<BNNSLayerParametersLossSigmoidCrossEntropy>;

interface BNNSLayerParametersLossSoftmaxCrossEntropy {
	function: BNNSLossFunction;
	i_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	reduction: BNNSLossReductionFunction;
	label_smooth: number;
}
declare var BNNSLayerParametersLossSoftmaxCrossEntropy: interop.StructType<BNNSLayerParametersLossSoftmaxCrossEntropy>;

interface BNNSLayerParametersLossYolo {
	function: BNNSLossFunction;
	i_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	reduction: BNNSLossReductionFunction;
	huber_delta: number;
	number_of_grid_columns: number;
	number_of_grid_rows: number;
	number_of_anchor_boxes: number;
	anchor_box_size: number;
	rescore: boolean;
	scale_xy: number;
	scale_wh: number;
	scale_object: number;
	scale_no_object: number;
	scale_classification: number;
	object_minimum_iou: number;
	no_object_maximum_iou: number;
	anchors_data: interop.Pointer | interop.Reference<number>;
}
declare var BNNSLayerParametersLossYolo: interop.StructType<BNNSLayerParametersLossYolo>;

interface BNNSLayerParametersMultiheadAttention {
	query: BNNSMHAProjectionParameters;
	key: BNNSMHAProjectionParameters;
	value: BNNSMHAProjectionParameters;
	add_zero_attn: boolean;
	key_attn_bias: BNNSNDArrayDescriptor;
	value_attn_bias: BNNSNDArrayDescriptor;
	output: BNNSMHAProjectionParameters;
	dropout: number;
	seed: number;
}
declare var BNNSLayerParametersMultiheadAttention: interop.StructType<BNNSLayerParametersMultiheadAttention>;

interface BNNSLayerParametersNormalization {
	i_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	beta_desc: BNNSNDArrayDescriptor;
	gamma_desc: BNNSNDArrayDescriptor;
	moving_mean_desc: BNNSNDArrayDescriptor;
	moving_variance_desc: BNNSNDArrayDescriptor;
	momentum: number;
	epsilon: number;
	activation: BNNSActivation;
	num_groups: number;
	normalization_axis: number;
}
declare var BNNSLayerParametersNormalization: interop.StructType<BNNSLayerParametersNormalization>;

interface BNNSLayerParametersPadding {
	i_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	padding_size: interop.Reference<interop.Reference<number>>;
	padding_mode: BNNSPaddingMode;
	padding_value: number;
}
declare var BNNSLayerParametersPadding: interop.StructType<BNNSLayerParametersPadding>;

interface BNNSLayerParametersPermute {
	i_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	permutation: interop.Reference<number>;
}
declare var BNNSLayerParametersPermute: interop.StructType<BNNSLayerParametersPermute>;

interface BNNSLayerParametersPooling {
	i_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	bias: BNNSNDArrayDescriptor;
	activation: BNNSActivation;
	pooling_function: BNNSPoolingFunction;
	k_width: number;
	k_height: number;
	x_stride: number;
	y_stride: number;
	x_dilation_stride: number;
	y_dilation_stride: number;
	x_padding: number;
	y_padding: number;
	pad: interop.Reference<number>;
}
declare var BNNSLayerParametersPooling: interop.StructType<BNNSLayerParametersPooling>;

interface BNNSLayerParametersReduction {
	i_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	w_desc: BNNSNDArrayDescriptor;
	reduce_func: BNNSReduceFunction;
	epsilon: number;
}
declare var BNNSLayerParametersReduction: interop.StructType<BNNSLayerParametersReduction>;

interface BNNSLayerParametersResize {
	method: BNNSInterpolationMethod;
	i_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
	align_corners: boolean;
}
declare var BNNSLayerParametersResize: interop.StructType<BNNSLayerParametersResize>;

interface BNNSLayerParametersTensorContraction {
	operation: string;
	alpha: number;
	beta: number;
	iA_desc: BNNSNDArrayDescriptor;
	iB_desc: BNNSNDArrayDescriptor;
	o_desc: BNNSNDArrayDescriptor;
}
declare var BNNSLayerParametersTensorContraction: interop.StructType<BNNSLayerParametersTensorContraction>;

declare function BNNSLossFilterApplyBackwardBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, _in: interop.Pointer | interop.Reference<any>, in_stride: number, in_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, in_delta_stride: number, labels: interop.Pointer | interop.Reference<any>, labels_stride: number, weights: interop.Pointer | interop.Reference<any>, weights_size: number, out_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, out_delta_stride: number): number;

declare function BNNSLossFilterApplyBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, _in: interop.Pointer | interop.Reference<any>, in_stride: number, labels: interop.Pointer | interop.Reference<any>, labels_stride: number, weights: interop.Pointer | interop.Reference<any>, weights_size: number, out: interop.Pointer | interop.Reference<any>, in_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, in_delta_stride: number): number;

declare const enum BNNSLossFunction {

	SoftmaxCrossEntropy = 1,

	SigmoidCrossEntropy = 2,

	MeanSquareError = 3,

	Huber = 4,

	Yolo = 5,

	Log = 6,

	CosineDistance = 7,

	Hinge = 8,

	MeanAbsoluteError = 9,

	CategoricalCrossEntropy = 10
}

declare const enum BNNSLossReductionFunction {

	None = 0,

	Sum = 1,

	WeightedMean = 2,

	Mean = 3,

	NonZeroWeightMean = 4
}

interface BNNSMHAProjectionParameters {
	target_desc: BNNSNDArrayDescriptor;
	weights: BNNSNDArrayDescriptor;
	bias: BNNSNDArrayDescriptor;
}
declare var BNNSMHAProjectionParameters: interop.StructType<BNNSMHAProjectionParameters>;

interface BNNSNDArrayDescriptor {
	flags: BNNSNDArrayFlags;
	layout: BNNSDataLayout;
	size: interop.Reference<number>;
	stride: interop.Reference<number>;
	data: interop.Pointer | interop.Reference<any>;
	data_type: BNNSDataType;
	table_data: interop.Pointer | interop.Reference<any>;
	table_data_type: BNNSDataType;
	data_scale: number;
	data_bias: number;
}
declare var BNNSNDArrayDescriptor: interop.StructType<BNNSNDArrayDescriptor>;

declare const enum BNNSNDArrayFlags {

	BackpropSet = 0,

	BackpropAccumulate = 1
}

declare function BNNSNormalizationFilterApplyBackwardBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, in_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, in_delta_stride: number, out: interop.Pointer | interop.Reference<any>, out_stride: number, out_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, out_delta_stride: number, beta_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, gamma_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>): number;

declare function BNNSNormalizationFilterApplyBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, _in: interop.Pointer | interop.Reference<any>, in_stride: number, out: interop.Pointer | interop.Reference<any>, out_stride: number, training: boolean): number;

interface BNNSOptimizerAdamFields {
	learning_rate: number;
	beta1: number;
	beta2: number;
	time_step: number;
	epsilon: number;
	gradient_scale: number;
	regularization_scale: number;
	clip_gradients: boolean;
	clip_gradients_min: number;
	clip_gradients_max: number;
	regularization_func: BNNSOptimizerRegularizationFunction;
}
declare var BNNSOptimizerAdamFields: interop.StructType<BNNSOptimizerAdamFields>;

declare const enum BNNSOptimizerFunction {

	SGDMomentum = 1,

	Adam = 2,

	RMSProp = 3
}

interface BNNSOptimizerRMSPropFields {
	learning_rate: number;
	alpha: number;
	epsilon: number;
	centered: boolean;
	momentum: number;
	gradient_scale: number;
	regularization_scale: number;
	clip_gradients: boolean;
	clip_gradients_min: number;
	clip_gradients_max: number;
	regularization_func: BNNSOptimizerRegularizationFunction;
}
declare var BNNSOptimizerRMSPropFields: interop.StructType<BNNSOptimizerRMSPropFields>;

declare const enum BNNSOptimizerRegularizationFunction {

	None = 0,

	L1 = 1,

	L2 = 2
}

interface BNNSOptimizerSGDMomentumFields {
	learning_rate: number;
	momentum: number;
	gradient_scale: number;
	regularization_scale: number;
	clip_gradients: boolean;
	clip_gradients_min: number;
	clip_gradients_max: number;
	nesterov: boolean;
	regularization_func: BNNSOptimizerRegularizationFunction;
	sgd_momentum_variant: BNNSOptimizerSGDMomentumVariant;
}
declare var BNNSOptimizerSGDMomentumFields: interop.StructType<BNNSOptimizerSGDMomentumFields>;

declare const enum BNNSOptimizerSGDMomentumVariant {

	SGDMomentumVariant0 = 0,

	SGDMomentumVariant1 = 1,

	SGDMomentumVariant2 = 2
}

declare function BNNSOptimizerStep(_function: BNNSOptimizerFunction, OptimizerAlgFields: interop.Pointer | interop.Reference<any>, number_of_parameters: number, parameters: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>>, gradients: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>>, accumulators: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>>, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): number;

declare const enum BNNSPaddingMode {

	Constant = 0,

	Reflect = 1,

	Symmetric = 2
}

declare function BNNSPermuteFilterApplyBackwardBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, in_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, in_delta_stride: number, out_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, out_delta_stride: number): number;

declare const enum BNNSPointerSpecifier {

	Alpha = 0,

	Beta = 1
}

declare function BNNSPoolingFilterApplyBackwardBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, _in: interop.Pointer | interop.Reference<any>, in_stride: number, in_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, in_delta_stride: number, out: interop.Pointer | interop.Reference<any>, out_stride: number, out_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, out_delta_stride: number, bias_delta: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, indices: interop.Pointer | interop.Reference<number>, idx_stride: number): number;

declare function BNNSPoolingFilterApplyBatch(filter: interop.Pointer | interop.Reference<any>, batch_size: number, _in: interop.Pointer | interop.Reference<any>, in_stride: number, out: interop.Pointer | interop.Reference<any>, out_stride: number, indices: interop.Pointer | interop.Reference<number>, idx_stride: number): number;

declare const enum BNNSPoolingFunction {

	Max = 0,

	AverageCountIncludePadding = 1,

	AverageCountExcludePadding = 2,

	UnMax = 3,

	L2Norm = 4,

	Average = 1
}

interface BNNSPoolingLayerParameters {
	x_stride: number;
	y_stride: number;
	x_padding: number;
	y_padding: number;
	k_width: number;
	k_height: number;
	in_channels: number;
	out_channels: number;
	pooling_function: BNNSPoolingFunction;
	bias: BNNSLayerData;
	activation: BNNSActivation;
}
declare var BNNSPoolingLayerParameters: interop.StructType<BNNSPoolingLayerParameters>;

declare const enum BNNSReduceFunction {

	Max = 0,

	Min = 1,

	ArgMax = 2,

	ArgMin = 3,

	Mean = 4,

	MeanNonZero = 5,

	Sum = 6,

	SumSquare = 7,

	SumLog = 8,

	L1Norm = 9,

	LogicalOr = 10,

	LogicalAnd = 11,

	Any = 10,

	All = 11
}

declare const enum BNNSRelationalOperator {

	Equal = 0,

	Less = 1,

	LessEqual = 2,

	Greater = 3,

	GreaterEqual = 4,

	NotEqual = 5,

	LogicalAND = 6,

	LogicalOR = 7,

	LogicalNOT = 8,

	LogicalNAND = 9,

	LogicalNOR = 10,

	LogicalXOR = 11
}

declare function BNNSTranspose(dest: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, src: interop.Pointer | interop.Reference<BNNSNDArrayDescriptor>, axis0: number, axis1: number, filter_params: interop.Pointer | interop.Reference<BNNSFilterParameters>): number;

interface BNNSVectorDescriptor {
	size: number;
	data_type: BNNSDataType;
	data_scale: number;
	data_bias: number;
}
declare var BNNSVectorDescriptor: interop.StructType<BNNSVectorDescriptor>;

declare const enum CBLAS_DIAG {

	CblasNonUnit = 131,

	CblasUnit = 132
}

declare const enum CBLAS_ORDER {

	CblasRowMajor = 101,

	CblasColMajor = 102
}

declare const enum CBLAS_SIDE {

	CblasLeft = 141,

	CblasRight = 142
}

declare const enum CBLAS_TRANSPOSE {

	CblasNoTrans = 111,

	CblasTrans = 112,

	CblasConjTrans = 113,

	AtlasConj = 114
}

declare const enum CBLAS_UPLO {

	CblasUpper = 121,

	CblasLower = 122
}

interface DSPComplex {
	real: number;
	imag: number;
}
declare var DSPComplex: interop.StructType<DSPComplex>;

interface DSPDoubleComplex {
	real: number;
	imag: number;
}
declare var DSPDoubleComplex: interop.StructType<DSPDoubleComplex>;

interface DSPDoubleSplitComplex {
	realp: interop.Pointer | interop.Reference<number>;
	imagp: interop.Pointer | interop.Reference<number>;
}
declare var DSPDoubleSplitComplex: interop.StructType<DSPDoubleSplitComplex>;

interface DSPSplitComplex {
	realp: interop.Pointer | interop.Reference<number>;
	imagp: interop.Pointer | interop.Reference<number>;
}
declare var DSPSplitComplex: interop.StructType<DSPSplitComplex>;

interface DenseMatrix_Double {
	rowCount: number;
	columnCount: number;
	columnStride: number;
	attributes: SparseAttributes_t;
	data: interop.Pointer | interop.Reference<number>;
}
declare var DenseMatrix_Double: interop.StructType<DenseMatrix_Double>;

interface DenseMatrix_Float {
	rowCount: number;
	columnCount: number;
	columnStride: number;
	attributes: SparseAttributes_t;
	data: interop.Pointer | interop.Reference<number>;
}
declare var DenseMatrix_Float: interop.StructType<DenseMatrix_Float>;

interface DenseVector_Double {
	count: number;
	data: interop.Pointer | interop.Reference<number>;
}
declare var DenseVector_Double: interop.StructType<DenseVector_Double>;

interface DenseVector_Float {
	count: number;
	data: interop.Pointer | interop.Reference<number>;
}
declare var DenseVector_Float: interop.StructType<DenseVector_Float>;

declare const FFT_FORWARD: number;

declare const FFT_INVERSE: number;

declare const FFT_RADIX2: number;

declare const FFT_RADIX3: number;

declare const FFT_RADIX5: number;

declare function SetBLASParamErrorProc(__ErrorProc: interop.FunctionReference<(p1: string, p2: string, p3: interop.Pointer | interop.Reference<number>, p4: interop.Pointer | interop.Reference<number>) => void>): void;

interface SparseAttributes_t {
	transpose: boolean;
	triangle: SparseTriangle_t;
	kind: SparseKind_t;
	_reserved: number;
	_allocatedBySparse: boolean;
}
declare var SparseAttributes_t: interop.StructType<SparseAttributes_t>;

interface SparseCGOptions {
	reportError: interop.FunctionReference<(p1: string) => void>;
	maxIterations: number;
	atol: number;
	rtol: number;
	reportStatus: interop.FunctionReference<(p1: string) => void>;
}
declare var SparseCGOptions: interop.StructType<SparseCGOptions>;

declare function SparseCleanup(Opaque: SparseOpaqueSymbolicFactorization): void;

declare function SparseCleanupFunction(Opaque: SparseOpaqueFactorization_Double): void;

declare function SparseCleanupFunction2(Opaque: SparseOpaqueFactorization_Float): void;

declare function SparseCleanupFunction3(Opaque: SparseOpaqueSubfactor_Double): void;

declare function SparseCleanupFunction4(Opaque: SparseOpaqueSubfactor_Float): void;

declare function SparseCleanupFunction5(Matrix: SparseMatrix_Double): void;

declare function SparseCleanupFunction6(Matrix: SparseMatrix_Float): void;

declare function SparseCleanupFunction7(Opaque: SparseOpaquePreconditioner_Double): void;

declare function SparseCleanupFunction8(Opaque: SparseOpaquePreconditioner_Float): void;

declare const enum SparseControl_t {

	DefaultControl = 0
}

declare function SparseConvertFromCoordinate(rowCount: number, columnCount: number, blockCount: number, blockSize: number, attributes: SparseAttributes_t, row: interop.Pointer | interop.Reference<number>, column: interop.Pointer | interop.Reference<number>, data: interop.Pointer | interop.Reference<number>): SparseMatrix_Double;

declare function SparseConvertFromCoordinateFunction(rowCount: number, columnCount: number, blockCount: number, blockSize: number, attributes: SparseAttributes_t, row: interop.Pointer | interop.Reference<number>, column: interop.Pointer | interop.Reference<number>, data: interop.Pointer | interop.Reference<number>): SparseMatrix_Float;

declare function SparseConvertFromCoordinateFunction2(rowCount: number, columnCount: number, blockCount: number, blockSize: number, attributes: SparseAttributes_t, row: interop.Pointer | interop.Reference<number>, column: interop.Pointer | interop.Reference<number>, data: interop.Pointer | interop.Reference<number>, storage: interop.Pointer | interop.Reference<any>, workspace: interop.Pointer | interop.Reference<any>): SparseMatrix_Double;

declare function SparseConvertFromCoordinateFunction3(rowCount: number, columnCount: number, blockCount: number, blockSize: number, attributes: SparseAttributes_t, row: interop.Pointer | interop.Reference<number>, column: interop.Pointer | interop.Reference<number>, data: interop.Pointer | interop.Reference<number>, storage: interop.Pointer | interop.Reference<any>, workspace: interop.Pointer | interop.Reference<any>): SparseMatrix_Float;

declare function SparseConvertFromOpaque(matrix: interop.Pointer | interop.Reference<any>): SparseMatrix_Double;

declare function SparseConvertFromOpaqueFunction(matrix: interop.Pointer | interop.Reference<any>): SparseMatrix_Float;

declare function SparseCreatePreconditioner(type: SparsePreconditioner_t, A: SparseMatrix_Double): SparseOpaquePreconditioner_Double;

declare function SparseCreatePreconditionerFunction(type: SparsePreconditioner_t, A: SparseMatrix_Float): SparseOpaquePreconditioner_Float;

declare function SparseCreateSubfactor(subfactor: SparseSubfactor_t, Factor: SparseOpaqueFactorization_Double): SparseOpaqueSubfactor_Double;

declare function SparseCreateSubfactorFunction(subfactor: SparseSubfactor_t, Factor: SparseOpaqueFactorization_Float): SparseOpaqueSubfactor_Float;

declare function SparseFactor(type: SparseFactorization_t, Matrix: SparseMatrix_Double): SparseOpaqueFactorization_Double;

declare function SparseFactorFunction(type: SparseFactorization_t, Matrix: SparseMatrix_Float): SparseOpaqueFactorization_Float;

declare function SparseFactorFunction10(type: SparseFactorization_t, Matrix: SparseMatrixStructure): SparseOpaqueSymbolicFactorization;

declare function SparseFactorFunction11(type: SparseFactorization_t, Matrix: SparseMatrixStructure, sfoptions: SparseSymbolicFactorOptions): SparseOpaqueSymbolicFactorization;

declare function SparseFactorFunction2(type: SparseFactorization_t, Matrix: SparseMatrix_Double, sfoptions: SparseSymbolicFactorOptions, nfoptions: SparseNumericFactorOptions): SparseOpaqueFactorization_Double;

declare function SparseFactorFunction3(type: SparseFactorization_t, Matrix: SparseMatrix_Float, sfoptions: SparseSymbolicFactorOptions, nfoptions: SparseNumericFactorOptions): SparseOpaqueFactorization_Float;

declare function SparseFactorFunction4(SymbolicFactor: SparseOpaqueSymbolicFactorization, Matrix: SparseMatrix_Double): SparseOpaqueFactorization_Double;

declare function SparseFactorFunction5(SymbolicFactor: SparseOpaqueSymbolicFactorization, Matrix: SparseMatrix_Float): SparseOpaqueFactorization_Float;

declare function SparseFactorFunction6(SymbolicFactor: SparseOpaqueSymbolicFactorization, Matrix: SparseMatrix_Double, nfoptions: SparseNumericFactorOptions): SparseOpaqueFactorization_Double;

declare function SparseFactorFunction7(SymbolicFactor: SparseOpaqueSymbolicFactorization, Matrix: SparseMatrix_Float, nfoptions: SparseNumericFactorOptions): SparseOpaqueFactorization_Float;

declare function SparseFactorFunction8(SymbolicFactor: SparseOpaqueSymbolicFactorization, Matrix: SparseMatrix_Double, nfoptions: SparseNumericFactorOptions, factorStorage: interop.Pointer | interop.Reference<any>, workspace: interop.Pointer | interop.Reference<any>): SparseOpaqueFactorization_Double;

declare function SparseFactorFunction9(SymbolicFactor: SparseOpaqueSymbolicFactorization, Matrix: SparseMatrix_Float, nfoptions: SparseNumericFactorOptions, factorStorage: interop.Pointer | interop.Reference<any>, workspace: interop.Pointer | interop.Reference<any>): SparseOpaqueFactorization_Float;

declare const enum SparseFactorization_t {

	Cholesky = 0,

	LDLT = 1,

	LDLTUnpivoted = 2,

	LDLTSBK = 3,

	LDLTTPP = 4,

	QR = 40,

	CholeskyAtA = 41
}

interface SparseGMRESOptions {
	reportError: interop.FunctionReference<(p1: string) => void>;
	variant: SparseGMRESVariant_t;
	nvec: number;
	maxIterations: number;
	atol: number;
	rtol: number;
	reportStatus: interop.FunctionReference<(p1: string) => void>;
}
declare var SparseGMRESOptions: interop.StructType<SparseGMRESOptions>;

declare const enum SparseGMRESVariant_t {

	VariantDQGMRES = 0,

	VariantGMRES = 1,

	VariantFGMRES = 2
}

declare function SparseGetTranspose(Matrix: SparseMatrix_Double): SparseMatrix_Double;

declare function SparseGetTransposeFunction(Matrix: SparseMatrix_Float): SparseMatrix_Float;

declare function SparseGetTransposeFunction2(Factor: SparseOpaqueFactorization_Double): SparseOpaqueFactorization_Double;

declare function SparseGetTransposeFunction3(Factor: SparseOpaqueFactorization_Float): SparseOpaqueFactorization_Float;

declare function SparseGetTransposeFunction4(Subfactor: SparseOpaqueSubfactor_Double): SparseOpaqueSubfactor_Double;

declare function SparseGetTransposeFunction5(Subfactor: SparseOpaqueSubfactor_Float): SparseOpaqueSubfactor_Float;

declare const enum SparseIterativeStatus_t {

	Converged = 0,

	MaxIterations = 1,

	ParameterError = -1,

	IllConditioned = -2,

	InternalError = -99
}

declare const enum SparseKind_t {

	Ordinary = 0,

	Triangular = 1,

	UnitTriangular = 2,

	Symmetric = 3
}

declare const enum SparseLSMRConvergenceTest_t {

	TDefault = 0,

	TFongSaunders = 1
}

interface SparseLSMROptions {
	reportError: interop.FunctionReference<(p1: string) => void>;
	lambda: number;
	nvec: number;
	convergenceTest: SparseLSMRConvergenceTest_t;
	atol: number;
	rtol: number;
	btol: number;
	conditionLimit: number;
	maxIterations: number;
	reportStatus: interop.FunctionReference<(p1: string) => void>;
}
declare var SparseLSMROptions: interop.StructType<SparseLSMROptions>;

interface SparseMatrixStructure {
	rowCount: number;
	columnCount: number;
	columnStarts: interop.Pointer | interop.Reference<number>;
	rowIndices: interop.Pointer | interop.Reference<number>;
	attributes: SparseAttributes_t;
	blockSize: number;
}
declare var SparseMatrixStructure: interop.StructType<SparseMatrixStructure>;

interface SparseMatrix_Double {
	structure: SparseMatrixStructure;
	data: interop.Pointer | interop.Reference<number>;
}
declare var SparseMatrix_Double: interop.StructType<SparseMatrix_Double>;

interface SparseMatrix_Float {
	structure: SparseMatrixStructure;
	data: interop.Pointer | interop.Reference<number>;
}
declare var SparseMatrix_Float: interop.StructType<SparseMatrix_Float>;

declare function SparseMultiply(A: SparseMatrix_Double, X: DenseMatrix_Double, Y: DenseMatrix_Double): void;

declare function SparseMultiplyAdd(A: SparseMatrix_Double, X: DenseMatrix_Double, Y: DenseMatrix_Double): void;

declare function SparseMultiplyAddFunction(A: SparseMatrix_Float, X: DenseMatrix_Float, Y: DenseMatrix_Float): void;

declare function SparseMultiplyAddFunction2(alpha: number, A: SparseMatrix_Double, X: DenseMatrix_Double, Y: DenseMatrix_Double): void;

declare function SparseMultiplyAddFunction3(alpha: number, A: SparseMatrix_Float, X: DenseMatrix_Float, Y: DenseMatrix_Float): void;

declare function SparseMultiplyAddFunction4(A: SparseMatrix_Double, x: DenseVector_Double, y: DenseVector_Double): void;

declare function SparseMultiplyAddFunction5(A: SparseMatrix_Float, x: DenseVector_Float, y: DenseVector_Float): void;

declare function SparseMultiplyAddFunction6(alpha: number, A: SparseMatrix_Double, x: DenseVector_Double, y: DenseVector_Double): void;

declare function SparseMultiplyAddFunction7(alpha: number, A: SparseMatrix_Float, x: DenseVector_Float, y: DenseVector_Float): void;

declare function SparseMultiplyFunction(A: SparseMatrix_Float, X: DenseMatrix_Float, Y: DenseMatrix_Float): void;

declare function SparseMultiplyFunction10(Subfactor: SparseOpaqueSubfactor_Double, X: DenseMatrix_Double, Y: DenseMatrix_Double): void;

declare function SparseMultiplyFunction11(Subfactor: SparseOpaqueSubfactor_Float, X: DenseMatrix_Float, Y: DenseMatrix_Float): void;

declare function SparseMultiplyFunction12(Subfactor: SparseOpaqueSubfactor_Double, XY: DenseMatrix_Double, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseMultiplyFunction13(Subfactor: SparseOpaqueSubfactor_Float, XY: DenseMatrix_Float, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseMultiplyFunction14(Subfactor: SparseOpaqueSubfactor_Double, X: DenseMatrix_Double, Y: DenseMatrix_Double, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseMultiplyFunction15(Subfactor: SparseOpaqueSubfactor_Float, X: DenseMatrix_Float, Y: DenseMatrix_Float, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseMultiplyFunction16(Subfactor: SparseOpaqueSubfactor_Double, xy: DenseVector_Double): void;

declare function SparseMultiplyFunction17(Subfactor: SparseOpaqueSubfactor_Float, xy: DenseVector_Float): void;

declare function SparseMultiplyFunction18(Subfactor: SparseOpaqueSubfactor_Double, x: DenseVector_Double, y: DenseVector_Double): void;

declare function SparseMultiplyFunction19(Subfactor: SparseOpaqueSubfactor_Float, x: DenseVector_Float, y: DenseVector_Float): void;

declare function SparseMultiplyFunction2(alpha: number, A: SparseMatrix_Double, X: DenseMatrix_Double, Y: DenseMatrix_Double): void;

declare function SparseMultiplyFunction20(Subfactor: SparseOpaqueSubfactor_Double, xy: DenseVector_Double, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseMultiplyFunction21(Subfactor: SparseOpaqueSubfactor_Float, xy: DenseVector_Float, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseMultiplyFunction22(Subfactor: SparseOpaqueSubfactor_Double, x: DenseVector_Double, y: DenseVector_Double, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseMultiplyFunction23(Subfactor: SparseOpaqueSubfactor_Float, x: DenseVector_Float, y: DenseVector_Float, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseMultiplyFunction3(alpha: number, A: SparseMatrix_Float, X: DenseMatrix_Float, Y: DenseMatrix_Float): void;

declare function SparseMultiplyFunction4(A: SparseMatrix_Double, x: DenseVector_Double, y: DenseVector_Double): void;

declare function SparseMultiplyFunction5(A: SparseMatrix_Float, x: DenseVector_Float, y: DenseVector_Float): void;

declare function SparseMultiplyFunction6(alpha: number, A: SparseMatrix_Double, x: DenseVector_Double, y: DenseVector_Double): void;

declare function SparseMultiplyFunction7(alpha: number, A: SparseMatrix_Float, x: DenseVector_Float, y: DenseVector_Float): void;

declare function SparseMultiplyFunction8(Subfactor: SparseOpaqueSubfactor_Double, XY: DenseMatrix_Double): void;

declare function SparseMultiplyFunction9(Subfactor: SparseOpaqueSubfactor_Float, XY: DenseMatrix_Float): void;

interface SparseNumericFactorOptions {
	control: SparseControl_t;
	scalingMethod: SparseScaling_t;
	scaling: interop.Pointer | interop.Reference<any>;
	pivotTolerance: number;
	zeroTolerance: number;
}
declare var SparseNumericFactorOptions: interop.StructType<SparseNumericFactorOptions>;

interface SparseOpaqueFactorization_Double {
	status: SparseStatus_t;
	attributes: SparseAttributes_t;
	symbolicFactorization: SparseOpaqueSymbolicFactorization;
	userFactorStorage: boolean;
	numericFactorization: interop.Pointer | interop.Reference<any>;
	solveWorkspaceRequiredStatic: number;
	solveWorkspaceRequiredPerRHS: number;
}
declare var SparseOpaqueFactorization_Double: interop.StructType<SparseOpaqueFactorization_Double>;

interface SparseOpaqueFactorization_Float {
	status: SparseStatus_t;
	attributes: SparseAttributes_t;
	symbolicFactorization: SparseOpaqueSymbolicFactorization;
	userFactorStorage: boolean;
	numericFactorization: interop.Pointer | interop.Reference<any>;
	solveWorkspaceRequiredStatic: number;
	solveWorkspaceRequiredPerRHS: number;
}
declare var SparseOpaqueFactorization_Float: interop.StructType<SparseOpaqueFactorization_Float>;

interface SparseOpaquePreconditioner_Double {
	type: SparsePreconditioner_t;
	mem: interop.Pointer | interop.Reference<any>;
	apply: interop.FunctionReference<(p1: interop.Pointer | interop.Reference<any>, p2: CBLAS_TRANSPOSE, p3: DenseMatrix_Double, p4: DenseMatrix_Double) => void>;
}
declare var SparseOpaquePreconditioner_Double: interop.StructType<SparseOpaquePreconditioner_Double>;

interface SparseOpaquePreconditioner_Float {
	type: SparsePreconditioner_t;
	mem: interop.Pointer | interop.Reference<any>;
	apply: interop.FunctionReference<(p1: interop.Pointer | interop.Reference<any>, p2: CBLAS_TRANSPOSE, p3: DenseMatrix_Float, p4: DenseMatrix_Float) => void>;
}
declare var SparseOpaquePreconditioner_Float: interop.StructType<SparseOpaquePreconditioner_Float>;

interface SparseOpaqueSubfactor_Double {
	attributes: SparseAttributes_t;
	contents: SparseSubfactor_t;
	factor: SparseOpaqueFactorization_Double;
	workspaceRequiredStatic: number;
	workspaceRequiredPerRHS: number;
}
declare var SparseOpaqueSubfactor_Double: interop.StructType<SparseOpaqueSubfactor_Double>;

interface SparseOpaqueSubfactor_Float {
	attributes: SparseAttributes_t;
	contents: SparseSubfactor_t;
	factor: SparseOpaqueFactorization_Float;
	workspaceRequiredStatic: number;
	workspaceRequiredPerRHS: number;
}
declare var SparseOpaqueSubfactor_Float: interop.StructType<SparseOpaqueSubfactor_Float>;

interface SparseOpaqueSymbolicFactorization {
	status: SparseStatus_t;
	rowCount: number;
	columnCount: number;
	attributes: SparseAttributes_t;
	blockSize: number;
	type: SparseFactorization_t;
	factorization: interop.Pointer | interop.Reference<any>;
	workspaceSize_Float: number;
	workspaceSize_Double: number;
	factorSize_Float: number;
	factorSize_Double: number;
}
declare var SparseOpaqueSymbolicFactorization: interop.StructType<SparseOpaqueSymbolicFactorization>;

declare const enum SparseOrder_t {

	Default = 0,

	User = 1,

	AMD = 2,

	Metis = 3,

	COLAMD = 4
}

declare const enum SparsePreconditioner_t {

	None = 0,

	User = 1,

	Diagonal = 2,

	DiagScaling = 3
}

declare function SparseRefactor(Matrix: SparseMatrix_Double, Factorization: interop.Pointer | interop.Reference<SparseOpaqueFactorization_Double>): void;

declare function SparseRefactorFunction(Matrix: SparseMatrix_Float, Factorization: interop.Pointer | interop.Reference<SparseOpaqueFactorization_Float>): void;

declare function SparseRefactorFunction2(Matrix: SparseMatrix_Double, Factorization: interop.Pointer | interop.Reference<SparseOpaqueFactorization_Double>, nfoptions: SparseNumericFactorOptions): void;

declare function SparseRefactorFunction3(Matrix: SparseMatrix_Float, Factorization: interop.Pointer | interop.Reference<SparseOpaqueFactorization_Float>, nfoptions: SparseNumericFactorOptions): void;

declare function SparseRefactorFunction4(Matrix: SparseMatrix_Double, Factorization: interop.Pointer | interop.Reference<SparseOpaqueFactorization_Double>, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseRefactorFunction5(Matrix: SparseMatrix_Float, Factorization: interop.Pointer | interop.Reference<SparseOpaqueFactorization_Float>, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseRefactorFunction6(Matrix: SparseMatrix_Double, Factorization: interop.Pointer | interop.Reference<SparseOpaqueFactorization_Double>, nfoptions: SparseNumericFactorOptions, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseRefactorFunction7(Matrix: SparseMatrix_Float, Factorization: interop.Pointer | interop.Reference<SparseOpaqueFactorization_Float>, nfoptions: SparseNumericFactorOptions, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseRetain(SymbolicFactor: SparseOpaqueSymbolicFactorization): SparseOpaqueSymbolicFactorization;

declare function SparseRetainFunction(NumericFactor: SparseOpaqueFactorization_Double): SparseOpaqueFactorization_Double;

declare function SparseRetainFunction2(NumericFactor: SparseOpaqueFactorization_Float): SparseOpaqueFactorization_Float;

declare function SparseRetainFunction3(NumericFactor: SparseOpaqueSubfactor_Double): SparseOpaqueSubfactor_Double;

declare function SparseRetainFunction4(NumericFactor: SparseOpaqueSubfactor_Float): SparseOpaqueSubfactor_Float;

declare const enum SparseScaling_t {

	Default = 0,

	User = 1,

	EquilibriationInf = 2
}

declare function SparseSolve(Factored: SparseOpaqueFactorization_Double, XB: DenseMatrix_Double): void;

declare function SparseSolveFunction(Factored: SparseOpaqueFactorization_Float, XB: DenseMatrix_Float): void;

declare function SparseSolveFunction10(Factored: SparseOpaqueFactorization_Double, b: DenseVector_Double, x: DenseVector_Double): void;

declare function SparseSolveFunction11(Factored: SparseOpaqueFactorization_Float, b: DenseVector_Float, x: DenseVector_Float): void;

declare function SparseSolveFunction12(Factored: SparseOpaqueFactorization_Double, xb: DenseVector_Double, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction13(Factored: SparseOpaqueFactorization_Float, xb: DenseVector_Float, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction14(Factored: SparseOpaqueFactorization_Double, x: DenseVector_Double, b: DenseVector_Double, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction15(Factored: SparseOpaqueFactorization_Float, x: DenseVector_Float, b: DenseVector_Float, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction16(Subfactor: SparseOpaqueSubfactor_Double, XB: DenseMatrix_Double): void;

declare function SparseSolveFunction17(Subfactor: SparseOpaqueSubfactor_Float, XB: DenseMatrix_Float): void;

declare function SparseSolveFunction18(Subfactor: SparseOpaqueSubfactor_Double, B: DenseMatrix_Double, X: DenseMatrix_Double): void;

declare function SparseSolveFunction19(Subfactor: SparseOpaqueSubfactor_Float, B: DenseMatrix_Float, X: DenseMatrix_Float): void;

declare function SparseSolveFunction2(Factored: SparseOpaqueFactorization_Double, B: DenseMatrix_Double, X: DenseMatrix_Double): void;

declare function SparseSolveFunction20(Subfactor: SparseOpaqueSubfactor_Double, XB: DenseMatrix_Double, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction21(Subfactor: SparseOpaqueSubfactor_Float, XB: DenseMatrix_Float, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction22(Subfactor: SparseOpaqueSubfactor_Double, B: DenseMatrix_Double, X: DenseMatrix_Double, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction23(Subfactor: SparseOpaqueSubfactor_Float, B: DenseMatrix_Float, X: DenseMatrix_Float, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction24(Subfactor: SparseOpaqueSubfactor_Double, xb: DenseVector_Double): void;

declare function SparseSolveFunction25(Subfactor: SparseOpaqueSubfactor_Float, xb: DenseVector_Float): void;

declare function SparseSolveFunction26(Subfactor: SparseOpaqueSubfactor_Double, b: DenseVector_Double, x: DenseVector_Double): void;

declare function SparseSolveFunction27(Subfactor: SparseOpaqueSubfactor_Float, b: DenseVector_Float, x: DenseVector_Float): void;

declare function SparseSolveFunction28(Subfactor: SparseOpaqueSubfactor_Double, xb: DenseVector_Double, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction29(Subfactor: SparseOpaqueSubfactor_Double, xb: DenseVector_Double, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction3(Factored: SparseOpaqueFactorization_Float, B: DenseMatrix_Float, X: DenseMatrix_Float): void;

declare function SparseSolveFunction30(Subfactor: SparseOpaqueSubfactor_Double, b: DenseVector_Double, x: DenseVector_Double, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction31(Subfactor: SparseOpaqueSubfactor_Float, b: DenseVector_Float, x: DenseVector_Float, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction4(Factored: SparseOpaqueFactorization_Double, XB: DenseMatrix_Double, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction5(Factored: SparseOpaqueFactorization_Float, XB: DenseMatrix_Float, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction6(Factored: SparseOpaqueFactorization_Double, X: DenseMatrix_Double, B: DenseMatrix_Double, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction7(Factored: SparseOpaqueFactorization_Float, X: DenseMatrix_Float, B: DenseMatrix_Float, workspace: interop.Pointer | interop.Reference<any>): void;

declare function SparseSolveFunction8(Factored: SparseOpaqueFactorization_Double, xb: DenseVector_Double): void;

declare function SparseSolveFunction9(Factored: SparseOpaqueFactorization_Float, xb: DenseVector_Float): void;

declare const enum SparseStatus_t {

	StatusOK = 0,

	FactorizationFailed = -1,

	MatrixIsSingular = -2,

	InternalError = -3,

	ParameterError = -4,

	StatusReleased = -2147483647
}

declare const enum SparseSubfactor_t {

	Invalid = 0,

	P = 1,

	S = 2,

	L = 3,

	D = 4,

	PLPS = 5,

	Q = 6,

	R = 7,

	RP = 8
}

interface SparseSymbolicFactorOptions {
	control: SparseControl_t;
	orderMethod: SparseOrder_t;
	order: interop.Pointer | interop.Reference<number>;
	ignoreRowsAndColumns: interop.Pointer | interop.Reference<number>;
	malloc: interop.FunctionReference<(p1: number) => interop.Pointer | interop.Reference<any>>;
	free: interop.FunctionReference<(p1: interop.Pointer | interop.Reference<any>) => void>;
	reportError: interop.FunctionReference<(p1: string) => void>;
}
declare var SparseSymbolicFactorOptions: interop.StructType<SparseSymbolicFactorOptions>;

declare const enum SparseTriangle_t {

	UpperTriangle = 0,

	LowerTriangle = 1
}

interface _SparseIterativeMethodBaseOptions {
	reportError: interop.FunctionReference<(p1: string) => void>;
}
declare var _SparseIterativeMethodBaseOptions: interop.StructType<_SparseIterativeMethodBaseOptions>;

interface __CLPK_complex {
	r: number;
	i: number;
}
declare var __CLPK_complex: interop.StructType<__CLPK_complex>;

interface __CLPK_doublecomplex {
	r: number;
	i: number;
}
declare var __CLPK_doublecomplex: interop.StructType<__CLPK_doublecomplex>;

declare function appleblas_dgeadd(__order: CBLAS_ORDER, __transA: CBLAS_TRANSPOSE, __transB: CBLAS_TRANSPOSE, __m: number, __n: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __beta: number, __B: interop.Pointer | interop.Reference<number>, __ldb: number, __C: interop.Pointer | interop.Reference<number>, __ldc: number): void;

declare function appleblas_sgeadd(__order: CBLAS_ORDER, __transA: CBLAS_TRANSPOSE, __transB: CBLAS_TRANSPOSE, __m: number, __n: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __beta: number, __B: interop.Pointer | interop.Reference<number>, __ldb: number, __C: interop.Pointer | interop.Reference<number>, __ldc: number): void;

declare function catlas_caxpby(__N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number, __beta: interop.Pointer | interop.Reference<any>, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function catlas_cset(__N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function catlas_daxpby(__N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __beta: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function catlas_dset(__N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function catlas_saxpby(__N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __beta: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function catlas_sset(__N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function catlas_zaxpby(__N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number, __beta: interop.Pointer | interop.Reference<any>, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function catlas_zset(__N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cbdsqr_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ncvt: interop.Pointer | interop.Reference<number>, __nru: interop.Pointer | interop.Reference<number>, __ncc: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvt: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<__CLPK_complex>, __ldu: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cblas_caxpy(__N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_ccopy(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_cdotc_sub(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number, __dotc: interop.Pointer | interop.Reference<any>): void;

declare function cblas_cdotu_sub(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number, __dotu: interop.Pointer | interop.Reference<any>): void;

declare function cblas_cgbmv(__Order: CBLAS_ORDER, __TransA: CBLAS_TRANSPOSE, __M: number, __N: number, __KL: number, __KU: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __beta: interop.Pointer | interop.Reference<any>, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_cgemm(__Order: CBLAS_ORDER, __TransA: CBLAS_TRANSPOSE, __TransB: CBLAS_TRANSPOSE, __M: number, __N: number, __K: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __B: interop.Pointer | interop.Reference<any>, __ldb: number, __beta: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<any>, __ldc: number): void;

declare function cblas_cgemv(__Order: CBLAS_ORDER, __TransA: CBLAS_TRANSPOSE, __M: number, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __beta: interop.Pointer | interop.Reference<any>, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_cgerc(__Order: CBLAS_ORDER, __M: number, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number, __A: interop.Pointer | interop.Reference<any>, __lda: number): void;

declare function cblas_cgeru(__Order: CBLAS_ORDER, __M: number, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number, __A: interop.Pointer | interop.Reference<any>, __lda: number): void;

declare function cblas_chbmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __K: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __beta: interop.Pointer | interop.Reference<any>, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_chemm(__Order: CBLAS_ORDER, __Side: CBLAS_SIDE, __Uplo: CBLAS_UPLO, __M: number, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __B: interop.Pointer | interop.Reference<any>, __ldb: number, __beta: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<any>, __ldc: number): void;

declare function cblas_chemv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __beta: interop.Pointer | interop.Reference<any>, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_cher(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __A: interop.Pointer | interop.Reference<any>, __lda: number): void;

declare function cblas_cher2(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number, __A: interop.Pointer | interop.Reference<any>, __lda: number): void;

declare function cblas_cher2k(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __Trans: CBLAS_TRANSPOSE, __N: number, __K: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __B: interop.Pointer | interop.Reference<any>, __ldb: number, __beta: number, __C: interop.Pointer | interop.Reference<any>, __ldc: number): void;

declare function cblas_cherk(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __Trans: CBLAS_TRANSPOSE, __N: number, __K: number, __alpha: number, __A: interop.Pointer | interop.Reference<any>, __lda: number, __beta: number, __C: interop.Pointer | interop.Reference<any>, __ldc: number): void;

declare function cblas_chpmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __Ap: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number, __beta: interop.Pointer | interop.Reference<any>, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_chpr(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __A: interop.Pointer | interop.Reference<any>): void;

declare function cblas_chpr2(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number, __Ap: interop.Pointer | interop.Reference<any>): void;

declare function cblas_crotg(__a: interop.Pointer | interop.Reference<any>, __b: interop.Pointer | interop.Reference<any>, __c: interop.Pointer | interop.Reference<any>, __s: interop.Pointer | interop.Reference<any>): void;

declare function cblas_cscal(__N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_csrot(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number, __c: number, __s: number): void;

declare function cblas_csscal(__N: number, __alpha: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_cswap(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_csymm(__Order: CBLAS_ORDER, __Side: CBLAS_SIDE, __Uplo: CBLAS_UPLO, __M: number, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __B: interop.Pointer | interop.Reference<any>, __ldb: number, __beta: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<any>, __ldc: number): void;

declare function cblas_csyr2k(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __Trans: CBLAS_TRANSPOSE, __N: number, __K: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __B: interop.Pointer | interop.Reference<any>, __ldb: number, __beta: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<any>, __ldc: number): void;

declare function cblas_csyrk(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __Trans: CBLAS_TRANSPOSE, __N: number, __K: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __beta: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<any>, __ldc: number): void;

declare function cblas_ctbmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __K: number, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_ctbsv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __K: number, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_ctpmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __Ap: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_ctpsv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __Ap: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_ctrmm(__Order: CBLAS_ORDER, __Side: CBLAS_SIDE, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __M: number, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __B: interop.Pointer | interop.Reference<any>, __ldb: number): void;

declare function cblas_ctrmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_ctrsm(__Order: CBLAS_ORDER, __Side: CBLAS_SIDE, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __M: number, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __B: interop.Pointer | interop.Reference<any>, __ldb: number): void;

declare function cblas_ctrsv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_dasum(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): number;

declare function cblas_daxpy(__N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_dcopy(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_ddot(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): number;

declare function cblas_dgbmv(__Order: CBLAS_ORDER, __TransA: CBLAS_TRANSPOSE, __M: number, __N: number, __KL: number, __KU: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __beta: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_dgemm(__Order: CBLAS_ORDER, __TransA: CBLAS_TRANSPOSE, __TransB: CBLAS_TRANSPOSE, __M: number, __N: number, __K: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __B: interop.Pointer | interop.Reference<number>, __ldb: number, __beta: number, __C: interop.Pointer | interop.Reference<number>, __ldc: number): void;

declare function cblas_dgemv(__Order: CBLAS_ORDER, __TransA: CBLAS_TRANSPOSE, __M: number, __N: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __beta: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_dger(__Order: CBLAS_ORDER, __M: number, __N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number, __A: interop.Pointer | interop.Reference<number>, __lda: number): void;

declare function cblas_dnrm2(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): number;

declare function cblas_drot(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number, __c: number, __s: number): void;

declare function cblas_drotg(__a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __c: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>): void;

declare function cblas_drotm(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number, __P: interop.Pointer | interop.Reference<number>): void;

declare function cblas_drotmg(__d1: interop.Pointer | interop.Reference<number>, __d2: interop.Pointer | interop.Reference<number>, __b1: interop.Pointer | interop.Reference<number>, __b2: number, __P: interop.Pointer | interop.Reference<number>): void;

declare function cblas_dsbmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __K: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __beta: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_dscal(__N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function cblas_dsdot(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): number;

declare function cblas_dspmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __Ap: interop.Pointer | interop.Reference<number>, __X: interop.Pointer | interop.Reference<number>, __incX: number, __beta: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_dspr(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Ap: interop.Pointer | interop.Reference<number>): void;

declare function cblas_dspr2(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number, __A: interop.Pointer | interop.Reference<number>): void;

declare function cblas_dswap(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_dsymm(__Order: CBLAS_ORDER, __Side: CBLAS_SIDE, __Uplo: CBLAS_UPLO, __M: number, __N: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __B: interop.Pointer | interop.Reference<number>, __ldb: number, __beta: number, __C: interop.Pointer | interop.Reference<number>, __ldc: number): void;

declare function cblas_dsymv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __beta: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_dsyr(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __A: interop.Pointer | interop.Reference<number>, __lda: number): void;

declare function cblas_dsyr2(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number, __A: interop.Pointer | interop.Reference<number>, __lda: number): void;

declare function cblas_dsyr2k(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __Trans: CBLAS_TRANSPOSE, __N: number, __K: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __B: interop.Pointer | interop.Reference<number>, __ldb: number, __beta: number, __C: interop.Pointer | interop.Reference<number>, __ldc: number): void;

declare function cblas_dsyrk(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __Trans: CBLAS_TRANSPOSE, __N: number, __K: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __beta: number, __C: interop.Pointer | interop.Reference<number>, __ldc: number): void;

declare function cblas_dtbmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __K: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function cblas_dtbsv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __K: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function cblas_dtpmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __Ap: interop.Pointer | interop.Reference<number>, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function cblas_dtpsv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __Ap: interop.Pointer | interop.Reference<number>, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function cblas_dtrmm(__Order: CBLAS_ORDER, __Side: CBLAS_SIDE, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __M: number, __N: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __B: interop.Pointer | interop.Reference<number>, __ldb: number): void;

declare function cblas_dtrmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function cblas_dtrsm(__Order: CBLAS_ORDER, __Side: CBLAS_SIDE, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __M: number, __N: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __B: interop.Pointer | interop.Reference<number>, __ldb: number): void;

declare function cblas_dtrsv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function cblas_dzasum(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): number;

declare function cblas_dznrm2(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): number;

declare function cblas_icamax(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): number;

declare function cblas_idamax(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): number;

declare function cblas_isamax(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): number;

declare function cblas_izamax(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): number;

declare function cblas_sasum(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): number;

declare function cblas_saxpy(__N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_scasum(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): number;

declare function cblas_scnrm2(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): number;

declare function cblas_scopy(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_sdot(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): number;

declare function cblas_sdsdot(__N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): number;

declare function cblas_sgbmv(__Order: CBLAS_ORDER, __TransA: CBLAS_TRANSPOSE, __M: number, __N: number, __KL: number, __KU: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __beta: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_sgemm(__Order: CBLAS_ORDER, __TransA: CBLAS_TRANSPOSE, __TransB: CBLAS_TRANSPOSE, __M: number, __N: number, __K: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __B: interop.Pointer | interop.Reference<number>, __ldb: number, __beta: number, __C: interop.Pointer | interop.Reference<number>, __ldc: number): void;

declare function cblas_sgemv(__Order: CBLAS_ORDER, __TransA: CBLAS_TRANSPOSE, __M: number, __N: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __beta: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_sger(__Order: CBLAS_ORDER, __M: number, __N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number, __A: interop.Pointer | interop.Reference<number>, __lda: number): void;

declare function cblas_snrm2(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): number;

declare function cblas_srot(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number, __c: number, __s: number): void;

declare function cblas_srotg(__a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __c: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>): void;

declare function cblas_srotm(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number, __P: interop.Pointer | interop.Reference<number>): void;

declare function cblas_srotmg(__d1: interop.Pointer | interop.Reference<number>, __d2: interop.Pointer | interop.Reference<number>, __b1: interop.Pointer | interop.Reference<number>, __b2: number, __P: interop.Pointer | interop.Reference<number>): void;

declare function cblas_ssbmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __K: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __beta: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_sscal(__N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function cblas_sspmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __Ap: interop.Pointer | interop.Reference<number>, __X: interop.Pointer | interop.Reference<number>, __incX: number, __beta: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_sspr(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Ap: interop.Pointer | interop.Reference<number>): void;

declare function cblas_sspr2(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number, __A: interop.Pointer | interop.Reference<number>): void;

declare function cblas_sswap(__N: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_ssymm(__Order: CBLAS_ORDER, __Side: CBLAS_SIDE, __Uplo: CBLAS_UPLO, __M: number, __N: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __B: interop.Pointer | interop.Reference<number>, __ldb: number, __beta: number, __C: interop.Pointer | interop.Reference<number>, __ldc: number): void;

declare function cblas_ssymv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __beta: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number): void;

declare function cblas_ssyr(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __A: interop.Pointer | interop.Reference<number>, __lda: number): void;

declare function cblas_ssyr2(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __X: interop.Pointer | interop.Reference<number>, __incX: number, __Y: interop.Pointer | interop.Reference<number>, __incY: number, __A: interop.Pointer | interop.Reference<number>, __lda: number): void;

declare function cblas_ssyr2k(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __Trans: CBLAS_TRANSPOSE, __N: number, __K: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __B: interop.Pointer | interop.Reference<number>, __ldb: number, __beta: number, __C: interop.Pointer | interop.Reference<number>, __ldc: number): void;

declare function cblas_ssyrk(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __Trans: CBLAS_TRANSPOSE, __N: number, __K: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __beta: number, __C: interop.Pointer | interop.Reference<number>, __ldc: number): void;

declare function cblas_stbmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __K: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function cblas_stbsv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __K: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function cblas_stpmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __Ap: interop.Pointer | interop.Reference<number>, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function cblas_stpsv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __Ap: interop.Pointer | interop.Reference<number>, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function cblas_strmm(__Order: CBLAS_ORDER, __Side: CBLAS_SIDE, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __M: number, __N: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __B: interop.Pointer | interop.Reference<number>, __ldb: number): void;

declare function cblas_strmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function cblas_strsm(__Order: CBLAS_ORDER, __Side: CBLAS_SIDE, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __M: number, __N: number, __alpha: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __B: interop.Pointer | interop.Reference<number>, __ldb: number): void;

declare function cblas_strsv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __A: interop.Pointer | interop.Reference<number>, __lda: number, __X: interop.Pointer | interop.Reference<number>, __incX: number): void;

declare function cblas_zaxpy(__N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_zcopy(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_zdotc_sub(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number, __dotc: interop.Pointer | interop.Reference<any>): void;

declare function cblas_zdotu_sub(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number, __dotu: interop.Pointer | interop.Reference<any>): void;

declare function cblas_zdrot(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number, __c: number, __s: number): void;

declare function cblas_zdscal(__N: number, __alpha: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_zgbmv(__Order: CBLAS_ORDER, __TransA: CBLAS_TRANSPOSE, __M: number, __N: number, __KL: number, __KU: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __beta: interop.Pointer | interop.Reference<any>, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_zgemm(__Order: CBLAS_ORDER, __TransA: CBLAS_TRANSPOSE, __TransB: CBLAS_TRANSPOSE, __M: number, __N: number, __K: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __B: interop.Pointer | interop.Reference<any>, __ldb: number, __beta: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<any>, __ldc: number): void;

declare function cblas_zgemv(__Order: CBLAS_ORDER, __TransA: CBLAS_TRANSPOSE, __M: number, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __beta: interop.Pointer | interop.Reference<any>, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_zgerc(__Order: CBLAS_ORDER, __M: number, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number, __A: interop.Pointer | interop.Reference<any>, __lda: number): void;

declare function cblas_zgeru(__Order: CBLAS_ORDER, __M: number, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number, __A: interop.Pointer | interop.Reference<any>, __lda: number): void;

declare function cblas_zhbmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __K: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __beta: interop.Pointer | interop.Reference<any>, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_zhemm(__Order: CBLAS_ORDER, __Side: CBLAS_SIDE, __Uplo: CBLAS_UPLO, __M: number, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __B: interop.Pointer | interop.Reference<any>, __ldb: number, __beta: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<any>, __ldc: number): void;

declare function cblas_zhemv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __beta: interop.Pointer | interop.Reference<any>, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_zher(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __A: interop.Pointer | interop.Reference<any>, __lda: number): void;

declare function cblas_zher2(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number, __A: interop.Pointer | interop.Reference<any>, __lda: number): void;

declare function cblas_zher2k(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __Trans: CBLAS_TRANSPOSE, __N: number, __K: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __B: interop.Pointer | interop.Reference<any>, __ldb: number, __beta: number, __C: interop.Pointer | interop.Reference<any>, __ldc: number): void;

declare function cblas_zherk(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __Trans: CBLAS_TRANSPOSE, __N: number, __K: number, __alpha: number, __A: interop.Pointer | interop.Reference<any>, __lda: number, __beta: number, __C: interop.Pointer | interop.Reference<any>, __ldc: number): void;

declare function cblas_zhpmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __Ap: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number, __beta: interop.Pointer | interop.Reference<any>, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_zhpr(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __A: interop.Pointer | interop.Reference<any>): void;

declare function cblas_zhpr2(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number, __Ap: interop.Pointer | interop.Reference<any>): void;

declare function cblas_zrotg(__a: interop.Pointer | interop.Reference<any>, __b: interop.Pointer | interop.Reference<any>, __c: interop.Pointer | interop.Reference<any>, __s: interop.Pointer | interop.Reference<any>): void;

declare function cblas_zscal(__N: number, __alpha: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_zswap(__N: number, __X: interop.Pointer | interop.Reference<any>, __incX: number, __Y: interop.Pointer | interop.Reference<any>, __incY: number): void;

declare function cblas_zsymm(__Order: CBLAS_ORDER, __Side: CBLAS_SIDE, __Uplo: CBLAS_UPLO, __M: number, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __B: interop.Pointer | interop.Reference<any>, __ldb: number, __beta: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<any>, __ldc: number): void;

declare function cblas_zsyr2k(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __Trans: CBLAS_TRANSPOSE, __N: number, __K: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __B: interop.Pointer | interop.Reference<any>, __ldb: number, __beta: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<any>, __ldc: number): void;

declare function cblas_zsyrk(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __Trans: CBLAS_TRANSPOSE, __N: number, __K: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __beta: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<any>, __ldc: number): void;

declare function cblas_ztbmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __K: number, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_ztbsv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __K: number, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_ztpmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __Ap: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_ztpsv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __Ap: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_ztrmm(__Order: CBLAS_ORDER, __Side: CBLAS_SIDE, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __M: number, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __B: interop.Pointer | interop.Reference<any>, __ldb: number): void;

declare function cblas_ztrmv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cblas_ztrsm(__Order: CBLAS_ORDER, __Side: CBLAS_SIDE, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __M: number, __N: number, __alpha: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<any>, __lda: number, __B: interop.Pointer | interop.Reference<any>, __ldb: number): void;

declare function cblas_ztrsv(__Order: CBLAS_ORDER, __Uplo: CBLAS_UPLO, __TransA: CBLAS_TRANSPOSE, __Diag: CBLAS_DIAG, __N: number, __A: interop.Pointer | interop.Reference<any>, __lda: number, __X: interop.Pointer | interop.Reference<any>, __incX: number): void;

declare function cgbbrd_(__vect: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ncc: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __pt: interop.Pointer | interop.Reference<__CLPK_complex>, __ldpt: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgbcon_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgbequ_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgbequb_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgbrfs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __afb: interop.Pointer | interop.Reference<__CLPK_complex>, __ldafb: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgbsv_(__n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgbsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __afb: interop.Pointer | interop.Reference<__CLPK_complex>, __ldafb: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgbtf2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgbtrf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgbtrs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgebak_(__job: string | interop.Pointer | interop.Reference<any>, __side: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __ldv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgebal_(__job: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgebd2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tauq: interop.Pointer | interop.Reference<__CLPK_complex>, __taup: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgebrd_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tauq: interop.Pointer | interop.Reference<__CLPK_complex>, __taup: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgecon_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgeequ_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgeequb_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgees_(__jobvs: string | interop.Pointer | interop.Reference<any>, __sort: string | interop.Pointer | interop.Reference<any>, __select: interop.FunctionReference<() => number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __sdim: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __vs: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvs: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgeesx_(__jobvs: string | interop.Pointer | interop.Reference<any>, __sort: string | interop.Pointer | interop.Reference<any>, __select: interop.FunctionReference<() => number>, __sense: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __sdim: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __vs: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvs: interop.Pointer | interop.Reference<number>, __rconde: interop.Pointer | interop.Reference<number>, __rcondv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgeev_(__jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __vl: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgeevx_(__balanc: string | interop.Pointer | interop.Reference<any>, __jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __sense: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __vl: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvr: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __abnrm: interop.Pointer | interop.Reference<number>, __rconde: interop.Pointer | interop.Reference<number>, __rcondv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgegs_(__jobvsl: string | interop.Pointer | interop.Reference<any>, __jobvsr: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __beta: interop.Pointer | interop.Reference<__CLPK_complex>, __vsl: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvsl: interop.Pointer | interop.Reference<number>, __vsr: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvsr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgegv_(__jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __beta: interop.Pointer | interop.Reference<__CLPK_complex>, __vl: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgehd2_(__n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgehrd_(__n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgelq2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgelqf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgels_(__trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgelsd_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgelss_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgelsx_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgelsy_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgeql2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgeqlf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgeqp3_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgeqpf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgeqr2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgeqrf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgerfs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<__CLPK_complex>, __ldaf: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgerq2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgerqf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgesc2_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __rhs: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __jpiv: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>): number;

declare function cgesdd_(__jobz: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<__CLPK_complex>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvt: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgesv_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgesvd_(__jobu: string | interop.Pointer | interop.Reference<any>, __jobvt: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<__CLPK_complex>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvt: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgesvx_(__fact: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<__CLPK_complex>, __ldaf: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgetc2_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __jpiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgetf2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgetrf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgetri_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgetrs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cggbak_(__job: string | interop.Pointer | interop.Reference<any>, __side: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __lscale: interop.Pointer | interop.Reference<number>, __rscale: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __ldv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cggbal_(__job: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __lscale: interop.Pointer | interop.Reference<number>, __rscale: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgges_(__jobvsl: string | interop.Pointer | interop.Reference<any>, __jobvsr: string | interop.Pointer | interop.Reference<any>, __sort: string | interop.Pointer | interop.Reference<any>, __selctg: interop.FunctionReference<() => number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __sdim: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __beta: interop.Pointer | interop.Reference<__CLPK_complex>, __vsl: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvsl: interop.Pointer | interop.Reference<number>, __vsr: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvsr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cggesx_(__jobvsl: string | interop.Pointer | interop.Reference<any>, __jobvsr: string | interop.Pointer | interop.Reference<any>, __sort: string | interop.Pointer | interop.Reference<any>, __selctg: interop.FunctionReference<() => number>, __sense: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __sdim: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __beta: interop.Pointer | interop.Reference<__CLPK_complex>, __vsl: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvsl: interop.Pointer | interop.Reference<number>, __vsr: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvsr: interop.Pointer | interop.Reference<number>, __rconde: interop.Pointer | interop.Reference<number>, __rcondv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cggev_(__jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __beta: interop.Pointer | interop.Reference<__CLPK_complex>, __vl: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cggevx_(__balanc: string | interop.Pointer | interop.Reference<any>, __jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __sense: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __beta: interop.Pointer | interop.Reference<__CLPK_complex>, __vl: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvr: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __lscale: interop.Pointer | interop.Reference<number>, __rscale: interop.Pointer | interop.Reference<number>, __abnrm: interop.Pointer | interop.Reference<number>, __bbnrm: interop.Pointer | interop.Reference<number>, __rconde: interop.Pointer | interop.Reference<number>, __rcondv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cggglm_(__n: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<__CLPK_complex>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __y: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgghrd_(__compq: string | interop.Pointer | interop.Reference<any>, __compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgglse_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __d__: interop.Pointer | interop.Reference<__CLPK_complex>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cggqrf_(__n: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __taua: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __taub: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cggrqf_(__m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __taua: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __taub: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cggsvd_(__jobu: string | interop.Pointer | interop.Reference<any>, __jobv: string | interop.Pointer | interop.Reference<any>, __jobq: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<__CLPK_complex>, __ldu: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __ldv: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cggsvp_(__jobu: string | interop.Pointer | interop.Reference<any>, __jobv: string | interop.Pointer | interop.Reference<any>, __jobq: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __tola: interop.Pointer | interop.Reference<number>, __tolb: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<__CLPK_complex>, __ldu: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __ldv: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgtcon_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<__CLPK_complex>, __d__: interop.Pointer | interop.Reference<__CLPK_complex>, __du: interop.Pointer | interop.Reference<__CLPK_complex>, __du2: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgtrfs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<__CLPK_complex>, __d__: interop.Pointer | interop.Reference<__CLPK_complex>, __du: interop.Pointer | interop.Reference<__CLPK_complex>, __dlf: interop.Pointer | interop.Reference<__CLPK_complex>, __df: interop.Pointer | interop.Reference<__CLPK_complex>, __duf: interop.Pointer | interop.Reference<__CLPK_complex>, __du2: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgtsv_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<__CLPK_complex>, __d__: interop.Pointer | interop.Reference<__CLPK_complex>, __du: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgtsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<__CLPK_complex>, __d__: interop.Pointer | interop.Reference<__CLPK_complex>, __du: interop.Pointer | interop.Reference<__CLPK_complex>, __dlf: interop.Pointer | interop.Reference<__CLPK_complex>, __df: interop.Pointer | interop.Reference<__CLPK_complex>, __duf: interop.Pointer | interop.Reference<__CLPK_complex>, __du2: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgttrf_(__n: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<__CLPK_complex>, __d__: interop.Pointer | interop.Reference<__CLPK_complex>, __du: interop.Pointer | interop.Reference<__CLPK_complex>, __du2: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgttrs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<__CLPK_complex>, __d__: interop.Pointer | interop.Reference<__CLPK_complex>, __du: interop.Pointer | interop.Reference<__CLPK_complex>, __du2: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cgtts2_(__itrans: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<__CLPK_complex>, __d__: interop.Pointer | interop.Reference<__CLPK_complex>, __du: interop.Pointer | interop.Reference<__CLPK_complex>, __du2: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function chbev_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chbevd_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __lrwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chbevx_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chbgst_(__vect: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ka: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __bb: interop.Pointer | interop.Reference<__CLPK_complex>, __ldbb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chbgv_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ka: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __bb: interop.Pointer | interop.Reference<__CLPK_complex>, __ldbb: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chbgvd_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ka: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __bb: interop.Pointer | interop.Reference<__CLPK_complex>, __ldbb: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __lrwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chbgvx_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ka: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __bb: interop.Pointer | interop.Reference<__CLPK_complex>, __ldbb: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chbtrd_(__vect: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function checon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cheequb_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cheev_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cheevd_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __lrwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cheevr_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __lrwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cheevx_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chegs2_(__itype: interop.Pointer | interop.Reference<number>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chegst_(__itype: interop.Pointer | interop.Reference<number>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chegv_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chegvd_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __lrwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chegvx_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cherfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<__CLPK_complex>, __ldaf: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chesv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chesvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<__CLPK_complex>, __ldaf: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chetd2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chetf2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chetrd_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chetrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chetri_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chetrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chfrk_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function chgeqz_(__job: string | interop.Pointer | interop.Reference<any>, __compq: string | interop.Pointer | interop.Reference<any>, __compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldh: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<__CLPK_complex>, __ldt: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __beta: interop.Pointer | interop.Reference<__CLPK_complex>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chla_transtype__(__ret_val: string | interop.Pointer | interop.Reference<any>, __ret_val_len: number, __trans: interop.Pointer | interop.Reference<number>): void;

declare function chpcon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chpev_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chpevd_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __lrwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chpevx_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chpgst_(__itype: interop.Pointer | interop.Reference<number>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __bp: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chpgv_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __bp: interop.Pointer | interop.Reference<__CLPK_complex>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chpgvd_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __bp: interop.Pointer | interop.Reference<__CLPK_complex>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __lrwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chpgvx_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __bp: interop.Pointer | interop.Reference<__CLPK_complex>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chprfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __afp: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chpsv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chpsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __afp: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chptrd_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chptrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chptri_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chptrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chsein_(__side: string | interop.Pointer | interop.Reference<any>, __eigsrc: string | interop.Pointer | interop.Reference<any>, __initv: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldh: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __vl: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvr: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __ifaill: interop.Pointer | interop.Reference<number>, __ifailr: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function chseqr_(__job: string | interop.Pointer | interop.Reference<any>, __compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldh: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function clabrd_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tauq: interop.Pointer | interop.Reference<__CLPK_complex>, __taup: interop.Pointer | interop.Reference<__CLPK_complex>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<__CLPK_complex>, __ldy: interop.Pointer | interop.Reference<number>): number;

declare function clacgv_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>): number;

declare function clacn2_(__n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __est: interop.Pointer | interop.Reference<number>, __kase: interop.Pointer | interop.Reference<number>, __isave: interop.Pointer | interop.Reference<number>): number;

declare function clacon_(__n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __est: interop.Pointer | interop.Reference<number>, __kase: interop.Pointer | interop.Reference<number>): number;

declare function clacp2_(__uplo: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function clacpy_(__uplo: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function clacrm_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>): number;

declare function clacrt_(__n: interop.Pointer | interop.Reference<number>, __cx: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>, __cy: interop.Pointer | interop.Reference<__CLPK_complex>, __incy: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __s: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function cladiv_(__ret_val: interop.Pointer | interop.Reference<__CLPK_complex>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __y: interop.Pointer | interop.Reference<__CLPK_complex>): void;

declare function claed0_(__qsiz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __qstore: interop.Pointer | interop.Reference<__CLPK_complex>, __ldqs: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function claed7_(__n: interop.Pointer | interop.Reference<number>, __cutpnt: interop.Pointer | interop.Reference<number>, __qsiz: interop.Pointer | interop.Reference<number>, __tlvls: interop.Pointer | interop.Reference<number>, __curlvl: interop.Pointer | interop.Reference<number>, __curpbm: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __indxq: interop.Pointer | interop.Reference<number>, __qstore: interop.Pointer | interop.Reference<number>, __qptr: interop.Pointer | interop.Reference<number>, __prmptr: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function claed8_(__k: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __qsiz: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __cutpnt: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __dlamda: interop.Pointer | interop.Reference<number>, __q2: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq2: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __indxp: interop.Pointer | interop.Reference<number>, __indx: interop.Pointer | interop.Reference<number>, __indxq: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function claein_(__rightv: interop.Pointer | interop.Reference<number>, __noinit: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldh: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __eps3: interop.Pointer | interop.Reference<number>, __smlnum: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function claesy_(__a: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __rt1: interop.Pointer | interop.Reference<__CLPK_complex>, __rt2: interop.Pointer | interop.Reference<__CLPK_complex>, __evscal: interop.Pointer | interop.Reference<__CLPK_complex>, __cs1: interop.Pointer | interop.Reference<__CLPK_complex>, __sn1: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function claev2_(__a: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __rt1: interop.Pointer | interop.Reference<number>, __rt2: interop.Pointer | interop.Reference<number>, __cs1: interop.Pointer | interop.Reference<number>, __sn1: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function clag2z_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __sa: interop.Pointer | interop.Reference<__CLPK_complex>, __ldsa: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_doublecomplex>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function clags2_(__upper: interop.Pointer | interop.Reference<number>, __a1: interop.Pointer | interop.Reference<number>, __a2: interop.Pointer | interop.Reference<__CLPK_complex>, __a3: interop.Pointer | interop.Reference<number>, __b1: interop.Pointer | interop.Reference<number>, __b2: interop.Pointer | interop.Reference<__CLPK_complex>, __b3: interop.Pointer | interop.Reference<number>, __csu: interop.Pointer | interop.Reference<number>, __snu: interop.Pointer | interop.Reference<__CLPK_complex>, __csv: interop.Pointer | interop.Reference<number>, __snv: interop.Pointer | interop.Reference<__CLPK_complex>, __csq: interop.Pointer | interop.Reference<number>, __snq: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function clagtm_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<__CLPK_complex>, __d__: interop.Pointer | interop.Reference<__CLPK_complex>, __du: interop.Pointer | interop.Reference<__CLPK_complex>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function clahef_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __ldw: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function clahqr_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldh: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function clahr2_(__n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __t: interop.Pointer | interop.Reference<__CLPK_complex>, __ldt: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<__CLPK_complex>, __ldy: interop.Pointer | interop.Reference<number>): number;

declare function clahrd_(__n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __t: interop.Pointer | interop.Reference<__CLPK_complex>, __ldt: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<__CLPK_complex>, __ldy: interop.Pointer | interop.Reference<number>): number;

declare function claic1_(__job: interop.Pointer | interop.Reference<number>, __j: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __sest: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __gamma: interop.Pointer | interop.Reference<__CLPK_complex>, __sestpr: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function clals0_(__icompq: interop.Pointer | interop.Reference<number>, __nl: interop.Pointer | interop.Reference<number>, __nr: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __bx: interop.Pointer | interop.Reference<__CLPK_complex>, __ldbx: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __ldgcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __ldgnum: interop.Pointer | interop.Reference<number>, __poles: interop.Pointer | interop.Reference<number>, __difl: interop.Pointer | interop.Reference<number>, __difr: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function clalsa_(__icompq: interop.Pointer | interop.Reference<number>, __smlsiz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __bx: interop.Pointer | interop.Reference<__CLPK_complex>, __ldbx: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __difl: interop.Pointer | interop.Reference<number>, __difr: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __poles: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __ldgcol: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function clalsd_(__uplo: string | interop.Pointer | interop.Reference<any>, __smlsiz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function clangb_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function clange_(__norm: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function clangt_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<__CLPK_complex>, __d__: interop.Pointer | interop.Reference<__CLPK_complex>, __du: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function clanhb_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function clanhe_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function clanhf_(__norm: string | interop.Pointer | interop.Reference<any>, __transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<number>): number;

declare function clanhp_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<number>): number;

declare function clanhs_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function clanht_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function clansb_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function clansp_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<number>): number;

declare function clansy_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function clantb_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function clantp_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<number>): number;

declare function clantr_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function clapll_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<__CLPK_complex>, __incy: interop.Pointer | interop.Reference<number>, __ssmin: interop.Pointer | interop.Reference<number>): number;

declare function clapmt_(__forwrd: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>): number;

declare function claqgb_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function claqge_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function claqhb_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function claqhe_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function claqhp_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function claqp2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __offset: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __vn1: interop.Pointer | interop.Reference<number>, __vn2: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function claqps_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __offset: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __vn1: interop.Pointer | interop.Reference<number>, __vn2: interop.Pointer | interop.Reference<number>, __auxv: interop.Pointer | interop.Reference<__CLPK_complex>, __f: interop.Pointer | interop.Reference<__CLPK_complex>, __ldf: interop.Pointer | interop.Reference<number>): number;

declare function claqr0_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldh: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function claqr1_(__n: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldh: interop.Pointer | interop.Reference<number>, __s1: interop.Pointer | interop.Reference<__CLPK_complex>, __s2: interop.Pointer | interop.Reference<__CLPK_complex>, __v: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function claqr2_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ktop: interop.Pointer | interop.Reference<number>, __kbot: interop.Pointer | interop.Reference<number>, __nw: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldh: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __ns: interop.Pointer | interop.Reference<number>, __nd: interop.Pointer | interop.Reference<number>, __sh: interop.Pointer | interop.Reference<__CLPK_complex>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __ldv: interop.Pointer | interop.Reference<number>, __nh: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<__CLPK_complex>, __ldt: interop.Pointer | interop.Reference<number>, __nv: interop.Pointer | interop.Reference<number>, __wv: interop.Pointer | interop.Reference<__CLPK_complex>, __ldwv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>): number;

declare function claqr3_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ktop: interop.Pointer | interop.Reference<number>, __kbot: interop.Pointer | interop.Reference<number>, __nw: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldh: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __ns: interop.Pointer | interop.Reference<number>, __nd: interop.Pointer | interop.Reference<number>, __sh: interop.Pointer | interop.Reference<__CLPK_complex>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __ldv: interop.Pointer | interop.Reference<number>, __nh: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<__CLPK_complex>, __ldt: interop.Pointer | interop.Reference<number>, __nv: interop.Pointer | interop.Reference<number>, __wv: interop.Pointer | interop.Reference<__CLPK_complex>, __ldwv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>): number;

declare function claqr4_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldh: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function claqr5_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __kacc22: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ktop: interop.Pointer | interop.Reference<number>, __kbot: interop.Pointer | interop.Reference<number>, __nshfts: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<__CLPK_complex>, __h__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldh: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __ldv: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<__CLPK_complex>, __ldu: interop.Pointer | interop.Reference<number>, __nv: interop.Pointer | interop.Reference<number>, __wv: interop.Pointer | interop.Reference<__CLPK_complex>, __ldwv: interop.Pointer | interop.Reference<number>, __nh: interop.Pointer | interop.Reference<number>, __wh: interop.Pointer | interop.Reference<__CLPK_complex>, __ldwh: interop.Pointer | interop.Reference<number>): number;

declare function claqsb_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function claqsp_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function claqsy_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function clar1v_(__n: interop.Pointer | interop.Reference<number>, __b1: interop.Pointer | interop.Reference<number>, __bn: interop.Pointer | interop.Reference<number>, __lambda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __ld: interop.Pointer | interop.Reference<number>, __lld: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __gaptol: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __wantnc: interop.Pointer | interop.Reference<number>, __negcnt: interop.Pointer | interop.Reference<number>, __ztz: interop.Pointer | interop.Reference<number>, __mingma: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __nrminv: interop.Pointer | interop.Reference<number>, __resid: interop.Pointer | interop.Reference<number>, __rqcorr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function clar2v_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __y: interop.Pointer | interop.Reference<__CLPK_complex>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<__CLPK_complex>, __incc: interop.Pointer | interop.Reference<number>): number;

declare function clarcm_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>): number;

declare function clarf_(__side: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __incv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function clarfb_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __direct: string | interop.Pointer | interop.Reference<any>, __storev: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __ldv: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<__CLPK_complex>, __ldt: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __ldwork: interop.Pointer | interop.Reference<number>): number;

declare function clarfg_(__n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function clarfp_(__n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function clarft_(__direct: string | interop.Pointer | interop.Reference<any>, __storev: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __ldv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __t: interop.Pointer | interop.Reference<__CLPK_complex>, __ldt: interop.Pointer | interop.Reference<number>): number;

declare function clarfx_(__side: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function clargv_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<__CLPK_complex>, __incy: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __incc: interop.Pointer | interop.Reference<number>): number;

declare function clarnv_(__idist: interop.Pointer | interop.Reference<number>, __iseed: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function clarrv_(__n: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __isplit: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __dol: interop.Pointer | interop.Reference<number>, __dou: interop.Pointer | interop.Reference<number>, __minrgp: interop.Pointer | interop.Reference<number>, __rtol1: interop.Pointer | interop.Reference<number>, __rtol2: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __wgap: interop.Pointer | interop.Reference<number>, __iblock: interop.Pointer | interop.Reference<number>, __indexw: interop.Pointer | interop.Reference<number>, __gers: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function clarscl2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>): number;

declare function clartg_(__f: interop.Pointer | interop.Reference<__CLPK_complex>, __g: interop.Pointer | interop.Reference<__CLPK_complex>, __cs: interop.Pointer | interop.Reference<number>, __sn: interop.Pointer | interop.Reference<__CLPK_complex>, __r__: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function clartv_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<__CLPK_complex>, __incy: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<__CLPK_complex>, __incc: interop.Pointer | interop.Reference<number>): number;

declare function clarz_(__side: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __incv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function clarzb_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __direct: string | interop.Pointer | interop.Reference<any>, __storev: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __ldv: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<__CLPK_complex>, __ldt: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __ldwork: interop.Pointer | interop.Reference<number>): number;

declare function clarzt_(__direct: string | interop.Pointer | interop.Reference<any>, __storev: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __ldv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __t: interop.Pointer | interop.Reference<__CLPK_complex>, __ldt: interop.Pointer | interop.Reference<number>): number;

declare function clascl2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>): number;

declare function clascl_(__type__: string | interop.Pointer | interop.Reference<any>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __cfrom: interop.Pointer | interop.Reference<number>, __cto: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function claset_(__uplo: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __beta: interop.Pointer | interop.Reference<__CLPK_complex>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function clasr_(__side: string | interop.Pointer | interop.Reference<any>, __pivot: string | interop.Pointer | interop.Reference<any>, __direct: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function classq_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __sumsq: interop.Pointer | interop.Reference<number>): number;

declare function claswp_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __k1: interop.Pointer | interop.Reference<number>, __k2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>): number;

declare function clasyf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __ldw: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function clatbs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __normin: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __scale: interop.Pointer | interop.Reference<number>, __cnorm: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function clatdf_(__ijob: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __rhs: interop.Pointer | interop.Reference<__CLPK_complex>, __rdsum: interop.Pointer | interop.Reference<number>, __rdscal: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __jpiv: interop.Pointer | interop.Reference<number>): number;

declare function clatps_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __normin: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __scale: interop.Pointer | interop.Reference<number>, __cnorm: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function clatrd_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __ldw: interop.Pointer | interop.Reference<number>): number;

declare function clatrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __normin: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __scale: interop.Pointer | interop.Reference<number>, __cnorm: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function clatrz_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function clatzm_(__side: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __incv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c1: interop.Pointer | interop.Reference<__CLPK_complex>, __c2: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function clauu2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function clauum_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpbcon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpbequ_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpbrfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __afb: interop.Pointer | interop.Reference<__CLPK_complex>, __ldafb: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpbstf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpbsv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpbsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __afb: interop.Pointer | interop.Reference<__CLPK_complex>, __ldafb: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>, __s: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpbtf2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpbtrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpbtrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpftrf_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpftri_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpftrs_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpocon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpoequ_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpoequb_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cporfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<__CLPK_complex>, __ldaf: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cposv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cposvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<__CLPK_complex>, __ldaf: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>, __s: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpotf2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpotrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpotri_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpotrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cppcon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cppequ_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpprfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __afp: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cppsv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cppsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __afp: interop.Pointer | interop.Reference<__CLPK_complex>, __equed: string | interop.Pointer | interop.Reference<any>, __s: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpptrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpptri_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpptrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpstf2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __piv: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __tol: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpstrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __piv: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __tol: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cptcon_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<__CLPK_complex>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpteqr_(__compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cptrfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<__CLPK_complex>, __df: interop.Pointer | interop.Reference<number>, __ef: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cptsv_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cptsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<__CLPK_complex>, __df: interop.Pointer | interop.Reference<number>, __ef: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpttrf_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cpttrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cptts2_(__iuplo: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function crot_(__n: interop.Pointer | interop.Reference<number>, __cx: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>, __cy: interop.Pointer | interop.Reference<__CLPK_complex>, __incy: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function cspcon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cspmv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<__CLPK_complex>, __y: interop.Pointer | interop.Reference<__CLPK_complex>, __incy: interop.Pointer | interop.Reference<number>): number;

declare function cspr_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>): number;

declare function csprfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __afp: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cspsv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cspsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __afp: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function csptrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function csptri_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function csptrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function csrscl_(__n: interop.Pointer | interop.Reference<number>, __sa: interop.Pointer | interop.Reference<number>, __sx: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>): number;

declare function cstedc_(__compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __lrwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cstegr_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cstein_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __iblock: interop.Pointer | interop.Reference<number>, __isplit: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cstemr_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __nzc: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __tryrac: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function csteqr_(__compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function csycon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function csyequb_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function csymv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<__CLPK_complex>, __y: interop.Pointer | interop.Reference<__CLPK_complex>, __incy: interop.Pointer | interop.Reference<number>): number;

declare function csyr_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function csyrfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<__CLPK_complex>, __ldaf: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function csysv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function csysvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<__CLPK_complex>, __ldaf: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function csytf2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function csytrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function csytri_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function csytrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctbcon_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctbrfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctbtrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<__CLPK_complex>, __ldab: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctfsm_(__transr: string | interop.Pointer | interop.Reference<any>, __side: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function ctftri_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctfttp_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __arf: interop.Pointer | interop.Reference<__CLPK_complex>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctfttr_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __arf: interop.Pointer | interop.Reference<__CLPK_complex>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctgevc_(__side: string | interop.Pointer | interop.Reference<any>, __howmny: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<__CLPK_complex>, __lds: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<__CLPK_complex>, __ldp: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvr: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctgex2_(__wantq: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __j1: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctgexc_(__wantq: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __ifst: interop.Pointer | interop.Reference<number>, __ilst: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctgsen_(__ijob: interop.Pointer | interop.Reference<number>, __wantq: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<__CLPK_complex>, __beta: interop.Pointer | interop.Reference<__CLPK_complex>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldz: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __pl: interop.Pointer | interop.Reference<number>, __pr: interop.Pointer | interop.Reference<number>, __dif: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctgsja_(__jobu: string | interop.Pointer | interop.Reference<any>, __jobv: string | interop.Pointer | interop.Reference<any>, __jobq: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __tola: interop.Pointer | interop.Reference<number>, __tolb: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<__CLPK_complex>, __ldu: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<__CLPK_complex>, __ldv: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __ncycle: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctgsna_(__job: string | interop.Pointer | interop.Reference<any>, __howmny: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvr: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __dif: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctgsy2_(__trans: string | interop.Pointer | interop.Reference<any>, __ijob: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldd: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<__CLPK_complex>, __lde: interop.Pointer | interop.Reference<number>, __f: interop.Pointer | interop.Reference<__CLPK_complex>, __ldf: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __rdsum: interop.Pointer | interop.Reference<number>, __rdscal: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctgsyl_(__trans: string | interop.Pointer | interop.Reference<any>, __ijob: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldd: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<__CLPK_complex>, __lde: interop.Pointer | interop.Reference<number>, __f: interop.Pointer | interop.Reference<__CLPK_complex>, __ldf: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __dif: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctpcon_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctprfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctptri_(__uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctptrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctpttf_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __arf: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctpttr_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctrcon_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctrevc_(__side: string | interop.Pointer | interop.Reference<any>, __howmny: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<__CLPK_complex>, __ldt: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvr: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctrexc_(__compq: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<__CLPK_complex>, __ldt: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __ifst: interop.Pointer | interop.Reference<number>, __ilst: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctrrfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<__CLPK_complex>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctrsen_(__job: string | interop.Pointer | interop.Reference<any>, __compq: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<__CLPK_complex>, __ldt: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<__CLPK_complex>, __m: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __sep: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctrsna_(__job: string | interop.Pointer | interop.Reference<any>, __howmny: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<__CLPK_complex>, __ldt: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<__CLPK_complex>, __ldvr: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __sep: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __ldwork: interop.Pointer | interop.Reference<number>, __rwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctrsyl_(__trana: string | interop.Pointer | interop.Reference<any>, __tranb: string | interop.Pointer | interop.Reference<any>, __isgn: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctrti2_(__uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctrtri_(__uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctrtrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<__CLPK_complex>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctrttf_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __arf: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctrttp_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctzrqf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ctzrzf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cung2l_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cung2r_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cungbr_(__vect: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunghr_(__n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cungl2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunglq_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cungql_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cungqr_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cungr2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cungrq_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cungtr_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunm2l_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunm2r_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunmbr_(__vect: string | interop.Pointer | interop.Reference<any>, __side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunmhr_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunml2_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunmlq_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunmql_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunmqr_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunmr2_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunmr3_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunmrq_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunmrz_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cunmtr_(__side: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cupgtr_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __q: interop.Pointer | interop.Reference<__CLPK_complex>, __ldq: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function cupmtr_(__side: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<__CLPK_complex>, __tau: interop.Pointer | interop.Reference<__CLPK_complex>, __c__: interop.Pointer | interop.Reference<__CLPK_complex>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<__CLPK_complex>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dbdsdc_(__uplo: string | interop.Pointer | interop.Reference<any>, __compq: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __iq: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dbdsqr_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ncvt: interop.Pointer | interop.Reference<number>, __nru: interop.Pointer | interop.Reference<number>, __ncc: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ddisna_(__job: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __sep: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgbbrd_(__vect: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ncc: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __pt: interop.Pointer | interop.Reference<number>, __ldpt: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgbcon_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgbequ_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgbequb_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgbrfs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __afb: interop.Pointer | interop.Reference<number>, __ldafb: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgbsv_(__n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgbsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __afb: interop.Pointer | interop.Reference<number>, __ldafb: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgbtf2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgbtrf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgbtrs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgebak_(__job: string | interop.Pointer | interop.Reference<any>, __side: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgebal_(__job: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgebd2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tauq: interop.Pointer | interop.Reference<number>, __taup: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgebrd_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tauq: interop.Pointer | interop.Reference<number>, __taup: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgecon_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgeequ_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgeequb_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgees_(__jobvs: string | interop.Pointer | interop.Reference<any>, __sort: string | interop.Pointer | interop.Reference<any>, __select: interop.FunctionReference<() => number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __sdim: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __vs: interop.Pointer | interop.Reference<number>, __ldvs: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgeesx_(__jobvs: string | interop.Pointer | interop.Reference<any>, __sort: string | interop.Pointer | interop.Reference<any>, __select: interop.FunctionReference<() => number>, __sense: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __sdim: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __vs: interop.Pointer | interop.Reference<number>, __ldvs: interop.Pointer | interop.Reference<number>, __rconde: interop.Pointer | interop.Reference<number>, __rcondv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgeev_(__jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgeevx_(__balanc: string | interop.Pointer | interop.Reference<any>, __jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __sense: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __abnrm: interop.Pointer | interop.Reference<number>, __rconde: interop.Pointer | interop.Reference<number>, __rcondv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgegs_(__jobvsl: string | interop.Pointer | interop.Reference<any>, __jobvsr: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __vsl: interop.Pointer | interop.Reference<number>, __ldvsl: interop.Pointer | interop.Reference<number>, __vsr: interop.Pointer | interop.Reference<number>, __ldvsr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgegv_(__jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgehd2_(__n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgehrd_(__n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgejsv_(__joba: string | interop.Pointer | interop.Reference<any>, __jobu: string | interop.Pointer | interop.Reference<any>, __jobv: string | interop.Pointer | interop.Reference<any>, __jobr: string | interop.Pointer | interop.Reference<any>, __jobt: string | interop.Pointer | interop.Reference<any>, __jobp: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __sva: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgelq2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgelqf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgels_(__trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgelsd_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgelss_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgelsx_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgelsy_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgeql2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgeqlf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgeqp3_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgeqpf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgeqr2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgeqrf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgerfs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<number>, __ldaf: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgerq2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgerqf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgesc2_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __rhs: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __jpiv: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>): number;

declare function dgesdd_(__jobz: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgesv_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgesvd_(__jobu: string | interop.Pointer | interop.Reference<any>, __jobvt: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgesvj_(__joba: string | interop.Pointer | interop.Reference<any>, __jobu: string | interop.Pointer | interop.Reference<any>, __jobv: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __sva: interop.Pointer | interop.Reference<number>, __mv: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgesvx_(__fact: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<number>, __ldaf: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgetc2_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __jpiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgetf2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgetrf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgetri_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgetrs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dggbak_(__job: string | interop.Pointer | interop.Reference<any>, __side: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __lscale: interop.Pointer | interop.Reference<number>, __rscale: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dggbal_(__job: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __lscale: interop.Pointer | interop.Reference<number>, __rscale: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgges_(__jobvsl: string | interop.Pointer | interop.Reference<any>, __jobvsr: string | interop.Pointer | interop.Reference<any>, __sort: string | interop.Pointer | interop.Reference<any>, __selctg: interop.FunctionReference<() => number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __sdim: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __vsl: interop.Pointer | interop.Reference<number>, __ldvsl: interop.Pointer | interop.Reference<number>, __vsr: interop.Pointer | interop.Reference<number>, __ldvsr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dggesx_(__jobvsl: string | interop.Pointer | interop.Reference<any>, __jobvsr: string | interop.Pointer | interop.Reference<any>, __sort: string | interop.Pointer | interop.Reference<any>, __selctg: interop.FunctionReference<() => number>, __sense: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __sdim: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __vsl: interop.Pointer | interop.Reference<number>, __ldvsl: interop.Pointer | interop.Reference<number>, __vsr: interop.Pointer | interop.Reference<number>, __ldvsr: interop.Pointer | interop.Reference<number>, __rconde: interop.Pointer | interop.Reference<number>, __rcondv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dggev_(__jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dggevx_(__balanc: string | interop.Pointer | interop.Reference<any>, __jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __sense: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __lscale: interop.Pointer | interop.Reference<number>, __rscale: interop.Pointer | interop.Reference<number>, __abnrm: interop.Pointer | interop.Reference<number>, __bbnrm: interop.Pointer | interop.Reference<number>, __rconde: interop.Pointer | interop.Reference<number>, __rcondv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dggglm_(__n: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgghrd_(__compq: string | interop.Pointer | interop.Reference<any>, __compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgglse_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dggqrf_(__n: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __taua: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __taub: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dggrqf_(__m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __taua: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __taub: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dggsvd_(__jobu: string | interop.Pointer | interop.Reference<any>, __jobv: string | interop.Pointer | interop.Reference<any>, __jobq: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dggsvp_(__jobu: string | interop.Pointer | interop.Reference<any>, __jobv: string | interop.Pointer | interop.Reference<any>, __jobq: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __tola: interop.Pointer | interop.Reference<number>, __tolb: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgsvj0_(__jobv: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __sva: interop.Pointer | interop.Reference<number>, __mv: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __eps: interop.Pointer | interop.Reference<number>, __sfmin: interop.Pointer | interop.Reference<number>, __tol: interop.Pointer | interop.Reference<number>, __nsweep: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgsvj1_(__jobv: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __n1: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __sva: interop.Pointer | interop.Reference<number>, __mv: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __eps: interop.Pointer | interop.Reference<number>, __sfmin: interop.Pointer | interop.Reference<number>, __tol: interop.Pointer | interop.Reference<number>, __nsweep: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgtcon_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __du2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgtrfs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __dlf: interop.Pointer | interop.Reference<number>, __df: interop.Pointer | interop.Reference<number>, __duf: interop.Pointer | interop.Reference<number>, __du2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgtsv_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgtsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __dlf: interop.Pointer | interop.Reference<number>, __df: interop.Pointer | interop.Reference<number>, __duf: interop.Pointer | interop.Reference<number>, __du2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgttrf_(__n: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __du2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgttrs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __du2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dgtts2_(__itrans: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __du2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function dhgeqz_(__job: string | interop.Pointer | interop.Reference<any>, __compq: string | interop.Pointer | interop.Reference<any>, __compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dhsein_(__side: string | interop.Pointer | interop.Reference<any>, __eigsrc: string | interop.Pointer | interop.Reference<any>, __initv: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __ifaill: interop.Pointer | interop.Reference<number>, __ifailr: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dhseqr_(__job: string | interop.Pointer | interop.Reference<any>, __compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function disnan_(__din: interop.Pointer | interop.Reference<number>): number;

declare function dlabad_(__small: interop.Pointer | interop.Reference<number>, __large: interop.Pointer | interop.Reference<number>): number;

declare function dlabrd_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tauq: interop.Pointer | interop.Reference<number>, __taup: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __ldy: interop.Pointer | interop.Reference<number>): number;

declare function dlacn2_(__n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __isgn: interop.Pointer | interop.Reference<number>, __est: interop.Pointer | interop.Reference<number>, __kase: interop.Pointer | interop.Reference<number>, __isave: interop.Pointer | interop.Reference<number>): number;

declare function dlacon_(__n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __isgn: interop.Pointer | interop.Reference<number>, __est: interop.Pointer | interop.Reference<number>, __kase: interop.Pointer | interop.Reference<number>): number;

declare function dlacpy_(__uplo: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function dladiv_(__a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>): number;

declare function dlae2_(__a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rt1: interop.Pointer | interop.Reference<number>, __rt2: interop.Pointer | interop.Reference<number>): number;

declare function dlaebz_(__ijob: interop.Pointer | interop.Reference<number>, __nitmax: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __mmax: interop.Pointer | interop.Reference<number>, __minp: interop.Pointer | interop.Reference<number>, __nbmin: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __reltol: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __e2: interop.Pointer | interop.Reference<number>, __nval: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __mout: interop.Pointer | interop.Reference<number>, __nab: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlaed0_(__icompq: interop.Pointer | interop.Reference<number>, __qsiz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __qstore: interop.Pointer | interop.Reference<number>, __ldqs: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlaed1_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __indxq: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __cutpnt: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlaed2_(__k: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __n1: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __indxq: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __dlamda: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __q2: interop.Pointer | interop.Reference<number>, __indx: interop.Pointer | interop.Reference<number>, __indxc: interop.Pointer | interop.Reference<number>, __indxp: interop.Pointer | interop.Reference<number>, __coltyp: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlaed3_(__k: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __n1: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __dlamda: interop.Pointer | interop.Reference<number>, __q2: interop.Pointer | interop.Reference<number>, __indx: interop.Pointer | interop.Reference<number>, __ctot: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlaed4_(__n: interop.Pointer | interop.Reference<number>, __i__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __delta: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __dlam: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlaed5_(__i__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __delta: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __dlam: interop.Pointer | interop.Reference<number>): number;

declare function dlaed6_(__kniter: interop.Pointer | interop.Reference<number>, __orgati: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __finit: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlaed7_(__icompq: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __qsiz: interop.Pointer | interop.Reference<number>, __tlvls: interop.Pointer | interop.Reference<number>, __curlvl: interop.Pointer | interop.Reference<number>, __curpbm: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __indxq: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __cutpnt: interop.Pointer | interop.Reference<number>, __qstore: interop.Pointer | interop.Reference<number>, __qptr: interop.Pointer | interop.Reference<number>, __prmptr: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlaed8_(__icompq: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __qsiz: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __indxq: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __cutpnt: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __dlamda: interop.Pointer | interop.Reference<number>, __q2: interop.Pointer | interop.Reference<number>, __ldq2: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __indxp: interop.Pointer | interop.Reference<number>, __indx: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlaed9_(__k: interop.Pointer | interop.Reference<number>, __kstart: interop.Pointer | interop.Reference<number>, __kstop: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __dlamda: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __lds: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlaeda_(__n: interop.Pointer | interop.Reference<number>, __tlvls: interop.Pointer | interop.Reference<number>, __curlvl: interop.Pointer | interop.Reference<number>, __curpbm: interop.Pointer | interop.Reference<number>, __prmptr: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __qptr: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ztemp: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlaein_(__rightv: interop.Pointer | interop.Reference<number>, __noinit: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __vi: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __eps3: interop.Pointer | interop.Reference<number>, __smlnum: interop.Pointer | interop.Reference<number>, __bignum: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlaev2_(__a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rt1: interop.Pointer | interop.Reference<number>, __rt2: interop.Pointer | interop.Reference<number>, __cs1: interop.Pointer | interop.Reference<number>, __sn1: interop.Pointer | interop.Reference<number>): number;

declare function dlaexc_(__wantq: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __j1: interop.Pointer | interop.Reference<number>, __n1: interop.Pointer | interop.Reference<number>, __n2: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlag2_(__a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __safmin: interop.Pointer | interop.Reference<number>, __scale1: interop.Pointer | interop.Reference<number>, __scale2: interop.Pointer | interop.Reference<number>, __wr1: interop.Pointer | interop.Reference<number>, __wr2: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>): number;

declare function dlag2s_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __sa: interop.Pointer | interop.Reference<number>, __ldsa: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlags2_(__upper: interop.Pointer | interop.Reference<number>, __a1: interop.Pointer | interop.Reference<number>, __a2: interop.Pointer | interop.Reference<number>, __a3: interop.Pointer | interop.Reference<number>, __b1: interop.Pointer | interop.Reference<number>, __b2: interop.Pointer | interop.Reference<number>, __b3: interop.Pointer | interop.Reference<number>, __csu: interop.Pointer | interop.Reference<number>, __snu: interop.Pointer | interop.Reference<number>, __csv: interop.Pointer | interop.Reference<number>, __snv: interop.Pointer | interop.Reference<number>, __csq: interop.Pointer | interop.Reference<number>, __snq: interop.Pointer | interop.Reference<number>): number;

declare function dlagtf_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lambda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __tol: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __in: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlagtm_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function dlagts_(__job: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __in: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __tol: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlagv2_(__a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __csl: interop.Pointer | interop.Reference<number>, __snl: interop.Pointer | interop.Reference<number>, __csr: interop.Pointer | interop.Reference<number>, __snr: interop.Pointer | interop.Reference<number>): number;

declare function dlahqr_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlahr2_(__n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __ldy: interop.Pointer | interop.Reference<number>): number;

declare function dlahrd_(__n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __ldy: interop.Pointer | interop.Reference<number>): number;

declare function dlaic1_(__job: interop.Pointer | interop.Reference<number>, __j: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __sest: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __gamma: interop.Pointer | interop.Reference<number>, __sestpr: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>): number;

declare function dlaisnan_(__din1: interop.Pointer | interop.Reference<number>, __din2: interop.Pointer | interop.Reference<number>): number;

declare function dlaln2_(__ltrans: interop.Pointer | interop.Reference<number>, __na: interop.Pointer | interop.Reference<number>, __nw: interop.Pointer | interop.Reference<number>, __smin: interop.Pointer | interop.Reference<number>, __ca: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d1: interop.Pointer | interop.Reference<number>, __d2: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __xnorm: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlals0_(__icompq: interop.Pointer | interop.Reference<number>, __nl: interop.Pointer | interop.Reference<number>, __nr: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __bx: interop.Pointer | interop.Reference<number>, __ldbx: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __ldgcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __ldgnum: interop.Pointer | interop.Reference<number>, __poles: interop.Pointer | interop.Reference<number>, __difl: interop.Pointer | interop.Reference<number>, __difr: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlalsa_(__icompq: interop.Pointer | interop.Reference<number>, __smlsiz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __bx: interop.Pointer | interop.Reference<number>, __ldbx: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __difl: interop.Pointer | interop.Reference<number>, __difr: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __poles: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __ldgcol: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlalsd_(__uplo: string | interop.Pointer | interop.Reference<any>, __smlsiz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlamc1_(__beta: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __rnd: interop.Pointer | interop.Reference<number>, __ieee1: interop.Pointer | interop.Reference<number>): number;

declare function dlamc1_Function(__beta: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __rnd: interop.Pointer | interop.Reference<number>, __ieee1: interop.Pointer | interop.Reference<number>): number;

declare function dlamc2_(__beta: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __rnd: interop.Pointer | interop.Reference<number>, __eps: interop.Pointer | interop.Reference<number>, __emin: interop.Pointer | interop.Reference<number>, __rmin: interop.Pointer | interop.Reference<number>, __emax: interop.Pointer | interop.Reference<number>, __rmax: interop.Pointer | interop.Reference<number>): number;

declare function dlamc3_(__a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>): number;

declare function dlamc4_(__emin: interop.Pointer | interop.Reference<number>, __start: interop.Pointer | interop.Reference<number>, __base: interop.Pointer | interop.Reference<number>): number;

declare function dlamc5_(__beta: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __emin: interop.Pointer | interop.Reference<number>, __ieee: interop.Pointer | interop.Reference<number>, __emax: interop.Pointer | interop.Reference<number>, __rmax: interop.Pointer | interop.Reference<number>): number;

declare function dlamch_(__cmach: string | interop.Pointer | interop.Reference<any>): number;

declare function dlamrg_(__n1: interop.Pointer | interop.Reference<number>, __n2: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __dtrd1: interop.Pointer | interop.Reference<number>, __dtrd2: interop.Pointer | interop.Reference<number>, __index: interop.Pointer | interop.Reference<number>): number;

declare function dlaneg_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __lld: interop.Pointer | interop.Reference<number>, __sigma: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>): number;

declare function dlangb_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlange_(__norm: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlangt_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>): number;

declare function dlanhs_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlansb_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlansf_(__norm: string | interop.Pointer | interop.Reference<any>, __transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlansp_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlanst_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>): number;

declare function dlansy_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlantb_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlantp_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlantr_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlanv2_(__a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __rt1r: interop.Pointer | interop.Reference<number>, __rt1i: interop.Pointer | interop.Reference<number>, __rt2r: interop.Pointer | interop.Reference<number>, __rt2i: interop.Pointer | interop.Reference<number>, __cs: interop.Pointer | interop.Reference<number>, __sn: interop.Pointer | interop.Reference<number>): number;

declare function dlapll_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __incy: interop.Pointer | interop.Reference<number>, __ssmin: interop.Pointer | interop.Reference<number>): number;

declare function dlapmt_(__forwrd: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>): number;

declare function dlapy2_(__x: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>): number;

declare function dlapy3_(__x: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>): number;

declare function dlaqgb_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function dlaqge_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function dlaqp2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __offset: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __vn1: interop.Pointer | interop.Reference<number>, __vn2: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlaqps_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __offset: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __vn1: interop.Pointer | interop.Reference<number>, __vn2: interop.Pointer | interop.Reference<number>, __auxv: interop.Pointer | interop.Reference<number>, __f: interop.Pointer | interop.Reference<number>, __ldf: interop.Pointer | interop.Reference<number>): number;

declare function dlaqr0_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlaqr1_(__n: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __sr1: interop.Pointer | interop.Reference<number>, __si1: interop.Pointer | interop.Reference<number>, __sr2: interop.Pointer | interop.Reference<number>, __si2: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>): number;

declare function dlaqr2_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ktop: interop.Pointer | interop.Reference<number>, __kbot: interop.Pointer | interop.Reference<number>, __nw: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __ns: interop.Pointer | interop.Reference<number>, __nd: interop.Pointer | interop.Reference<number>, __sr: interop.Pointer | interop.Reference<number>, __si: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __nh: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __nv: interop.Pointer | interop.Reference<number>, __wv: interop.Pointer | interop.Reference<number>, __ldwv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>): number;

declare function dlaqr3_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ktop: interop.Pointer | interop.Reference<number>, __kbot: interop.Pointer | interop.Reference<number>, __nw: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __ns: interop.Pointer | interop.Reference<number>, __nd: interop.Pointer | interop.Reference<number>, __sr: interop.Pointer | interop.Reference<number>, __si: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __nh: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __nv: interop.Pointer | interop.Reference<number>, __wv: interop.Pointer | interop.Reference<number>, __ldwv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>): number;

declare function dlaqr4_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlaqr5_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __kacc22: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ktop: interop.Pointer | interop.Reference<number>, __kbot: interop.Pointer | interop.Reference<number>, __nshfts: interop.Pointer | interop.Reference<number>, __sr: interop.Pointer | interop.Reference<number>, __si: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __nv: interop.Pointer | interop.Reference<number>, __wv: interop.Pointer | interop.Reference<number>, __ldwv: interop.Pointer | interop.Reference<number>, __nh: interop.Pointer | interop.Reference<number>, __wh: interop.Pointer | interop.Reference<number>, __ldwh: interop.Pointer | interop.Reference<number>): number;

declare function dlaqsb_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function dlaqsp_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function dlaqsy_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function dlaqtr_(__ltran: interop.Pointer | interop.Reference<number>, __l__CLPK_real: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlar1v_(__n: interop.Pointer | interop.Reference<number>, __b1: interop.Pointer | interop.Reference<number>, __bn: interop.Pointer | interop.Reference<number>, __lambda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __ld: interop.Pointer | interop.Reference<number>, __lld: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __gaptol: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __wantnc: interop.Pointer | interop.Reference<number>, __negcnt: interop.Pointer | interop.Reference<number>, __ztz: interop.Pointer | interop.Reference<number>, __mingma: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __nrminv: interop.Pointer | interop.Reference<number>, __resid: interop.Pointer | interop.Reference<number>, __rqcorr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlar2v_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __incc: interop.Pointer | interop.Reference<number>): number;

declare function dlarf_(__side: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __incv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlarfb_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __direct: string | interop.Pointer | interop.Reference<any>, __storev: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __ldwork: interop.Pointer | interop.Reference<number>): number;

declare function dlarfg_(__n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>): number;

declare function dlarfp_(__n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>): number;

declare function dlarft_(__direct: string | interop.Pointer | interop.Reference<any>, __storev: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>): number;

declare function dlarfx_(__side: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlargv_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __incy: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __incc: interop.Pointer | interop.Reference<number>): number;

declare function dlarnv_(__idist: interop.Pointer | interop.Reference<number>, __iseed: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>): number;

declare function dlarra_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __e2: interop.Pointer | interop.Reference<number>, __spltol: interop.Pointer | interop.Reference<number>, __tnrm: interop.Pointer | interop.Reference<number>, __nsplit: interop.Pointer | interop.Reference<number>, __isplit: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlarrb_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __lld: interop.Pointer | interop.Reference<number>, __ifirst: interop.Pointer | interop.Reference<number>, __ilast: interop.Pointer | interop.Reference<number>, __rtol1: interop.Pointer | interop.Reference<number>, __rtol2: interop.Pointer | interop.Reference<number>, __offset: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __wgap: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __spdiam: interop.Pointer | interop.Reference<number>, __twist: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlarrc_(__jobt: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __eigcnt: interop.Pointer | interop.Reference<number>, __lcnt: interop.Pointer | interop.Reference<number>, __rcnt: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlarrd_(__range: string | interop.Pointer | interop.Reference<any>, __order: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __gers: interop.Pointer | interop.Reference<number>, __reltol: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __e2: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __nsplit: interop.Pointer | interop.Reference<number>, __isplit: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __wl: interop.Pointer | interop.Reference<number>, __wu: interop.Pointer | interop.Reference<number>, __iblock: interop.Pointer | interop.Reference<number>, __indexw: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlarre_(__range: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __e2: interop.Pointer | interop.Reference<number>, __rtol1: interop.Pointer | interop.Reference<number>, __rtol2: interop.Pointer | interop.Reference<number>, __spltol: interop.Pointer | interop.Reference<number>, __nsplit: interop.Pointer | interop.Reference<number>, __isplit: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __wgap: interop.Pointer | interop.Reference<number>, __iblock: interop.Pointer | interop.Reference<number>, __indexw: interop.Pointer | interop.Reference<number>, __gers: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlarrf_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __ld: interop.Pointer | interop.Reference<number>, __clstrt: interop.Pointer | interop.Reference<number>, __clend: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __wgap: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __spdiam: interop.Pointer | interop.Reference<number>, __clgapl: interop.Pointer | interop.Reference<number>, __clgapr: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __sigma: interop.Pointer | interop.Reference<number>, __dplus: interop.Pointer | interop.Reference<number>, __lplus: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlarrj_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e2: interop.Pointer | interop.Reference<number>, __ifirst: interop.Pointer | interop.Reference<number>, __ilast: interop.Pointer | interop.Reference<number>, __rtol: interop.Pointer | interop.Reference<number>, __offset: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __spdiam: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlarrk_(__n: interop.Pointer | interop.Reference<number>, __iw: interop.Pointer | interop.Reference<number>, __gl: interop.Pointer | interop.Reference<number>, __gu: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e2: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __reltol: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlarrr_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlarrv_(__n: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __isplit: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __dol: interop.Pointer | interop.Reference<number>, __dou: interop.Pointer | interop.Reference<number>, __minrgp: interop.Pointer | interop.Reference<number>, __rtol1: interop.Pointer | interop.Reference<number>, __rtol2: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __wgap: interop.Pointer | interop.Reference<number>, __iblock: interop.Pointer | interop.Reference<number>, __indexw: interop.Pointer | interop.Reference<number>, __gers: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlarscl2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>): number;

declare function dlartg_(__f: interop.Pointer | interop.Reference<number>, __g: interop.Pointer | interop.Reference<number>, __cs: interop.Pointer | interop.Reference<number>, __sn: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>): number;

declare function dlartv_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __incy: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __incc: interop.Pointer | interop.Reference<number>): number;

declare function dlaruv_(__iseed: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>): number;

declare function dlarz_(__side: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __incv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlarzb_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __direct: string | interop.Pointer | interop.Reference<any>, __storev: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __ldwork: interop.Pointer | interop.Reference<number>): number;

declare function dlarzt_(__direct: string | interop.Pointer | interop.Reference<any>, __storev: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>): number;

declare function dlas2_(__f: interop.Pointer | interop.Reference<number>, __g: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ssmin: interop.Pointer | interop.Reference<number>, __ssmax: interop.Pointer | interop.Reference<number>): number;

declare function dlascl2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>): number;

declare function dlascl_(__type__: string | interop.Pointer | interop.Reference<any>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __cfrom: interop.Pointer | interop.Reference<number>, __cto: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlasd0_(__n: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __smlsiz: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlasd1_(__nl: interop.Pointer | interop.Reference<number>, __nr: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __idxq: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlasd2_(__nl: interop.Pointer | interop.Reference<number>, __nr: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __dsigma: interop.Pointer | interop.Reference<number>, __u2: interop.Pointer | interop.Reference<number>, __ldu2: interop.Pointer | interop.Reference<number>, __vt2: interop.Pointer | interop.Reference<number>, __ldvt2: interop.Pointer | interop.Reference<number>, __idxp: interop.Pointer | interop.Reference<number>, __idx: interop.Pointer | interop.Reference<number>, __idxc: interop.Pointer | interop.Reference<number>, __idxq: interop.Pointer | interop.Reference<number>, __coltyp: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlasd3_(__nl: interop.Pointer | interop.Reference<number>, __nr: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __dsigma: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __u2: interop.Pointer | interop.Reference<number>, __ldu2: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __vt2: interop.Pointer | interop.Reference<number>, __ldvt2: interop.Pointer | interop.Reference<number>, __idxc: interop.Pointer | interop.Reference<number>, __ctot: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlasd4_(__n: interop.Pointer | interop.Reference<number>, __i__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __delta: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __sigma: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlasd5_(__i__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __delta: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __dsigma: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlasd6_(__icompq: interop.Pointer | interop.Reference<number>, __nl: interop.Pointer | interop.Reference<number>, __nr: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __vf: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __idxq: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __ldgcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __ldgnum: interop.Pointer | interop.Reference<number>, __poles: interop.Pointer | interop.Reference<number>, __difl: interop.Pointer | interop.Reference<number>, __difr: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlasd7_(__icompq: interop.Pointer | interop.Reference<number>, __nl: interop.Pointer | interop.Reference<number>, __nr: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __zw: interop.Pointer | interop.Reference<number>, __vf: interop.Pointer | interop.Reference<number>, __vfw: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vlw: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __dsigma: interop.Pointer | interop.Reference<number>, __idx: interop.Pointer | interop.Reference<number>, __idxp: interop.Pointer | interop.Reference<number>, __idxq: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __ldgcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __ldgnum: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlasd8_(__icompq: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __vf: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __difl: interop.Pointer | interop.Reference<number>, __difr: interop.Pointer | interop.Reference<number>, __lddifr: interop.Pointer | interop.Reference<number>, __dsigma: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlasda_(__icompq: interop.Pointer | interop.Reference<number>, __smlsiz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __difl: interop.Pointer | interop.Reference<number>, __difr: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __poles: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __ldgcol: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlasdq_(__uplo: string | interop.Pointer | interop.Reference<any>, __sqre: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ncvt: interop.Pointer | interop.Reference<number>, __nru: interop.Pointer | interop.Reference<number>, __ncc: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlasdt_(__n: interop.Pointer | interop.Reference<number>, __lvl: interop.Pointer | interop.Reference<number>, __nd: interop.Pointer | interop.Reference<number>, __inode: interop.Pointer | interop.Reference<number>, __ndiml: interop.Pointer | interop.Reference<number>, __ndimr: interop.Pointer | interop.Reference<number>, __msub: interop.Pointer | interop.Reference<number>): number;

declare function dlaset_(__uplo: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function dlasq1_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlasq2_(__n: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlasq3_(__i0: interop.Pointer | interop.Reference<number>, __n0: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __pp: interop.Pointer | interop.Reference<number>, __dmin__: interop.Pointer | interop.Reference<number>, __sigma: interop.Pointer | interop.Reference<number>, __desig: interop.Pointer | interop.Reference<number>, __qmax: interop.Pointer | interop.Reference<number>, __nfail: interop.Pointer | interop.Reference<number>, __iter: interop.Pointer | interop.Reference<number>, __ndiv: interop.Pointer | interop.Reference<number>, __ieee: interop.Pointer | interop.Reference<number>, __ttype: interop.Pointer | interop.Reference<number>, __dmin1: interop.Pointer | interop.Reference<number>, __dmin2: interop.Pointer | interop.Reference<number>, __dn: interop.Pointer | interop.Reference<number>, __dn1: interop.Pointer | interop.Reference<number>, __dn2: interop.Pointer | interop.Reference<number>, __g: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>): number;

declare function dlasq4_(__i0: interop.Pointer | interop.Reference<number>, __n0: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __pp: interop.Pointer | interop.Reference<number>, __n0in: interop.Pointer | interop.Reference<number>, __dmin__: interop.Pointer | interop.Reference<number>, __dmin1: interop.Pointer | interop.Reference<number>, __dmin2: interop.Pointer | interop.Reference<number>, __dn: interop.Pointer | interop.Reference<number>, __dn1: interop.Pointer | interop.Reference<number>, __dn2: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __ttype: interop.Pointer | interop.Reference<number>, __g: interop.Pointer | interop.Reference<number>): number;

declare function dlasq5_(__i0: interop.Pointer | interop.Reference<number>, __n0: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __pp: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __dmin__: interop.Pointer | interop.Reference<number>, __dmin1: interop.Pointer | interop.Reference<number>, __dmin2: interop.Pointer | interop.Reference<number>, __dn: interop.Pointer | interop.Reference<number>, __dnm1: interop.Pointer | interop.Reference<number>, __dnm2: interop.Pointer | interop.Reference<number>, __ieee: interop.Pointer | interop.Reference<number>): number;

declare function dlasq6_(__i0: interop.Pointer | interop.Reference<number>, __n0: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __pp: interop.Pointer | interop.Reference<number>, __dmin__: interop.Pointer | interop.Reference<number>, __dmin1: interop.Pointer | interop.Reference<number>, __dmin2: interop.Pointer | interop.Reference<number>, __dn: interop.Pointer | interop.Reference<number>, __dnm1: interop.Pointer | interop.Reference<number>, __dnm2: interop.Pointer | interop.Reference<number>): number;

declare function dlasr_(__side: string | interop.Pointer | interop.Reference<any>, __pivot: string | interop.Pointer | interop.Reference<any>, __direct: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function dlasrt_(__id: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlassq_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __sumsq: interop.Pointer | interop.Reference<number>): number;

declare function dlasv2_(__f: interop.Pointer | interop.Reference<number>, __g: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ssmin: interop.Pointer | interop.Reference<number>, __ssmax: interop.Pointer | interop.Reference<number>, __snr: interop.Pointer | interop.Reference<number>, __csr: interop.Pointer | interop.Reference<number>, __snl: interop.Pointer | interop.Reference<number>, __csl: interop.Pointer | interop.Reference<number>): number;

declare function dlaswp_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __k1: interop.Pointer | interop.Reference<number>, __k2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>): number;

declare function dlasy2_(__ltranl: interop.Pointer | interop.Reference<number>, __ltranr: interop.Pointer | interop.Reference<number>, __isgn: interop.Pointer | interop.Reference<number>, __n1: interop.Pointer | interop.Reference<number>, __n2: interop.Pointer | interop.Reference<number>, __tl: interop.Pointer | interop.Reference<number>, __ldtl: interop.Pointer | interop.Reference<number>, __tr: interop.Pointer | interop.Reference<number>, __ldtr: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __xnorm: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlasyf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __ldw: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlat2s_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __sa: interop.Pointer | interop.Reference<number>, __ldsa: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlatbs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __normin: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __cnorm: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlatdf_(__ijob: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __rhs: interop.Pointer | interop.Reference<number>, __rdsum: interop.Pointer | interop.Reference<number>, __rdscal: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __jpiv: interop.Pointer | interop.Reference<number>): number;

declare function dlatps_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __normin: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __cnorm: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlatrd_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __ldw: interop.Pointer | interop.Reference<number>): number;

declare function dlatrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __normin: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __cnorm: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlatrz_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlatzm_(__side: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __incv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c1: interop.Pointer | interop.Reference<number>, __c2: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function dlauu2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dlauum_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dopgtr_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dopmtr_(__side: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dorg2l_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dorg2r_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dorgbr_(__vect: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dorghr_(__n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dorgl2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dorglq_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dorgql_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dorgqr_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dorgr2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dorgrq_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dorgtr_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dorm2l_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dorm2r_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dormbr_(__vect: string | interop.Pointer | interop.Reference<any>, __side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dormhr_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dorml2_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dormlq_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dormql_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dormqr_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dormr2_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dormr3_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dormrq_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dormrz_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dormtr_(__side: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpbcon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpbequ_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpbrfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __afb: interop.Pointer | interop.Reference<number>, __ldafb: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpbstf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpbsv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpbsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __afb: interop.Pointer | interop.Reference<number>, __ldafb: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>, __s: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpbtf2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpbtrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpbtrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpftrf_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpftri_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpftrs_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpocon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpoequ_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpoequb_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dporfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<number>, __ldaf: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dposv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dposvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<number>, __ldaf: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>, __s: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpotf2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpotrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpotri_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpotrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dppcon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dppequ_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpprfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __afp: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dppsv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dppsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __afp: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>, __s: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpptrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpptri_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpptrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpstf2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __piv: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __tol: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpstrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __piv: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __tol: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dptcon_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpteqr_(__compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dptrfs_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __df: interop.Pointer | interop.Reference<number>, __ef: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dptsv_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dptsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __df: interop.Pointer | interop.Reference<number>, __ef: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpttrf_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dpttrs_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dptts2_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function drscl_(__n: interop.Pointer | interop.Reference<number>, __sa: interop.Pointer | interop.Reference<number>, __sx: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>): number;

declare function dsbev_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsbevd_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsbevx_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsbgst_(__vect: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ka: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __bb: interop.Pointer | interop.Reference<number>, __ldbb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsbgv_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ka: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __bb: interop.Pointer | interop.Reference<number>, __ldbb: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsbgvd_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ka: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __bb: interop.Pointer | interop.Reference<number>, __ldbb: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsbgvx_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ka: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __bb: interop.Pointer | interop.Reference<number>, __ldbb: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsbtrd_(__vect: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsfrk_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>): number;

declare function dsgesv_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __swork: interop.Pointer | interop.Reference<number>, __iter: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dspcon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dspev_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dspevd_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dspevx_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dspgst_(__itype: interop.Pointer | interop.Reference<number>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __bp: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dspgv_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __bp: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dspgvd_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __bp: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dspgvx_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __bp: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsposv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __swork: interop.Pointer | interop.Reference<number>, __iter: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsprfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __afp: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dspsv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dspsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __afp: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsptrd_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsptrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsptri_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsptrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dstebz_(__range: string | interop.Pointer | interop.Reference<any>, __order: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __nsplit: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __iblock: interop.Pointer | interop.Reference<number>, __isplit: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dstedc_(__compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dstegr_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dstein_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __iblock: interop.Pointer | interop.Reference<number>, __isplit: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dstemr_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __nzc: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __tryrac: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsteqr_(__compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsterf_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dstev_(__jobz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dstevd_(__jobz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dstevr_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dstevx_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsycon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsyequb_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsyev_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsyevd_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsyevr_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsyevx_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsygs2_(__itype: interop.Pointer | interop.Reference<number>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsygst_(__itype: interop.Pointer | interop.Reference<number>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsygv_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsygvd_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsygvx_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsyrfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<number>, __ldaf: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsysv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsysvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<number>, __ldaf: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsytd2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsytf2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsytrd_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsytrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsytri_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dsytrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtbcon_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtbrfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtbtrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtfsm_(__transr: string | interop.Pointer | interop.Reference<any>, __side: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function dtftri_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtfttp_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __arf: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtfttr_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __arf: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtgevc_(__side: string | interop.Pointer | interop.Reference<any>, __howmny: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __lds: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __ldp: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtgex2_(__wantq: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __j1: interop.Pointer | interop.Reference<number>, __n1: interop.Pointer | interop.Reference<number>, __n2: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtgexc_(__wantq: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __ifst: interop.Pointer | interop.Reference<number>, __ilst: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtgsen_(__ijob: interop.Pointer | interop.Reference<number>, __wantq: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __pl: interop.Pointer | interop.Reference<number>, __pr: interop.Pointer | interop.Reference<number>, __dif: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtgsja_(__jobu: string | interop.Pointer | interop.Reference<any>, __jobv: string | interop.Pointer | interop.Reference<any>, __jobq: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __tola: interop.Pointer | interop.Reference<number>, __tolb: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __ncycle: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtgsna_(__job: string | interop.Pointer | interop.Reference<any>, __howmny: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __dif: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtgsy2_(__trans: string | interop.Pointer | interop.Reference<any>, __ijob: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __ldd: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __lde: interop.Pointer | interop.Reference<number>, __f: interop.Pointer | interop.Reference<number>, __ldf: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __rdsum: interop.Pointer | interop.Reference<number>, __rdscal: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __pq: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtgsyl_(__trans: string | interop.Pointer | interop.Reference<any>, __ijob: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __ldd: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __lde: interop.Pointer | interop.Reference<number>, __f: interop.Pointer | interop.Reference<number>, __ldf: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __dif: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtpcon_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtprfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtptri_(__uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtptrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtpttf_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __arf: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtpttr_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtrcon_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtrevc_(__side: string | interop.Pointer | interop.Reference<any>, __howmny: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtrexc_(__compq: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __ifst: interop.Pointer | interop.Reference<number>, __ilst: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtrrfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtrsen_(__job: string | interop.Pointer | interop.Reference<any>, __compq: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __sep: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtrsna_(__job: string | interop.Pointer | interop.Reference<any>, __howmny: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __sep: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __ldwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtrsyl_(__trana: string | interop.Pointer | interop.Reference<any>, __tranb: string | interop.Pointer | interop.Reference<any>, __isgn: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtrti2_(__uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtrtri_(__uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtrtrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtrttf_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __arf: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtrttp_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtzrqf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dtzrzf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function dzsum1_(__n: interop.Pointer | interop.Reference<number>, __cx: interop.Pointer | interop.Reference<__CLPK_doublecomplex>, __incx: interop.Pointer | interop.Reference<number>): number;

declare function icmax1_(__n: interop.Pointer | interop.Reference<number>, __cx: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>): number;

declare function ieeeck_(__ispec: interop.Pointer | interop.Reference<number>, __zero: interop.Pointer | interop.Reference<number>, __one: interop.Pointer | interop.Reference<number>): number;

declare function ilaclc_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function ilaclr_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_complex>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function iladiag_(__diag: string | interop.Pointer | interop.Reference<any>): number;

declare function iladlc_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function iladlr_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function ilaenv_(__ispec: interop.Pointer | interop.Reference<number>, __name__: string | interop.Pointer | interop.Reference<any>, __opts: string | interop.Pointer | interop.Reference<any>, __n1: interop.Pointer | interop.Reference<number>, __n2: interop.Pointer | interop.Reference<number>, __n3: interop.Pointer | interop.Reference<number>, __n4: interop.Pointer | interop.Reference<number>): number;

declare function ilaenv_Function(__ispec: interop.Pointer | interop.Reference<number>, __name__: string | interop.Pointer | interop.Reference<any>, __opts: string | interop.Pointer | interop.Reference<any>, __n1: interop.Pointer | interop.Reference<number>, __n2: interop.Pointer | interop.Reference<number>, __n3: interop.Pointer | interop.Reference<number>, __n4: interop.Pointer | interop.Reference<number>): number;

declare function ilaprec_(__prec: string | interop.Pointer | interop.Reference<any>): number;

declare function ilaslc_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function ilaslr_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function ilatrans_(__trans: string | interop.Pointer | interop.Reference<any>): number;

declare function ilauplo_(__uplo: string | interop.Pointer | interop.Reference<any>): number;

declare function ilaver_(__vers_major__: interop.Pointer | interop.Reference<number>, __vers_minor__: interop.Pointer | interop.Reference<number>, __vers_patch__: interop.Pointer | interop.Reference<number>): number;

declare function ilaver_Function(__vers_major__: interop.Pointer | interop.Reference<number>, __vers_minor__: interop.Pointer | interop.Reference<number>, __vers_patch__: interop.Pointer | interop.Reference<number>): number;

declare function ilazlc_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_doublecomplex>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function ilazlr_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<__CLPK_doublecomplex>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function iparmq_(__ispec: interop.Pointer | interop.Reference<number>, __name__: string | interop.Pointer | interop.Reference<any>, __opts: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>): number;

declare function izmax1_(__n: interop.Pointer | interop.Reference<number>, __cx: interop.Pointer | interop.Reference<__CLPK_doublecomplex>, __incx: interop.Pointer | interop.Reference<number>): number;

declare const kFFTDirection_Forward: number;

declare const kFFTDirection_Inverse: number;

declare const kFFTRadix2: number;

declare const kFFTRadix3: number;

declare const kFFTRadix5: number;

declare const kRotate0DegreesClockwise: number;

declare const kRotate0DegreesCounterClockwise: number;

declare const kRotate180DegreesClockwise: number;

declare const kRotate180DegreesCounterClockwise: number;

declare const kRotate270DegreesClockwise: number;

declare const kRotate270DegreesCounterClockwise: number;

declare const kRotate90DegreesClockwise: number;

declare const kRotate90DegreesCounterClockwise: number;

declare const kvImageBackgroundColorFill: number;

declare const kvImageBufferSizeMismatch: number;

declare const kvImageBufferTypeCode_Alpha: number;

declare const kvImageBufferTypeCode_CGFormat: number;

declare const kvImageBufferTypeCode_CMYK_Black: number;

declare const kvImageBufferTypeCode_CMYK_Cyan: number;

declare const kvImageBufferTypeCode_CMYK_Magenta: number;

declare const kvImageBufferTypeCode_CMYK_Yellow: number;

declare const kvImageBufferTypeCode_CVPixelBuffer_YCbCr: number;

declare const kvImageBufferTypeCode_Cb: number;

declare const kvImageBufferTypeCode_Chroma: number;

declare const kvImageBufferTypeCode_Chunky: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel1: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel10: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel11: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel12: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel13: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel14: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel15: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel16: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel2: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel3: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel4: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel5: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel6: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel7: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel8: number;

declare const kvImageBufferTypeCode_ColorSpaceChannel9: number;

declare const kvImageBufferTypeCode_Cr: number;

declare const kvImageBufferTypeCode_EndOfList: number;

declare const kvImageBufferTypeCode_Indexed: number;

declare const kvImageBufferTypeCode_LAB_A: number;

declare const kvImageBufferTypeCode_LAB_B: number;

declare const kvImageBufferTypeCode_LAB_L: number;

declare const kvImageBufferTypeCode_Luminance: number;

declare const kvImageBufferTypeCode_Monochrome: number;

declare const kvImageBufferTypeCode_RGB_Blue: number;

declare const kvImageBufferTypeCode_RGB_Green: number;

declare const kvImageBufferTypeCode_RGB_Red: number;

declare const kvImageBufferTypeCode_UniqueFormatCount: number;

declare const kvImageBufferTypeCode_XYZ_X: number;

declare const kvImageBufferTypeCode_XYZ_Y: number;

declare const kvImageBufferTypeCode_XYZ_Z: number;

declare const kvImageCVImageFormat_AlphaIsOneHint: number;

declare const kvImageCVImageFormat_ChromaSiting: number;

declare const kvImageCVImageFormat_ColorSpace: number;

declare const kvImageCVImageFormat_ConversionMatrix: number;

declare const kvImageCVImageFormat_NoError: number;

declare const kvImageCVImageFormat_VideoChannelDescription: number;

declare const kvImageColorSyncIsAbsent: number;

declare const kvImageConvert_DitherAtkinson: number;

declare const kvImageConvert_DitherFloydSteinberg: number;

declare const kvImageConvert_DitherNone: number;

declare const kvImageConvert_DitherOrdered: number;

declare const kvImageConvert_DitherOrderedReproducible: number;

declare const kvImageConvert_OrderedGaussianBlue: number;

declare const kvImageConvert_OrderedNoiseShapeMask: number;

declare const kvImageConvert_OrderedUniformBlue: number;

declare const kvImageCopyInPlace: number;

declare const kvImageCoreVideoIsAbsent: number;

declare var kvImageDecodeArray_16Q12Format: interop.Pointer | interop.Reference<number>;

declare const kvImageDoNotClamp: number;

declare const kvImageDoNotTile: number;

declare const kvImageEdgeExtend: number;

declare const kvImageGamma_11_over_5_half_precision: number;

declare const kvImageGamma_11_over_9_half_precision: number;

declare const kvImageGamma_5_over_11_half_precision: number;

declare const kvImageGamma_5_over_9_half_precision: number;

declare const kvImageGamma_9_over_11_half_precision: number;

declare const kvImageGamma_9_over_5_half_precision: number;

declare const kvImageGamma_BT709_forward_half_precision: number;

declare const kvImageGamma_BT709_reverse_half_precision: number;

declare const kvImageGamma_UseGammaValue: number;

declare const kvImageGamma_UseGammaValue_half_precision: number;

declare const kvImageGamma_sRGB_forward_half_precision: number;

declare const kvImageGamma_sRGB_reverse_half_precision: number;

declare const kvImageGetTempBufferSize: number;

declare const kvImageHDRContent: number;

declare const kvImageHighQualityResampling: number;

declare const kvImageInternalError: number;

declare const kvImageInvalidCVImageFormat: number;

declare const kvImageInvalidEdgeStyle: number;

declare const kvImageInvalidImageFormat: number;

declare const kvImageInvalidImageObject: number;

declare const kvImageInvalidKernelSize: number;

declare const kvImageInvalidOffset_X: number;

declare const kvImageInvalidOffset_Y: number;

declare const kvImageInvalidParameter: number;

declare const kvImageInvalidRowBytes: number;

declare const kvImageLeaveAlphaUnchanged: number;

declare const kvImageMatrixType_ARGBToYpCbCrMatrix: number;

declare const kvImageMatrixType_None: number;

declare const kvImageMemoryAllocationError: number;

declare const kvImageNoAllocate: number;

declare const kvImageNoError: number;

declare const kvImageNoFlags: number;

declare const kvImageNullPointerArgument: number;

declare const kvImageOutOfPlaceOperationRequired: number;

declare const kvImagePrintDiagnosticsToConsole: number;

declare const kvImageRoiLargerThanInputBuffer: number;

declare const kvImageTruncateKernel: number;

declare const kvImageUnknownFlagsBit: number;

declare const kvImageUnsupportedConversion: number;

declare var kvImage_ARGBToYpCbCrMatrix_ITU_R_601_4: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCrMatrix>;

declare var kvImage_ARGBToYpCbCrMatrix_ITU_R_709_2: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCrMatrix>;

declare const kvImage_PNG_FILTER_VALUE_AVG: number;

declare const kvImage_PNG_FILTER_VALUE_NONE: number;

declare const kvImage_PNG_FILTER_VALUE_PAETH: number;

declare const kvImage_PNG_FILTER_VALUE_SUB: number;

declare const kvImage_PNG_FILTER_VALUE_UP: number;

declare var kvImage_YpCbCrToARGBMatrix_ITU_R_601_4: interop.Pointer | interop.Reference<vImage_YpCbCrToARGBMatrix>;

declare var kvImage_YpCbCrToARGBMatrix_ITU_R_709_2: interop.Pointer | interop.Reference<vImage_YpCbCrToARGBMatrix>;

declare function lsamen_(__n: interop.Pointer | interop.Reference<number>, __ca: string | interop.Pointer | interop.Reference<any>, __cb: string | interop.Pointer | interop.Reference<any>): number;

declare const enum quadrature_status {

	QUADRATURE_SUCCESS = 0,

	QUADRATURE_ERROR = -1,

	QUADRATURE_INVALID_ARG_ERROR = -2,

	QUADRATURE_ALLOC_ERROR = -3,

	QUADRATURE_INTERNAL_ERROR = -99,

	QUADRATURE_INTEGRATE_MAX_EVAL_ERROR = -101,

	QUADRATURE_INTEGRATE_BAD_BEHAVIOUR_ERROR = -102
}

declare function sbdsdc_(__uplo: string | interop.Pointer | interop.Reference<any>, __compq: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __iq: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sbdsqr_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ncvt: interop.Pointer | interop.Reference<number>, __nru: interop.Pointer | interop.Reference<number>, __ncc: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function scsum1_(__n: interop.Pointer | interop.Reference<number>, __cx: interop.Pointer | interop.Reference<__CLPK_complex>, __incx: interop.Pointer | interop.Reference<number>): number;

declare function sdisna_(__job: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __sep: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgbbrd_(__vect: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ncc: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __pt: interop.Pointer | interop.Reference<number>, __ldpt: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgbcon_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgbequ_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgbequb_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgbrfs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __afb: interop.Pointer | interop.Reference<number>, __ldafb: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgbsv_(__n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgbsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __afb: interop.Pointer | interop.Reference<number>, __ldafb: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgbtf2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgbtrf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgbtrs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgebak_(__job: string | interop.Pointer | interop.Reference<any>, __side: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgebal_(__job: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgebd2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tauq: interop.Pointer | interop.Reference<number>, __taup: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgebrd_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tauq: interop.Pointer | interop.Reference<number>, __taup: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgecon_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgeequ_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgeequb_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgees_(__jobvs: string | interop.Pointer | interop.Reference<any>, __sort: string | interop.Pointer | interop.Reference<any>, __select: interop.FunctionReference<() => number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __sdim: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __vs: interop.Pointer | interop.Reference<number>, __ldvs: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgeesx_(__jobvs: string | interop.Pointer | interop.Reference<any>, __sort: string | interop.Pointer | interop.Reference<any>, __select: interop.FunctionReference<() => number>, __sense: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __sdim: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __vs: interop.Pointer | interop.Reference<number>, __ldvs: interop.Pointer | interop.Reference<number>, __rconde: interop.Pointer | interop.Reference<number>, __rcondv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgeev_(__jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgeevx_(__balanc: string | interop.Pointer | interop.Reference<any>, __jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __sense: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __abnrm: interop.Pointer | interop.Reference<number>, __rconde: interop.Pointer | interop.Reference<number>, __rcondv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgegs_(__jobvsl: string | interop.Pointer | interop.Reference<any>, __jobvsr: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __vsl: interop.Pointer | interop.Reference<number>, __ldvsl: interop.Pointer | interop.Reference<number>, __vsr: interop.Pointer | interop.Reference<number>, __ldvsr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgegv_(__jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgehd2_(__n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgehrd_(__n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgejsv_(__joba: string | interop.Pointer | interop.Reference<any>, __jobu: string | interop.Pointer | interop.Reference<any>, __jobv: string | interop.Pointer | interop.Reference<any>, __jobr: string | interop.Pointer | interop.Reference<any>, __jobt: string | interop.Pointer | interop.Reference<any>, __jobp: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __sva: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgelq2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgelqf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgels_(__trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgelsd_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgelss_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgelsx_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgelsy_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgeql2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgeqlf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgeqp3_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgeqpf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgeqr2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgeqrf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgerfs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<number>, __ldaf: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgerq2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgerqf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgesc2_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __rhs: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __jpiv: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>): number;

declare function sgesdd_(__jobz: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgesv_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgesvd_(__jobu: string | interop.Pointer | interop.Reference<any>, __jobvt: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgesvj_(__joba: string | interop.Pointer | interop.Reference<any>, __jobu: string | interop.Pointer | interop.Reference<any>, __jobv: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __sva: interop.Pointer | interop.Reference<number>, __mv: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgesvx_(__fact: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<number>, __ldaf: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgetc2_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __jpiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgetf2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgetrf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgetri_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgetrs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sggbak_(__job: string | interop.Pointer | interop.Reference<any>, __side: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __lscale: interop.Pointer | interop.Reference<number>, __rscale: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sggbal_(__job: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __lscale: interop.Pointer | interop.Reference<number>, __rscale: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgges_(__jobvsl: string | interop.Pointer | interop.Reference<any>, __jobvsr: string | interop.Pointer | interop.Reference<any>, __sort: string | interop.Pointer | interop.Reference<any>, __selctg: interop.FunctionReference<() => number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __sdim: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __vsl: interop.Pointer | interop.Reference<number>, __ldvsl: interop.Pointer | interop.Reference<number>, __vsr: interop.Pointer | interop.Reference<number>, __ldvsr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sggesx_(__jobvsl: string | interop.Pointer | interop.Reference<any>, __jobvsr: string | interop.Pointer | interop.Reference<any>, __sort: string | interop.Pointer | interop.Reference<any>, __selctg: interop.FunctionReference<() => number>, __sense: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __sdim: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __vsl: interop.Pointer | interop.Reference<number>, __ldvsl: interop.Pointer | interop.Reference<number>, __vsr: interop.Pointer | interop.Reference<number>, __ldvsr: interop.Pointer | interop.Reference<number>, __rconde: interop.Pointer | interop.Reference<number>, __rcondv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sggev_(__jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sggevx_(__balanc: string | interop.Pointer | interop.Reference<any>, __jobvl: string | interop.Pointer | interop.Reference<any>, __jobvr: string | interop.Pointer | interop.Reference<any>, __sense: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __lscale: interop.Pointer | interop.Reference<number>, __rscale: interop.Pointer | interop.Reference<number>, __abnrm: interop.Pointer | interop.Reference<number>, __bbnrm: interop.Pointer | interop.Reference<number>, __rconde: interop.Pointer | interop.Reference<number>, __rcondv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __bwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sggglm_(__n: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgghrd_(__compq: string | interop.Pointer | interop.Reference<any>, __compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgglse_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sggqrf_(__n: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __taua: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __taub: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sggrqf_(__m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __taua: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __taub: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sggsvd_(__jobu: string | interop.Pointer | interop.Reference<any>, __jobv: string | interop.Pointer | interop.Reference<any>, __jobq: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sggsvp_(__jobu: string | interop.Pointer | interop.Reference<any>, __jobv: string | interop.Pointer | interop.Reference<any>, __jobq: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __tola: interop.Pointer | interop.Reference<number>, __tolb: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgsvj0_(__jobv: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __sva: interop.Pointer | interop.Reference<number>, __mv: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __eps: interop.Pointer | interop.Reference<number>, __sfmin: interop.Pointer | interop.Reference<number>, __tol: interop.Pointer | interop.Reference<number>, __nsweep: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgsvj1_(__jobv: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __n1: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __sva: interop.Pointer | interop.Reference<number>, __mv: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __eps: interop.Pointer | interop.Reference<number>, __sfmin: interop.Pointer | interop.Reference<number>, __tol: interop.Pointer | interop.Reference<number>, __nsweep: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgtcon_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __du2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgtrfs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __dlf: interop.Pointer | interop.Reference<number>, __df: interop.Pointer | interop.Reference<number>, __duf: interop.Pointer | interop.Reference<number>, __du2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgtsv_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgtsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __dlf: interop.Pointer | interop.Reference<number>, __df: interop.Pointer | interop.Reference<number>, __duf: interop.Pointer | interop.Reference<number>, __du2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgttrf_(__n: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __du2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgttrs_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __du2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sgtts2_(__itrans: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __du2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function shgeqz_(__job: string | interop.Pointer | interop.Reference<any>, __compq: string | interop.Pointer | interop.Reference<any>, __compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function shsein_(__side: string | interop.Pointer | interop.Reference<any>, __eigsrc: string | interop.Pointer | interop.Reference<any>, __initv: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __ifaill: interop.Pointer | interop.Reference<number>, __ifailr: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function shseqr_(__job: string | interop.Pointer | interop.Reference<any>, __compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sisnan_(__sin__: interop.Pointer | interop.Reference<number>): number;

declare function slabad_(__small: interop.Pointer | interop.Reference<number>, __large: interop.Pointer | interop.Reference<number>): number;

declare function slabrd_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tauq: interop.Pointer | interop.Reference<number>, __taup: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __ldy: interop.Pointer | interop.Reference<number>): number;

declare function slacn2_(__n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __isgn: interop.Pointer | interop.Reference<number>, __est: interop.Pointer | interop.Reference<number>, __kase: interop.Pointer | interop.Reference<number>, __isave: interop.Pointer | interop.Reference<number>): number;

declare function slacon_(__n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __isgn: interop.Pointer | interop.Reference<number>, __est: interop.Pointer | interop.Reference<number>, __kase: interop.Pointer | interop.Reference<number>): number;

declare function slacpy_(__uplo: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function sladiv_(__a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>): number;

declare function slae2_(__a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rt1: interop.Pointer | interop.Reference<number>, __rt2: interop.Pointer | interop.Reference<number>): number;

declare function slaebz_(__ijob: interop.Pointer | interop.Reference<number>, __nitmax: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __mmax: interop.Pointer | interop.Reference<number>, __minp: interop.Pointer | interop.Reference<number>, __nbmin: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __reltol: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __e2: interop.Pointer | interop.Reference<number>, __nval: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __mout: interop.Pointer | interop.Reference<number>, __nab: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slaed0_(__icompq: interop.Pointer | interop.Reference<number>, __qsiz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __qstore: interop.Pointer | interop.Reference<number>, __ldqs: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slaed1_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __indxq: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __cutpnt: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slaed2_(__k: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __n1: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __indxq: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __dlamda: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __q2: interop.Pointer | interop.Reference<number>, __indx: interop.Pointer | interop.Reference<number>, __indxc: interop.Pointer | interop.Reference<number>, __indxp: interop.Pointer | interop.Reference<number>, __coltyp: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slaed3_(__k: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __n1: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __dlamda: interop.Pointer | interop.Reference<number>, __q2: interop.Pointer | interop.Reference<number>, __indx: interop.Pointer | interop.Reference<number>, __ctot: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slaed4_(__n: interop.Pointer | interop.Reference<number>, __i__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __delta: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __dlam: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slaed5_(__i__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __delta: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __dlam: interop.Pointer | interop.Reference<number>): number;

declare function slaed6_(__kniter: interop.Pointer | interop.Reference<number>, __orgati: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __finit: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slaed7_(__icompq: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __qsiz: interop.Pointer | interop.Reference<number>, __tlvls: interop.Pointer | interop.Reference<number>, __curlvl: interop.Pointer | interop.Reference<number>, __curpbm: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __indxq: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __cutpnt: interop.Pointer | interop.Reference<number>, __qstore: interop.Pointer | interop.Reference<number>, __qptr: interop.Pointer | interop.Reference<number>, __prmptr: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slaed8_(__icompq: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __qsiz: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __indxq: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __cutpnt: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __dlamda: interop.Pointer | interop.Reference<number>, __q2: interop.Pointer | interop.Reference<number>, __ldq2: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __indxp: interop.Pointer | interop.Reference<number>, __indx: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slaed9_(__k: interop.Pointer | interop.Reference<number>, __kstart: interop.Pointer | interop.Reference<number>, __kstop: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __dlamda: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __lds: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slaeda_(__n: interop.Pointer | interop.Reference<number>, __tlvls: interop.Pointer | interop.Reference<number>, __curlvl: interop.Pointer | interop.Reference<number>, __curpbm: interop.Pointer | interop.Reference<number>, __prmptr: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __qptr: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ztemp: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slaein_(__rightv: interop.Pointer | interop.Reference<number>, __noinit: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __vi: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __eps3: interop.Pointer | interop.Reference<number>, __smlnum: interop.Pointer | interop.Reference<number>, __bignum: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slaev2_(__a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rt1: interop.Pointer | interop.Reference<number>, __rt2: interop.Pointer | interop.Reference<number>, __cs1: interop.Pointer | interop.Reference<number>, __sn1: interop.Pointer | interop.Reference<number>): number;

declare function slaexc_(__wantq: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __j1: interop.Pointer | interop.Reference<number>, __n1: interop.Pointer | interop.Reference<number>, __n2: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slag2_(__a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __safmin: interop.Pointer | interop.Reference<number>, __scale1: interop.Pointer | interop.Reference<number>, __scale2: interop.Pointer | interop.Reference<number>, __wr1: interop.Pointer | interop.Reference<number>, __wr2: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>): number;

declare function slag2d_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __sa: interop.Pointer | interop.Reference<number>, __ldsa: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slags2_(__upper: interop.Pointer | interop.Reference<number>, __a1: interop.Pointer | interop.Reference<number>, __a2: interop.Pointer | interop.Reference<number>, __a3: interop.Pointer | interop.Reference<number>, __b1: interop.Pointer | interop.Reference<number>, __b2: interop.Pointer | interop.Reference<number>, __b3: interop.Pointer | interop.Reference<number>, __csu: interop.Pointer | interop.Reference<number>, __snu: interop.Pointer | interop.Reference<number>, __csv: interop.Pointer | interop.Reference<number>, __snv: interop.Pointer | interop.Reference<number>, __csq: interop.Pointer | interop.Reference<number>, __snq: interop.Pointer | interop.Reference<number>): number;

declare function slagtf_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lambda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __tol: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __in: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slagtm_(__trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function slagts_(__job: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __in: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __tol: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slagv2_(__a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __csl: interop.Pointer | interop.Reference<number>, __snl: interop.Pointer | interop.Reference<number>, __csr: interop.Pointer | interop.Reference<number>, __snr: interop.Pointer | interop.Reference<number>): number;

declare function slahqr_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slahr2_(__n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __ldy: interop.Pointer | interop.Reference<number>): number;

declare function slahrd_(__n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __ldy: interop.Pointer | interop.Reference<number>): number;

declare function slaic1_(__job: interop.Pointer | interop.Reference<number>, __j: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __sest: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __gamma: interop.Pointer | interop.Reference<number>, __sestpr: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>): number;

declare function slaisnan_(__sin1: interop.Pointer | interop.Reference<number>, __sin2: interop.Pointer | interop.Reference<number>): number;

declare function slaln2_(__ltrans: interop.Pointer | interop.Reference<number>, __na: interop.Pointer | interop.Reference<number>, __nw: interop.Pointer | interop.Reference<number>, __smin: interop.Pointer | interop.Reference<number>, __ca: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d1: interop.Pointer | interop.Reference<number>, __d2: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __xnorm: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slals0_(__icompq: interop.Pointer | interop.Reference<number>, __nl: interop.Pointer | interop.Reference<number>, __nr: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __bx: interop.Pointer | interop.Reference<number>, __ldbx: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __ldgcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __ldgnum: interop.Pointer | interop.Reference<number>, __poles: interop.Pointer | interop.Reference<number>, __difl: interop.Pointer | interop.Reference<number>, __difr: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slalsa_(__icompq: interop.Pointer | interop.Reference<number>, __smlsiz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __bx: interop.Pointer | interop.Reference<number>, __ldbx: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __difl: interop.Pointer | interop.Reference<number>, __difr: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __poles: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __ldgcol: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slalsd_(__uplo: string | interop.Pointer | interop.Reference<any>, __smlsiz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slamc1_(__beta: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __rnd: interop.Pointer | interop.Reference<number>, __ieee1: interop.Pointer | interop.Reference<number>): number;

declare function slamc2_(__beta: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __rnd: interop.Pointer | interop.Reference<number>, __eps: interop.Pointer | interop.Reference<number>, __emin: interop.Pointer | interop.Reference<number>, __rmin: interop.Pointer | interop.Reference<number>, __emax: interop.Pointer | interop.Reference<number>, __rmax: interop.Pointer | interop.Reference<number>): number;

declare function slamc3_(__a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>): number;

declare function slamc4_(__emin: interop.Pointer | interop.Reference<number>, __start: interop.Pointer | interop.Reference<number>, __base: interop.Pointer | interop.Reference<number>): number;

declare function slamc5_(__beta: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __emin: interop.Pointer | interop.Reference<number>, __ieee: interop.Pointer | interop.Reference<number>, __emax: interop.Pointer | interop.Reference<number>, __rmax: interop.Pointer | interop.Reference<number>): number;

declare function slamch_(__cmach: string | interop.Pointer | interop.Reference<any>): number;

declare function slamrg_(__n1: interop.Pointer | interop.Reference<number>, __n2: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __strd1: interop.Pointer | interop.Reference<number>, __strd2: interop.Pointer | interop.Reference<number>, __index: interop.Pointer | interop.Reference<number>): number;

declare function slaneg_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __lld: interop.Pointer | interop.Reference<number>, __sigma: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>): number;

declare function slangb_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slange_(__norm: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slangt_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __dl: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __du: interop.Pointer | interop.Reference<number>): number;

declare function slanhs_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slansb_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slansf_(__norm: string | interop.Pointer | interop.Reference<any>, __transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slansp_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slanst_(__norm: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>): number;

declare function slansy_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slantb_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slantp_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slantr_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slanv2_(__a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __rt1r: interop.Pointer | interop.Reference<number>, __rt1i: interop.Pointer | interop.Reference<number>, __rt2r: interop.Pointer | interop.Reference<number>, __rt2i: interop.Pointer | interop.Reference<number>, __cs: interop.Pointer | interop.Reference<number>, __sn: interop.Pointer | interop.Reference<number>): number;

declare function slapll_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __incy: interop.Pointer | interop.Reference<number>, __ssmin: interop.Pointer | interop.Reference<number>): number;

declare function slapmt_(__forwrd: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>): number;

declare function slapy2_(__x: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>): number;

declare function slapy3_(__x: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>): number;

declare function slaqgb_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function slaqge_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __rowcnd: interop.Pointer | interop.Reference<number>, __colcnd: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function slaqp2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __offset: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __vn1: interop.Pointer | interop.Reference<number>, __vn2: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slaqps_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __offset: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __jpvt: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __vn1: interop.Pointer | interop.Reference<number>, __vn2: interop.Pointer | interop.Reference<number>, __auxv: interop.Pointer | interop.Reference<number>, __f: interop.Pointer | interop.Reference<number>, __ldf: interop.Pointer | interop.Reference<number>): number;

declare function slaqr0_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slaqr1_(__n: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __sr1: interop.Pointer | interop.Reference<number>, __si1: interop.Pointer | interop.Reference<number>, __sr2: interop.Pointer | interop.Reference<number>, __si2: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>): number;

declare function slaqr2_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ktop: interop.Pointer | interop.Reference<number>, __kbot: interop.Pointer | interop.Reference<number>, __nw: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __ns: interop.Pointer | interop.Reference<number>, __nd: interop.Pointer | interop.Reference<number>, __sr: interop.Pointer | interop.Reference<number>, __si: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __nh: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __nv: interop.Pointer | interop.Reference<number>, __wv: interop.Pointer | interop.Reference<number>, __ldwv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>): number;

declare function slaqr3_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ktop: interop.Pointer | interop.Reference<number>, __kbot: interop.Pointer | interop.Reference<number>, __nw: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __ns: interop.Pointer | interop.Reference<number>, __nd: interop.Pointer | interop.Reference<number>, __sr: interop.Pointer | interop.Reference<number>, __si: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __nh: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __nv: interop.Pointer | interop.Reference<number>, __wv: interop.Pointer | interop.Reference<number>, __ldwv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>): number;

declare function slaqr4_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slaqr5_(__wantt: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __kacc22: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ktop: interop.Pointer | interop.Reference<number>, __kbot: interop.Pointer | interop.Reference<number>, __nshfts: interop.Pointer | interop.Reference<number>, __sr: interop.Pointer | interop.Reference<number>, __si: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ldh: interop.Pointer | interop.Reference<number>, __iloz: interop.Pointer | interop.Reference<number>, __ihiz: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __nv: interop.Pointer | interop.Reference<number>, __wv: interop.Pointer | interop.Reference<number>, __ldwv: interop.Pointer | interop.Reference<number>, __nh: interop.Pointer | interop.Reference<number>, __wh: interop.Pointer | interop.Reference<number>, __ldwh: interop.Pointer | interop.Reference<number>): number;

declare function slaqsb_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function slaqsp_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function slaqsy_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>): number;

declare function slaqtr_(__ltran: interop.Pointer | interop.Reference<number>, __l__CLPK_real: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slar1v_(__n: interop.Pointer | interop.Reference<number>, __b1: interop.Pointer | interop.Reference<number>, __bn: interop.Pointer | interop.Reference<number>, __lambda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __ld: interop.Pointer | interop.Reference<number>, __lld: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __gaptol: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __wantnc: interop.Pointer | interop.Reference<number>, __negcnt: interop.Pointer | interop.Reference<number>, __ztz: interop.Pointer | interop.Reference<number>, __mingma: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __nrminv: interop.Pointer | interop.Reference<number>, __resid: interop.Pointer | interop.Reference<number>, __rqcorr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slar2v_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __incc: interop.Pointer | interop.Reference<number>): number;

declare function slarf_(__side: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __incv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slarfb_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __direct: string | interop.Pointer | interop.Reference<any>, __storev: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __ldwork: interop.Pointer | interop.Reference<number>): number;

declare function slarfg_(__n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>): number;

declare function slarfp_(__n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>): number;

declare function slarft_(__direct: string | interop.Pointer | interop.Reference<any>, __storev: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>): number;

declare function slarfx_(__side: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slargv_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __incy: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __incc: interop.Pointer | interop.Reference<number>): number;

declare function slarnv_(__idist: interop.Pointer | interop.Reference<number>, __iseed: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>): number;

declare function slarra_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __e2: interop.Pointer | interop.Reference<number>, __spltol: interop.Pointer | interop.Reference<number>, __tnrm: interop.Pointer | interop.Reference<number>, __nsplit: interop.Pointer | interop.Reference<number>, __isplit: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slarrb_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __lld: interop.Pointer | interop.Reference<number>, __ifirst: interop.Pointer | interop.Reference<number>, __ilast: interop.Pointer | interop.Reference<number>, __rtol1: interop.Pointer | interop.Reference<number>, __rtol2: interop.Pointer | interop.Reference<number>, __offset: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __wgap: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __spdiam: interop.Pointer | interop.Reference<number>, __twist: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slarrc_(__jobt: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __eigcnt: interop.Pointer | interop.Reference<number>, __lcnt: interop.Pointer | interop.Reference<number>, __rcnt: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slarrd_(__range: string | interop.Pointer | interop.Reference<any>, __order: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __gers: interop.Pointer | interop.Reference<number>, __reltol: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __e2: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __nsplit: interop.Pointer | interop.Reference<number>, __isplit: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __wl: interop.Pointer | interop.Reference<number>, __wu: interop.Pointer | interop.Reference<number>, __iblock: interop.Pointer | interop.Reference<number>, __indexw: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slarre_(__range: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __e2: interop.Pointer | interop.Reference<number>, __rtol1: interop.Pointer | interop.Reference<number>, __rtol2: interop.Pointer | interop.Reference<number>, __spltol: interop.Pointer | interop.Reference<number>, __nsplit: interop.Pointer | interop.Reference<number>, __isplit: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __wgap: interop.Pointer | interop.Reference<number>, __iblock: interop.Pointer | interop.Reference<number>, __indexw: interop.Pointer | interop.Reference<number>, __gers: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slarrf_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __ld: interop.Pointer | interop.Reference<number>, __clstrt: interop.Pointer | interop.Reference<number>, __clend: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __wgap: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __spdiam: interop.Pointer | interop.Reference<number>, __clgapl: interop.Pointer | interop.Reference<number>, __clgapr: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __sigma: interop.Pointer | interop.Reference<number>, __dplus: interop.Pointer | interop.Reference<number>, __lplus: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slarrj_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e2: interop.Pointer | interop.Reference<number>, __ifirst: interop.Pointer | interop.Reference<number>, __ilast: interop.Pointer | interop.Reference<number>, __rtol: interop.Pointer | interop.Reference<number>, __offset: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __spdiam: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slarrk_(__n: interop.Pointer | interop.Reference<number>, __iw: interop.Pointer | interop.Reference<number>, __gl: interop.Pointer | interop.Reference<number>, __gu: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e2: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __reltol: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slarrr_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slarrv_(__n: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __pivmin: interop.Pointer | interop.Reference<number>, __isplit: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __dol: interop.Pointer | interop.Reference<number>, __dou: interop.Pointer | interop.Reference<number>, __minrgp: interop.Pointer | interop.Reference<number>, __rtol1: interop.Pointer | interop.Reference<number>, __rtol2: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __werr: interop.Pointer | interop.Reference<number>, __wgap: interop.Pointer | interop.Reference<number>, __iblock: interop.Pointer | interop.Reference<number>, __indexw: interop.Pointer | interop.Reference<number>, __gers: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slarscl2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>): number;

declare function slartg_(__f: interop.Pointer | interop.Reference<number>, __g: interop.Pointer | interop.Reference<number>, __cs: interop.Pointer | interop.Reference<number>, __sn: interop.Pointer | interop.Reference<number>, __r__: interop.Pointer | interop.Reference<number>): number;

declare function slartv_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>, __y: interop.Pointer | interop.Reference<number>, __incy: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __incc: interop.Pointer | interop.Reference<number>): number;

declare function slaruv_(__iseed: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>): number;

declare function slarz_(__side: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __incv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slarzb_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __direct: string | interop.Pointer | interop.Reference<any>, __storev: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __ldwork: interop.Pointer | interop.Reference<number>): number;

declare function slarzt_(__direct: string | interop.Pointer | interop.Reference<any>, __storev: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>): number;

declare function slas2_(__f: interop.Pointer | interop.Reference<number>, __g: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ssmin: interop.Pointer | interop.Reference<number>, __ssmax: interop.Pointer | interop.Reference<number>): number;

declare function slascl2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>): number;

declare function slascl_(__type__: string | interop.Pointer | interop.Reference<any>, __kl: interop.Pointer | interop.Reference<number>, __ku: interop.Pointer | interop.Reference<number>, __cfrom: interop.Pointer | interop.Reference<number>, __cto: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slasd0_(__n: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __smlsiz: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slasd1_(__nl: interop.Pointer | interop.Reference<number>, __nr: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __idxq: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slasd2_(__nl: interop.Pointer | interop.Reference<number>, __nr: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __dsigma: interop.Pointer | interop.Reference<number>, __u2: interop.Pointer | interop.Reference<number>, __ldu2: interop.Pointer | interop.Reference<number>, __vt2: interop.Pointer | interop.Reference<number>, __ldvt2: interop.Pointer | interop.Reference<number>, __idxp: interop.Pointer | interop.Reference<number>, __idx: interop.Pointer | interop.Reference<number>, __idxc: interop.Pointer | interop.Reference<number>, __idxq: interop.Pointer | interop.Reference<number>, __coltyp: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slasd3_(__nl: interop.Pointer | interop.Reference<number>, __nr: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __dsigma: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __u2: interop.Pointer | interop.Reference<number>, __ldu2: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __vt2: interop.Pointer | interop.Reference<number>, __ldvt2: interop.Pointer | interop.Reference<number>, __idxc: interop.Pointer | interop.Reference<number>, __ctot: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slasd4_(__n: interop.Pointer | interop.Reference<number>, __i__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __delta: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __sigma: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slasd5_(__i__: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __delta: interop.Pointer | interop.Reference<number>, __rho: interop.Pointer | interop.Reference<number>, __dsigma: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slasd6_(__icompq: interop.Pointer | interop.Reference<number>, __nl: interop.Pointer | interop.Reference<number>, __nr: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __vf: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __idxq: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __ldgcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __ldgnum: interop.Pointer | interop.Reference<number>, __poles: interop.Pointer | interop.Reference<number>, __difl: interop.Pointer | interop.Reference<number>, __difr: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slasd7_(__icompq: interop.Pointer | interop.Reference<number>, __nl: interop.Pointer | interop.Reference<number>, __nr: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __zw: interop.Pointer | interop.Reference<number>, __vf: interop.Pointer | interop.Reference<number>, __vfw: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vlw: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __dsigma: interop.Pointer | interop.Reference<number>, __idx: interop.Pointer | interop.Reference<number>, __idxp: interop.Pointer | interop.Reference<number>, __idxq: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __ldgcol: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __ldgnum: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slasd8_(__icompq: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __vf: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __difl: interop.Pointer | interop.Reference<number>, __difr: interop.Pointer | interop.Reference<number>, __lddifr: interop.Pointer | interop.Reference<number>, __dsigma: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slasda_(__icompq: interop.Pointer | interop.Reference<number>, __smlsiz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __sqre: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __difl: interop.Pointer | interop.Reference<number>, __difr: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __poles: interop.Pointer | interop.Reference<number>, __givptr: interop.Pointer | interop.Reference<number>, __givcol: interop.Pointer | interop.Reference<number>, __ldgcol: interop.Pointer | interop.Reference<number>, __perm: interop.Pointer | interop.Reference<number>, __givnum: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slasdq_(__uplo: string | interop.Pointer | interop.Reference<any>, __sqre: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ncvt: interop.Pointer | interop.Reference<number>, __nru: interop.Pointer | interop.Reference<number>, __ncc: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vt: interop.Pointer | interop.Reference<number>, __ldvt: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slasdt_(__n: interop.Pointer | interop.Reference<number>, __lvl: interop.Pointer | interop.Reference<number>, __nd: interop.Pointer | interop.Reference<number>, __inode: interop.Pointer | interop.Reference<number>, __ndiml: interop.Pointer | interop.Reference<number>, __ndimr: interop.Pointer | interop.Reference<number>, __msub: interop.Pointer | interop.Reference<number>): number;

declare function slaset_(__uplo: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function slasq1_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slasq2_(__n: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slasq3_(__i0: interop.Pointer | interop.Reference<number>, __n0: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __pp: interop.Pointer | interop.Reference<number>, __dmin__: interop.Pointer | interop.Reference<number>, __sigma: interop.Pointer | interop.Reference<number>, __desig: interop.Pointer | interop.Reference<number>, __qmax: interop.Pointer | interop.Reference<number>, __nfail: interop.Pointer | interop.Reference<number>, __iter: interop.Pointer | interop.Reference<number>, __ndiv: interop.Pointer | interop.Reference<number>, __ieee: interop.Pointer | interop.Reference<number>, __ttype: interop.Pointer | interop.Reference<number>, __dmin1: interop.Pointer | interop.Reference<number>, __dmin2: interop.Pointer | interop.Reference<number>, __dn: interop.Pointer | interop.Reference<number>, __dn1: interop.Pointer | interop.Reference<number>, __dn2: interop.Pointer | interop.Reference<number>, __g: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>): number;

declare function slasq4_(__i0: interop.Pointer | interop.Reference<number>, __n0: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __pp: interop.Pointer | interop.Reference<number>, __n0in: interop.Pointer | interop.Reference<number>, __dmin__: interop.Pointer | interop.Reference<number>, __dmin1: interop.Pointer | interop.Reference<number>, __dmin2: interop.Pointer | interop.Reference<number>, __dn: interop.Pointer | interop.Reference<number>, __dn1: interop.Pointer | interop.Reference<number>, __dn2: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __ttype: interop.Pointer | interop.Reference<number>, __g: interop.Pointer | interop.Reference<number>): number;

declare function slasq5_(__i0: interop.Pointer | interop.Reference<number>, __n0: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __pp: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __dmin__: interop.Pointer | interop.Reference<number>, __dmin1: interop.Pointer | interop.Reference<number>, __dmin2: interop.Pointer | interop.Reference<number>, __dn: interop.Pointer | interop.Reference<number>, __dnm1: interop.Pointer | interop.Reference<number>, __dnm2: interop.Pointer | interop.Reference<number>, __ieee: interop.Pointer | interop.Reference<number>): number;

declare function slasq6_(__i0: interop.Pointer | interop.Reference<number>, __n0: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __pp: interop.Pointer | interop.Reference<number>, __dmin__: interop.Pointer | interop.Reference<number>, __dmin1: interop.Pointer | interop.Reference<number>, __dmin2: interop.Pointer | interop.Reference<number>, __dn: interop.Pointer | interop.Reference<number>, __dnm1: interop.Pointer | interop.Reference<number>, __dnm2: interop.Pointer | interop.Reference<number>): number;

declare function slasr_(__side: string | interop.Pointer | interop.Reference<any>, __pivot: string | interop.Pointer | interop.Reference<any>, __direct: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>): number;

declare function slasrt_(__id: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slassq_(__n: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __sumsq: interop.Pointer | interop.Reference<number>): number;

declare function slasv2_(__f: interop.Pointer | interop.Reference<number>, __g: interop.Pointer | interop.Reference<number>, __h__: interop.Pointer | interop.Reference<number>, __ssmin: interop.Pointer | interop.Reference<number>, __ssmax: interop.Pointer | interop.Reference<number>, __snr: interop.Pointer | interop.Reference<number>, __csr: interop.Pointer | interop.Reference<number>, __snl: interop.Pointer | interop.Reference<number>, __csl: interop.Pointer | interop.Reference<number>): number;

declare function slaswp_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __k1: interop.Pointer | interop.Reference<number>, __k2: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>): number;

declare function slasy2_(__ltranl: interop.Pointer | interop.Reference<number>, __ltranr: interop.Pointer | interop.Reference<number>, __isgn: interop.Pointer | interop.Reference<number>, __n1: interop.Pointer | interop.Reference<number>, __n2: interop.Pointer | interop.Reference<number>, __tl: interop.Pointer | interop.Reference<number>, __ldtl: interop.Pointer | interop.Reference<number>, __tr: interop.Pointer | interop.Reference<number>, __ldtr: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __xnorm: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slasyf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __ldw: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slatbs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __normin: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __cnorm: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slatdf_(__ijob: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __rhs: interop.Pointer | interop.Reference<number>, __rdsum: interop.Pointer | interop.Reference<number>, __rdscal: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __jpiv: interop.Pointer | interop.Reference<number>): number;

declare function slatps_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __normin: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __cnorm: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slatrd_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nb: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __ldw: interop.Pointer | interop.Reference<number>): number;

declare function slatrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __normin: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __cnorm: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slatrz_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slatzm_(__side: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __incv: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c1: interop.Pointer | interop.Reference<number>, __c2: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>): number;

declare function slauu2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function slauum_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function smaxloc_(__a: interop.Pointer | interop.Reference<number>, __dimm: interop.Pointer | interop.Reference<number>): number;

declare function sopgtr_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sopmtr_(__side: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sorg2l_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sorg2r_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sorgbr_(__vect: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sorghr_(__n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sorgl2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sorglq_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sorgql_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sorgqr_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sorgr2_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sorgrq_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sorgtr_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sorm2l_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sorm2r_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sormbr_(__vect: string | interop.Pointer | interop.Reference<any>, __side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sormhr_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __ilo: interop.Pointer | interop.Reference<number>, __ihi: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sorml2_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sormlq_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sormql_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sormqr_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sormr2_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sormr3_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sormrq_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sormrz_(__side: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sormtr_(__side: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sparse_commit(A: interop.Pointer | interop.Reference<any>): sparse_status;

declare function sparse_elementwise_norm_double(A: interop.Pointer | interop.Reference<any>, norm: sparse_norm): number;

declare function sparse_elementwise_norm_float(A: interop.Pointer | interop.Reference<any>, norm: sparse_norm): number;

declare function sparse_extract_block_double(A: interop.Pointer | interop.Reference<any>, bi: number, bj: number, row_stride: number, col_stride: number, val: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_extract_block_float(A: interop.Pointer | interop.Reference<any>, bi: number, bj: number, row_stride: number, col_stride: number, val: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_extract_sparse_column_double(A: interop.Pointer | interop.Reference<any>, column: number, row_start: number, row_end: interop.Pointer | interop.Reference<number>, nz: number, val: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_extract_sparse_column_float(A: interop.Pointer | interop.Reference<any>, column: number, row_start: number, row_end: interop.Pointer | interop.Reference<number>, nz: number, val: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_extract_sparse_row_double(A: interop.Pointer | interop.Reference<any>, row: number, column_start: number, column_end: interop.Pointer | interop.Reference<number>, nz: number, val: interop.Pointer | interop.Reference<number>, jndx: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_extract_sparse_row_float(A: interop.Pointer | interop.Reference<any>, row: number, column_start: number, column_end: interop.Pointer | interop.Reference<number>, nz: number, val: interop.Pointer | interop.Reference<number>, jndx: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_get_block_dimension_for_col(A: interop.Pointer | interop.Reference<any>, j: number): number;

declare function sparse_get_block_dimension_for_row(A: interop.Pointer | interop.Reference<any>, i: number): number;

declare function sparse_get_matrix_nonzero_count(A: interop.Pointer | interop.Reference<any>): number;

declare function sparse_get_matrix_nonzero_count_for_column(A: interop.Pointer | interop.Reference<any>, j: number): number;

declare function sparse_get_matrix_nonzero_count_for_row(A: interop.Pointer | interop.Reference<any>, i: number): number;

declare function sparse_get_matrix_number_of_columns(A: interop.Pointer | interop.Reference<any>): number;

declare function sparse_get_matrix_number_of_rows(A: interop.Pointer | interop.Reference<any>): number;

declare function sparse_get_matrix_property(A: interop.Pointer | interop.Reference<any>, pname: sparse_matrix_property): number;

declare function sparse_get_vector_nonzero_count_double(N: number, x: interop.Pointer | interop.Reference<number>, incx: number): number;

declare function sparse_get_vector_nonzero_count_float(N: number, x: interop.Pointer | interop.Reference<number>, incx: number): number;

declare function sparse_inner_product_dense_double(nz: number, x: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>, y: interop.Pointer | interop.Reference<number>, incy: number): number;

declare function sparse_inner_product_dense_float(nz: number, x: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>, y: interop.Pointer | interop.Reference<number>, incy: number): number;

declare function sparse_inner_product_sparse_double(nzx: number, nzy: number, x: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>, y: interop.Pointer | interop.Reference<number>, indy: interop.Pointer | interop.Reference<number>): number;

declare function sparse_inner_product_sparse_float(nzx: number, nzy: number, x: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>, y: interop.Pointer | interop.Reference<number>, indy: interop.Pointer | interop.Reference<number>): number;

declare function sparse_insert_block_double(A: interop.Pointer | interop.Reference<any>, val: interop.Pointer | interop.Reference<number>, row_stride: number, col_stride: number, bi: number, bj: number): sparse_status;

declare function sparse_insert_block_float(A: interop.Pointer | interop.Reference<any>, val: interop.Pointer | interop.Reference<number>, row_stride: number, col_stride: number, bi: number, bj: number): sparse_status;

declare function sparse_insert_col_double(A: interop.Pointer | interop.Reference<any>, j: number, nz: number, val: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_insert_col_float(A: interop.Pointer | interop.Reference<any>, j: number, nz: number, val: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_insert_entries_double(A: interop.Pointer | interop.Reference<any>, N: number, val: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>, jndx: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_insert_entries_float(A: interop.Pointer | interop.Reference<any>, N: number, val: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>, jndx: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_insert_entry_double(A: interop.Pointer | interop.Reference<any>, val: number, i: number, j: number): sparse_status;

declare function sparse_insert_entry_float(A: interop.Pointer | interop.Reference<any>, val: number, i: number, j: number): sparse_status;

declare function sparse_insert_row_double(A: interop.Pointer | interop.Reference<any>, i: number, nz: number, val: interop.Pointer | interop.Reference<number>, jndx: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_insert_row_float(A: interop.Pointer | interop.Reference<any>, i: number, nz: number, val: interop.Pointer | interop.Reference<number>, jndx: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_matrix_block_create_double(Mb: number, Nb: number, k: number, l: number): interop.Pointer | interop.Reference<any>;

declare function sparse_matrix_block_create_float(Mb: number, Nb: number, k: number, l: number): interop.Pointer | interop.Reference<any>;

declare function sparse_matrix_create_double(M: number, N: number): interop.Pointer | interop.Reference<any>;

declare function sparse_matrix_create_float(M: number, N: number): interop.Pointer | interop.Reference<any>;

declare function sparse_matrix_destroy(A: interop.Pointer | interop.Reference<any>): sparse_status;

declare function sparse_matrix_product_dense_double(order: CBLAS_ORDER, transa: CBLAS_TRANSPOSE, n: number, alpha: number, A: interop.Pointer | interop.Reference<any>, B: interop.Pointer | interop.Reference<number>, ldb: number, C: interop.Pointer | interop.Reference<number>, ldc: number): sparse_status;

declare function sparse_matrix_product_dense_float(order: CBLAS_ORDER, transa: CBLAS_TRANSPOSE, n: number, alpha: number, A: interop.Pointer | interop.Reference<any>, B: interop.Pointer | interop.Reference<number>, ldb: number, C: interop.Pointer | interop.Reference<number>, ldc: number): sparse_status;

declare function sparse_matrix_product_sparse_double(order: CBLAS_ORDER, transa: CBLAS_TRANSPOSE, alpha: number, A: interop.Pointer | interop.Reference<any>, B: interop.Pointer | interop.Reference<any>, C: interop.Pointer | interop.Reference<number>, ldc: number): sparse_status;

declare function sparse_matrix_product_sparse_float(order: CBLAS_ORDER, transa: CBLAS_TRANSPOSE, alpha: number, A: interop.Pointer | interop.Reference<any>, B: interop.Pointer | interop.Reference<any>, C: interop.Pointer | interop.Reference<number>, ldc: number): sparse_status;

declare const enum sparse_matrix_property {

	SPARSE_UPPER_TRIANGULAR = 1,

	SPARSE_LOWER_TRIANGULAR = 2,

	SPARSE_UPPER_SYMMETRIC = 4,

	SPARSE_LOWER_SYMMETRIC = 8
}

declare function sparse_matrix_trace_double(A: interop.Pointer | interop.Reference<any>, offset: number): number;

declare function sparse_matrix_trace_float(A: interop.Pointer | interop.Reference<any>, offset: number): number;

declare function sparse_matrix_triangular_solve_dense_double(order: CBLAS_ORDER, transt: CBLAS_TRANSPOSE, nrhs: number, alpha: number, T: interop.Pointer | interop.Reference<any>, B: interop.Pointer | interop.Reference<number>, ldb: number): sparse_status;

declare function sparse_matrix_triangular_solve_dense_float(order: CBLAS_ORDER, transt: CBLAS_TRANSPOSE, nrhs: number, alpha: number, T: interop.Pointer | interop.Reference<any>, B: interop.Pointer | interop.Reference<number>, ldb: number): sparse_status;

declare function sparse_matrix_variable_block_create_double(Mb: number, Nb: number, K: interop.Pointer | interop.Reference<number>, L: interop.Pointer | interop.Reference<number>): interop.Pointer | interop.Reference<any>;

declare function sparse_matrix_variable_block_create_float(Mb: number, Nb: number, K: interop.Pointer | interop.Reference<number>, L: interop.Pointer | interop.Reference<number>): interop.Pointer | interop.Reference<any>;

declare function sparse_matrix_vector_product_dense_double(transa: CBLAS_TRANSPOSE, alpha: number, A: interop.Pointer | interop.Reference<any>, x: interop.Pointer | interop.Reference<number>, incx: number, y: interop.Pointer | interop.Reference<number>, incy: number): sparse_status;

declare function sparse_matrix_vector_product_dense_float(transa: CBLAS_TRANSPOSE, alpha: number, A: interop.Pointer | interop.Reference<any>, x: interop.Pointer | interop.Reference<number>, incx: number, y: interop.Pointer | interop.Reference<number>, incy: number): sparse_status;

declare const enum sparse_norm {

	SPARSE_NORM_ONE = 171,

	SPARSE_NORM_TWO = 173,

	SPARSE_NORM_INF = 175,

	SPARSE_NORM_R1 = 179
}

declare function sparse_operator_norm_double(A: interop.Pointer | interop.Reference<any>, norm: sparse_norm): number;

declare function sparse_operator_norm_float(A: interop.Pointer | interop.Reference<any>, norm: sparse_norm): number;

declare function sparse_outer_product_dense_double(M: number, N: number, nz: number, alpha: number, x: interop.Pointer | interop.Reference<number>, incx: number, y: interop.Pointer | interop.Reference<number>, indy: interop.Pointer | interop.Reference<number>, C: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<any>>): sparse_status;

declare function sparse_outer_product_dense_float(M: number, N: number, nz: number, alpha: number, x: interop.Pointer | interop.Reference<number>, incx: number, y: interop.Pointer | interop.Reference<number>, indy: interop.Pointer | interop.Reference<number>, C: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<any>>): sparse_status;

declare function sparse_pack_vector_double(N: number, nz: number, x: interop.Pointer | interop.Reference<number>, incx: number, y: interop.Pointer | interop.Reference<number>, indy: interop.Pointer | interop.Reference<number>): number;

declare function sparse_pack_vector_float(N: number, nz: number, x: interop.Pointer | interop.Reference<number>, incx: number, y: interop.Pointer | interop.Reference<number>, indy: interop.Pointer | interop.Reference<number>): number;

declare function sparse_permute_cols_double(A: interop.Pointer | interop.Reference<any>, perm: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_permute_cols_float(A: interop.Pointer | interop.Reference<any>, perm: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_permute_rows_double(A: interop.Pointer | interop.Reference<any>, perm: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_permute_rows_float(A: interop.Pointer | interop.Reference<any>, perm: interop.Pointer | interop.Reference<number>): sparse_status;

declare function sparse_set_matrix_property(A: interop.Pointer | interop.Reference<any>, pname: sparse_matrix_property): sparse_status;

declare const enum sparse_status {

	SPARSE_SUCCESS = 0,

	SPARSE_ILLEGAL_PARAMETER = -1000,

	SPARSE_CANNOT_SET_PROPERTY = -1001,

	SPARSE_SYSTEM_ERROR = -1002
}

declare function sparse_unpack_vector_double(N: number, nz: number, zero: boolean, x: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>, y: interop.Pointer | interop.Reference<number>, incy: number): void;

declare function sparse_unpack_vector_float(N: number, nz: number, zero: boolean, x: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>, y: interop.Pointer | interop.Reference<number>, incy: number): void;

declare function sparse_vector_add_with_scale_dense_double(nz: number, alpha: number, x: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>, y: interop.Pointer | interop.Reference<number>, incy: number): void;

declare function sparse_vector_add_with_scale_dense_float(nz: number, alpha: number, x: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>, y: interop.Pointer | interop.Reference<number>, incy: number): void;

declare function sparse_vector_norm_double(nz: number, x: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>, norm: sparse_norm): number;

declare function sparse_vector_norm_float(nz: number, x: interop.Pointer | interop.Reference<number>, indx: interop.Pointer | interop.Reference<number>, norm: sparse_norm): number;

declare function sparse_vector_triangular_solve_dense_double(transt: CBLAS_TRANSPOSE, alpha: number, T: interop.Pointer | interop.Reference<any>, x: interop.Pointer | interop.Reference<number>, incx: number): sparse_status;

declare function sparse_vector_triangular_solve_dense_float(transt: CBLAS_TRANSPOSE, alpha: number, T: interop.Pointer | interop.Reference<any>, x: interop.Pointer | interop.Reference<number>, incx: number): sparse_status;

declare function spbcon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spbequ_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spbrfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __afb: interop.Pointer | interop.Reference<number>, __ldafb: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spbstf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spbsv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spbsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __afb: interop.Pointer | interop.Reference<number>, __ldafb: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>, __s: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spbtf2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spbtrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spbtrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spftrf_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spftri_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spftrs_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spocon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spoequ_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spoequb_(__n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sporfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<number>, __ldaf: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sposv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sposvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<number>, __ldaf: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>, __s: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spotf2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spotrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spotri_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spotrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sppcon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sppequ_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spprfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __afp: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sppsv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sppsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __afp: interop.Pointer | interop.Reference<number>, __equed: string | interop.Pointer | interop.Reference<any>, __s: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spptrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spptri_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spptrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spstf2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __piv: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __tol: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spstrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __piv: interop.Pointer | interop.Reference<number>, __rank: interop.Pointer | interop.Reference<number>, __tol: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sptcon_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spteqr_(__compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sptrfs_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __df: interop.Pointer | interop.Reference<number>, __ef: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sptsv_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sptsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __df: interop.Pointer | interop.Reference<number>, __ef: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spttrf_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function spttrs_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sptts2_(__n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function srscl_(__n: interop.Pointer | interop.Reference<number>, __sa: interop.Pointer | interop.Reference<number>, __sx: interop.Pointer | interop.Reference<number>, __incx: interop.Pointer | interop.Reference<number>): number;

declare function ssbev_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssbevd_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssbevx_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssbgst_(__vect: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ka: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __bb: interop.Pointer | interop.Reference<number>, __ldbb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssbgv_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ka: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __bb: interop.Pointer | interop.Reference<number>, __ldbb: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssbgvd_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ka: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __bb: interop.Pointer | interop.Reference<number>, __ldbb: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssbgvx_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ka: interop.Pointer | interop.Reference<number>, __kb: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __bb: interop.Pointer | interop.Reference<number>, __ldbb: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssbtrd_(__vect: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssfrk_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>): number;

declare function sspcon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sspev_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sspevd_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sspevx_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sspgst_(__itype: interop.Pointer | interop.Reference<number>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __bp: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sspgv_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __bp: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sspgvd_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __bp: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sspgvx_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __bp: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssprfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __afp: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sspsv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sspsvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __afp: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssptrd_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssptrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssptri_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssptrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sstebz_(__range: string | interop.Pointer | interop.Reference<any>, __order: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __nsplit: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __iblock: interop.Pointer | interop.Reference<number>, __isplit: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sstedc_(__compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sstegr_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sstein_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __iblock: interop.Pointer | interop.Reference<number>, __isplit: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sstemr_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __nzc: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __tryrac: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssteqr_(__compz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssterf_(__n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sstev_(__jobz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sstevd_(__jobz: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sstevr_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function sstevx_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssycon_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __anorm: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssyequb_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __scond: interop.Pointer | interop.Reference<number>, __amax: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssyev_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssyevd_(__jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssyevr_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __isuppz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssyevx_(__jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssygs2_(__itype: interop.Pointer | interop.Reference<number>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssygst_(__itype: interop.Pointer | interop.Reference<number>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssygv_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssygvd_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssygvx_(__itype: interop.Pointer | interop.Reference<number>, __jobz: string | interop.Pointer | interop.Reference<any>, __range: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __vu: interop.Pointer | interop.Reference<number>, __il: interop.Pointer | interop.Reference<number>, __iu: interop.Pointer | interop.Reference<number>, __abstol: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __w: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __ifail: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssyrfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<number>, __ldaf: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssysv_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssysvx_(__fact: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __af: interop.Pointer | interop.Reference<number>, __ldaf: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssytd2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssytf2_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssytrd_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssytrf_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssytri_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function ssytrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ipiv: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stbcon_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stbrfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stbtrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __kd: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ab: interop.Pointer | interop.Reference<number>, __ldab: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stfsm_(__transr: string | interop.Pointer | interop.Reference<any>, __side: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>): number;

declare function stftri_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stfttp_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __arf: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stfttr_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __arf: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stgevc_(__side: string | interop.Pointer | interop.Reference<any>, __howmny: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __lds: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __ldp: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stgex2_(__wantq: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __j1: interop.Pointer | interop.Reference<number>, __n1: interop.Pointer | interop.Reference<number>, __n2: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stgexc_(__wantq: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __ifst: interop.Pointer | interop.Reference<number>, __ilst: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stgsen_(__ijob: interop.Pointer | interop.Reference<number>, __wantq: interop.Pointer | interop.Reference<number>, __wantz: interop.Pointer | interop.Reference<number>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __alphar: interop.Pointer | interop.Reference<number>, __alphai: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __z__: interop.Pointer | interop.Reference<number>, __ldz: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __pl: interop.Pointer | interop.Reference<number>, __pr: interop.Pointer | interop.Reference<number>, __dif: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stgsja_(__jobu: string | interop.Pointer | interop.Reference<any>, __jobv: string | interop.Pointer | interop.Reference<any>, __jobq: string | interop.Pointer | interop.Reference<any>, __m: interop.Pointer | interop.Reference<number>, __p: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __k: interop.Pointer | interop.Reference<number>, __l: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __tola: interop.Pointer | interop.Reference<number>, __tolb: interop.Pointer | interop.Reference<number>, __alpha: interop.Pointer | interop.Reference<number>, __beta: interop.Pointer | interop.Reference<number>, __u: interop.Pointer | interop.Reference<number>, __ldu: interop.Pointer | interop.Reference<number>, __v: interop.Pointer | interop.Reference<number>, __ldv: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __ncycle: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stgsna_(__job: string | interop.Pointer | interop.Reference<any>, __howmny: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __dif: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stgsy2_(__trans: string | interop.Pointer | interop.Reference<any>, __ijob: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __ldd: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __lde: interop.Pointer | interop.Reference<number>, __f: interop.Pointer | interop.Reference<number>, __ldf: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __rdsum: interop.Pointer | interop.Reference<number>, __rdscal: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __pq: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stgsyl_(__trans: string | interop.Pointer | interop.Reference<any>, __ijob: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __d__: interop.Pointer | interop.Reference<number>, __ldd: interop.Pointer | interop.Reference<number>, __e: interop.Pointer | interop.Reference<number>, __lde: interop.Pointer | interop.Reference<number>, __f: interop.Pointer | interop.Reference<number>, __ldf: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __dif: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stpcon_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stprfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stptri_(__uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stptrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stpttf_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __arf: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stpttr_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function strcon_(__norm: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __rcond: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function strevc_(__side: string | interop.Pointer | interop.Reference<any>, __howmny: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function strexc_(__compq: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __ifst: interop.Pointer | interop.Reference<number>, __ilst: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function strrfs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __x: interop.Pointer | interop.Reference<number>, __ldx: interop.Pointer | interop.Reference<number>, __ferr: interop.Pointer | interop.Reference<number>, __berr: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function strsen_(__job: string | interop.Pointer | interop.Reference<any>, __compq: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __q: interop.Pointer | interop.Reference<number>, __ldq: interop.Pointer | interop.Reference<number>, __wr: interop.Pointer | interop.Reference<number>, __wi: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __sep: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __liwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function strsna_(__job: string | interop.Pointer | interop.Reference<any>, __howmny: string | interop.Pointer | interop.Reference<any>, __select: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __t: interop.Pointer | interop.Reference<number>, __ldt: interop.Pointer | interop.Reference<number>, __vl: interop.Pointer | interop.Reference<number>, __ldvl: interop.Pointer | interop.Reference<number>, __vr: interop.Pointer | interop.Reference<number>, __ldvr: interop.Pointer | interop.Reference<number>, __s: interop.Pointer | interop.Reference<number>, __sep: interop.Pointer | interop.Reference<number>, __mm: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __ldwork: interop.Pointer | interop.Reference<number>, __iwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function strsyl_(__trana: string | interop.Pointer | interop.Reference<any>, __tranb: string | interop.Pointer | interop.Reference<any>, __isgn: interop.Pointer | interop.Reference<number>, __m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __c__: interop.Pointer | interop.Reference<number>, __ldc: interop.Pointer | interop.Reference<number>, __scale: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function strti2_(__uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function strtri_(__uplo: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function strtrs_(__uplo: string | interop.Pointer | interop.Reference<any>, __trans: string | interop.Pointer | interop.Reference<any>, __diag: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __nrhs: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __b: interop.Pointer | interop.Reference<number>, __ldb: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function strttf_(__transr: string | interop.Pointer | interop.Reference<any>, __uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __arf: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function strttp_(__uplo: string | interop.Pointer | interop.Reference<any>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __ap: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stzrqf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function stzrzf_(__m: interop.Pointer | interop.Reference<number>, __n: interop.Pointer | interop.Reference<number>, __a: interop.Pointer | interop.Reference<number>, __lda: interop.Pointer | interop.Reference<number>, __tau: interop.Pointer | interop.Reference<number>, __work: interop.Pointer | interop.Reference<number>, __lwork: interop.Pointer | interop.Reference<number>, __info: interop.Pointer | interop.Reference<number>): number;

declare function vDSP_DCT_CreateSetup(__Previous: interop.Pointer | interop.Reference<any>, __Length: number, __Type: vDSP_DCT_Type): interop.Pointer | interop.Reference<any>;

declare function vDSP_DCT_Execute(__Setup: interop.Pointer | interop.Reference<any>, __Input: interop.Pointer | interop.Reference<number>, __Output: interop.Pointer | interop.Reference<number>): void;

declare const enum vDSP_DCT_Type {

	II = 2,

	III = 3,

	IV = 4
}

declare function vDSP_DFT_CreateSetup(__Previous: interop.Pointer | interop.Reference<any>, __Length: number): interop.Pointer | interop.Reference<any>;

declare function vDSP_DFT_DestroySetup(__Setup: interop.Pointer | interop.Reference<any>): void;

declare function vDSP_DFT_DestroySetupD(__Setup: interop.Pointer | interop.Reference<any>): void;

declare const enum vDSP_DFT_Direction {

	FORWARD = 1,

	INVERSE = -1
}

declare function vDSP_DFT_Execute(__Setup: interop.Pointer | interop.Reference<any>, __Ir: interop.Pointer | interop.Reference<number>, __Ii: interop.Pointer | interop.Reference<number>, __Or: interop.Pointer | interop.Reference<number>, __Oi: interop.Pointer | interop.Reference<number>): void;

declare function vDSP_DFT_ExecuteD(__Setup: interop.Pointer | interop.Reference<any>, __Ir: interop.Pointer | interop.Reference<number>, __Ii: interop.Pointer | interop.Reference<number>, __Or: interop.Pointer | interop.Reference<number>, __Oi: interop.Pointer | interop.Reference<number>): void;

declare function vDSP_DFT_zop(__Setup: interop.Pointer | interop.Reference<any>, __Ir: interop.Pointer | interop.Reference<number>, __Ii: interop.Pointer | interop.Reference<number>, __Is: number, __Or: interop.Pointer | interop.Reference<number>, __Oi: interop.Pointer | interop.Reference<number>, __Os: number, __Direction: vDSP_DFT_Direction): void;

declare function vDSP_DFT_zop_CreateSetup(__Previous: interop.Pointer | interop.Reference<any>, __Length: number, __Direction: vDSP_DFT_Direction): interop.Pointer | interop.Reference<any>;

declare function vDSP_DFT_zop_CreateSetupD(__Previous: interop.Pointer | interop.Reference<any>, __Length: number, __Direction: vDSP_DFT_Direction): interop.Pointer | interop.Reference<any>;

declare function vDSP_DFT_zrop_CreateSetup(__Previous: interop.Pointer | interop.Reference<any>, __Length: number, __Direction: vDSP_DFT_Direction): interop.Pointer | interop.Reference<any>;

declare function vDSP_DFT_zrop_CreateSetupD(__Previous: interop.Pointer | interop.Reference<any>, __Length: number, __Direction: vDSP_DFT_Direction): interop.Pointer | interop.Reference<any>;

declare function vDSP_FFT16_copv(__Output: interop.Pointer | interop.Reference<number>, __Input: interop.Pointer | interop.Reference<number>, __Direction: number): void;

declare function vDSP_FFT16_zopv(__Or: interop.Pointer | interop.Reference<number>, __Oi: interop.Pointer | interop.Reference<number>, __Ir: interop.Pointer | interop.Reference<number>, __Ii: interop.Pointer | interop.Reference<number>, __Direction: number): void;

declare function vDSP_FFT32_copv(__Output: interop.Pointer | interop.Reference<number>, __Input: interop.Pointer | interop.Reference<number>, __Direction: number): void;

declare function vDSP_FFT32_zopv(__Or: interop.Pointer | interop.Reference<number>, __Oi: interop.Pointer | interop.Reference<number>, __Ir: interop.Pointer | interop.Reference<number>, __Ii: interop.Pointer | interop.Reference<number>, __Direction: number): void;

declare const vDSP_HALF_WINDOW: number;

declare const vDSP_HANN_DENORM: number;

declare const vDSP_HANN_NORM: number;

declare function vDSP_biquad(__Setup: interop.Pointer | interop.Reference<any>, __Delay: interop.Pointer | interop.Reference<number>, __X: interop.Pointer | interop.Reference<number>, __IX: number, __Y: interop.Pointer | interop.Reference<number>, __IY: number, __N: number): void;

declare function vDSP_biquadD(__Setup: interop.Pointer | interop.Reference<any>, __Delay: interop.Pointer | interop.Reference<number>, __X: interop.Pointer | interop.Reference<number>, __IX: number, __Y: interop.Pointer | interop.Reference<number>, __IY: number, __N: number): void;

declare function vDSP_biquad_CreateSetup(__Coefficients: interop.Pointer | interop.Reference<number>, __M: number): interop.Pointer | interop.Reference<any>;

declare function vDSP_biquad_CreateSetupD(__Coefficients: interop.Pointer | interop.Reference<number>, __M: number): interop.Pointer | interop.Reference<any>;

declare function vDSP_biquad_DestroySetup(__setup: interop.Pointer | interop.Reference<any>): void;

declare function vDSP_biquad_DestroySetupD(__setup: interop.Pointer | interop.Reference<any>): void;

declare function vDSP_biquadm(__Setup: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<number>>, __IX: number, __Y: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<number>>, __IY: number, __N: number): void;

declare function vDSP_biquadmD(__Setup: interop.Pointer | interop.Reference<any>, __X: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<number>>, __IX: number, __Y: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<number>>, __IY: number, __N: number): void;

declare function vDSP_biquadm_CopyState(__dest: interop.Pointer | interop.Reference<any>, __src: interop.Pointer | interop.Reference<any>): void;

declare function vDSP_biquadm_CopyStateD(__dest: interop.Pointer | interop.Reference<any>, __src: interop.Pointer | interop.Reference<any>): void;

declare function vDSP_biquadm_CreateSetup(__coeffs: interop.Pointer | interop.Reference<number>, __M: number, __N: number): interop.Pointer | interop.Reference<any>;

declare function vDSP_biquadm_CreateSetupD(__coeffs: interop.Pointer | interop.Reference<number>, __M: number, __N: number): interop.Pointer | interop.Reference<any>;

declare function vDSP_biquadm_DestroySetup(__setup: interop.Pointer | interop.Reference<any>): void;

declare function vDSP_biquadm_DestroySetupD(__setup: interop.Pointer | interop.Reference<any>): void;

declare function vDSP_biquadm_ResetState(__setup: interop.Pointer | interop.Reference<any>): void;

declare function vDSP_biquadm_ResetStateD(__setup: interop.Pointer | interop.Reference<any>): void;

declare function vDSP_biquadm_SetActiveFilters(__setup: interop.Pointer | interop.Reference<any>, __filter_states: interop.Pointer | interop.Reference<boolean>): void;

declare function vDSP_biquadm_SetCoefficientsDouble(__setup: interop.Pointer | interop.Reference<any>, __coeffs: interop.Pointer | interop.Reference<number>, __start_sec: number, __start_chn: number, __nsec: number, __nchn: number): void;

declare function vDSP_biquadm_SetCoefficientsSingle(__setup: interop.Pointer | interop.Reference<any>, __coeffs: interop.Pointer | interop.Reference<number>, __start_sec: number, __start_chn: number, __nsec: number, __nchn: number): void;

declare function vDSP_biquadm_SetTargetsDouble(__setup: interop.Pointer | interop.Reference<any>, __targets: interop.Pointer | interop.Reference<number>, __interp_rate: number, __interp_threshold: number, __start_sec: number, __start_chn: number, __nsec: number, __nchn: number): void;

declare function vDSP_biquadm_SetTargetsSingle(__setup: interop.Pointer | interop.Reference<any>, __targets: interop.Pointer | interop.Reference<number>, __interp_rate: number, __interp_threshold: number, __start_sec: number, __start_chn: number, __nsec: number, __nchn: number): void;

declare function vDSP_blkman_window(__C: interop.Pointer | interop.Reference<number>, __N: number, __Flag: number): void;

declare function vDSP_blkman_windowD(__C: interop.Pointer | interop.Reference<number>, __N: number, __Flag: number): void;

declare function vDSP_conv(__A: interop.Pointer | interop.Reference<number>, __IA: number, __F: interop.Pointer | interop.Reference<number>, __IF: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __P: number): void;

declare function vDSP_convD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __F: interop.Pointer | interop.Reference<number>, __IF: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __P: number): void;

declare function vDSP_create_fftsetup(__Log2n: number, __Radix: number): interop.Pointer | interop.Reference<any>;

declare function vDSP_create_fftsetupD(__Log2n: number, __Radix: number): interop.Pointer | interop.Reference<any>;

declare function vDSP_ctoz(__C: interop.Pointer | interop.Reference<DSPComplex>, __IC: number, __Z: interop.Pointer | interop.Reference<DSPSplitComplex>, __IZ: number, __N: number): void;

declare function vDSP_ctozD(__C: interop.Pointer | interop.Reference<DSPDoubleComplex>, __IC: number, __Z: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IZ: number, __N: number): void;

declare function vDSP_deq22(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_deq22D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_desamp(__A: interop.Pointer | interop.Reference<number>, __DF: number, __F: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __N: number, __P: number): void;

declare function vDSP_desampD(__A: interop.Pointer | interop.Reference<number>, __DF: number, __F: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __N: number, __P: number): void;

declare function vDSP_destroy_fftsetup(__setup: interop.Pointer | interop.Reference<any>): void;

declare function vDSP_destroy_fftsetupD(__setup: interop.Pointer | interop.Reference<any>): void;

declare function vDSP_distancesq(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_distancesqD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_dotpr(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_dotpr2(__A0: interop.Pointer | interop.Reference<number>, __IA0: number, __A1: interop.Pointer | interop.Reference<number>, __IA1: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C0: interop.Pointer | interop.Reference<number>, __C1: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_dotpr2D(__A0: interop.Pointer | interop.Reference<number>, __IA0: number, __A1: interop.Pointer | interop.Reference<number>, __IA1: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C0: interop.Pointer | interop.Reference<number>, __C1: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_dotpr2_s1_15(__A0: interop.Pointer | interop.Reference<number>, __IA0: number, __A1: interop.Pointer | interop.Reference<number>, __IA1: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C0: interop.Pointer | interop.Reference<number>, __C1: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_dotpr2_s8_24(__A0: interop.Pointer | interop.Reference<number>, __IA0: number, __A1: interop.Pointer | interop.Reference<number>, __IA1: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C0: interop.Pointer | interop.Reference<number>, __C1: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_dotprD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_dotpr_s1_15(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_dotpr_s8_24(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_f3x3(__A: interop.Pointer | interop.Reference<number>, __NR: number, __NC: number, __F: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>): void;

declare function vDSP_f3x3D(__A: interop.Pointer | interop.Reference<number>, __NR: number, __NC: number, __F: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>): void;

declare function vDSP_f5x5(__A: interop.Pointer | interop.Reference<number>, __NR: number, __NC: number, __F: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>): void;

declare function vDSP_f5x5D(__A: interop.Pointer | interop.Reference<number>, __NR: number, __NC: number, __F: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>): void;

declare function vDSP_fft2d_zip(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC0: number, __IC1: number, __Log2N0: number, __Log2N1: number, __Direction: number): void;

declare function vDSP_fft2d_zipD(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC0: number, __IC1: number, __Log2N0: number, __Log2N1: number, __Direction: number): void;

declare function vDSP_fft2d_zipt(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC1: number, __IC0: number, __Buffer: interop.Pointer | interop.Reference<DSPSplitComplex>, __Log2N0: number, __Log2N1: number, __Direction: number): void;

declare function vDSP_fft2d_ziptD(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC0: number, __IC1: number, __Buffer: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __Log2N0: number, __Log2N1: number, __Direction: number): void;

declare function vDSP_fft2d_zop(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA0: number, __IA1: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC0: number, __IC1: number, __Log2N0: number, __Log2N1: number, __Direction: number): void;

declare function vDSP_fft2d_zopD(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA0: number, __IA1: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC0: number, __IC1: number, __Log2N0: number, __Log2N1: number, __Direction: number): void;

declare function vDSP_fft2d_zopt(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA0: number, __IA1: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC0: number, __IC1: number, __Buffer: interop.Pointer | interop.Reference<DSPSplitComplex>, __Log2N0: number, __Log2N1: number, __Direction: number): void;

declare function vDSP_fft2d_zoptD(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA0: number, __IA1: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC0: number, __IC1: number, __Buffer: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __Log2N0: number, __Log2N1: number, __Direction: number): void;

declare function vDSP_fft2d_zrip(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC0: number, __IC1: number, __Log2N0: number, __Log2N1: number, __Direction: number): void;

declare function vDSP_fft2d_zripD(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC0: number, __IC1: number, __Log2N0: number, __Log2N1: number, __flag: number): void;

declare function vDSP_fft2d_zript(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC0: number, __IC1: number, __Buffer: interop.Pointer | interop.Reference<DSPSplitComplex>, __Log2N0: number, __Log2N1: number, __Direction: number): void;

declare function vDSP_fft2d_zriptD(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC0: number, __IC1: number, __Buffer: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __Log2N0: number, __Log2N1: number, __flag: number): void;

declare function vDSP_fft2d_zrop(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA0: number, __IA1: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC0: number, __IC1: number, __Log2N0: number, __Log2N1: number, __Direction: number): void;

declare function vDSP_fft2d_zropD(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA0: number, __IA1: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC0: number, __IC1: number, __Log2N0: number, __Log2N1: number, __Direction: number): void;

declare function vDSP_fft2d_zropt(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA0: number, __IA1: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC0: number, __IC1: number, __Buffer: interop.Pointer | interop.Reference<DSPSplitComplex>, __Log2N0: number, __Log2N1: number, __Direction: number): void;

declare function vDSP_fft2d_zroptD(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA0: number, __IA1: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC0: number, __IC1: number, __Buffer: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __Log2N0: number, __Log2N1: number, __Direction: number): void;

declare function vDSP_fft3_zop(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __Log2N: number, __Direction: number): void;

declare function vDSP_fft3_zopD(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __Log2N: number, __Direction: number): void;

declare function vDSP_fft5_zop(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __Log2N: number, __Direction: number): void;

declare function vDSP_fft5_zopD(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zip(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zipD(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zipt(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __Buffer: interop.Pointer | interop.Reference<DSPSplitComplex>, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_ziptD(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __Buffer: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zop(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zopD(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zopt(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __Buffer: interop.Pointer | interop.Reference<DSPSplitComplex>, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zoptD(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __Buffer: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zrip(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zripD(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zript(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __Buffer: interop.Pointer | interop.Reference<DSPSplitComplex>, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zriptD(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __Buffer: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zrop(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zropD(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zropt(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __Buffer: interop.Pointer | interop.Reference<DSPSplitComplex>, __Log2N: number, __Direction: number): void;

declare function vDSP_fft_zroptD(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __Buffer: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __Log2N: number, __Direction: number): void;

declare function vDSP_fftm_zip(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __IM: number, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_zipD(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __IM: number, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_zipt(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __IM: number, __Buffer: interop.Pointer | interop.Reference<DSPSplitComplex>, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_ziptD(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __IM: number, __Buffer: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_zop(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __IMA: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __IMC: number, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_zopD(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __IMA: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __IMC: number, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_zopt(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __IMA: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __IMC: number, __Buffer: interop.Pointer | interop.Reference<DSPSplitComplex>, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_zoptD(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __IMA: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __IMC: number, __Buffer: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_zrip(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __IM: number, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_zripD(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __IM: number, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_zript(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __IM: number, __Buffer: interop.Pointer | interop.Reference<DSPSplitComplex>, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_zriptD(__Setup: interop.Pointer | interop.Reference<any>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __IM: number, __Buffer: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_zrop(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __IMA: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __IMC: number, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_zropD(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __IMA: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __IMC: number, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_zropt(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __IMA: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __IMC: number, __Buffer: interop.Pointer | interop.Reference<DSPSplitComplex>, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_fftm_zroptD(__Setup: interop.Pointer | interop.Reference<any>, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __IMA: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __IMC: number, __Buffer: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __Log2N: number, __M: number, __Direction: number): void;

declare function vDSP_hamm_window(__C: interop.Pointer | interop.Reference<number>, __N: number, __Flag: number): void;

declare function vDSP_hamm_windowD(__C: interop.Pointer | interop.Reference<number>, __N: number, __Flag: number): void;

declare function vDSP_hann_window(__C: interop.Pointer | interop.Reference<number>, __N: number, __Flag: number): void;

declare function vDSP_hann_windowD(__C: interop.Pointer | interop.Reference<number>, __N: number, __Flag: number): void;

declare function vDSP_imgfir(__A: interop.Pointer | interop.Reference<number>, __NR: number, __NC: number, __F: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __P: number, __Q: number): void;

declare function vDSP_imgfirD(__A: interop.Pointer | interop.Reference<number>, __NR: number, __NC: number, __F: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __P: number, __Q: number): void;

interface vDSP_int24 {
	bytes: interop.Reference<number>;
}
declare var vDSP_int24: interop.StructType<vDSP_int24>;

declare function vDSP_maxmgv(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_maxmgvD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_maxmgvi(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __I: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_maxmgviD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __I: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_maxv(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_maxvD(__A: interop.Pointer | interop.Reference<number>, __I: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_maxvi(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __I: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_maxviD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __I: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_meamgv(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_meamgvD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_meanv(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_meanvD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_measqv(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_measqvD(__A: interop.Pointer | interop.Reference<number>, __I: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_minmgv(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_minmgvD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_minmgvi(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __I: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_minmgviD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __I: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_minv(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_minvD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_minvi(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __I: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_minviD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __I: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_mmov(__A: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __M: number, __N: number, __TA: number, __TC: number): void;

declare function vDSP_mmovD(__A: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __M: number, __N: number, __TA: number, __TC: number): void;

declare function vDSP_mmul(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __M: number, __N: number, __P: number): void;

declare function vDSP_mmulD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __M: number, __N: number, __P: number): void;

declare function vDSP_mtrans(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __M: number, __N: number): void;

declare function vDSP_mtransD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __M: number, __N: number): void;

declare function vDSP_mvessq(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_mvessqD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_normalize(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __Mean: interop.Pointer | interop.Reference<number>, __StandardDeviation: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_normalizeD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __Mean: interop.Pointer | interop.Reference<number>, __StandardDeviation: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_nzcros(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: number, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_nzcrosD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: number, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_polar(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_polarD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_rect(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_rectD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_rmsqv(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_rmsqvD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_svdiv(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_svdivD(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_sve(__A: interop.Pointer | interop.Reference<number>, __I: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_sveD(__A: interop.Pointer | interop.Reference<number>, __I: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_sve_svesq(__A: interop.Pointer | interop.Reference<number>, __IA: number, __Sum: interop.Pointer | interop.Reference<number>, __SumOfSquares: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_sve_svesqD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __Sum: interop.Pointer | interop.Reference<number>, __SumOfSquares: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_svemg(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_svemgD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_svesq(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_svesqD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_svs(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_svsD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

interface vDSP_uint24 {
	bytes: interop.Reference<number>;
}
declare var vDSP_uint24: interop.StructType<vDSP_uint24>;

declare function vDSP_vaam(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __E: interop.Pointer | interop.Reference<number>, __IE: number, __N: number): void;

declare function vDSP_vaamD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __E: interop.Pointer | interop.Reference<number>, __IE: number, __N: number): void;

declare function vDSP_vabs(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vabsD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vabsi(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vadd(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vaddD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vaddi(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vaddsub(__I0: interop.Pointer | interop.Reference<number>, __I0S: number, __I1: interop.Pointer | interop.Reference<number>, __I1S: number, __O0: interop.Pointer | interop.Reference<number>, __O0S: number, __O1: interop.Pointer | interop.Reference<number>, __O1S: number, __N: number): void;

declare function vDSP_vaddsubD(__I0: interop.Pointer | interop.Reference<number>, __I0S: number, __I1: interop.Pointer | interop.Reference<number>, __I1S: number, __O0: interop.Pointer | interop.Reference<number>, __O0S: number, __O1: interop.Pointer | interop.Reference<number>, __O1S: number, __N: number): void;

declare function vDSP_vam(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vamD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __IDD: number, __N: number): void;

declare function vDSP_vasbm(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __E: interop.Pointer | interop.Reference<number>, __IE: number, __N: number): void;

declare function vDSP_vasbmD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __E: interop.Pointer | interop.Reference<number>, __IE: number, __N: number): void;

declare function vDSP_vasm(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vasmD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vavlin(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vavlinD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vclip(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vclipD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vclipc(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number, __NLow: interop.Pointer | interop.Reference<number>, __NHigh: interop.Pointer | interop.Reference<number>): void;

declare function vDSP_vclipcD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number, __NLow: interop.Pointer | interop.Reference<number>, __NHigh: interop.Pointer | interop.Reference<number>): void;

declare function vDSP_vclr(__C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vclrD(__C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vcmprs(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vcmprsD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vdbcon(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __F: number): void;

declare function vDSP_vdbconD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __F: number): void;

declare function vDSP_vdist(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vdistD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vdiv(__B: interop.Pointer | interop.Reference<number>, __IB: number, __A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vdivD(__B: interop.Pointer | interop.Reference<number>, __IB: number, __A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vdivi(__B: interop.Pointer | interop.Reference<number>, __IB: number, __A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vdpsp(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_venvlp(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_venvlpD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_veqvi(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfill(__A: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfillD(__A: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfilli(__A: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfix16(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfix16D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfix32(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfix32D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfix8(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: string | interop.Pointer | interop.Reference<any>, __IC: number, __N: number): void;

declare function vDSP_vfix8D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: string | interop.Pointer | interop.Reference<any>, __IC: number, __N: number): void;

declare function vDSP_vfixr16(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfixr16D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfixr32(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfixr32D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfixr8(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: string | interop.Pointer | interop.Reference<any>, __IC: number, __N: number): void;

declare function vDSP_vfixr8D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: string | interop.Pointer | interop.Reference<any>, __IC: number, __N: number): void;

declare function vDSP_vfixru16(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfixru16D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfixru32(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfixru32D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfixru8(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: string | interop.Pointer | interop.Reference<any>, __IC: number, __N: number): void;

declare function vDSP_vfixru8D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: string | interop.Pointer | interop.Reference<any>, __IC: number, __N: number): void;

declare function vDSP_vfixu16(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfixu16D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfixu32(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfixu32D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfixu8(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: string | interop.Pointer | interop.Reference<any>, __IC: number, __N: number): void;

declare function vDSP_vfixu8D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: string | interop.Pointer | interop.Reference<any>, __IC: number, __N: number): void;

declare function vDSP_vflt16(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vflt16D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vflt24(__A: interop.Pointer | interop.Reference<vDSP_int24>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vflt32(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vflt32D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vflt8(__A: string | interop.Pointer | interop.Reference<any>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vflt8D(__A: string | interop.Pointer | interop.Reference<any>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfltsm24(__A: interop.Pointer | interop.Reference<vDSP_int24>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfltsmu24(__A: interop.Pointer | interop.Reference<vDSP_uint24>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfltu16(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfltu16D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfltu24(__A: interop.Pointer | interop.Reference<vDSP_uint24>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfltu32(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfltu32D(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfltu8(__A: string | interop.Pointer | interop.Reference<any>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfltu8D(__A: string | interop.Pointer | interop.Reference<any>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfrac(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vfracD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vgathr(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vgathrD(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vgathra(__A: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<number>>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vgathraD(__A: interop.Pointer | interop.Reference<interop.Pointer | interop.Reference<number>>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vgen(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vgenD(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vgenp(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __M: number): void;

declare function vDSP_vgenpD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __M: number): void;

declare function vDSP_viclip(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_viclipD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vindex(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vindexD(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vintb(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vintbD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vlim(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vlimD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vlint(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __M: number): void;

declare function vDSP_vlintD(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __M: number): void;

declare function vDSP_vma(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vmaD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vmax(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vmaxD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vmaxmg(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vmaxmgD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vmin(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vminD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vminmg(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vminmgD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vmma(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __E: interop.Pointer | interop.Reference<number>, __IE: number, __N: number): void;

declare function vDSP_vmmaD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __E: interop.Pointer | interop.Reference<number>, __IE: number, __N: number): void;

declare function vDSP_vmmsb(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __E: interop.Pointer | interop.Reference<number>, __IE: number, __N: number): void;

declare function vDSP_vmmsbD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __E: interop.Pointer | interop.Reference<number>, __IE: number, __N: number): void;

declare function vDSP_vmsa(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vmsaD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vmsb(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vmsbD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vmul(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vmulD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vnabs(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vnabsD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vneg(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vnegD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vpoly(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __P: number): void;

declare function vDSP_vpolyD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __P: number): void;

declare function vDSP_vpythg(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __E: interop.Pointer | interop.Reference<number>, __IE: number, __N: number): void;

declare function vDSP_vpythgD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __E: interop.Pointer | interop.Reference<number>, __IE: number, __N: number): void;

declare function vDSP_vqint(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __M: number): void;

declare function vDSP_vqintD(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __M: number): void;

declare function vDSP_vramp(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vrampD(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vrampmul(__I: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmul2(__I0: interop.Pointer | interop.Reference<number>, __I1: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O0: interop.Pointer | interop.Reference<number>, __O1: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmul2D(__I0: interop.Pointer | interop.Reference<number>, __I1: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O0: interop.Pointer | interop.Reference<number>, __O1: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmul2_s1_15(__I0: interop.Pointer | interop.Reference<number>, __I1: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O0: interop.Pointer | interop.Reference<number>, __O1: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmul2_s8_24(__I0: interop.Pointer | interop.Reference<number>, __I1: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O0: interop.Pointer | interop.Reference<number>, __O1: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmulD(__I: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmul_s1_15(__I: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmul_s8_24(__I: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmuladd(__I: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmuladd2(__I0: interop.Pointer | interop.Reference<number>, __I1: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O0: interop.Pointer | interop.Reference<number>, __O1: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmuladd2D(__I0: interop.Pointer | interop.Reference<number>, __I1: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O0: interop.Pointer | interop.Reference<number>, __O1: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmuladd2_s1_15(__I0: interop.Pointer | interop.Reference<number>, __I1: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O0: interop.Pointer | interop.Reference<number>, __O1: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmuladd2_s8_24(__I0: interop.Pointer | interop.Reference<number>, __I1: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O0: interop.Pointer | interop.Reference<number>, __O1: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmuladdD(__I: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmuladd_s1_15(__I: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrampmuladd_s8_24(__I: interop.Pointer | interop.Reference<number>, __IS: number, __Start: interop.Pointer | interop.Reference<number>, __Step: interop.Pointer | interop.Reference<number>, __O: interop.Pointer | interop.Reference<number>, __OS: number, __N: number): void;

declare function vDSP_vrsum(__A: interop.Pointer | interop.Reference<number>, __IA: number, __S: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vrsumD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __S: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vrvrs(__C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vrvrsD(__C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsadd(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsaddD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsaddi(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsbm(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vsbmD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vsbsbm(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __E: interop.Pointer | interop.Reference<number>, __IE: number, __N: number): void;

declare function vDSP_vsbsbmD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __E: interop.Pointer | interop.Reference<number>, __IE: number, __N: number): void;

declare function vDSP_vsbsm(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vsbsmD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vsdiv(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsdivD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsdivi(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsimps(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsimpsD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsma(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vsmaD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vsmfix24(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<vDSP_int24>, __IC: number, __N: number): void;

declare function vDSP_vsmfixu24(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<vDSP_uint24>, __IC: number, __N: number): void;

declare function vDSP_vsmsa(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vsmsaD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vsmsb(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vsmsbD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vsmsma(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __E: interop.Pointer | interop.Reference<number>, __IE: number, __N: number): void;

declare function vDSP_vsmsmaD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __D: interop.Pointer | interop.Reference<number>, __E: interop.Pointer | interop.Reference<number>, __IE: number, __N: number): void;

declare function vDSP_vsmul(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsmulD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsort(__C: interop.Pointer | interop.Reference<number>, __N: number, __Order: number): void;

declare function vDSP_vsortD(__C: interop.Pointer | interop.Reference<number>, __N: number, __Order: number): void;

declare function vDSP_vsorti(__C: interop.Pointer | interop.Reference<number>, __I: interop.Pointer | interop.Reference<number>, __Temporary: interop.Pointer | interop.Reference<number>, __N: number, __Order: number): void;

declare function vDSP_vsortiD(__C: interop.Pointer | interop.Reference<number>, __I: interop.Pointer | interop.Reference<number>, __Temporary: interop.Pointer | interop.Reference<number>, __N: number, __Order: number): void;

declare function vDSP_vspdp(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsq(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsqD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vssq(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vssqD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsub(__B: interop.Pointer | interop.Reference<number>, __IB: number, __A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vsubD(__B: interop.Pointer | interop.Reference<number>, __IB: number, __A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vswap(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __N: number): void;

declare function vDSP_vswapD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __N: number): void;

declare function vDSP_vswmax(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __WindowLength: number): void;

declare function vDSP_vswmaxD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __WindowLength: number): void;

declare function vDSP_vswsum(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __P: number): void;

declare function vDSP_vswsumD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number, __P: number): void;

declare function vDSP_vtabi(__A: interop.Pointer | interop.Reference<number>, __IA: number, __S1: interop.Pointer | interop.Reference<number>, __S2: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __M: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vtabiD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __S1: interop.Pointer | interop.Reference<number>, __S2: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __M: number, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vthr(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vthrD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vthres(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vthresD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vthrsc(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vthrscD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __D: interop.Pointer | interop.Reference<number>, __ID: number, __N: number): void;

declare function vDSP_vtmerg(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vtmergD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vtrapz(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_vtrapzD(__A: interop.Pointer | interop.Reference<number>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_wiener(__L: number, __A: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __F: interop.Pointer | interop.Reference<number>, __P: interop.Pointer | interop.Reference<number>, __Flag: number, __Error: interop.Pointer | interop.Reference<number>): void;

declare function vDSP_wienerD(__L: number, __A: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<number>, __F: interop.Pointer | interop.Reference<number>, __P: interop.Pointer | interop.Reference<number>, __Flag: number, __Error: interop.Pointer | interop.Reference<number>): void;

declare function vDSP_zaspec(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_zaspecD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __C: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_zcoher(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __D: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_zcoherD(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __D: interop.Pointer | interop.Reference<number>, __N: number): void;

declare function vDSP_zconv(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __F: interop.Pointer | interop.Reference<DSPSplitComplex>, __IF: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number, __P: number): void;

declare function vDSP_zconvD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __F: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IF: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __N: number, __P: number): void;

declare function vDSP_zcspec(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __N: number): void;

declare function vDSP_zcspecD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __N: number): void;

declare function vDSP_zdotpr(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __N: number): void;

declare function vDSP_zdotprD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __N: number): void;

declare function vDSP_zidotpr(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __N: number): void;

declare function vDSP_zidotprD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __N: number): void;

declare function vDSP_zmma(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __D: interop.Pointer | interop.Reference<DSPSplitComplex>, __ID: number, __M: number, __N: number, __P: number): void;

declare function vDSP_zmmaD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __D: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __ID: number, __M: number, __N: number, __P: number): void;

declare function vDSP_zmms(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __D: interop.Pointer | interop.Reference<DSPSplitComplex>, __ID: number, __M: number, __N: number, __P: number): void;

declare function vDSP_zmmsD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __D: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __ID: number, __M: number, __N: number, __P: number): void;

declare function vDSP_zmmul(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __M: number, __N: number, __P: number): void;

declare function vDSP_zmmulD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __M: number, __N: number, __P: number): void;

declare function vDSP_zmsm(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __D: interop.Pointer | interop.Reference<DSPSplitComplex>, __ID: number, __M: number, __N: number, __P: number): void;

declare function vDSP_zmsmD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __D: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __ID: number, __M: number, __N: number, __P: number): void;

declare function vDSP_zrdesamp(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __DF: number, __F: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __N: number, __P: number): void;

declare function vDSP_zrdesampD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __DF: number, __F: interop.Pointer | interop.Reference<number>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __N: number, __P: number): void;

declare function vDSP_zrdotpr(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __N: number): void;

declare function vDSP_zrdotprD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __N: number): void;

declare function vDSP_zrvadd(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zrvaddD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zrvdiv(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zrvdivD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zrvmul(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zrvmulD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zrvsub(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zrvsubD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_ztoc(__Z: interop.Pointer | interop.Reference<DSPSplitComplex>, __IZ: number, __C: interop.Pointer | interop.Reference<DSPComplex>, __IC: number, __N: number): void;

declare function vDSP_ztocD(__Z: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IZ: number, __C: interop.Pointer | interop.Reference<DSPDoubleComplex>, __IC: number, __N: number): void;

declare function vDSP_ztrans(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __N: number): void;

declare function vDSP_ztransD(__A: interop.Pointer | interop.Reference<number>, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __N: number): void;

declare function vDSP_zvabs(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_zvabsD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_zvadd(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvaddD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvcma(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __D: interop.Pointer | interop.Reference<DSPSplitComplex>, __ID: number, __N: number): void;

declare function vDSP_zvcmaD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __D: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __ID: number, __N: number): void;

declare function vDSP_zvcmul(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvcmulD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __iC: number, __N: number): void;

declare function vDSP_zvconj(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvconjD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvdiv(__B: interop.Pointer | interop.Reference<DSPSplitComplex>, __IB: number, __A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvdivD(__B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IB: number, __A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvfill(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvfillD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvma(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __D: interop.Pointer | interop.Reference<DSPSplitComplex>, __ID: number, __N: number): void;

declare function vDSP_zvmaD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __D: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __ID: number, __N: number): void;

declare function vDSP_zvmags(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_zvmagsD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_zvmgsa(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_zvmgsaD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<number>, __IB: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_zvmmaa(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __D: interop.Pointer | interop.Reference<DSPSplitComplex>, __ID: number, __E: interop.Pointer | interop.Reference<DSPSplitComplex>, __IE: number, __F: interop.Pointer | interop.Reference<DSPSplitComplex>, __IF: number, __N: number): void;

declare function vDSP_zvmmaaD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __D: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __ID: number, __E: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IE: number, __F: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IF: number, __N: number): void;

declare function vDSP_zvmov(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvmovD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvmul(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number, __Conjugate: number): void;

declare function vDSP_zvmulD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __N: number, __Conjugate: number): void;

declare function vDSP_zvneg(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvnegD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvphas(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_zvphasD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __C: interop.Pointer | interop.Reference<number>, __IC: number, __N: number): void;

declare function vDSP_zvsma(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __D: interop.Pointer | interop.Reference<DSPSplitComplex>, __ID: number, __N: number): void;

declare function vDSP_zvsmaD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __D: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __ID: number, __N: number): void;

declare function vDSP_zvsub(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvsubD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IB: number, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvzsml(__A: interop.Pointer | interop.Reference<DSPSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPSplitComplex>, __C: interop.Pointer | interop.Reference<DSPSplitComplex>, __IC: number, __N: number): void;

declare function vDSP_zvzsmlD(__A: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IA: number, __B: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __C: interop.Pointer | interop.Reference<DSPDoubleSplitComplex>, __IC: number, __N: number): void;

declare const enum vImageARGBType {

	kvImageARGB8888 = 0,

	kvImageARGB16U = 1,

	kvImageARGB16Q12 = 2
}

declare function vImageAffineWarpCG_ARGB16S(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform_Double>, backColor: interop.Reference<number>, flags: number): number;

declare function vImageAffineWarpCG_ARGB16U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform_Double>, backColor: interop.Reference<number>, flags: number): number;

declare function vImageAffineWarpCG_ARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform_Double>, backColor: interop.Reference<number>, flags: number): number;

declare function vImageAffineWarpCG_ARGBFFFF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform_Double>, backColor: interop.Reference<number>, flags: number): number;

declare function vImageAffineWarpCG_Planar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform_Double>, backColor: number, flags: number): number;

declare function vImageAffineWarpCG_PlanarF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform_Double>, backColor: number, flags: number): number;

declare function vImageAffineWarpD_ARGB16S(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform_Double>, backColor: interop.Reference<number>, flags: number): number;

declare function vImageAffineWarpD_ARGB16U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform_Double>, backColor: interop.Reference<number>, flags: number): number;

declare function vImageAffineWarpD_ARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform_Double>, backColor: interop.Reference<number>, flags: number): number;

declare function vImageAffineWarpD_ARGBFFFF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform_Double>, backColor: interop.Reference<number>, flags: number): number;

declare function vImageAffineWarpD_Planar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform_Double>, backColor: number, flags: number): number;

declare function vImageAffineWarpD_PlanarF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform_Double>, backColor: number, flags: number): number;

declare function vImageAffineWarp_ARGB16S(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform>, backColor: interop.Reference<number>, flags: number): number;

declare function vImageAffineWarp_ARGB16U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform>, backColor: interop.Reference<number>, flags: number): number;

declare function vImageAffineWarp_ARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform>, backColor: interop.Reference<number>, flags: number): number;

declare function vImageAffineWarp_ARGBFFFF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform>, backColor: interop.Reference<number>, flags: number): number;

declare function vImageAffineWarp_Planar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform>, backColor: number, flags: number): number;

declare function vImageAffineWarp_PlanarF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, transform: interop.Pointer | interop.Reference<vImage_AffineTransform>, backColor: number, flags: number): number;

declare function vImageAlphaBlend_ARGB8888(srcTop: interop.Pointer | interop.Reference<vImage_Buffer>, srcBottom: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageAlphaBlend_ARGBFFFF(srcTop: interop.Pointer | interop.Reference<vImage_Buffer>, srcBottom: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageAlphaBlend_NonpremultipliedToPremultiplied_ARGB8888(srcTop: interop.Pointer | interop.Reference<vImage_Buffer>, srcBottom: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageAlphaBlend_NonpremultipliedToPremultiplied_ARGBFFFF(srcTop: interop.Pointer | interop.Reference<vImage_Buffer>, srcBottom: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageAlphaBlend_NonpremultipliedToPremultiplied_Planar8(srcTop: interop.Pointer | interop.Reference<vImage_Buffer>, srcTopAlpha: interop.Pointer | interop.Reference<vImage_Buffer>, srcBottom: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageAlphaBlend_NonpremultipliedToPremultiplied_PlanarF(srcTop: interop.Pointer | interop.Reference<vImage_Buffer>, srcTopAlpha: interop.Pointer | interop.Reference<vImage_Buffer>, srcBottom: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageAlphaBlend_Planar8(srcTop: interop.Pointer | interop.Reference<vImage_Buffer>, srcTopAlpha: interop.Pointer | interop.Reference<vImage_Buffer>, srcBottom: interop.Pointer | interop.Reference<vImage_Buffer>, srcBottomAlpha: interop.Pointer | interop.Reference<vImage_Buffer>, alpha: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageAlphaBlend_PlanarF(srcTop: interop.Pointer | interop.Reference<vImage_Buffer>, srcTopAlpha: interop.Pointer | interop.Reference<vImage_Buffer>, srcBottom: interop.Pointer | interop.Reference<vImage_Buffer>, srcBottomAlpha: interop.Pointer | interop.Reference<vImage_Buffer>, alpha: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageBoxConvolve_ARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, srcOffsetToROI_X: number, srcOffsetToROI_Y: number, kernel_height: number, kernel_width: number, backgroundColor: interop.Reference<number>, flags: number): number;

declare function vImageBoxConvolve_Planar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, srcOffsetToROI_X: number, srcOffsetToROI_Y: number, kernel_height: number, kernel_width: number, backgroundColor: number, flags: number): number;

declare function vImageBufferFill_ARGB16S(dest: interop.Pointer | interop.Reference<vImage_Buffer>, color: interop.Reference<number>, flags: number): number;

declare function vImageBufferFill_ARGB16U(dest: interop.Pointer | interop.Reference<vImage_Buffer>, color: interop.Reference<number>, flags: number): number;

declare function vImageBufferFill_ARGB8888(dest: interop.Pointer | interop.Reference<vImage_Buffer>, color: interop.Reference<number>, flags: number): number;

declare function vImageBufferFill_ARGBFFFF(dest: interop.Pointer | interop.Reference<vImage_Buffer>, color: interop.Reference<number>, flags: number): number;

declare function vImageBufferFill_CbCr16U(dest: interop.Pointer | interop.Reference<vImage_Buffer>, color: interop.Reference<number>, flags: number): number;

declare function vImageBufferFill_CbCr8(dest: interop.Pointer | interop.Reference<vImage_Buffer>, color: interop.Reference<number>, flags: number): number;

declare function vImageBuffer_CopyToCVPixelBuffer(buffer: interop.Pointer | interop.Reference<vImage_Buffer>, bufferFormat: interop.Pointer | interop.Reference<vImage_CGImageFormat>, cvPixelBuffer: any, cvImageFormat: any, backgroundColor: interop.Pointer | interop.Reference<number>, flags: number): number;

declare function vImageBuffer_GetSize(buf: interop.Pointer | interop.Reference<vImage_Buffer>): CGSize;

declare function vImageBuffer_Init(buf: interop.Pointer | interop.Reference<vImage_Buffer>, height: number, width: number, pixelBits: number, flags: number): number;

declare function vImageBuffer_InitForCopyFromCVPixelBuffer(buffers: interop.Pointer | interop.Reference<vImage_Buffer>, converter: any, pixelBuffer: any, flags: number): number;

declare function vImageBuffer_InitForCopyToCVPixelBuffer(buffers: interop.Pointer | interop.Reference<vImage_Buffer>, converter: any, pixelBuffer: any, flags: number): number;

declare function vImageBuffer_InitWithCGImage(buf: interop.Pointer | interop.Reference<vImage_Buffer>, format: interop.Pointer | interop.Reference<vImage_CGImageFormat>, backgroundColor: interop.Pointer | interop.Reference<number>, image: any, flags: number): number;

declare function vImageBuffer_InitWithCVPixelBuffer(buffer: interop.Pointer | interop.Reference<vImage_Buffer>, desiredFormat: interop.Pointer | interop.Reference<vImage_CGImageFormat>, cvPixelBuffer: any, cvImageFormat: any, backgroundColor: interop.Pointer | interop.Reference<number>, flags: number): number;

declare function vImageByteSwap_Planar16U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageCGImageFormat_GetComponentCount(format: interop.Pointer | interop.Reference<vImage_CGImageFormat>): number;

declare function vImageCGImageFormat_IsEqual(f1: interop.Pointer | interop.Reference<vImage_CGImageFormat>, f2: interop.Pointer | interop.Reference<vImage_CGImageFormat>): boolean;

declare function vImageCVImageFormat_Copy(format: any): interop.Unmanaged<any>;

declare function vImageCVImageFormat_CopyChannelDescription(format: any, desc: interop.Pointer | interop.Reference<vImageChannelDescription>, type: number): number;

declare function vImageCVImageFormat_CopyConversionMatrix(format: any, matrix: interop.Pointer | interop.Reference<any>, inType: number): number;

declare function vImageCVImageFormat_Create(imageFormatType: number, matrix: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCrMatrix>, cvImageBufferChromaLocation: string, baseColorspace: any, alphaIsOneHint: number): interop.Unmanaged<any>;

declare function vImageCVImageFormat_CreateWithCVPixelBuffer(buffer: any): interop.Unmanaged<any>;

declare function vImageCVImageFormat_GetAlphaHint(format: any): number;

declare function vImageCVImageFormat_GetChannelCount(format: any): number;

declare function vImageCVImageFormat_GetChannelDescription(format: any, type: number): interop.Pointer | interop.Reference<vImageChannelDescription>;

declare function vImageCVImageFormat_GetChannelNames(format: any): interop.Pointer | interop.Reference<number>;

declare function vImageCVImageFormat_GetChromaSiting(format: any): interop.Unmanaged<string>;

declare function vImageCVImageFormat_GetColorSpace(format: any): interop.Unmanaged<any>;

declare function vImageCVImageFormat_GetConversionMatrix(format: any, outType: interop.Pointer | interop.Reference<number>): interop.Pointer | interop.Reference<any>;

declare function vImageCVImageFormat_GetFormatCode(format: any): number;

declare function vImageCVImageFormat_GetUserData(format: any): interop.Pointer | interop.Reference<any>;

declare function vImageCVImageFormat_Release(fmt: any): void;

declare function vImageCVImageFormat_Retain(fmt: any): void;

declare function vImageCVImageFormat_SetAlphaHint(format: any, alphaIsOne: number): number;

declare function vImageCVImageFormat_SetChromaSiting(format: any, siting: string): number;

declare function vImageCVImageFormat_SetColorSpace(format: any, colorspace: any): number;

declare function vImageCVImageFormat_SetUserData(format: any, userData: interop.Pointer | interop.Reference<any>, userDataReleaseCallback: interop.FunctionReference<(p1: any, p2: interop.Pointer | interop.Reference<any>) => void>): number;

interface vImageChannelDescription {
	min: number;
	zero: number;
	full: number;
	max: number;
}
declare var vImageChannelDescription: interop.StructType<vImageChannelDescription>;

declare function vImageClipToAlpha_ARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageClipToAlpha_ARGBFFFF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageClipToAlpha_Planar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, alpha: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageClipToAlpha_PlanarF(src: interop.Pointer | interop.Reference<vImage_Buffer>, alpha: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageClipToAlpha_RGBA8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageClipToAlpha_RGBAFFFF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageClip_PlanarF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, maxFloat: number, minFloat: number, flags: number): number;

declare function vImageContrastStretch_ARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageContrastStretch_ARGBFFFF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, histogram_entries: number, minVal: number, maxVal: number, flags: number): number;

declare function vImageContrastStretch_Planar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageContrastStretch_PlanarF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, histogram_entries: number, minVal: number, maxVal: number, flags: number): number;

declare function vImageConvert_12UTo16U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_16Fto16Q12(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_16Fto16U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_16Q12to16F(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_16Q12to16U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_16Q12to8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_16Q12toF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_16SToF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, offset: number, scale: number, flags: number): number;

declare function vImageConvert_16UTo12U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_16UToF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, offset: number, scale: number, flags: number): number;

declare function vImageConvert_16UToPlanar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_16Uto16F(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_16Uto16Q12(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_420Yp8_Cb8_Cr8ToARGB8888(srcYp: interop.Pointer | interop.Reference<vImage_Buffer>, srcCb: interop.Pointer | interop.Reference<vImage_Buffer>, srcCr: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, alpha: number, flags: number): number;

declare function vImageConvert_420Yp8_CbCr8ToARGB8888(srcYp: interop.Pointer | interop.Reference<vImage_Buffer>, srcCbCr: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, alpha: number, flags: number): number;

declare function vImageConvert_422CbYpCrYp16ToARGB16U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, alpha: number, flags: number): number;

declare function vImageConvert_422CbYpCrYp16ToARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, alpha: number, flags: number): number;

declare function vImageConvert_422CbYpCrYp8ToARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, alpha: number, flags: number): number;

declare function vImageConvert_422CbYpCrYp8_AA8ToARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, srcA: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_422CrYpCbYpCbYpCbYpCrYpCrYp10ToARGB16Q12(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, alpha: number, flags: number): number;

declare function vImageConvert_422CrYpCbYpCbYpCbYpCrYpCrYp10ToARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, alpha: number, flags: number): number;

declare function vImageConvert_422YpCbYpCr8ToARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, alpha: number, flags: number): number;

declare function vImageConvert_444AYpCbCr16ToARGB16U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_444AYpCbCr16ToARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_444AYpCbCr8ToARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_444CbYpCrA8ToARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_444CrYpCb10ToARGB16Q12(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, alpha: number, flags: number): number;

declare function vImageConvert_444CrYpCb10ToARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, alpha: number, flags: number): number;

declare function vImageConvert_444CrYpCb8ToARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_YpCbCrToARGB>, permuteMap: interop.Reference<number>, alpha: number, flags: number): number;

declare function vImageConvert_8to16Q12(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_ARGB1555toARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_ARGB1555toPlanar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, destA: interop.Pointer | interop.Reference<vImage_Buffer>, destR: interop.Pointer | interop.Reference<vImage_Buffer>, destG: interop.Pointer | interop.Reference<vImage_Buffer>, destB: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_ARGB1555toRGB565(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_ARGB16Q12To422CrYpCbYpCbYpCbYpCrYpCrYp10(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB16Q12To444CrYpCb10(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB16Q12ToARGB2101010(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, RGB101010Min: number, RGB101010Max: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB16Q12ToRGBA1010102(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, RGB101010Min: number, RGB101010Max: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB16Q12ToXRGB2101010(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, RGB101010Min: number, RGB101010Max: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB16UTo422CbYpCrYp16(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB16UTo444AYpCbCr16(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB16UToARGB2101010(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB16UToARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, permuteMap: interop.Reference<number>, copyMask: number, backgroundColor: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB16UToRGBA1010102(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB16UToXRGB2101010(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB16UtoARGB8888_dithered(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, dither: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB16UtoPlanar16U(argbSrc: interop.Pointer | interop.Reference<vImage_Buffer>, aDest: interop.Pointer | interop.Reference<vImage_Buffer>, rDest: interop.Pointer | interop.Reference<vImage_Buffer>, gDest: interop.Pointer | interop.Reference<vImage_Buffer>, bDest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_ARGB16UtoRGB16U(argbSrc: interop.Pointer | interop.Reference<vImage_Buffer>, rgbDest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_ARGB2101010ToARGB16F(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB2101010ToARGB16Q12(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB2101010ToARGB16U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB2101010ToARGB8888(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB2101010ToARGBFFFF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888To420Yp8_Cb8_Cr8(src: interop.Pointer | interop.Reference<vImage_Buffer>, destYp: interop.Pointer | interop.Reference<vImage_Buffer>, destCb: interop.Pointer | interop.Reference<vImage_Buffer>, destCr: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888To420Yp8_CbCr8(src: interop.Pointer | interop.Reference<vImage_Buffer>, destYp: interop.Pointer | interop.Reference<vImage_Buffer>, destCbCr: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888To422CbYpCrYp16(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888To422CbYpCrYp8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888To422CbYpCrYp8_AA8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, destA: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888To422CrYpCbYpCbYpCbYpCrYpCrYp10(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888To422YpCbYpCr8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888To444AYpCbCr16(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888To444AYpCbCr8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888To444CbYpCrA8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888To444CrYpCb10(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888To444CrYpCb8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, info: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888ToARGB16U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, permuteMap: interop.Reference<number>, copyMask: number, backgroundColor: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888ToARGB2101010(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888ToRGB16U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, permuteMap: interop.Reference<number>, copyMask: number, backgroundColor: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888ToRGBA1010102(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888ToXRGB2101010(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888toARGB1555(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_ARGB8888toARGB1555_dithered(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, dither: number, flags: number): number;

declare function vImageConvert_ARGB8888toPlanar16Q12(src: interop.Pointer | interop.Reference<vImage_Buffer>, alpha: interop.Pointer | interop.Reference<vImage_Buffer>, red: interop.Pointer | interop.Reference<vImage_Buffer>, green: interop.Pointer | interop.Reference<vImage_Buffer>, blue: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_ARGB8888toPlanar8(srcARGB: interop.Pointer | interop.Reference<vImage_Buffer>, destA: interop.Pointer | interop.Reference<vImage_Buffer>, destR: interop.Pointer | interop.Reference<vImage_Buffer>, destG: interop.Pointer | interop.Reference<vImage_Buffer>, destB: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_ARGB8888toPlanarF(src: interop.Pointer | interop.Reference<vImage_Buffer>, alpha: interop.Pointer | interop.Reference<vImage_Buffer>, red: interop.Pointer | interop.Reference<vImage_Buffer>, green: interop.Pointer | interop.Reference<vImage_Buffer>, blue: interop.Pointer | interop.Reference<vImage_Buffer>, maxFloat: interop.Reference<number>, minFloat: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGB8888toRGB565(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_ARGB8888toRGB565_dithered(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, dither: number, flags: number): number;

declare function vImageConvert_ARGB8888toRGB888(p1: interop.Pointer | interop.Reference<vImage_Buffer>, p2: interop.Pointer | interop.Reference<vImage_Buffer>, p3: number): number;

declare function vImageConvert_ARGBFFFFToARGB2101010(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGBFFFFToXRGB2101010(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, RGB101010RangeMin: number, RGB101010RangeMax: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGBFFFFtoARGB8888_dithered(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, maxFloat: interop.Reference<number>, minFloat: interop.Reference<number>, dither: number, permuteMap: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGBFFFFtoPlanar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, alpha: interop.Pointer | interop.Reference<vImage_Buffer>, red: interop.Pointer | interop.Reference<vImage_Buffer>, green: interop.Pointer | interop.Reference<vImage_Buffer>, blue: interop.Pointer | interop.Reference<vImage_Buffer>, maxFloat: interop.Reference<number>, minFloat: interop.Reference<number>, flags: number): number;

declare function vImageConvert_ARGBFFFFtoPlanarF(srcARGB: interop.Pointer | interop.Reference<vImage_Buffer>, destA: interop.Pointer | interop.Reference<vImage_Buffer>, destR: interop.Pointer | interop.Reference<vImage_Buffer>, destG: interop.Pointer | interop.Reference<vImage_Buffer>, destB: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_ARGBFFFFtoRGBFFF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_ARGBToYpCbCr_GenerateConversion(matrix: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCrMatrix>, pixelRange: interop.Pointer | interop.Reference<vImage_YpCbCrPixelRange>, outInfo: interop.Pointer | interop.Reference<vImage_ARGBToYpCbCr>, inARGBType: vImageARGBType, outYpCbCrType: vImageYpCbCrType, flags: number): number;

declare function vImageConvert_AnyToAny(converter: any, srcs: interop.Pointer | interop.Reference<vImage_Buffer>, dests: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, flags: number): number;

declare function vImageConvert_BGRA16UtoRGB16U(bgraSrc: interop.Pointer | interop.Reference<vImage_Buffer>, rgbDest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_BGRA8888toRGB565(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_BGRA8888toRGB565_dithered(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, tempBuffer: interop.Pointer | interop.Reference<any>, dither: number, flags: number): number;

declare function vImageConvert_BGRA8888toRGB888(p1: interop.Pointer | interop.Reference<vImage_Buffer>, p2: interop.Pointer | interop.Reference<vImage_Buffer>, p3: number): number;

declare function vImageConvert_BGRAFFFFtoRGBFFF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_BGRX8888ToPlanar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, blue: interop.Pointer | interop.Reference<vImage_Buffer>, green: interop.Pointer | interop.Reference<vImage_Buffer>, red: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_BGRXFFFFToPlanarF(src: interop.Pointer | interop.Reference<vImage_Buffer>, blue: interop.Pointer | interop.Reference<vImage_Buffer>, green: interop.Pointer | interop.Reference<vImage_Buffer>, red: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_ChunkyToPlanar8(srcChannels: interop.Reference<interop.Pointer | interop.Reference<any>>, destPlanarBuffers: interop.Reference<interop.Pointer | interop.Reference<vImage_Buffer>>, channelCount: number, srcStrideBytes: number, srcWidth: number, srcHeight: number, srcRowBytes: number, flags: number): number;

declare function vImageConvert_ChunkyToPlanarF(srcChannels: interop.Reference<interop.Pointer | interop.Reference<any>>, destPlanarBuffers: interop.Reference<interop.Pointer | interop.Reference<vImage_Buffer>>, channelCount: number, srcStrideBytes: number, srcWidth: number, srcHeight: number, srcRowBytes: number, flags: number): number;

declare function vImageConvert_FTo16S(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, offset: number, scale: number, flags: number): number;

declare function vImageConvert_FTo16U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, offset: number, scale: number, flags: number): number;

declare function vImageConvert_Fto16Q12(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_Indexed1toPlanar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, colors: interop.Reference<number>, flags: number): number;

declare function vImageConvert_Indexed2toPlanar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, colors: interop.Reference<number>, flags: number): number;

declare function vImageConvert_Indexed4toPlanar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, colors: interop.Reference<number>, flags: number): number;

declare function vImageConvert_Planar16FtoPlanar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_Planar16FtoPlanarF(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_Planar16Q12toARGB16F(alpha: interop.Pointer | interop.Reference<vImage_Buffer>, red: interop.Pointer | interop.Reference<vImage_Buffer>, green: interop.Pointer | interop.Reference<vImage_Buffer>, blue: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_Planar16Q12toARGB8888(alpha: interop.Pointer | interop.Reference<vImage_Buffer>, red: interop.Pointer | interop.Reference<vImage_Buffer>, green: interop.Pointer | interop.Reference<vImage_Buffer>, blue: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_Planar16Q12toRGB16F(red: interop.Pointer | interop.Reference<vImage_Buffer>, green: interop.Pointer | interop.Reference<vImage_Buffer>, blue: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_Planar16Q12toRGB888(red: interop.Pointer | interop.Reference<vImage_Buffer>, green: interop.Pointer | interop.Reference<vImage_Buffer>, blue: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_Planar16UtoARGB16U(aSrc: interop.Pointer | interop.Reference<vImage_Buffer>, rSrc: interop.Pointer | interop.Reference<vImage_Buffer>, gSrc: interop.Pointer | interop.Reference<vImage_Buffer>, bSrc: interop.Pointer | interop.Reference<vImage_Buffer>, argbDest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_Planar16UtoPlanar8_dithered(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, dither: number, flags: number): number;

declare function vImageConvert_Planar16UtoRGB16U(rSrc: interop.Pointer | interop.Reference<vImage_Buffer>, gSrc: interop.Pointer | interop.Reference<vImage_Buffer>, bSrc: interop.Pointer | interop.Reference<vImage_Buffer>, rgbDest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_Planar1toPlanar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_Planar2toPlanar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_Planar4toPlanar8(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_Planar8To16U(src: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_Planar8ToARGBFFFF(alpha: interop.Pointer | interop.Reference<vImage_Buffer>, red: interop.Pointer | interop.Reference<vImage_Buffer>, green: interop.Pointer | interop.Reference<vImage_Buffer>, blue: interop.Pointer | interop.Reference<vImage_Buffer>, dest: interop.Pointer | interop.Reference<vImage_Buffer>, maxFloat: interop.Reference<number>, minFloat: interop.Reference<number>, flags: number): number;

declare function vImageConvert_Planar8ToBGRX8888(blue: interop.Pointer | interop.Reference<vImage_Buffer>, green: interop.Pointer | interop.Reference<vImage_Buffer>, red: interop.Pointer | interop.Reference<vImage_Buffer>, alpha: number, dest: interop.Pointer | interop.Reference<vImage_Buffer>, flags: number): number;

declare function vImageConvert_Planar8ToBGRXFFFF(blue: interop.Pointer | interop.Reference<vImage_Buffer>, green: interop.Pointer | interop.Reference<vImage_Buffer>, red: interop.Pointer | interop.Reference<vImage_Buffer>, alpha: number, dest: interop.Pointer | interop.Reference<vImage_Buffer>, maxFloat: interop.Reference<number>, minFloat: interop.Reference<number>, flags: number): number;

declare function vImageConvert_Planar8ToXRGB8888(alpha: number, red: interop.Pointer | interop.Reference<vImage_Buffer>, green: interop.Pointer | interop.Reference<vImage_Buf