/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwhisk.common;

import akka.event.Logging;
import akka.event.Logging$;
import akka.http.scaladsl.model.headers.RawHeader;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.apache.openwhisk.common.LogMarker;
import org.apache.openwhisk.common.LogMarker$;
import org.apache.openwhisk.common.LogMarkerToken;
import org.apache.openwhisk.common.Logging;
import org.apache.openwhisk.common.MetricEmitter$;
import org.apache.openwhisk.common.StartMarker;
import org.apache.openwhisk.common.TransactionGeneratorConfig;
import org.apache.openwhisk.common.TransactionId;
import org.apache.openwhisk.common.TransactionId$;
import org.apache.openwhisk.common.TransactionMetadata;
import org.apache.openwhisk.common.tracing.WhiskTracerProvider$;
import org.apache.openwhisk.core.ConfigKeys$;
import pureconfig.ConfigReader;
import pureconfig.ConfigReader$;
import pureconfig.Derivation;
import pureconfig.DerivedReaders1;
import pureconfig.ProductHint$;
import pureconfig.package$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Symbol;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;
import scala.util.Try$;
import shapeless.;
import shapeless.Default;
import shapeless.Default$;
import shapeless.DefaultSymbolicLabelling;
import shapeless.Generic;
import shapeless.HList;
import shapeless.HNil;
import shapeless.HNil$;
import shapeless.LabelledGeneric$;
import shapeless.Lazy$;
import shapeless.Witness$;
import shapeless.ops.hlist;
import spray.json.JsArray;
import spray.json.JsArray$;
import spray.json.JsBoolean;
import spray.json.JsBoolean$;
import spray.json.JsNumber;
import spray.json.JsNumber$;
import spray.json.JsString;
import spray.json.JsValue;
import spray.json.RootJsonFormat;

public final class TransactionId$
implements scala.Serializable {
    public static TransactionId$ MODULE$;
    private final boolean metricsKamon;
    private final boolean metricsKamonTags;
    private final boolean metricsLog;
    private final TransactionGeneratorConfig generatorConfig;
    private final String systemPrefix;
    private final TransactionMetadata unknown;
    private final TransactionMetadata testing;
    private final TransactionMetadata invoker;
    private final TransactionMetadata invokerWarmup;
    private final TransactionMetadata invokerNanny;
    private final TransactionMetadata dispatcher;
    private final TransactionMetadata loadbalancer;
    private final TransactionMetadata invokerHealth;
    private final TransactionMetadata controller;
    private final TransactionMetadata dbBatcher;
    private final RootJsonFormat<TransactionMetadata> serdes;

    static {
        new TransactionId$();
    }

    public boolean metricsKamon() {
        return this.metricsKamon;
    }

    public boolean metricsKamonTags() {
        return this.metricsKamonTags;
    }

    public boolean metricsLog() {
        return this.metricsLog;
    }

    public TransactionGeneratorConfig generatorConfig() {
        return this.generatorConfig;
    }

    public String systemPrefix() {
        return this.systemPrefix;
    }

    public TransactionMetadata unknown() {
        return this.unknown;
    }

    public TransactionMetadata testing() {
        return this.testing;
    }

    public TransactionMetadata invoker() {
        return this.invoker;
    }

    public TransactionMetadata invokerWarmup() {
        return this.invokerWarmup;
    }

    public TransactionMetadata invokerNanny() {
        return this.invokerNanny;
    }

    public TransactionMetadata dispatcher() {
        return this.dispatcher;
    }

    public TransactionMetadata loadbalancer() {
        return this.loadbalancer;
    }

    public TransactionMetadata invokerHealth() {
        return this.invokerHealth;
    }

    public TransactionMetadata controller() {
        return this.controller;
    }

    public TransactionMetadata dbBatcher() {
        return this.dbBatcher;
    }

    public TransactionMetadata apply(String tid, boolean extraLogging) {
        Instant now = Instant.now(Clock.systemUTC());
        return new TransactionMetadata(tid, now, extraLogging);
    }

    public boolean apply$default$2() {
        return false;
    }

    public RootJsonFormat<TransactionMetadata> serdes() {
        return this.serdes;
    }

    public TransactionMetadata apply(TransactionMetadata meta) {
        return meta;
    }

    public Option<TransactionMetadata> unapply(TransactionMetadata x$0) {
        return new TransactionId(x$0) == null ? None$.MODULE$ : new Some((Object)x$0);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final String id$extension(TransactionMetadata $this) {
        return $this.id();
    }

    public final String toString$extension(TransactionMetadata $this) {
        return new StringBuilder(5).append("#tid_").append($this.id()).toString();
    }

    public final RawHeader toHeader$extension(TransactionMetadata $this) {
        return new RawHeader(this.generatorConfig().header(), $this.id());
    }

    public final void mark$extension(TransactionMetadata $this, Object from, LogMarkerToken marker, Function0<String> message, int logLevel, Logging logging) {
        if (this.metricsLog()) {
            logging.emit(Logging$.MODULE$.InfoLevel(), $this, from, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.createMessageWithMarker$extension($this, (String)message.apply(), new LogMarker(marker, MODULE$.deltaToStart$extension($this), LogMarker$.MODULE$.apply$default$3())));
        } else {
            logging.emit(logLevel, $this, from, message);
        }
        MetricEmitter$.MODULE$.emitCounterMetric(marker, MetricEmitter$.MODULE$.emitCounterMetric$default$2());
    }

    public final String mark$default$3$extension(TransactionMetadata $this) {
        return "";
    }

    public final int mark$default$4$extension(TransactionMetadata $this) {
        return Logging$.MODULE$.DebugLevel();
    }

    public final StartMarker started$extension(TransactionMetadata $this, Object from, LogMarkerToken marker, Function0<String> message, int logLevel, Logging logging) {
        if (this.metricsLog()) {
            logging.emit(Logging$.MODULE$.InfoLevel(), $this, from, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.createMessageWithMarker$extension($this, (String)message.apply(), new LogMarker(marker, MODULE$.deltaToStart$extension($this), LogMarker$.MODULE$.apply$default$3())));
        } else {
            logging.emit(logLevel, $this, from, message);
        }
        MetricEmitter$.MODULE$.emitCounterMetric(marker, MetricEmitter$.MODULE$.emitCounterMetric$default$2());
        WhiskTracerProvider$.MODULE$.tracer().startSpan(marker, $this);
        return new StartMarker(Instant.now(), marker);
    }

    public final String started$default$3$extension(TransactionMetadata $this) {
        return "";
    }

    public final int started$default$4$extension(TransactionMetadata $this) {
        return Logging$.MODULE$.DebugLevel();
    }

    public final void finished$extension(TransactionMetadata $this, Object from, StartMarker startMarker, Function0<String> message, int logLevel, Instant endTime, Logging logging) {
        LogMarkerToken endMarker = startMarker.startMarker().asFinish();
        long deltaToEnd = this.deltaToMarker$extension($this, startMarker, endTime);
        if (this.metricsLog()) {
            logging.emit(Logging$.MODULE$.InfoLevel(), $this, from, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.createMessageWithMarker$extension($this, Logging.LogLevel$.MODULE$.$less$eq$extension(logLevel, Logging$.MODULE$.InfoLevel()) ? (String)message.apply() : "", new LogMarker(endMarker, MODULE$.deltaToStart$extension($this), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)deltaToEnd)))));
        } else {
            logging.emit(logLevel, $this, from, message);
        }
        MetricEmitter$.MODULE$.emitHistogramMetric(endMarker, deltaToEnd);
        WhiskTracerProvider$.MODULE$.tracer().finishSpan($this);
    }

    public final String finished$default$3$extension(TransactionMetadata $this) {
        return "";
    }

    public final int finished$default$4$extension(TransactionMetadata $this) {
        return Logging$.MODULE$.DebugLevel();
    }

    public final Instant finished$default$5$extension(TransactionMetadata $this) {
        return Instant.now(Clock.systemUTC());
    }

    public final void failed$extension(TransactionMetadata $this, Object from, StartMarker startMarker, Function0<String> message, int logLevel, Logging logging) {
        LogMarkerToken endMarker = startMarker.startMarker().asError();
        long deltaToEnd = this.deltaToMarker$extension($this, startMarker, this.deltaToMarker$default$2$extension($this));
        if (this.metricsLog()) {
            logging.emit(logLevel, $this, from, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.createMessageWithMarker$extension($this, (String)message.apply(), new LogMarker(endMarker, MODULE$.deltaToStart$extension($this), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)deltaToEnd)))));
        } else {
            logging.emit(logLevel, $this, from, message);
        }
        MetricEmitter$.MODULE$.emitHistogramMetric(endMarker, deltaToEnd);
        MetricEmitter$.MODULE$.emitCounterMetric(endMarker, MetricEmitter$.MODULE$.emitCounterMetric$default$2());
        WhiskTracerProvider$.MODULE$.tracer().error($this, message);
    }

    public final String failed$default$3$extension(TransactionMetadata $this) {
        return "";
    }

    public final int failed$default$4$extension(TransactionMetadata $this) {
        return Logging$.MODULE$.WarningLevel();
    }

    public final long deltaToStart$extension(TransactionMetadata $this) {
        return Duration.between($this.start(), Instant.now(Clock.systemUTC())).toMillis();
    }

    public final long deltaToMarker$extension(TransactionMetadata $this, StartMarker startMarker, Instant endTime) {
        return Duration.between(startMarker.start(), endTime).toMillis();
    }

    public final Instant deltaToMarker$default$2$extension(TransactionMetadata $this) {
        return Instant.now(Clock.systemUTC());
    }

    public final String createMessageWithMarker$extension(TransactionMetadata $this, String message, LogMarker marker) {
        return new StringBuilder(1).append(message).append(" ").append(marker).toString();
    }

    public final TransactionMetadata copy$extension(TransactionMetadata $this, TransactionMetadata meta) {
        return meta;
    }

    public final TransactionMetadata copy$default$1$extension(TransactionMetadata $this) {
        return $this;
    }

    public final String productPrefix$extension(TransactionMetadata $this) {
        return "TransactionId";
    }

    public final int productArity$extension(TransactionMetadata $this) {
        return 1;
    }

    public final Object productElement$extension(TransactionMetadata $this, int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return $this;
    }

    public final Iterator<Object> productIterator$extension(TransactionMetadata $this) {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)new TransactionId($this));
    }

    public final boolean canEqual$extension(TransactionMetadata $this, Object x$1) {
        return x$1 instanceof TransactionMetadata;
    }

    public final int hashCode$extension(TransactionMetadata $this) {
        return $this.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals$extension(TransactionMetadata $this, Object x$1) {
        Object object = x$1;
        if (!(object instanceof TransactionId)) return false;
        boolean bl = true;
        if (!bl) return false;
        TransactionMetadata transactionMetadata = x$1 == null ? null : ((TransactionId)x$1).meta();
        TransactionMetadata transactionMetadata2 = $this;
        TransactionMetadata transactionMetadata3 = transactionMetadata;
        if (transactionMetadata2 != null) {
            if (!((Object)transactionMetadata2).equals(transactionMetadata3)) return false;
            return true;
        }
        if (transactionMetadata3 == null) return true;
        return false;
    }

    private TransactionId$() {
        MODULE$ = this;
        this.metricsKamon = new StringOps(Predef$.MODULE$.augmentString((String)scala.sys.package$.MODULE$.env().get((Object)"METRICS_KAMON").getOrElse((Function0 & Serializable & scala.Serializable)() -> "False"))).toBoolean();
        this.metricsKamonTags = new StringOps(Predef$.MODULE$.augmentString((String)scala.sys.package$.MODULE$.env().get((Object)"METRICS_KAMON_TAGS").getOrElse((Function0 & Serializable & scala.Serializable)() -> "False"))).toBoolean();
        this.metricsLog = new StringOps(Predef$.MODULE$.augmentString((String)scala.sys.package$.MODULE$.env().get((Object)"METRICS_LOG").getOrElse((Function0 & Serializable & scala.Serializable)() -> "True"))).toBoolean();
        public final class Org_apache_openwhisk_common_TransactionId$anon$deriveProductInstance$macro$14$1
        implements scala.Serializable {
            private ConfigReader<String> inst$macro$12;
            private DerivedReaders1.WrappedDefaultValue<TransactionGeneratorConfig, HNil, HNil> inst$macro$13;
            private DerivedReaders1.WrappedDefaultValue<TransactionGeneratorConfig, .colon.colon<String, HNil>, .colon.colon<Option<String>, HNil>> inst$macro$11;
            private volatile byte bitmap$0;

            private ConfigReader<String> inst$macro$12$lzycompute() {
                Org_apache_openwhisk_common_TransactionId$anon$deriveProductInstance$macro$14$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.inst$macro$12 = ConfigReader$.MODULE$.stringConfigReader();
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                return this.inst$macro$12;
            }

            public ConfigReader<String> inst$macro$12() {
                return (byte)(this.bitmap$0 & 1) == 0 ? this.inst$macro$12$lzycompute() : this.inst$macro$12;
            }

            private DerivedReaders1.WrappedDefaultValue<TransactionGeneratorConfig, HNil, HNil> inst$macro$13$lzycompute() {
                Org_apache_openwhisk_common_TransactionId$anon$deriveProductInstance$macro$14$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        this.inst$macro$13 = ConfigReader$.MODULE$.labelledHNilConfigReader(ProductHint$.MODULE$.default());
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.inst$macro$13;
            }

            public DerivedReaders1.WrappedDefaultValue<TransactionGeneratorConfig, HNil, HNil> inst$macro$13() {
                return (byte)(this.bitmap$0 & 2) == 0 ? this.inst$macro$13$lzycompute() : this.inst$macro$13;
            }

            private DerivedReaders1.WrappedDefaultValue<TransactionGeneratorConfig, .colon.colon<String, HNil>, .colon.colon<Option<String>, HNil>> inst$macro$11$lzycompute() {
                Org_apache_openwhisk_common_TransactionId$anon$deriveProductInstance$macro$14$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 4) == 0) {
                        this.inst$macro$11 = ConfigReader$.MODULE$.labelledHConsConfigReader(Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "header")), (Derivation)new Derivation.Successful(Predef$.MODULE$.implicitly((Object)Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.inst$macro$12()))), Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.inst$macro$13()), ProductHint$.MODULE$.default());
                        this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                    }
                }
                return this.inst$macro$11;
            }

            public DerivedReaders1.WrappedDefaultValue<TransactionGeneratorConfig, .colon.colon<String, HNil>, .colon.colon<Option<String>, HNil>> inst$macro$11() {
                return (byte)(this.bitmap$0 & 4) == 0 ? this.inst$macro$11$lzycompute() : this.inst$macro$11;
            }

            public Org_apache_openwhisk_common_TransactionId$anon$deriveProductInstance$macro$14$1() {
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$11$1(org.apache.openwhisk.common.TransactionId$anon$deriveProductInstance$macro$14$1 ), $anonfun$inst$macro$11$2(org.apache.openwhisk.common.TransactionId$anon$deriveProductInstance$macro$14$1 )}, serializedLambda);
            }
        }
        DerivedReaders1.WrappedDefaultValue<TransactionGeneratorConfig, .colon.colon<String, HNil>, .colon.colon<Option<String>, HNil>> inst$macro$15 = new Org_apache_openwhisk_common_TransactionId$anon$deriveProductInstance$macro$14$1().inst$macro$11();
        public final class Org_apache_openwhisk_common_TransactionId$anon$macro$8$1
        implements Generic<TransactionGeneratorConfig> {
            public .colon.colon<String, HNil> to(TransactionGeneratorConfig p) {
                TransactionGeneratorConfig transactionGeneratorConfig = p;
                if (transactionGeneratorConfig == null) {
                    throw new MatchError((Object)transactionGeneratorConfig);
                }
                String pat$macro$7 = transactionGeneratorConfig.header();
                .colon.colon colon2 = new .colon.colon((Object)pat$macro$7, (HList)HNil$.MODULE$);
                return colon2;
            }

            public TransactionGeneratorConfig from(.colon.colon<String, HNil> p) {
                String pat$macro$7;
                block3: {
                    .colon.colon<String, HNil> colon2;
                    block2: {
                        colon2 = p;
                        if (colon2 == null) break block2;
                        pat$macro$7 = (String)colon2.head();
                        HNil hNil = (HNil)colon2.tail();
                        if (HNil$.MODULE$.equals(hNil)) break block3;
                    }
                    throw new MatchError(colon2);
                }
                TransactionGeneratorConfig transactionGeneratorConfig = new TransactionGeneratorConfig(pat$macro$7);
                return transactionGeneratorConfig;
            }

            public Org_apache_openwhisk_common_TransactionId$anon$macro$8$1() {
            }
        }
        public final class Org_apache_openwhisk_common_TransactionId$anon$macro$10$1
        implements Generic<TransactionGeneratorConfig> {
            public .colon.colon<String, HNil> to(TransactionGeneratorConfig p) {
                TransactionGeneratorConfig transactionGeneratorConfig = p;
                if (transactionGeneratorConfig == null) {
                    throw new MatchError((Object)transactionGeneratorConfig);
                }
                String pat$macro$9 = transactionGeneratorConfig.header();
                .colon.colon colon2 = new .colon.colon((Object)pat$macro$9, (HList)HNil$.MODULE$);
                return colon2;
            }

            public TransactionGeneratorConfig from(.colon.colon<String, HNil> p) {
                String pat$macro$9;
                block3: {
                    .colon.colon<String, HNil> colon2;
                    block2: {
                        colon2 = p;
                        if (colon2 == null) break block2;
                        pat$macro$9 = (String)colon2.head();
                        HNil hNil = (HNil)colon2.tail();
                        if (HNil$.MODULE$.equals(hNil)) break block3;
                    }
                    throw new MatchError(colon2);
                }
                TransactionGeneratorConfig transactionGeneratorConfig = new TransactionGeneratorConfig(pat$macro$9);
                return transactionGeneratorConfig;
            }

            public Org_apache_openwhisk_common_TransactionId$anon$macro$10$1() {
            }
        }
        this.generatorConfig = (TransactionGeneratorConfig)package$.MODULE$.loadConfigOrThrow(ConfigKeys$.MODULE$.transactions(), ClassTag$.MODULE$.apply(TransactionGeneratorConfig.class), (Derivation)new Derivation.Successful(Predef$.MODULE$.implicitly((Object)ConfigReader$.MODULE$.deriveProductInstance(LabelledGeneric$.MODULE$.materializeProduct((DefaultSymbolicLabelling)new DefaultSymbolicLabelling<TransactionGeneratorConfig>(){

            public .colon.colon<Symbol, HNil> apply() {
                return new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "header"), (HList)HNil$.MODULE$);
            }
        }, (Generic)new Org_apache_openwhisk_common_TransactionId$anon$macro$8$1(), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "header"))), Predef$.MODULE$.$conforms()), Default.AsOptions$.MODULE$.asOption(Default$.MODULE$.mkDefault((HList)new .colon.colon((Object)None$.MODULE$, (HList)HNil$.MODULE$)), (Generic)new Org_apache_openwhisk_common_TransactionId$anon$macro$10$1(), Default.AsOptions$.Helper$.MODULE$.hconsNoneHelper(Default.AsOptions$.Helper$.MODULE$.hnilHelper())), Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> inst$macro$15)))));
        this.systemPrefix = "sid_";
        this.unknown = this.apply(new StringBuilder(7).append(this.systemPrefix()).append("unknown").toString(), this.apply$default$2());
        this.testing = this.apply(new StringBuilder(7).append(this.systemPrefix()).append("testing").toString(), this.apply$default$2());
        this.invoker = this.apply(new StringBuilder(7).append(this.systemPrefix()).append("invoker").toString(), this.apply$default$2());
        this.invokerWarmup = this.apply(new StringBuilder(13).append(this.systemPrefix()).append("invokerWarmup").toString(), this.apply$default$2());
        this.invokerNanny = this.apply(new StringBuilder(12).append(this.systemPrefix()).append("invokerNanny").toString(), this.apply$default$2());
        this.dispatcher = this.apply(new StringBuilder(10).append(this.systemPrefix()).append("dispatcher").toString(), this.apply$default$2());
        this.loadbalancer = this.apply(new StringBuilder(12).append(this.systemPrefix()).append("loadbalancer").toString(), this.apply$default$2());
        this.invokerHealth = this.apply(new StringBuilder(13).append(this.systemPrefix()).append("invokerHealth").toString(), this.apply$default$2());
        this.controller = this.apply(new StringBuilder(10).append(this.systemPrefix()).append("controller").toString(), this.apply$default$2());
        this.dbBatcher = this.apply(new StringBuilder(9).append(this.systemPrefix()).append("dbBatcher").toString(), this.apply$default$2());
        this.serdes = new RootJsonFormat<TransactionMetadata>(){

            public JsValue write(TransactionMetadata t) {
                return t.extraLogging() ? JsArray$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsValue[]{new JsString(t.id()), JsNumber$.MODULE$.apply(t.start().toEpochMilli()), JsBoolean$.MODULE$.apply(t.extraLogging())})) : JsArray$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsValue[]{new JsString(t.id()), JsNumber$.MODULE$.apply(t.start().toEpochMilli())}));
            }

            public TransactionMetadata read(JsValue value) {
                return ((TransactionId)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new TransactionId(anon.1.$anonfun$read$1(value))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new TransactionId(anon.1.$anonfun$read$2()))).meta();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final /* synthetic */ TransactionMetadata $anonfun$read$1(JsValue value$1) {
                boolean bl = false;
                JsArray jsArray = null;
                JsValue jsValue = value$1;
                if (jsValue instanceof JsArray) {
                    bl = true;
                    jsArray = (JsArray)jsValue;
                    Vector vector = jsArray.elements();
                    Some some = scala.package$.MODULE$.Vector().unapplySeq((Seq)vector);
                    if (!some.isEmpty() && some.get() != null && ((Vector)some.get()).lengthCompare(2) == 0) {
                        JsValue jsValue2 = (JsValue)((Vector)some.get()).apply(0);
                        JsValue jsValue3 = (JsValue)((Vector)some.get()).apply(1);
                        if (jsValue2 instanceof JsString) {
                            JsString jsString = (JsString)jsValue2;
                            String id = jsString.value();
                            if (jsValue3 instanceof JsNumber) {
                                JsNumber jsNumber = (JsNumber)jsValue3;
                                BigDecimal start = jsNumber.value();
                                return new TransactionMetadata(id, Instant.ofEpochMilli(start.longValue()), false);
                            }
                        }
                    }
                }
                if (!bl) throw new MatchError((Object)jsValue);
                Vector vector = jsArray.elements();
                Some some = scala.package$.MODULE$.Vector().unapplySeq((Seq)vector);
                if (some.isEmpty()) throw new MatchError((Object)jsValue);
                if (some.get() == null) throw new MatchError((Object)jsValue);
                if (((Vector)some.get()).lengthCompare(3) != 0) throw new MatchError((Object)jsValue);
                JsValue jsValue4 = (JsValue)((Vector)some.get()).apply(0);
                JsValue jsValue5 = (JsValue)((Vector)some.get()).apply(1);
                JsValue jsValue6 = (JsValue)((Vector)some.get()).apply(2);
                if (!(jsValue4 instanceof JsString)) throw new MatchError((Object)jsValue);
                JsString jsString = (JsString)jsValue4;
                String id = jsString.value();
                if (!(jsValue5 instanceof JsNumber)) throw new MatchError((Object)jsValue);
                JsNumber jsNumber = (JsNumber)jsValue5;
                BigDecimal start = jsNumber.value();
                if (!(jsValue6 instanceof JsBoolean)) throw new MatchError((Object)jsValue);
                JsBoolean jsBoolean = (JsBoolean)jsValue6;
                Option option = JsBoolean$.MODULE$.unapply(jsBoolean);
                if (option.isEmpty()) throw new MatchError((Object)jsValue);
                boolean extraLogging = BoxesRunTime.unboxToBoolean((Object)option.get());
                return new TransactionMetadata(id, Instant.ofEpochMilli(start.longValue()), extraLogging);
            }

            public static final /* synthetic */ TransactionMetadata $anonfun$read$2() {
                return TransactionId$.MODULE$.unknown();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$1$adapted(spray.json.JsValue ), $anonfun$read$2$adapted()}, serializedLambda);
            }
        };
    }
}

