/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwhisk.connector.kafka;

import akka.actor.ActorSystem;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.NotEnoughReplicasAfterAppendException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.openwhisk.common.Counter;
import org.apache.openwhisk.common.Logging;
import org.apache.openwhisk.common.TransactionMetadata;
import org.apache.openwhisk.connector.kafka.KafkaConfiguration$;
import org.apache.openwhisk.connector.kafka.KafkaProducerConnector$;
import org.apache.openwhisk.core.ConfigKeys$;
import org.apache.openwhisk.core.connector.Message;
import org.apache.openwhisk.core.connector.MessageProducer;
import org.apache.openwhisk.core.entity.ByteSize;
import org.apache.openwhisk.utils.Exceptions;
import pureconfig.ConfigReader;
import pureconfig.ConfigReader$;
import pureconfig.Derivation;
import pureconfig.package$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import shapeless.Lazy$;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u00015\u0011acS1gW\u0006\u0004&o\u001c3vG\u0016\u00148i\u001c8oK\u000e$xN\u001d\u0006\u0003\u0007\u0011\tQa[1gW\u0006T!!\u0002\u0004\u0002\u0013\r|gN\\3di>\u0014(BA\u0004\t\u0003%y\u0007/\u001a8xQ&\u001c8N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019!2\u0004\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+ei\u0011A\u0006\u0006\u0003\u000b]Q!\u0001\u0007\u0004\u0002\t\r|'/Z\u0005\u00035Y\u0011q\"T3tg\u0006<W\r\u0015:pIV\u001cWM\u001d\t\u00039}i\u0011!\b\u0006\u0003=\u0019\tQ!\u001e;jYNL!\u0001I\u000f\u0003\u0015\u0015C8-\u001a9uS>t7\u000f\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0003)Y\u0017MZ6bQ>\u001cHo\u001d\t\u0003I-r!!J\u0015\u0011\u0005\u0019\u0002R\"A\u0014\u000b\u0005!b\u0011A\u0002\u001fs_>$h(\u0003\u0002+!\u00051\u0001K]3eK\u001aL!\u0001L\u0017\u0003\rM#(/\u001b8h\u0015\tQ\u0003\u0003\u0003\u00050\u0001\t\u0005\t\u0015!\u0003$\u0003\tIG\r\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u00039i\u0017\r\u001f*fcV,7\u000f^*ju\u0016\u00042aD\u001a6\u0013\t!\u0004C\u0001\u0004PaRLwN\u001c\t\u0003mej\u0011a\u000e\u0006\u0003q]\ta!\u001a8uSRL\u0018B\u0001\u001e8\u0005!\u0011\u0015\u0010^3TSj,\u0007\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b1B\u001f\u0002\u000f1|wmZ5oOB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001IB\u0001\u0007G>lWn\u001c8\n\u0005\t{$a\u0002'pO\u001eLgn\u001a\u0005\t\t\u0002\u0011\t\u0011)A\u0006\u000b\u0006Y\u0011m\u0019;peNK8\u000f^3n!\t15*D\u0001H\u0015\tA\u0015*A\u0003bGR|'OC\u0001K\u0003\u0011\t7n[1\n\u00051;%aC!di>\u00148+_:uK6DQA\u0014\u0001\u0005\u0002=\u000ba\u0001P5oSRtD\u0003\u0002)V-^#2!U*U!\t\u0011\u0006!D\u0001\u0003\u0011\u0015aT\nq\u0001>\u0011\u0015!U\nq\u0001F\u0011\u0015\u0011S\n1\u0001$\u0011\u001dyS\n%AA\u0002\rBq!M'\u0011\u0002\u0003\u0007!\u0007C\u0004Z\u0001\t\u0007I1\u0001.\u0002\u0005\u0015\u001cW#A.\u0011\u0005q{V\"A/\u000b\u0005y\u0003\u0012AC2p]\u000e,(O]3oi&\u0011\u0001-\u0018\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDaA\u0019\u0001!\u0002\u0013Y\u0016aA3dA!9A\r\u0001b\u0001\n\u0013)\u0017\u0001E4sC\u000e,g-\u001e7XC&$H+[7f+\u00051\u0007CA4k\u001b\u0005A'BA5^\u0003!!WO]1uS>t\u0017BA6i\u000591\u0015N\\5uK\u0012+(/\u0019;j_:Da!\u001c\u0001!\u0002\u00131\u0017!E4sC\u000e,g-\u001e7XC&$H+[7fA!)q\u000e\u0001C!a\u0006I1/\u001a8u\u0007>,h\u000e\u001e\u000b\u0002cB\u0011qB]\u0005\u0003gB\u0011A\u0001T8oO\")Q\u000f\u0001C!m\u0006!1/\u001a8e)\u001d9\u0018qAA\u0006\u0003+\u00012\u0001\u0018={\u0013\tIXL\u0001\u0004GkR,(/\u001a\t\u0004w\u0006\rQ\"\u0001?\u000b\u0005ut\u0018\u0001\u00039s_\u0012,8-\u001a:\u000b\u0007}\f\t!A\u0004dY&,g\u000e^:\u000b\u0005\rA\u0011bAA\u0003y\nq!+Z2pe\u0012lU\r^1eCR\f\u0007BBA\u0005i\u0002\u00071%A\u0003u_BL7\rC\u0004\u0002\u000eQ\u0004\r!a\u0004\u0002\u00075\u001cx\rE\u0002\u0016\u0003#I1!a\u0005\u0017\u0005\u001diUm]:bO\u0016D\u0011\"a\u0006u!\u0003\u0005\r!!\u0007\u0002\u000bI,GO]=\u0011\u0007=\tY\"C\u0002\u0002\u001eA\u00111!\u00138u\u0011\u001d\t\t\u0003\u0001C!\u0003G\tQa\u00197pg\u0016$\"!!\n\u0011\u0007=\t9#C\u0002\u0002*A\u0011A!\u00168ji\"I\u0011Q\u0006\u0001C\u0002\u0013%\u0011qF\u0001\fg\u0016tGoQ8v]R,'/\u0006\u0002\u00022A\u0019a(a\r\n\u0007\u0005UrHA\u0004D_VtG/\u001a:\t\u0011\u0005e\u0002\u0001)A\u0005\u0003c\tAb]3oi\u000e{WO\u001c;fe\u0002Bq!!\u0010\u0001\t\u0013\ty$\u0001\bde\u0016\fG/\u001a)s_\u0012,8-\u001a:\u0015\u0005\u0005\u0005\u0003#B>\u0002D\r\u001a\u0013bAA#y\ni1*\u00194lCB\u0013x\u000eZ;dKJDq!!\u0013\u0001\t\u0013\t\u0019#\u0001\tsK\u000e\u0014X-\u0019;f!J|G-^2fe\"AQ\u0010\u0001a\u0001\n\u0013\ti%\u0006\u0002\u0002B!I\u0011\u0011\u000b\u0001A\u0002\u0013%\u00111K\u0001\raJ|G-^2fe~#S-\u001d\u000b\u0005\u0003K\t)\u0006\u0003\u0006\u0002X\u0005=\u0013\u0011!a\u0001\u0003\u0003\n1\u0001\u001f\u00132\u0011!\tY\u0006\u0001Q!\n\u0005\u0005\u0013!\u00039s_\u0012,8-\u001a:!Q\u0011\tI&a\u0018\u0011\u0007=\t\t'C\u0002\u0002dA\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0003O\u0002\u0011\u0013!C!\u0003S\nab]3oI\u0012\"WMZ1vYR$3'\u0006\u0002\u0002l)\"\u0011\u0011DA7W\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA=!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00141\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,w!CAA\u0005\u0005\u0005\t\u0012AAB\u0003YY\u0015MZ6b!J|G-^2fe\u000e{gN\\3di>\u0014\bc\u0001*\u0002\u0006\u001aA\u0011AAA\u0001\u0012\u0003\t9iE\u0002\u0002\u0006:AqATAC\t\u0003\tY\t\u0006\u0002\u0002\u0004\"Q\u0011qRAC#\u0003%\t!!%\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019JK\u0002$\u0003[B!\"a&\u0002\u0006F\u0005I\u0011AAM\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0014\u0016\u0004e\u00055\u0004")
public class KafkaProducerConnector
implements MessageProducer,
Exceptions {
    private final String kafkahosts;
    private final Option<ByteSize> maxRequestSize;
    public final Logging org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$logging;
    public final ActorSystem org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$actorSystem;
    private final ExecutionContext ec;
    private final FiniteDuration org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$gracefulWaitTime;
    private final Counter org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$sentCounter;
    private volatile KafkaProducer<String, String> producer;

    public static Option<ByteSize> $lessinit$greater$default$3() {
        return KafkaProducerConnector$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$2() {
        return KafkaProducerConnector$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public void tryAndSwallow(String task, Function0<Object> block, Logging logging) {
        Exceptions.tryAndSwallow$(this, task, block, logging);
    }

    @Override
    public <T> T tryAndThrow(String task, Function0<T> block, Logging logging) {
        return (T)Exceptions.tryAndThrow$(this, task, block, logging);
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public FiniteDuration org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$gracefulWaitTime() {
        return this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$gracefulWaitTime;
    }

    @Override
    public long sentCount() {
        return this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$sentCounter().cur();
    }

    @Override
    public Future<RecordMetadata> send(String topic, Message msg, int retry2) {
        TransactionMetadata transid = msg.transid();
        ProducerRecord record = new ProducerRecord(topic, (Object)"messages", (Object)msg.serialize());
        Promise produced = Promise$.MODULE$.apply();
        Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> scala.concurrent.package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            try {
                object = this.producer().send(record, new Callback(null, produced){
                    private final Promise produced$1;

                    public void onCompletion(RecordMetadata metadata, Exception exception) {
                        if (exception == null) {
                            this.produced$1.trySuccess((Object)metadata);
                        } else {
                            this.produced$1.tryFailure((Throwable)exception);
                        }
                    }
                    {
                        this.produced$1 = produced$1;
                    }
                });
            }
            catch (Throwable e) {
                object = BoxesRunTime.boxToBoolean((boolean)produced.tryFailure(e));
            }
            return object;
        }), this.ec());
        return produced.future().andThen((PartialFunction)new scala.Serializable(this, topic, transid){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaProducerConnector $outer;
            private final String topic$1;
            private final TransactionMetadata transid$1;

            public final <A1 extends Try<RecordMetadata>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Success) {
                    Success success = (Success)A1;
                    RecordMetadata status = (RecordMetadata)success.value();
                    this.$outer.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$logging.debug(this.$outer, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("sent message: ").append(status.topic()).append("[").append(status.partition()).append("][").append(status.offset()).append("]").toString(), this.transid$1);
                    object = BoxesRunTime.boxToLong((long)this.$outer.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$sentCounter().next());
                } else if (A1 instanceof Failure) {
                    Failure failure = (Failure)A1;
                    Throwable t = failure.exception();
                    this.$outer.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$logging.error(this.$outer, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("sending message on topic '").append($this.topic$1).append("' failed: ").append(t.getMessage()).toString(), this.transid$1);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Try<RecordMetadata> x1) {
                Try<RecordMetadata> try_ = x1;
                boolean bl = try_ instanceof Success ? true : try_ instanceof Failure;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.transid$1 = transid$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.kafka.clients.producer.RecordMetadata ), $anonfun$applyOrElse$2(org.apache.openwhisk.connector.kafka.KafkaProducerConnector$$anonfun$send$3 java.lang.Throwable )}, serializedLambda);
            }
        }, this.ec()).recoverWith((PartialFunction)new scala.Serializable(this, topic, msg, retry2, transid, produced){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaProducerConnector $outer;
            private final String topic$1;
            private final Message msg$1;
            private final int retry$1;
            private final TransactionMetadata transid$1;
            private final Promise produced$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                void var3_10;
                A1 A1 = x2;
                boolean bl = A1 instanceof NotEnoughReplicasAfterAppendException ? true : A1 instanceof TimeoutException;
                if (bl) {
                    this.$outer.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$recreateProducer();
                    Future future = this.produced$1.future();
                    return var3_10;
                }
                if (A1 instanceof RetriableException) {
                    RetriableException retriableException = (RetriableException)A1;
                    if (this.retry$1 > 0) {
                        this.$outer.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$logging.info(this.$outer, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append(retriableException).append(": Retrying ").append($this.retry$1).append(" more times").toString(), this.transid$1);
                        Future future = akka.pattern.package$.MODULE$.after(this.$outer.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$gracefulWaitTime(), this.$outer.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$actorSystem.scheduler(), (Function0 & Serializable & scala.Serializable)() -> $this.$outer.send($this.topic$1, $this.msg$1, $this.retry$1 - 1), this.$outer.ec());
                        return var3_10;
                    }
                }
                if (A1 instanceof RecordTooLargeException) {
                    RecordTooLargeException recordTooLargeException = (RecordTooLargeException)A1;
                    Future future = Future$.MODULE$.failed((Throwable)recordTooLargeException);
                    return var3_10;
                }
                if (A1 != null) {
                    this.$outer.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$recreateProducer();
                    Future future = this.produced$1.future();
                    return var3_10;
                }
                Object object = function1.apply(x2);
                return var3_10;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = throwable instanceof NotEnoughReplicasAfterAppendException ? true : throwable instanceof TimeoutException;
                boolean bl2 = bl ? true : (throwable instanceof RetriableException && this.retry$1 > 0 ? true : (throwable instanceof RecordTooLargeException ? true : throwable != null));
                return bl2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.msg$1 = msg$1;
                this.retry$1 = retry$1;
                this.transid$1 = transid$1;
                this.produced$1 = produced$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(org.apache.openwhisk.connector.kafka.KafkaProducerConnector$$anonfun$send$4 org.apache.kafka.common.errors.RetriableException ), $anonfun$applyOrElse$4(org.apache.openwhisk.connector.kafka.KafkaProducerConnector$$anonfun$send$4 )}, serializedLambda);
            }
        }, this.ec());
    }

    @Override
    public int send$default$3() {
        return 3;
    }

    @Override
    public void close() {
        KafkaProducerConnector x$1 = this;
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> "closing producer";
        TransactionMetadata x$3 = this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$logging.info$default$3(x$1, (Function0<String>)x$2);
        this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$logging.info(x$1, (Function0<String>)x$2, x$3);
        this.producer().close();
    }

    public Counter org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$sentCounter() {
        return this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$sentCounter;
    }

    private KafkaProducer<String, String> createProducer() {
        ConfigReader inst$macro$224 = ConfigReader$.MODULE$.stringConfigReader();
        ConfigReader inst$macro$226 = ConfigReader$.MODULE$.stringConfigReader();
        Map config = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.kafkahosts)}))).$plus$plus(KafkaConfiguration$.MODULE$.configMapToKafkaConfig((Map<String, String>)((Map)package$.MODULE$.loadConfigOrThrow(ConfigKeys$.MODULE$.kafkaCommon(), ClassTag$.MODULE$.apply(Map.class), (Derivation)new Derivation.Successful(Predef$.MODULE$.implicitly((Object)ConfigReader$.MODULE$.deriveMap((Derivation)new Derivation.Successful(Predef$.MODULE$.implicitly((Object)Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> inst$macro$224)))))))))).$plus$plus(KafkaConfiguration$.MODULE$.configMapToKafkaConfig((Map<String, String>)((Map)package$.MODULE$.loadConfigOrThrow(ConfigKeys$.MODULE$.kafkaProducer(), ClassTag$.MODULE$.apply(Map.class), (Derivation)new Derivation.Successful(Predef$.MODULE$.implicitly((Object)ConfigReader$.MODULE$.deriveMap((Derivation)new Derivation.Successful(Predef$.MODULE$.implicitly((Object)Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> inst$macro$226)))))))))).$plus$plus((GenTraversableOnce)this.maxRequestSize.map((Function1 & Serializable & scala.Serializable)max -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.request.size"), (Object)((Object)BoxesRunTime.boxToLong((long)max.size())).toString())}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()));
        KafkaConfiguration$.MODULE$.verifyConfig((Map<String, String>)config, (Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(ProducerConfig.configNames()).asScala()).toSet(), this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$logging);
        return (KafkaProducer)this.tryAndThrow("creating producer", (Function0 & Serializable & scala.Serializable)() -> new KafkaProducer(KafkaConfiguration$.MODULE$.mapToProperties((Map<String, String>)config), (Serializer)new StringSerializer(), (Serializer)new StringSerializer()), this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$logging);
    }

    public void org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$recreateProducer() {
        KafkaProducerConnector x$4 = this;
        Function0 & Serializable & scala.Serializable x$5 = (Function0 & Serializable & scala.Serializable)() -> "recreating producer";
        TransactionMetadata x$6 = this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$logging.info$default$3(x$4, (Function0<String>)x$5);
        this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$logging.info(x$4, (Function0<String>)x$5, x$6);
        this.tryAndSwallow("closing old producer", (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.producer().close(), this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$logging);
        KafkaProducerConnector x$7 = this;
        Function0 & Serializable & scala.Serializable x$8 = (Function0 & Serializable & scala.Serializable)() -> "old producer closed";
        TransactionMetadata x$9 = this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$logging.info$default$3(x$7, (Function0<String>)x$8);
        this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$logging.info(x$7, (Function0<String>)x$8, x$9);
        this.producer_$eq(this.createProducer());
    }

    private KafkaProducer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<String, String> x$1) {
        this.producer = x$1;
    }

    public KafkaProducerConnector(String kafkahosts, String id, Option<ByteSize> maxRequestSize, Logging logging, ActorSystem actorSystem) {
        this.kafkahosts = kafkahosts;
        this.maxRequestSize = maxRequestSize;
        this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$logging = logging;
        this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$actorSystem = actorSystem;
        Exceptions.$init$(this);
        this.ec = actorSystem.dispatcher();
        this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$gracefulWaitTime = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).milliseconds();
        this.org$apache$openwhisk$connector$kafka$KafkaProducerConnector$$sentCounter = new Counter();
        this.producer = this.createProducer();
    }
}

