/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwhisk.core.containerpool.logging;

import akka.actor.ActorSystem;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.alpakka.file.scaladsl.LogRotatorSink$;
import akka.stream.scaladsl.Broadcast$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.MergeHub$;
import akka.stream.scaladsl.RestartSink$;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Instant;
import java.util.EnumSet;
import org.apache.openwhisk.common.AkkaLogging;
import org.apache.openwhisk.common.TransactionMetadata;
import org.apache.openwhisk.core.containerpool.Container;
import org.apache.openwhisk.core.containerpool.logging.DockerToActivationFileLogStore$;
import org.apache.openwhisk.core.containerpool.logging.DockerToActivationLogStore;
import org.apache.openwhisk.core.containerpool.logging.DockerToActivationLogStore$;
import org.apache.openwhisk.core.containerpool.logging.LogCollectingException;
import org.apache.openwhisk.core.containerpool.logging.OwSink$;
import org.apache.openwhisk.core.entity.ActivationLogs;
import org.apache.openwhisk.core.entity.ByteSize;
import org.apache.openwhisk.core.entity.CodeExec;
import org.apache.openwhisk.core.entity.ExecutableWhiskAction;
import org.apache.openwhisk.core.entity.Identity;
import org.apache.openwhisk.core.entity.LogLimit$;
import org.apache.openwhisk.core.entity.UUID;
import org.apache.openwhisk.core.entity.UUID$;
import org.apache.openwhisk.core.entity.WhiskActivation;
import org.apache.openwhisk.core.entity.size$;
import org.apache.openwhisk.http.Messages$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import spray.json.DefaultJsonProtocol$;
import spray.json.JsObject;
import spray.json.JsValue;
import spray.json.JsonWriter;
import spray.json.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001=\u0011a\u0004R8dW\u0016\u0014Hk\\!di&4\u0018\r^5p]\u001aKG.\u001a'pON#xN]3\u000b\u0005\r!\u0011a\u00027pO\u001eLgn\u001a\u0006\u0003\u000b\u0019\tQbY8oi\u0006Lg.\u001a:q_>d'BA\u0004\t\u0003\u0011\u0019wN]3\u000b\u0005%Q\u0011!C8qK:<\b.[:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011!\u0004R8dW\u0016\u0014Hk\\!di&4\u0018\r^5p]2{wm\u0015;pe\u0016D\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0007gf\u001cH/Z7\u0011\u0005]aR\"\u0001\r\u000b\u0005eQ\u0012!B1di>\u0014(\"A\u000e\u0002\t\u0005\\7.Y\u0005\u0003;a\u00111\"Q2u_J\u001c\u0016p\u001d;f[\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u000beKN$\u0018N\\1uS>tG)\u001b:fGR|'/\u001f\t\u0003C!j\u0011A\t\u0006\u0003G\u0011\nAAZ5mK*\u0011QEJ\u0001\u0004]&|'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\t\u0012A\u0001U1uQ\")1\u0006\u0001C\u0001Y\u00051A(\u001b8jiz\"2!\f\u00180!\t\t\u0002\u0001C\u0003\u0016U\u0001\u0007a\u0003C\u0004 UA\u0005\t\u0019\u0001\u0011\t\u000f\r\u0001!\u0019!C\u0005cU\t!\u0007\u0005\u00024m5\tAG\u0003\u00026\u0011\u000511m\\7n_:L!a\u000e\u001b\u0003\u0017\u0005[7.\u0019'pO\u001eLgn\u001a\u0005\u0007s\u0001\u0001\u000b\u0011\u0002\u001a\u0002\u00111|wmZ5oO\u0002Bqa\u000f\u0001C\u0002\u0013%A(\u0001\u0005fm\u0016tG/\u00128e+\u0005i\u0004C\u0001 B\u001b\u0005y$B\u0001!\u001b\u0003\u0011)H/\u001b7\n\u0005\t{$A\u0003\"zi\u0016\u001cFO]5oO\"1A\t\u0001Q\u0001\nu\n\u0011\"\u001a<f]R,e\u000e\u001a\u0011\t\u000b\u0019\u0003A\u0011B$\u0002\u0019\u0019LW\r\u001c3t'R\u0014\u0018N\\4\u0015\u0005!+\u0006CA%S\u001d\tQ\u0005\u000b\u0005\u0002L\u001d6\tAJ\u0003\u0002N\u001d\u00051AH]8pizR\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u000ba\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011K\u0014\u0005\u0006-\u0016\u0003\raV\u0001\u0007M&,G\u000eZ:\u0011\t%C\u0006JW\u0005\u00033R\u00131!T1q!\tY\u0006-D\u0001]\u0015\tif,\u0001\u0003kg>t'\"A0\u0002\u000bM\u0004(/Y=\n\u0005\u0005d&a\u0002&t-\u0006dW/\u001a\u0005\bG\u0002\u0011\r\u0011\"\u0001e\u0003)\u0011WO\u001a4feNK'0Z\u000b\u0002KB\u0011a-[\u0007\u0002O*\u0011\u0001NB\u0001\u0007K:$\u0018\u000e^=\n\u0005)<'\u0001\u0003\"zi\u0016\u001c\u0016N_3\t\r1\u0004\u0001\u0015!\u0003f\u0003-\u0011WO\u001a4feNK'0\u001a\u0011\t\u000f9\u0004!\u0019!C\u0001_\u0006)\u0001/\u001a:ngV\t\u0001\u000fE\u0002rgVl\u0011A\u001d\u0006\u0003\u0001\u001aJ!\u0001\u001e:\u0003\u000f\u0015sW/\\*fiB\u0011a/_\u0007\u0002o*\u0011\u0001PI\u0001\nCR$(/\u001b2vi\u0016L!A_<\u0003'A{7/\u001b=GS2,\u0007+\u001a:nSN\u001c\u0018n\u001c8\t\rq\u0004\u0001\u0015!\u0003q\u0003\u0019\u0001XM]7tA!9a\u0010\u0001b\u0001\n#y\u0018aC<sSR,Gk\u001c$jY\u0016,\"!!\u00011\t\u0005\r\u0011q\u0003\t\b\u0003\u000b\ty!PA\n\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011\u0001C:dC2\fGm\u001d7\u000b\u0007\u00055!$\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0003#\t9A\u0001\u0003TS:\\\u0007\u0003BA\u000b\u0003/a\u0001\u0001\u0002\u0007\u0002\u001a\u0005m\u0011\u0011!A\u0001\u0006\u0003\tyBA\u0002`IEB\u0001\"!\b\u0001A\u0003%\u0011\u0011A\u0001\roJLG/\u001a+p\r&dW\rI\t\u0005\u0003C\tI\u0003\u0005\u0003\u0002$\u0005\u0015R\"\u0001(\n\u0007\u0005\u001dbJA\u0004O_RD\u0017N\\4\u0011\t\u0005\r\u00121F\u0005\u0004\u0003[q%aA!os\"9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0012aC2pY2,7\r\u001e'pON$B\"!\u000e\u0002H\u0005E\u00131LA3\u0003c\u0002b!a\u000e\u0002>\u0005\u0005SBAA\u001d\u0015\r\tYDT\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA \u0003s\u0011aAR;ukJ,\u0007c\u00014\u0002D%\u0019\u0011QI4\u0003\u001d\u0005\u001bG/\u001b<bi&|g\u000eT8hg\"A\u0011\u0011JA\u0018\u0001\u0004\tY%A\u0004ue\u0006t7/\u001b3\u0011\u0007M\ni%C\u0002\u0002PQ\u0012Q\u0002\u0016:b]N\f7\r^5p]&#\u0007\u0002CA*\u0003_\u0001\r!!\u0016\u0002\tU\u001cXM\u001d\t\u0004M\u0006]\u0013bAA-O\nA\u0011\nZ3oi&$\u0018\u0010\u0003\u0005\u0002^\u0005=\u0002\u0019AA0\u0003)\t7\r^5wCRLwN\u001c\t\u0004M\u0006\u0005\u0014bAA2O\nyq\u000b[5tW\u0006\u001bG/\u001b<bi&|g\u000e\u0003\u0005\u0002h\u0005=\u0002\u0019AA5\u0003%\u0019wN\u001c;bS:,'\u000f\u0005\u0003\u0002l\u00055T\"\u0001\u0003\n\u0007\u0005=DAA\u0005D_:$\u0018-\u001b8fe\"A\u00111OA\u0018\u0001\u0004\t)(\u0001\u0004bGRLwN\u001c\t\u0004M\u0006]\u0014bAA=O\n)R\t_3dkR\f'\r\\3XQ&\u001c8.Q2uS>tw!CA?\u0005\u0005\u0005\t\u0012AA@\u0003y!unY6feR{\u0017i\u0019;jm\u0006$\u0018n\u001c8GS2,Gj\\4Ti>\u0014X\rE\u0002\u0012\u0003\u00033\u0001\"\u0001\u0002\u0002\u0002#\u0005\u00111Q\n\u0005\u0003\u0003\u000b)\t\u0005\u0003\u0002$\u0005\u001d\u0015bAAE\u001d\n1\u0011I\\=SK\u001aDqaKAA\t\u0003\ti\t\u0006\u0002\u0002\u0000!Q\u0011\u0011SAA#\u0003%\t!a%\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t)JK\u0002!\u0003/[#!!'\u0011\t\u0005m\u0015QU\u0007\u0003\u0003;SA!a(\u0002\"\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Gs\u0015AC1o]>$\u0018\r^5p]&!\u0011qUAO\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class DockerToActivationFileLogStore
extends DockerToActivationLogStore {
    private final Path destinationDirectory;
    private final AkkaLogging logging;
    private final ByteString eventEnd;
    private final ByteSize bufferSize;
    private final EnumSet<PosixFilePermission> perms;
    private final Sink<ByteString, ?> writeToFile;

    public static Path $lessinit$greater$default$2() {
        return DockerToActivationFileLogStore$.MODULE$.$lessinit$greater$default$2();
    }

    private AkkaLogging logging() {
        return this.logging;
    }

    private ByteString eventEnd() {
        return this.eventEnd;
    }

    private String fieldsString(Map<String, JsValue> fields) {
        return ((TraversableOnce)fields.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            JsValue value = (JsValue)tuple2._2();
            String string = new StringBuilder(3).append("\"").append(key).append("\":").append(value.compactPrint()).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
    }

    public ByteSize bufferSize() {
        return this.bufferSize;
    }

    public EnumSet<PosixFilePermission> perms() {
        return this.perms;
    }

    public Sink<ByteString, ?> writeToFile() {
        return this.writeToFile;
    }

    @Override
    public Future<Vector<String>> collectLogs(TransactionMetadata transid, Identity user, WhiskActivation activation, Container container, ExecutableWhiskAction action) {
        Source<ByteString, Object> logs = container.logs(LogLimit$.MODULE$.asMegaBytes$extension(action.limits().logs()), ((CodeExec)action.exec()).sentinelledLogs(), transid);
        Map userIdField = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"namespaceId"), (Object)package$.MODULE$.enrichAny((Object)new UUID(user.namespace().uuid())).toJson(UUID$.MODULE$.serdes()))}));
        Map additionalMetadata = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"activationId"), (Object)package$.MODULE$.enrichAny((Object)activation.activationId()).toJson((JsonWriter)DefaultJsonProtocol$.MODULE$.StringJsonFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"action"), (Object)package$.MODULE$.enrichAny((Object)action.fullyQualifiedName(false).asString()).toJson((JsonWriter)DefaultJsonProtocol$.MODULE$.StringJsonFormat()))}))).$plus$plus((GenTraversableOnce)userIdField);
        JsObject augmentedActivation = new JsObject(activation.toJson().fields().$plus$plus((GenTraversableOnce)userIdField));
        ByteString metadata = ByteString$.MODULE$.apply(new StringBuilder(1).append(",").append(this.fieldsString((Map<String, JsValue>)additionalMetadata)).toString());
        Sink toSeq = Flow$.MODULE$.apply().via(DockerToActivationLogStore$.MODULE$.toFormattedString()).toMat((Graph)Sink$.MODULE$.seq(), Keep$.MODULE$.right());
        Sink toFile = ((Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.dropRight(1).$plus$plus(metadata).$plus$plus(this.eventEnd())).concat((Graph)Source$.MODULE$.single((Object)ByteString$.MODULE$.apply(new StringBuilder(1).append(package$.MODULE$.enrichAny((Object)augmentedActivation).toJson((JsonWriter)DefaultJsonProtocol$.MODULE$.RootJsObjectFormat()).compactPrint()).append("\n").toString())))).to(this.writeToFile());
        Sink combined = OwSink$.MODULE$.combine(toSeq, toFile, (Function1 & Serializable & scala.Serializable)x$5 -> Broadcast$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)x$5), Broadcast$.MODULE$.apply$default$2()));
        return ((Future)((Tuple2)logs.runWith(combined, (Materializer)this.mat()))._1()).flatMap((Function1 & Serializable & scala.Serializable)seq -> {
            Set possibleErrors = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Messages$.MODULE$.logFailure(), Messages$.MODULE$.truncateLogs(LogLimit$.MODULE$.asMegaBytes$extension(action.limits().logs()))}));
            boolean errored = seq.lastOption().exists((Function1 & Serializable & scala.Serializable)last -> BoxesRunTime.boxToBoolean((boolean)possibleErrors.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)last.contains(x$1)))));
            Vector logs = seq.toVector();
            return !errored ? Future$.MODULE$.successful((Object)new ActivationLogs((Vector<String>)logs)) : Future$.MODULE$.failed((Throwable)new LogCollectingException(logs));
        }, this.ec());
    }

    public DockerToActivationFileLogStore(ActorSystem system, Path destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
        super(system);
        this.logging = new AkkaLogging(system.log());
        this.eventEnd = ByteString$.MODULE$.apply("}\n");
        this.bufferSize = size$.MODULE$.SizeInt(100).MB();
        this.perms = EnumSet.of(PosixFilePermission.OWNER_READ, (Enum[])new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE});
        this.writeToFile = (Sink)((Source)MergeHub$.MODULE$.source().batchWeighted(this.bufferSize().toBytes(), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.length()), (Function1 & Serializable & scala.Serializable)x -> (ByteString)Predef$.MODULE$.identity(x), (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.$plus$plus(x$3))).to((Graph)RestartSink$.MODULE$.withBackoff(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(60)).seconds(), 0.2, (Function0 & Serializable & scala.Serializable)() -> LogRotatorSink$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            long maxSize = this.bufferSize().toBytes();
            LongRef bytesRead = LongRef.create((long)maxSize);
            return (Function1 & Serializable & scala.Serializable)element -> {
                None$ none$;
                int size2 = element.size();
                if (bytesRead$1.elem + (long)size2 > maxSize) {
                    bytesRead$1.elem = size2;
                    Path logFilePath = $this.destinationDirectory.resolve(new StringBuilder(13).append("userlogs-").append(Instant.now().toEpochMilli()).append(".log").toString());
                    DockerToActivationFileLogStore x$8 = this;
                    Function0 & Serializable & scala.Serializable x$9 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Rotating log file to '").append(logFilePath).append("'").toString();
                    TransactionMetadata x$10 = this.logging().info$default$3(x$8, (Function0<String>)x$9);
                    this.logging().info(x$8, (Function0<String>)x$9, x$10);
                    try {
                        Files.createFile(logFilePath, new FileAttribute[0]);
                        Files.setPosixFilePermissions(logFilePath, this.perms());
                    }
                    catch (Throwable t) {
                        DockerToActivationFileLogStore x$11 = this;
                        Function0 & Serializable & scala.Serializable x$12 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Couldn't create userlogs file: ").append(t).toString();
                        TransactionMetadata x$13 = this.logging().error$default$3(x$11, (Function0<String>)x$12);
                        this.logging().error(x$11, (Function0<String>)x$12, x$13);
                        throw t;
                    }
                    none$ = new Some((Object)logFilePath);
                } else {
                    bytesRead$1.elem += (long)size2;
                    none$ = None$.MODULE$;
                }
                return none$;
            };
        }, LogRotatorSink$.MODULE$.apply$default$2()))).run((Materializer)this.mat());
    }
}

