/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwhisk.core.database;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.dispatch.MessageDispatcher;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.openwhisk.common.Logging;
import org.apache.openwhisk.common.TransactionMetadata;
import org.apache.openwhisk.core.WhiskConfig;
import org.apache.openwhisk.core.connector.MessageConsumer;
import org.apache.openwhisk.core.connector.MessageFeed;
import org.apache.openwhisk.core.connector.MessageFeed$;
import org.apache.openwhisk.core.connector.MessageFeed$Processed$;
import org.apache.openwhisk.core.connector.MessageProducer;
import org.apache.openwhisk.core.connector.MessagingProvider;
import org.apache.openwhisk.core.database.CacheInvalidationMessage;
import org.apache.openwhisk.core.database.CacheInvalidationMessage$;
import org.apache.openwhisk.core.entity.CacheKey;
import org.apache.openwhisk.core.entity.ControllerInstanceId;
import org.apache.openwhisk.core.entity.WhiskAction$;
import org.apache.openwhisk.core.entity.WhiskActionMetaData$;
import org.apache.openwhisk.core.entity.WhiskPackage$;
import org.apache.openwhisk.core.entity.WhiskRule$;
import org.apache.openwhisk.core.entity.WhiskTrigger$;
import org.apache.openwhisk.spi.SpiLoader$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u00015\u0011qCU3n_R,7)Y2iK&sg/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005\r!\u0011\u0001\u00033bi\u0006\u0014\u0017m]3\u000b\u0005\u00151\u0011\u0001B2pe\u0016T!a\u0002\u0005\u0002\u0013=\u0004XM\\<iSN\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aD\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0007G>tg-[4\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!aC,iSN\\7i\u001c8gS\u001eD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\nG>l\u0007o\u001c8f]R\u0004\"!\b\u0013\u000f\u0005y\u0011\u0003CA\u0010\u0011\u001b\u0005\u0001#BA\u0011\r\u0003\u0019a$o\\8u}%\u00111\u0005E\u0001\u0007!J,G-\u001a4\n\u0005\u00152#AB*ue&twM\u0003\u0002$!!A\u0001\u0006\u0001B\u0001B\u0003%\u0011&\u0001\u0005j]N$\u0018M\\2f!\tQS&D\u0001,\u0015\taC!\u0001\u0004f]RLG/_\u0005\u0003]-\u0012AcQ8oiJ|G\u000e\\3s\u0013:\u001cH/\u00198dK&#\u0007\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b1B\u0019\u0002\u000f1|wmZ5oOB\u0011!'N\u0007\u0002g)\u0011AGB\u0001\u0007G>lWn\u001c8\n\u0005Y\u001a$a\u0002'pO\u001eLgn\u001a\u0005\tq\u0001\u0011\t\u0011)A\u0006s\u0005\u0011\u0011m\u001d\t\u0003u}j\u0011a\u000f\u0006\u0003yu\nQ!Y2u_JT\u0011AP\u0001\u0005C.\\\u0017-\u0003\u0002Aw\tY\u0011i\u0019;peNK8\u000f^3n\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0003\u0019a\u0014N\\5u}Q!A)\u0013&L)\r)u\t\u0013\t\u0003\r\u0002i\u0011A\u0001\u0005\u0006a\u0005\u0003\u001d!\r\u0005\u0006q\u0005\u0003\u001d!\u000f\u0005\u0006+\u0005\u0003\rA\u0006\u0005\u00067\u0005\u0003\r\u0001\b\u0005\u0006Q\u0005\u0003\r!\u000b\u0005\b\u001b\u0002\u0011\r\u0011b\u0003O\u0003\t)7-F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011V(\u0001\u0005eSN\u0004\u0018\r^2i\u0013\t!\u0016KA\tNKN\u001c\u0018mZ3ESN\u0004\u0018\r^2iKJDaA\u0016\u0001!\u0002\u0013y\u0015aA3dA!9\u0001\f\u0001b\u0001\n\u0013I\u0016!\u0002;pa&\u001cW#\u0001.\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016\u0001\u00027b]\u001eT\u0011aX\u0001\u0005U\u00064\u0018-\u0003\u0002&9\"1!\r\u0001Q\u0001\ni\u000ba\u0001^8qS\u000e\u0004\u0003b\u00023\u0001\u0005\u0004%I!Z\u0001\u000bS:\u001cH/\u00198dK&#W#\u0001\u000f\t\r\u001d\u0004\u0001\u0015!\u0003\u001d\u0003-Ign\u001d;b]\u000e,\u0017\n\u001a\u0011\t\u000f%\u0004!\u0019!C\u0005U\u0006YQn]4Qe>4\u0018\u000eZ3s+\u0005Y\u0007C\u00017p\u001b\u0005i'B\u00018\u0005\u0003%\u0019wN\u001c8fGR|'/\u0003\u0002q[\n\tR*Z:tC\u001eLgn\u001a)s_ZLG-\u001a:\t\rI\u0004\u0001\u0015!\u0003l\u00031i7o\u001a)s_ZLG-\u001a:!\u0011\u001d!\bA1A\u0005\nU\f\u0011dY1dQ\u0016LeN^1mS\u0012\fG/[8o\u0007>t7/^7feV\ta\u000f\u0005\u0002mo&\u0011\u00010\u001c\u0002\u0010\u001b\u0016\u001c8/Y4f\u0007>t7/^7fe\"1!\u0010\u0001Q\u0001\nY\f!dY1dQ\u0016LeN^1mS\u0012\fG/[8o\u0007>t7/^7fe\u0002Bq\u0001 \u0001C\u0002\u0013%Q0A\rdC\u000eDW-\u00138wC2LG-\u0019;j_:\u0004&o\u001c3vG\u0016\u0014X#\u0001@\u0011\u00051|\u0018bAA\u0001[\nyQ*Z:tC\u001e,\u0007K]8ek\u000e,'\u000fC\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u0002@\u00025\r\f7\r[3J]Z\fG.\u001b3bi&|g\u000e\u0015:pIV\u001cWM\u001d\u0011\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f\u0005)cn\u001c;jMf|E\u000f[3s\u0013:\u001cH/\u00198dKN\f%m\\;u\u0013:4\u0018\r\\5eCRLwN\u001c\u000b\u0005\u0003\u001b\ty\u0002\u0005\u0004\u0002\u0010\u0005U\u0011\u0011D\u0007\u0003\u0003#Q1!a\u0005\u0011\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003/\t\tB\u0001\u0004GkR,(/\u001a\t\u0004\u001f\u0005m\u0011bAA\u000f!\t!QK\\5u\u0011!\t\t#a\u0002A\u0002\u0005\r\u0012aA6fsB\u0019!&!\n\n\u0007\u0005\u001d2F\u0001\u0005DC\u000eDWmS3z\u0011%\tY\u0003\u0001b\u0001\n\u0013\ti#\u0001\tj]Z\fG.\u001b3bi&|gNR3fIV\u0011\u0011q\u0006\t\u0004u\u0005E\u0012bAA\u001aw\tA\u0011i\u0019;peJ+g\r\u0003\u0005\u00028\u0001\u0001\u000b\u0011BA\u0018\u0003EIgN^1mS\u0012\fG/[8o\r\u0016,G\r\t\u0005\b\u0003w\u0001A\u0011AA\u001f\u0003uIgN^1mS\u0012\fG/Z,iSN\\\u0017i\u0019;j_:lU\r^1ECR\fG\u0003BA\r\u0003\u007fA\u0001\"!\t\u0002:\u0001\u0007\u00111\u0005\u0005\b\u0003\u0007\u0002A\u0011BA#\u0003Q\u0011X-\\8wK\u001a\u0013x.\u001c'pG\u0006d7)Y2iKR!\u0011QBA$\u0011!\tI%!\u0011A\u0002\u0005-\u0013!\u00022zi\u0016\u001c\b#B\b\u0002N\u0005E\u0013bAA(!\t)\u0011I\u001d:bsB\u0019q\"a\u0015\n\u0007\u0005U\u0003C\u0001\u0003CsR,\u0007")
public class RemoteCacheInvalidation {
    private final Logging logging;
    private final MessageDispatcher ec;
    private final String topic;
    private final String instanceId;
    private final MessagingProvider msgProvider;
    private final MessageConsumer cacheInvalidationConsumer;
    private final MessageProducer cacheInvalidationProducer;
    private final ActorRef invalidationFeed;

    private MessageDispatcher ec() {
        return this.ec;
    }

    private String topic() {
        return this.topic;
    }

    private String instanceId() {
        return this.instanceId;
    }

    private MessagingProvider msgProvider() {
        return this.msgProvider;
    }

    private MessageConsumer cacheInvalidationConsumer() {
        return this.cacheInvalidationConsumer;
    }

    private MessageProducer cacheInvalidationProducer() {
        return this.cacheInvalidationProducer;
    }

    public Future<BoxedUnit> notifyOtherInstancesAboutInvalidation(CacheKey key) {
        return this.cacheInvalidationProducer().send(this.topic(), new CacheInvalidationMessage(key, this.instanceId()), this.cacheInvalidationProducer().send$default$3()).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            RemoteCacheInvalidation.$anonfun$notifyOtherInstancesAboutInvalidation$1(x$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.ec());
    }

    private ActorRef invalidationFeed() {
        return this.invalidationFeed;
    }

    public void invalidateWhiskActionMetaData(CacheKey key) {
        WhiskActionMetaData$.MODULE$.removeId(key, (ExecutionContext)this.ec());
    }

    private Future<BoxedUnit> removeFromLocalCache(byte[] bytes) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Success success;
            CacheInvalidationMessage msg;
            String raw = new String(bytes, StandardCharsets.UTF_8);
            Try<CacheInvalidationMessage> try_ = CacheInvalidationMessage$.MODULE$.parse(raw);
            if (try_ instanceof Success && (msg = (CacheInvalidationMessage)(success = (Success)try_).value()) != null) {
                BoxedUnit boxedUnit;
                CacheInvalidationMessage cacheInvalidationMessage = msg;
                String string = cacheInvalidationMessage.instanceId();
                String string2 = this.instanceId();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    WhiskActionMetaData$.MODULE$.removeId(cacheInvalidationMessage.key(), (ExecutionContext)this.ec());
                    WhiskAction$.MODULE$.removeId(cacheInvalidationMessage.key(), (ExecutionContext)this.ec());
                    WhiskPackage$.MODULE$.removeId(cacheInvalidationMessage.key(), (ExecutionContext)this.ec());
                    WhiskRule$.MODULE$.removeId(cacheInvalidationMessage.key(), (ExecutionContext)this.ec());
                    WhiskTrigger$.MODULE$.removeId(cacheInvalidationMessage.key(), (ExecutionContext)this.ec());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                RemoteCacheInvalidation x$2 = this;
                Function0 & Serializable & scala.Serializable x$3 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("failed processing message: ").append(raw).append(" with ").append(t).toString();
                TransactionMetadata x$4 = $this.logging.error$default$3(x$2, (Function0<String>)x$3);
                $this.logging.error(x$2, (Function0<String>)x$3, x$4);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(try_);
            }
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.invalidationFeed());
            MessageFeed$Processed$ x$5 = MessageFeed$Processed$.MODULE$;
            ActorRef x$6 = qual$1.$bang$default$2((Object)x$5);
            qual$1.$bang((Object)x$5, x$6);
        }, (ExecutionContext)this.ec());
    }

    public static final /* synthetic */ void $anonfun$notifyOtherInstancesAboutInvalidation$1(RecordMetadata x$1) {
    }

    public RemoteCacheInvalidation(WhiskConfig config, String component, ControllerInstanceId instance, Logging logging, ActorSystem as) {
        this.logging = logging;
        this.ec = as.dispatchers().lookup("dispatchers.kafka-dispatcher");
        this.topic = "cacheInvalidation";
        this.instanceId = new StringBuilder(0).append(component).append(instance.asString()).toString();
        this.msgProvider = (MessagingProvider)SpiLoader$.MODULE$.get(ManifestFactory$.MODULE$.classType(MessagingProvider.class), SpiLoader$.MODULE$.get$default$2());
        this.cacheInvalidationConsumer = this.msgProvider().getConsumer(config, new StringBuilder(0).append(this.topic()).append(this.instanceId()).toString(), this.topic(), 128, this.msgProvider().getConsumer$default$5(), logging, as);
        this.cacheInvalidationProducer = this.msgProvider().getProducer(config, this.msgProvider().getProducer$default$2(), logging, as);
        this.invalidationFeed = as.actorOf(Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new MessageFeed("cacheInvalidation", $this.logging, this.cacheInvalidationConsumer(), this.cacheInvalidationConsumer().maxPeek(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second(), (Function1<byte[], Future<BoxedUnit>>)(Function1 & Serializable & scala.Serializable)bytes -> this.removeFromLocalCache((byte[])bytes), MessageFeed$.MODULE$.$lessinit$greater$default$7(), MessageFeed$.MODULE$.$lessinit$greater$default$8()), ClassTag$.MODULE$.apply(MessageFeed.class)));
    }
}

