/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwhisk.core.database;

import akka.event.Logging$;
import akka.stream.Graph;
import akka.stream.SinkShape;
import akka.stream.UniformFanOutShape;
import akka.stream.scaladsl.Broadcast$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.util.ByteString;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.security.MessageDigest;
import org.apache.openwhisk.common.Logging;
import org.apache.openwhisk.common.StartMarker;
import org.apache.openwhisk.common.TransactionId$;
import org.apache.openwhisk.common.TransactionMetadata;
import org.apache.openwhisk.core.database.ArtifactStoreException;
import org.apache.openwhisk.core.database.DocumentTypeMismatchException;
import org.apache.openwhisk.core.database.StoreUtils;
import org.apache.openwhisk.core.entity.DocInfo;
import org.apache.openwhisk.core.entity.DocRevision$;
import org.apache.openwhisk.core.entity.DocumentReader;
import org.apache.openwhisk.core.entity.WhiskDocument;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spray.json.DefaultJsonProtocol$;
import spray.json.JsObject;
import spray.json.JsValue;
import spray.json.JsonReader;
import spray.json.RootJsonFormat;

public final class StoreUtils$ {
    public static StoreUtils$ MODULE$;
    private final String digestAlgo;
    private final String encodedAlgoName;

    static {
        new StoreUtils$();
    }

    private String digestAlgo() {
        return this.digestAlgo;
    }

    private String encodedAlgoName() {
        return this.encodedAlgoName;
    }

    public <T> Future<T> reportFailure(Future<T> f, StartMarker start, Function1<Throwable, String> failureMessage, TransactionMetadata transid, Logging logging, ExecutionContext ec) {
        f.failed().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StoreUtils$.$anonfun$reportFailure$1(start, failureMessage, transid, logging, x0$1);
            return BoxedUnit.UNIT;
        }, ec);
        return f;
    }

    public void checkDocHasRevision(DocInfo doc) {
        Predef$.MODULE$.require(doc != null, (Function0 & Serializable & scala.Serializable)() -> "doc undefined");
        Predef$.MODULE$.require(doc.rev() != null, (Function0 & Serializable & scala.Serializable)() -> "doc revision must be specified");
    }

    /*
     * Unable to fully structure code
     */
    public <A extends DocumentAbstraction, DocumentAbstraction> A deserialize(DocInfo doc, JsObject js, DocumentReader docReader, Manifest<A> ma, RootJsonFormat<DocumentAbstraction> jsonFormat) {
        try {
            v0 = docReader.read(ma, (JsValue)js);
        }
        catch (Exception v1) {
            v0 = jsonFormat.read((JsValue)js);
        }
        asFormat = v0;
        v2 = asFormat.getClass();
        var7_7 = ma.runtimeClass();
        if (v2 == null ? var7_7 != null : v2.equals(var7_7) == false) {
            throw new DocumentTypeMismatchException(new StringBuilder(44).append("document type ").append(asFormat.getClass()).append(" did not match expected type ").append(ma.runtimeClass()).append(".").toString());
        }
        deserialized = asFormat;
        responseRev = (String)((JsValue)js.fields().apply((Object)"_rev")).convertTo((JsonReader)DefaultJsonProtocol$.MODULE$.StringJsonFormat());
        if (doc.rev() == null) ** GOTO lbl-1000
        v3 = doc.rev();
        var10_10 = responseRev;
        if (!(v3 != null ? v3.equals(var10_10) == false : var10_10 != null)) lbl-1000:
        // 2 sources

        {
            v4 = true;
        } else {
            v4 = false;
        }
        Predef$.MODULE$.assert(v4, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$deserialize$1(), ()Ljava/lang/String;)());
        return (A)((WhiskDocument)deserialized).revision(DocRevision$.MODULE$.apply(responseRev));
    }

    public <T> Sink<ByteString, Future<StoreUtils.AttachmentUploadResult<T>>> combinedSink(Sink<ByteString, Future<T>> dest, ExecutionContext ec) {
        return Sink$.MODULE$.fromGraph(GraphDSL$.MODULE$.create(this.digestSink(), this.lengthSink(), dest, (Function3 & Serializable & scala.Serializable)(digest, length, upload) -> MODULE$.combineResult((Future<String>)digest, (Future<Object>)length, (Future)upload, ec), (Function1 & Serializable & scala.Serializable)builder -> (Function3 & Serializable & scala.Serializable)(dgs, ls, dests) -> {
            UniformFanOutShape bcast = (UniformFanOutShape)builder.add((Graph)Broadcast$.MODULE$.apply(3, Broadcast$.MODULE$.apply$default$2()));
            GraphDSL.Implicits$.MODULE$.fanOut2flow(bcast, builder).$tilde$greater(dgs.in(), builder);
            GraphDSL.Implicits$.MODULE$.fanOut2flow(bcast, builder).$tilde$greater(ls.in(), builder);
            GraphDSL.Implicits$.MODULE$.fanOut2flow(bcast, builder).$tilde$greater(dests.in(), builder);
            return new SinkShape(bcast.in());
        }));
    }

    public MessageDigest emptyDigest() {
        return MessageDigest.getInstance(this.digestAlgo());
    }

    public String encodeDigest(byte[] bytes) {
        String digest = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).map((Function1 & Serializable & scala.Serializable)x$1 -> StoreUtils$.$anonfun$encodeDigest$1(BoxesRunTime.unboxToByte((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString();
        return new StringBuilder(1).append(this.encodedAlgoName()).append("-").append(digest).toString();
    }

    private <T> Future<StoreUtils.AttachmentUploadResult<T>> combineResult(Future<String> digest, Future<Object> length, Future<T> upload, ExecutionContext ec) {
        return digest.flatMap((Function1 & Serializable & scala.Serializable)d -> length.flatMap((Function1 & Serializable & scala.Serializable)l -> upload.map((Function1 & Serializable & scala.Serializable)u -> new StoreUtils.AttachmentUploadResult<Object>(d$1, l, u), ec), ec), ec);
    }

    private Sink<ByteString, Future<String>> digestSink() {
        return ((Flow)Flow$.MODULE$.apply().fold((Object)this.emptyDigest(), (Function2 & Serializable & scala.Serializable)(digest, bytes) -> {
            digest.update((byte[])bytes.toArray(ClassTag$.MODULE$.Byte()));
            return digest;
        }).map((Function1 & Serializable & scala.Serializable)md -> MODULE$.encodeDigest(md.digest()))).toMat((Graph)Sink$.MODULE$.head(), Keep$.MODULE$.right());
    }

    private Sink<ByteString, Future<Object>> lengthSink() {
        return Sink$.MODULE$.fold((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(length, bytes) -> BoxesRunTime.boxToLong((long)StoreUtils$.$anonfun$lengthSink$1(BoxesRunTime.unboxToLong((Object)length), bytes)));
    }

    public static final /* synthetic */ void $anonfun$reportFailure$1(StartMarker start$1, Function1 failureMessage$1, TransactionMetadata transid$1, Logging logging$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof ArtifactStoreException) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            TransactionId$.MODULE$.failed$extension(transid$1, MODULE$, start$1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(3).append(failureMessage$1.apply((Object)throwable)).append(" [").append(throwable.getClass().getSimpleName()).append("]").toString(), Logging$.MODULE$.ErrorLevel(), logging$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ String $anonfun$deserialize$1() {
        return "Returned revision should match original argument";
    }

    public static final /* synthetic */ String $anonfun$encodeDigest$1(byte x$1) {
        return new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$1)}));
    }

    public static final /* synthetic */ long $anonfun$lengthSink$1(long length, ByteString bytes) {
        return length + (long)bytes.size();
    }

    private StoreUtils$() {
        MODULE$ = this;
        this.digestAlgo = "SHA-256";
        this.encodedAlgoName = new StringOps(Predef$.MODULE$.augmentString(this.digestAlgo().toLowerCase())).replaceAllLiterally("-", "");
    }
}

