/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwhisk.core.database;

import java.io.Serializable;
import org.apache.openwhisk.core.database.SimpleHandler;
import org.apache.openwhisk.core.database.UnsupportedQueryKeys;
import org.apache.openwhisk.core.database.UnsupportedView;
import org.apache.openwhisk.core.entity.EntityPath$;
import org.apache.openwhisk.utils.JsHelpers$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import spray.json.JsArray;
import spray.json.JsFalse$;
import spray.json.JsObject;
import spray.json.JsObject$;
import spray.json.JsString;
import spray.json.JsValue;

public final class WhisksHandler$
extends SimpleHandler {
    public static WhisksHandler$ MODULE$;
    private final String ROOT_NS;
    private final Set<String> commonFields;
    private final Set<String> actionFields;
    private final Set<String> packageFields;
    private final Set<String> packagePublicFields;
    private final Set<String> ruleFields;
    private final Set<String> triggerFields;
    private final Set<String> supportedTables;

    static {
        new WhisksHandler$();
    }

    public String ROOT_NS() {
        return this.ROOT_NS;
    }

    private Set<String> commonFields() {
        return this.commonFields;
    }

    private Set<String> actionFields() {
        return this.actionFields;
    }

    private Set<String> packageFields() {
        return this.packageFields;
    }

    private Set<String> packagePublicFields() {
        return this.packagePublicFields;
    }

    private Set<String> ruleFields() {
        return this.ruleFields;
    }

    private Set<String> triggerFields() {
        return this.triggerFields;
    }

    @Override
    public Set<String> supportedTables() {
        return this.supportedTables;
    }

    @Override
    public JsObject computedFields(JsObject js) {
        JsObject jsObject;
        Some some;
        JsValue jsValue;
        Option option = js.fields().get((Object)"namespace");
        if (option instanceof Some && (jsValue = (JsValue)(some = (Some)option).value()) instanceof JsString) {
            JsString jsString = (JsString)jsValue;
            String namespace = jsString.value();
            String[] ns = namespace.split(EntityPath$.MODULE$.PATHSEP());
            String rootNS = ns.length > 1 ? ns[0] : namespace;
            jsObject = JsObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.ROOT_NS(), (Object)new JsString(rootNS))}));
        } else {
            jsObject = JsObject$.MODULE$.empty();
        }
        return jsObject;
    }

    @Override
    public Set<String> fieldsRequiredForView(String ddoc, String view) {
        Set<String> set;
        String string = view;
        if ("actions".equals(string)) {
            set = this.actionFields();
        } else if ("packages".equals(string)) {
            set = this.packageFields();
        } else if ("packages-public".equals(string)) {
            set = this.packagePublicFields();
        } else if ("rules".equals(string)) {
            set = this.ruleFields();
        } else if ("triggers".equals(string)) {
            set = this.triggerFields();
        } else {
            throw new UnsupportedView(new StringBuilder(1).append(ddoc).append("/").append(view).toString());
        }
        return set;
    }

    @Override
    public JsObject computeView(String ddoc, String view, JsObject js) {
        JsObject jsObject;
        String string = view;
        if ("actions".equals(string)) {
            jsObject = this.computeActionView(js);
        } else if ("packages".equals(string)) {
            jsObject = this.computePackageView(js);
        } else if ("packages-public".equals(string)) {
            jsObject = this.computePublicPackageView(js);
        } else if ("rules".equals(string)) {
            jsObject = this.computeRulesView(js);
        } else if ("triggers".equals(string)) {
            jsObject = this.computeTriggersView(js);
        } else {
            throw new UnsupportedView(new StringBuilder(1).append(ddoc).append("/").append(view).toString());
        }
        return jsObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsArray createKey(String ddoc, String view, List<Object> startKey, JsObject js) {
        boolean bl = false;
        .colon.colon colon2 = null;
        List<Object> list = startKey;
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            Object ns = colon2.head();
            List list2 = colon2.tl$access$1();
            if (ns instanceof String) {
                String string = (String)ns;
                if (Nil$.MODULE$.equals(list2)) {
                    return new JsArray((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsString[]{new JsString(string)})));
                }
            }
        }
        if (!bl) throw new UnsupportedQueryKeys("$ddoc/$view -> ($startKey, $endKey)");
        Object ns = colon2.head();
        List list3 = colon2.tl$access$1();
        if (!(ns instanceof String)) throw new UnsupportedQueryKeys("$ddoc/$view -> ($startKey, $endKey)");
        String string = (String)ns;
        if (!(list3 instanceof .colon.colon)) throw new UnsupportedQueryKeys("$ddoc/$view -> ($startKey, $endKey)");
        .colon.colon colon3 = (.colon.colon)list3;
        List list4 = colon3.tl$access$1();
        if (!Nil$.MODULE$.equals(list4)) throw new UnsupportedQueryKeys("$ddoc/$view -> ($startKey, $endKey)");
        return new JsArray((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsValue[]{new JsString(string), (JsValue)js.fields().apply((Object)"updated")})));
    }

    public String getEntityTypeForDesignDoc(String ddoc, String view) {
        String string;
        String string2 = view;
        if ("actions".equals(string2)) {
            string = "action";
        } else if ("rules".equals(string2)) {
            string = "rule";
        } else if ("triggers".equals(string2)) {
            string = "trigger";
        } else {
            boolean bl = "packages".equals(string2) ? true : "packages-public".equals(string2);
            if (bl) {
                string = "package";
            } else {
                throw new UnsupportedView(new StringBuilder(1).append(ddoc).append("/").append(view).toString());
            }
        }
        return string;
    }

    private JsObject computeTriggersView(JsObject js) {
        return new JsObject(js.fields().filterKeys(this.commonFields()));
    }

    private JsObject computePublicPackageView(JsObject js) {
        return new JsObject(js.fields().filterKeys(this.commonFields()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"binding"), (Object)JsFalse$.MODULE$)));
    }

    private JsObject computeRulesView(JsObject js) {
        return new JsObject(js.fields().filterKeys(this.ruleFields()));
    }

    private JsObject computePackageView(JsObject js) {
        JsObject jsObject;
        Some some;
        JsValue x;
        Map common = js.fields().filterKeys(this.commonFields());
        Option option = js.fields().get((Object)"binding");
        Object object = option instanceof Some && (x = (JsValue)(some = (Some)option).value()) instanceof JsObject && (jsObject = (JsObject)x).fields().nonEmpty() ? jsObject : JsFalse$.MODULE$;
        JsFalse$ binding = object;
        return new JsObject(common.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"binding"), (Object)binding)));
    }

    private JsObject computeActionView(JsObject js) {
        Map base = js.fields().filterKeys((Function1)this.commonFields().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"limits"}))));
        Option<JsValue> exec_binary = JsHelpers$.MODULE$.getFieldPath(js, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exec", "binary"}));
        return new JsObject(base.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exec"), (Object)JsObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"binary"), exec_binary.getOrElse((Function0 & Serializable & scala.Serializable)() -> JsFalse$.MODULE$))})))));
    }

    private WhisksHandler$() {
        MODULE$ = this;
        this.ROOT_NS = "rootns";
        this.commonFields = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"namespace", "name", "version", "publish", "annotations", "updated"}));
        this.actionFields = (Set)this.commonFields().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"limits", "exec.binary"})));
        this.packageFields = (Set)this.commonFields().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"binding"})));
        this.packagePublicFields = this.commonFields();
        this.ruleFields = this.commonFields();
        this.triggerFields = this.commonFields();
        this.supportedTables = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"whisks.v2.1.0/actions", "whisks.v2.1.0/packages", "whisks.v2.1.0/packages-public", "whisks.v2.1.0/rules", "whisks.v2.1.0/triggers"}));
    }
}

