/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwhisk.core.database.s3;

import akka.Done;
import akka.actor.ActorSystem;
import akka.http.scaladsl.model.ContentType;
import akka.stream.ActorMaterializer;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.alpakka.s3.S3Exception;
import akka.stream.alpakka.s3.scaladsl.S3Client;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import java.io.Serializable;
import org.apache.openwhisk.common.Logging;
import org.apache.openwhisk.common.LoggingMarkers$;
import org.apache.openwhisk.common.StartMarker;
import org.apache.openwhisk.common.TransactionId$;
import org.apache.openwhisk.common.TransactionMetadata;
import org.apache.openwhisk.core.database.AttachResult;
import org.apache.openwhisk.core.database.AttachmentStore;
import org.apache.openwhisk.core.database.NoDocumentException;
import org.apache.openwhisk.core.database.StoreUtils$;
import org.apache.openwhisk.core.entity.DocId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0001\u0003\u0001=\u0011\u0011cU\u001aBiR\f7\r[7f]R\u001cFo\u001c:f\u0015\t\u0019A!\u0001\u0002tg)\u0011QAB\u0001\tI\u0006$\u0018MY1tK*\u0011q\u0001C\u0001\u0005G>\u0014XM\u0003\u0002\n\u0015\u0005Iq\u000e]3oo\"L7o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/ai\u0011\u0001B\u0005\u00033\u0011\u0011q\"\u0011;uC\u000eDW.\u001a8u'R|'/\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u000511\r\\5f]R\u0004\"!H\u0014\u000e\u0003yQ!a\b\u0011\u0002\u0011M\u001c\u0017\r\\1eg2T!aA\u0011\u000b\u0005\t\u001a\u0013aB1ma\u0006\\7.\u0019\u0006\u0003I\u0015\naa\u001d;sK\u0006l'\"\u0001\u0014\u0002\t\u0005\\7.Y\u0005\u0003Qy\u0011\u0001bU\u001aDY&,g\u000e\u001e\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u00051!-^2lKR\u0004\"\u0001L\u001a\u000f\u00055\n\u0004C\u0001\u0018\u0013\u001b\u0005y#B\u0001\u0019\u000f\u0003\u0019a$o\\8u}%\u0011!GE\u0001\u0007!J,G-\u001a4\n\u0005Q*$AB*ue&twM\u0003\u00023%!Aq\u0007\u0001B\u0001B\u0003%1&\u0001\u0004qe\u00164\u0017\u000e\u001f\u0005\ts\u0001\u0011\t\u0011)A\u0006u\u000511/_:uK6\u0004\"a\u000f \u000e\u0003qR!!P\u0013\u0002\u000b\u0005\u001cGo\u001c:\n\u0005}b$aC!di>\u00148+_:uK6D\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006YAQ\u0001\bY><w-\u001b8h!\t\u0019e)D\u0001E\u0015\t)\u0005\"\u0001\u0004d_6lwN\\\u0005\u0003\u000f\u0012\u0013q\u0001T8hO&tw\r\u0003\u0005J\u0001\t\u0005\t\u0015a\u0003K\u00031i\u0017\r^3sS\u0006d\u0017N_3s!\tYE*D\u0001$\u0013\ti5EA\tBGR|'/T1uKJL\u0017\r\\5{KJDQa\u0014\u0001\u0005\u0002A\u000ba\u0001P5oSRtD\u0003B)X1f#BA\u0015+V-B\u00111\u000bA\u0007\u0002\u0005!)\u0011H\u0014a\u0002u!)\u0011I\u0014a\u0002\u0005\")\u0011J\u0014a\u0002\u0015\")1D\u0014a\u00019!)!F\u0014a\u0001W!)qG\u0014a\u0001W!91\f\u0001b\u0001\n\u0003b\u0016AB:dQ\u0016lW-F\u0001^!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0003mC:<'\"\u00012\u0002\t)\fg/Y\u0005\u0003i}Ca!\u001a\u0001!\u0002\u0013i\u0016aB:dQ\u0016lW\r\t\u0005\tO\u0002\u0011\r\u0011b\u0015\u0007Q\u0006\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010^\u000b\u0002SB\u0011!.\\\u0007\u0002W*\u0011ANE\u0001\u000bG>t7-\u001e:sK:$\u0018B\u00018l\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0003\u0004q\u0001\u0001\u0006I![\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0003B\u0002:\u0001\t#21/\u0001\u0004biR\f7\r\u001b\u000b\ni\u0006\u0005\u0011\u0011CA\u000b\u0003W!\"!^>\u0011\u0007)4\b0\u0003\u0002xW\n1a)\u001e;ve\u0016\u0004\"aF=\n\u0005i$!\u0001D!ui\u0006\u001c\u0007NU3tk2$\b\"\u0002?r\u0001\bi\u0018a\u0002;sC:\u001c\u0018\u000e\u001a\t\u0003\u0007zL!a #\u0003\u001bQ\u0013\u0018M\\:bGRLwN\\%e\u0011\u001d\t\u0019!\u001da\u0001\u0003\u000b\tQ\u0001Z8d\u0013\u0012\u0004B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u00171\u0011AB3oi&$\u00180\u0003\u0003\u0002\u0010\u0005%!!\u0002#pG&#\u0007BBA\nc\u0002\u00071&\u0001\u0003oC6,\u0007bBA\fc\u0002\u0007\u0011\u0011D\u0001\fG>tG/\u001a8u)f\u0004X\r\u0005\u0003\u0002\u001c\u0005\u001dRBAA\u000f\u0015\u0011\ty\"!\t\u0002\u000b5|G-\u001a7\u000b\u0007}\t\u0019CC\u0002\u0002&\u0015\nA\u0001\u001b;ua&!\u0011\u0011FA\u000f\u0005-\u0019uN\u001c;f]R$\u0016\u0010]3\t\u000f\u00055\u0012\u000f1\u0001\u00020\u0005IAm\\2TiJ,\u0017-\u001c\u0019\u0005\u0003c\tY\u0005\u0005\u0005\u00024\u0005]\u00121HA$\u001b\t\t)D\u0003\u0002 G%!\u0011\u0011HA\u001b\u0005\u0019\u0019v.\u001e:dKB!\u0011QHA\"\u001b\t\tyDC\u0002\u0002B\u0015\nA!\u001e;jY&!\u0011QIA \u0005)\u0011\u0015\u0010^3TiJLgn\u001a\t\u0005\u0003\u0013\nY\u0005\u0004\u0001\u0005\u0019\u00055\u00131FA\u0001\u0002\u0003\u0015\t!a\u0014\u0003\u0007}#\u0013'\u0005\u0003\u0002R\u0005]\u0003cA\t\u0002T%\u0019\u0011Q\u000b\n\u0003\u000f9{G\u000f[5oOB\u0019\u0011#!\u0017\n\u0007\u0005m#CA\u0002B]fD\u0001\"a\u0018\u0001\t#2\u0011\u0011M\u0001\u000fe\u0016\fG-\u0011;uC\u000eDW.\u001a8u+\u0011\t\u0019'a\u001b\u0015\u0011\u0005\u0015\u0014\u0011OA:\u0003k\"B!a\u001a\u0002pA!!N^A5!\u0011\tI%a\u001b\u0005\u0011\u00055\u0014Q\fb\u0001\u0003\u001f\u0012\u0011\u0001\u0016\u0005\u0007y\u0006u\u00039A?\t\u0011\u0005\r\u0011Q\fa\u0001\u0003\u000bAq!a\u0005\u0002^\u0001\u00071\u0006\u0003\u0005\u0002x\u0005u\u0003\u0019AA=\u0003\u0011\u0019\u0018N\\6\u0011\u0011\u0005M\u00121PA\u001e\u0003OJA!! \u00026\t!1+\u001b8l\u0011!\t\t\t\u0001C)\r\u0005\r\u0015!\u00053fY\u0016$X-\u0011;uC\u000eDW.\u001a8ugR!\u0011QQAI)\u0011\t9)a$\u0011\t)4\u0018\u0011\u0012\t\u0004#\u0005-\u0015bAAG%\t9!i\\8mK\u0006t\u0007B\u0002?\u0002\u0000\u0001\u000fQ\u0010\u0003\u0005\u0002\u0004\u0005}\u0004\u0019AA\u0003\u0011!\t)\n\u0001C)\r\u0005]\u0015\u0001\u00053fY\u0016$X-\u0011;uC\u000eDW.\u001a8u)\u0019\tI*!(\u0002 R!\u0011qQAN\u0011\u0019a\u00181\u0013a\u0002{\"A\u00111AAJ\u0001\u0004\t)\u0001C\u0004\u0002\u0014\u0005M\u0005\u0019A\u0016\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\u0006A1\u000f[;uI><h\u000e\u0006\u0002\u0002(B\u0019\u0011#!+\n\u0007\u0005-&C\u0001\u0003V]&$\bbBAX\u0001\u0011%\u0011\u0011W\u0001\n_\nTWm\u0019;LKf$RaKAZ\u0003oC\u0001\"!.\u0002.\u0002\u0007\u0011QA\u0001\u0003S\u0012Dq!a\u0005\u0002.\u0002\u00071\u0006C\u0004\u0002<\u0002!I!!0\u0002\u001f=\u0014'.Z2u\u0017\u0016L\bK]3gSb$2aKA`\u0011!\t),!/A\u0002\u0005\u0015\u0001bBAb\u0001\u0011%\u0011QY\u0001\u0016SNl\u0015n]:j]\u001e\\U-_#yG\u0016\u0004H/[8o)\u0011\tI)a2\t\u0011\u0005%\u0017\u0011\u0019a\u0001\u0003\u0017\f\u0011!\u001a\t\u0005\u0003\u001b\f9N\u0004\u0003\u0002P\u0006Mgb\u0001\u0018\u0002R&\t1#C\u0002\u0002VJ\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002Z\u0006m'!\u0003+ie><\u0018M\u00197f\u0015\r\t)N\u0005")
public class S3AttachmentStore
implements AttachmentStore {
    private final S3Client client;
    private final String bucket;
    private final String prefix;
    private final Logging logging;
    private final ActorMaterializer materializer;
    private final String scheme;
    private final ExecutionContext executionContext;

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public Future<AttachResult> attach(String docId, String name, ContentType contentType, Source<ByteString, ?> docStream, TransactionMetadata transid) {
        Predef$.MODULE$.require(name != null, (Function0 & Serializable & scala.Serializable)() -> "name undefined");
        StartMarker start = TransactionId$.MODULE$.started$extension(transid, this, LoggingMarkers$.MODULE$.DATABASE_ATT_SAVE(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("[ATT_PUT] uploading attachment '").append(name).append("' of document 'id: ").append(new DocId(docId)).append("'").toString(), TransactionId$.MODULE$.started$default$4$extension(transid), this.logging);
        Future f = ((Future)docStream.runWith(StoreUtils$.MODULE$.combinedSink(this.client.multipartUpload(this.bucket, this.objectKey(docId, name), contentType, this.client.multipartUpload$default$4(), this.client.multipartUpload$default$5(), this.client.multipartUpload$default$6(), this.client.multipartUpload$default$7(), this.client.multipartUpload$default$8()), this.executionContext()), (Materializer)this.materializer)).map((Function1 & Serializable & scala.Serializable)r -> new AttachResult(r.digest(), r.length()), this.executionContext());
        f.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            TransactionId$.MODULE$.finished$extension(transid, this, start, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("[ATT_PUT] '").append($this.prefix).append("' completed uploading attachment '").append(name$1).append("' of document 'id: ").append(new DocId(docId$1)).append("'").toString(), TransactionId$.MODULE$.finished$default$4$extension(transid), TransactionId$.MODULE$.finished$default$5$extension(transid), this.logging);
            return BoxedUnit.UNIT;
        }, this.executionContext());
        return StoreUtils$.MODULE$.reportFailure(f, start, (Function1<Throwable, String>)(Function1 & Serializable & scala.Serializable)failure -> new StringBuilder(59).append("[ATT_PUT] '").append($this.prefix).append("' internal error, name: '").append(name).append("', doc: '").append(new DocId(docId)).append("', failure: '").append(failure.getMessage()).append("'").toString(), transid, this.logging, this.executionContext());
    }

    @Override
    public <T> Future<T> readAttachment(String docId, String name, Sink<ByteString, Future<T>> sink, TransactionMetadata transid) {
        Source source;
        Predef$.MODULE$.require(name != null, (Function0 & Serializable & scala.Serializable)() -> "name undefined");
        StartMarker start = TransactionId$.MODULE$.started$extension(transid, this, LoggingMarkers$.MODULE$.DATABASE_ATT_GET(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("[ATT_GET] '").append($this.prefix).append("' finding attachment '").append(name).append("' of document 'id: ").append(new DocId(docId)).append("'").toString(), TransactionId$.MODULE$.started$default$4$extension(transid), this.logging);
        Tuple2 tuple2 = this.client.download(this.bucket, this.objectKey(docId, name), this.client.download$default$3(), this.client.download$default$4());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Source source2 = source = (Source)tuple2._1();
        Source source3 = source2;
        Future f = (Future)source3.runWith(sink, (Materializer)this.materializer);
        Future g = f.transform((Function1 & Serializable & scala.Serializable)s -> {
            TransactionId$.MODULE$.finished$extension(transid, this, start, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("[ATT_GET] '").append($this.prefix).append("' completed: found attachment '").append(name).append("' of document 'id: ").append(new DocId(docId)).append("'").toString(), TransactionId$.MODULE$.finished$default$4$extension(transid), TransactionId$.MODULE$.finished$default$5$extension(transid), $this.logging);
            return s;
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable;
            Throwable throwable2;
            Throwable throwable3 = x0$1;
            if (throwable3 != null && this.isMissingKeyException(throwable2 = throwable3)) {
                TransactionId$.MODULE$.finished$extension(transid, this, start, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("[ATT_GET] '").append($this.prefix).append("', retrieving attachment '").append(name).append("' of document 'id: ").append(new DocId(docId)).append("'; not found.").toString(), TransactionId$.MODULE$.finished$default$4$extension(transid), TransactionId$.MODULE$.finished$default$5$extension(transid), $this.logging);
                throwable = new NoDocumentException("Not found on 'readAttachment'.");
            } else {
                throwable = throwable3;
            }
            return throwable;
        }, this.executionContext());
        return StoreUtils$.MODULE$.reportFailure(g, start, (Function1<Throwable, String>)(Function1 & Serializable & scala.Serializable)failure -> new StringBuilder(63).append("[ATT_GET] '").append($this.prefix).append("' internal error, name: '").append(name).append("', doc: 'id: ").append(new DocId(docId)).append("', failure: '").append(failure.getMessage()).append("'").toString(), transid, this.logging, this.executionContext());
    }

    @Override
    public Future<Object> deleteAttachments(String docId, TransactionMetadata transid) {
        StartMarker start = TransactionId$.MODULE$.started$extension(transid, this, LoggingMarkers$.MODULE$.DATABASE_ATTS_DELETE(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("[ATT_DELETE] deleting attachments of document 'id: ").append(new DocId(docId)).append("'").toString(), TransactionId$.MODULE$.started$default$4$extension(transid), this.logging);
        Future f = ((Future)((Source)this.client.listBucket(this.bucket, (Option)new Some((Object)this.objectKeyPrefix(docId))).mapAsync(1, (Function1 & Serializable & scala.Serializable)bc -> $this.client.deleteObject(bc.bucketName(), bc.key()))).runWith((Graph)Sink$.MODULE$.seq(), (Materializer)this.materializer)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)S3AttachmentStore.$anonfun$deleteAttachments$3(x$2)), this.executionContext());
        f.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            TransactionId$.MODULE$.finished$extension(transid, this, start, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("[ATTS_DELETE] completed: deleting attachments of document 'id: ").append(new DocId(docId$3)).append("'").toString(), TransactionId$.MODULE$.finished$default$4$extension(transid), TransactionId$.MODULE$.finished$default$5$extension(transid), this.logging);
            return BoxedUnit.UNIT;
        }, this.executionContext());
        return StoreUtils$.MODULE$.reportFailure(f, start, (Function1<Throwable, String>)(Function1 & Serializable & scala.Serializable)failure -> new StringBuilder(53).append("[ATTS_DELETE] '").append($this.prefix).append("' internal error, doc: '").append(new DocId(docId)).append("', failure: '").append(failure.getMessage()).append("'").toString(), transid, this.logging, this.executionContext());
    }

    @Override
    public Future<Object> deleteAttachment(String docId, String name, TransactionMetadata transid) {
        StartMarker start = TransactionId$.MODULE$.started$extension(transid, this, LoggingMarkers$.MODULE$.DATABASE_ATT_DELETE(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("[ATT_DELETE] deleting attachment '").append(name).append("' of document 'id: ").append(new DocId(docId)).append("'").toString(), TransactionId$.MODULE$.started$default$4$extension(transid), this.logging);
        Future f = this.client.deleteObject(this.bucket, this.objectKey(docId, name)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)S3AttachmentStore.$anonfun$deleteAttachment$2(x$4)), this.executionContext());
        f.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            TransactionId$.MODULE$.finished$extension(transid, this, start, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("[ATT_DELETE] completed: deleting attachment '").append(name$3).append("' of document 'id: ").append(new DocId(docId$4)).append("'").toString(), TransactionId$.MODULE$.finished$default$4$extension(transid), TransactionId$.MODULE$.finished$default$5$extension(transid), this.logging);
            return BoxedUnit.UNIT;
        }, this.executionContext());
        return StoreUtils$.MODULE$.reportFailure(f, start, (Function1<Throwable, String>)(Function1 & Serializable & scala.Serializable)failure -> new StringBuilder(52).append("[ATT_DELETE] '").append($this.prefix).append("' internal error, doc: '").append(new DocId(docId)).append("', failure: '").append(failure.getMessage()).append("'").toString(), transid, this.logging, this.executionContext());
    }

    @Override
    public void shutdown() {
    }

    private String objectKey(String id, String name) {
        return new StringBuilder(2).append(this.prefix).append("/").append(id).append("/").append(name).toString();
    }

    private String objectKeyPrefix(String id) {
        return new StringBuilder(1).append(this.prefix).append("/").append(id).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMissingKeyException(Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof S3Exception) {
            S3Exception s3Exception = (S3Exception)throwable;
            String string = s3Exception.code();
            String string2 = "NoSuchKey";
            if (string == null) {
                if (string2 == null) return true;
            } else if (string.equals(string2)) {
                return true;
            }
        }
        if (throwable == null) return false;
        if (!this.isMissingKeyException(throwable.getCause())) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$deleteAttachments$3(Seq x$2) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$deleteAttachment$2(Done x$4) {
        return true;
    }

    public S3AttachmentStore(S3Client client, String bucket, String prefix, ActorSystem system, Logging logging, ActorMaterializer materializer) {
        this.client = client;
        this.bucket = bucket;
        this.prefix = prefix;
        this.logging = logging;
        this.materializer = materializer;
        this.scheme = "s3";
        this.executionContext = system.dispatcher();
        S3AttachmentStore x$6 = this;
        Function0 & Serializable & scala.Serializable x$7 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Initializing S3AttachmentStore with bucket=[").append($this.bucket).append("], prefix=[").append($this.prefix).append("]").toString();
        TransactionMetadata x$8 = logging.info$default$3(x$6, (Function0<String>)x$7);
        logging.info(x$6, (Function0<String>)x$7, x$8);
    }
}

