/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwhisk.http;

import akka.http.scaladsl.model.MediaType;
import org.apache.openwhisk.core.entity.ActivationId;
import org.apache.openwhisk.core.entity.ByteSize;
import org.apache.openwhisk.core.entity.Exec;
import org.apache.openwhisk.core.entity.ExecMetaDataBase;
import org.apache.openwhisk.core.entity.SizeError;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import spray.json.JsValue;

public final class Messages$ {
    public static Messages$ MODULE$;
    private final String conflictMessage;
    private final String conformanceMessage;
    private final String corruptedEntity;
    private final String resourceDoesNotExist;
    private final String systemOverloaded;
    private final String notAuthorizedtoOperateOnResource;
    private final String malformedFullyQualifiedEntityName;
    private final String entityNameIllegal;
    private final String namespaceIllegal;
    private final String activationIdIllegal;
    private final String sequenceIsTooLong;
    private final String sequenceNoComponent;
    private final String sequenceIsCyclic;
    private final String sequenceComponentNotFound;
    private final String bindingDoesNotExist;
    private final String packageCannotBecomeBinding;
    private final String bindingCannotReferenceBinding;
    private final String requestedBindingIsNotValid;
    private final String notAllowedOnBinding;
    private final String sequenceActivationFailure;
    private final String compositionIsTooLong;
    private final String compositionActivationFailure;
    private final String parametersNotAllowed;
    private final String abnormalInitialization;
    private final String abnormalRun;
    private final String memoryExhausted;
    private final String docsNotAllowedWithCount;
    private final String logFailure;
    private final String propertyNotFound;
    private final String unsupportedContentType;
    private final String errorExtractingRequestBody;
    private final String responseNotReady;
    private final String httpUnknownContentType;
    private final String httpContentTypeError;
    private final String errorProcessingRequest;
    private final String namespacesBlacklisted;
    private final String actionRemovedWhileInvoking;
    private final String actionMismatchWhileInvoking;
    private final String actionFetchErrorWhileInvoking;
    private final String resourceProvisionError;

    static {
        new Messages$();
    }

    public String conflictMessage() {
        return this.conflictMessage;
    }

    public String conformanceMessage() {
        return this.conformanceMessage;
    }

    public String corruptedEntity() {
        return this.corruptedEntity;
    }

    public String runtimeDeprecated(Exec e) {
        return new StringBuilder(100).append("The '").append(e.kind()).append("' runtime is no longer supported. You may read and delete but not update or invoke this action.").toString();
    }

    public String runtimeDeprecated(ExecMetaDataBase e) {
        return new StringBuilder(100).append("The '").append(e.kind()).append("' runtime is no longer supported. You may read and delete but not update or invoke this action.").toString();
    }

    public String resourceDoesNotExist() {
        return this.resourceDoesNotExist;
    }

    public String resourceDoesntExist(String value) {
        return new StringBuilder(41).append("The requested resource '").append(value).append("' does not exist.").toString();
    }

    public String tooManyRequests(int count, int allowed) {
        return new StringBuilder(58).append("Too many requests in the last minute (count: ").append(count).append(", allowed: ").append(allowed).append(").").toString();
    }

    public String tooManyConcurrentRequests(int count, int allowed) {
        return new StringBuilder(60).append("Too many concurrent requests in flight (count: ").append(count).append(", allowed: ").append(allowed).append(").").toString();
    }

    public String systemOverloaded() {
        return this.systemOverloaded;
    }

    public String notAuthorizedtoOperateOnResource() {
        return this.notAuthorizedtoOperateOnResource;
    }

    public String notAuthorizedtoAccessResource(String value) {
        return new StringBuilder(59).append("The supplied authentication is not authorized to access '").append(value).append("'.").toString();
    }

    public String notAuthorizedtoActionKind(String value) {
        return new StringBuilder(75).append("The supplied authentication is not authorized to access actions of kind '").append(value).append("'.").toString();
    }

    public String malformedFullyQualifiedEntityName() {
        return this.malformedFullyQualifiedEntityName;
    }

    public String entityNameTooLong(SizeError error) {
        return new StringBuilder(26).append(error.field()).append(" longer than allowed: ").append(error.is().toBytes()).append(" > ").append(error.allowed().toBytes()).append(".").toString();
    }

    public String entityNameIllegal() {
        return this.entityNameIllegal;
    }

    public String namespaceIllegal() {
        return this.namespaceIllegal;
    }

    public String activationIdIllegal() {
        return this.activationIdIllegal;
    }

    public String activationIdLengthError(SizeError error) {
        return new StringBuilder(25).append(error.field()).append(" length is ").append(error.is().toBytes()).append(" but must be ").append(error.allowed().toBytes()).append(".").toString();
    }

    public String sequenceIsTooLong() {
        return this.sequenceIsTooLong;
    }

    public String sequenceNoComponent() {
        return this.sequenceNoComponent;
    }

    public String sequenceIsCyclic() {
        return this.sequenceIsCyclic;
    }

    public String sequenceComponentNotFound() {
        return this.sequenceComponentNotFound;
    }

    public String bindingDoesNotExist() {
        return this.bindingDoesNotExist;
    }

    public String packageCannotBecomeBinding() {
        return this.packageCannotBecomeBinding;
    }

    public String bindingCannotReferenceBinding() {
        return this.bindingCannotReferenceBinding;
    }

    public String requestedBindingIsNotValid() {
        return this.requestedBindingIsNotValid;
    }

    public String notAllowedOnBinding() {
        return this.notAllowedOnBinding;
    }

    public String packageNameIsReserved(String name) {
        return new StringBuilder(28).append("Package name '").append(name).append("' is reserved.").toString();
    }

    public String packageBindingCircularReference(String name) {
        return new StringBuilder(49).append("Package binding '").append(name).append("' contains a circular reference.").toString();
    }

    public String triggerWithInactiveRule(String rule, String action) {
        return new StringBuilder(49).append("Rule '").append(rule).append("' is inactive, action '").append(action).append("' was not activated.").toString();
    }

    public String sequenceRetrieveActivationTimeout(String id) {
        return new StringBuilder(67).append("Timeout reached when retrieving activation ").append(new ActivationId(id)).append(" for sequence component.").toString();
    }

    public String sequenceActivationFailure() {
        return this.sequenceActivationFailure;
    }

    public String compositionIsTooLong() {
        return this.compositionIsTooLong;
    }

    public String compositionActivationFailure() {
        return this.compositionActivationFailure;
    }

    public String compositionActivationTimeout(String id) {
        return new StringBuilder(63).append("Timeout reached when retrieving activation ").append(new ActivationId(id)).append(" during composition.").toString();
    }

    public String compositionComponentInvalid(JsValue value) {
        return new StringBuilder(64).append("Failed to parse action name from json value ").append(value).append(" during composition.").toString();
    }

    public String compositionComponentNotFound(String name) {
        return new StringBuilder(57).append("Failed to resolve action with name '").append(name).append("' during composition.").toString();
    }

    public String compositionComponentNotAccessible(String name) {
        return new StringBuilder(68).append("Failed entitlement check for action with name '").append(name).append("' during composition.").toString();
    }

    public String parametersNotAllowed() {
        return this.parametersNotAllowed;
    }

    public String invalidTimeout(FiniteDuration max) {
        return new StringBuilder(46).append("Timeout must be number of milliseconds up to ").append(max.toMillis()).append(".").toString();
    }

    public String abnormalInitialization() {
        return this.abnormalInitialization;
    }

    public String abnormalRun() {
        return this.abnormalRun;
    }

    public String memoryExhausted() {
        return this.memoryExhausted;
    }

    public String docsNotAllowedWithCount() {
        return this.docsNotAllowedWithCount;
    }

    public String badNameFilter(String value) {
        return new StringBuilder(64).append("Parameter may be a 'simple' name or 'package-name/simple' name: ").append(value).toString();
    }

    public String badEpoch(String value) {
        return new StringBuilder(50).append("Parameter is not a valid value for epoch seconds: ").append(value).toString();
    }

    public String entityTooBig(SizeError error) {
        return new StringBuilder(32).append(error.field()).append(" larger than allowed: ").append(error.is().toBytes()).append(" > ").append(error.allowed().toBytes()).append(" bytes.").toString();
    }

    public String listLimitOutOfRange(String collection, int value, int max) {
        return new StringBuilder(47).append("The value '").append(value).append("' is not in the range of 0 to ").append(max).append(" for ").append(collection).append(".").toString();
    }

    public String listSkipOutOfRange(String collection, int value) {
        return new StringBuilder(52).append("The value '").append(value).append("' is not greater than or equal to 0 for ").append(collection).append(".").toString();
    }

    public String argumentNotInteger(String collection, String value) {
        return new StringBuilder(36).append("The value '").append(value).append("' is not an integer for ").append(collection).append(".").toString();
    }

    public String truncateLogs(ByteSize limit) {
        return new StringBuilder(77).append("Logs were truncated because the total bytes size exceeds the limit of ").append(limit.toBytes()).append(" bytes.").toString();
    }

    public String logFailure() {
        return this.logFailure;
    }

    public String propertyNotFound() {
        return this.propertyNotFound;
    }

    public String invalidMedia(MediaType m) {
        return new StringBuilder(25).append("Response is not valid '").append(m.value()).append("'.").toString();
    }

    public String contentTypeExtensionNotSupported(Set<String> extensions) {
        return new StringBuilder(40).append("Extension must be specified and one of ").append(extensions.mkString("[", ", ", "]")).append(".").toString();
    }

    public String unsupportedContentType() {
        return this.unsupportedContentType;
    }

    public String unsupportedContentType(MediaType m) {
        return new StringBuilder(33).append("Content type '").append(m.value()).append("' is not supported.").toString();
    }

    public String errorExtractingRequestBody() {
        return this.errorExtractingRequestBody;
    }

    public String responseNotReady() {
        return this.responseNotReady;
    }

    public String httpUnknownContentType() {
        return this.httpUnknownContentType;
    }

    public String httpContentTypeError() {
        return this.httpContentTypeError;
    }

    public String errorProcessingRequest() {
        return this.errorProcessingRequest;
    }

    public String invalidInitResponse(String actualResponse) {
        return new StringBuilder(39).append("The action failed during initialization").append(Option$.MODULE$.apply((Object)actualResponse).filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Messages$.$anonfun$invalidInitResponse$1(x$1))).map((Function1 & java.io.Serializable & Serializable)s -> new StringBuilder(2).append(": ").append((String)s).toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> ".")).toString();
    }

    public String invalidRunResponse(String actualResponse) {
        return new StringBuilder(48).append("The action did not produce a valid JSON response").append(Option$.MODULE$.apply((Object)actualResponse).filter((Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Messages$.$anonfun$invalidRunResponse$1(x$2))).map((Function1 & java.io.Serializable & Serializable)s -> new StringBuilder(2).append(": ").append((String)s).toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> ".")).toString();
    }

    public String truncatedResponse(ByteSize length, ByteSize maxLength) {
        return new StringBuilder(75).append("The action produced a response that exceeded the allowed length: ").append(length.toBytes()).append(" > ").append(maxLength.toBytes()).append(" bytes.").toString();
    }

    public String truncatedResponse(String trunk, ByteSize length, ByteSize maxLength) {
        return new StringBuilder(29).append(this.truncatedResponse(length, maxLength)).append(" The truncated response was: ").append(trunk).toString();
    }

    public String timedoutActivation(Duration timeout, boolean init) {
        return new StringBuilder(52).append("The action exceeded its time limits of ").append(timeout.toMillis()).append(" milliseconds").append((Object)(!init ? "." : " during initialization.")).toString();
    }

    public String namespacesBlacklisted() {
        return this.namespacesBlacklisted;
    }

    public String actionRemovedWhileInvoking() {
        return this.actionRemovedWhileInvoking;
    }

    public String actionMismatchWhileInvoking() {
        return this.actionMismatchWhileInvoking;
    }

    public String actionFetchErrorWhileInvoking() {
        return this.actionFetchErrorWhileInvoking;
    }

    public String imagePullError(String image) {
        return new StringBuilder(34).append("Failed to pull container image '").append(image).append("'.").toString();
    }

    public String resourceProvisionError() {
        return this.resourceProvisionError;
    }

    public static final /* synthetic */ boolean $anonfun$invalidInitResponse$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$invalidRunResponse$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    private Messages$() {
        MODULE$ = this;
        this.conflictMessage = "Concurrent modification to resource detected.";
        this.conformanceMessage = "Resource by this name exists but is not in this collection.";
        this.corruptedEntity = "Resource is corrupted and cannot be read.";
        this.resourceDoesNotExist = "The requested resource does not exist.";
        this.systemOverloaded = "System is overloaded, try again later.";
        this.notAuthorizedtoOperateOnResource = "The supplied authentication is not authorized to access this resource.";
        this.malformedFullyQualifiedEntityName = "The fully qualified name of the entity must contain at least the namespace and the name of the entity.";
        this.entityNameIllegal = "The name of the entity contains illegal characters.";
        this.namespaceIllegal = "The namespace contains illegal characters.";
        this.activationIdIllegal = "The activation id is not valid.";
        this.sequenceIsTooLong = "Too many actions in the sequence.";
        this.sequenceNoComponent = "No component specified for the sequence.";
        this.sequenceIsCyclic = "Sequence may not refer to itself.";
        this.sequenceComponentNotFound = "Sequence component does not exist.";
        this.bindingDoesNotExist = "Binding references a package that does not exist.";
        this.packageCannotBecomeBinding = "Resource is a package and cannot be converted into a binding.";
        this.bindingCannotReferenceBinding = "Cannot bind to another package binding.";
        this.requestedBindingIsNotValid = "Cannot bind to a resource that is not a package.";
        this.notAllowedOnBinding = "Operation not permitted on package binding.";
        this.sequenceActivationFailure = "Sequence failed.";
        this.compositionIsTooLong = "Too many actions in the composition.";
        this.compositionActivationFailure = "Activation failure during composition.";
        this.parametersNotAllowed = "Request defines parameters that are not allowed (e.g., reserved properties).";
        this.abnormalInitialization = "The action did not initialize and exited unexpectedly.";
        this.abnormalRun = "The action did not produce a valid response and exited unexpectedly.";
        this.memoryExhausted = "The action exhausted its memory and was aborted.";
        this.docsNotAllowedWithCount = "The parameter 'docs' is not permitted with 'count'.";
        this.logFailure = "There was an issue while collecting your logs. Data might be missing.";
        this.propertyNotFound = "Response does not include requested property.";
        this.unsupportedContentType = "Content type is not supported.";
        this.errorExtractingRequestBody = "Failed extracting request body.";
        this.responseNotReady = "Response not yet ready.";
        this.httpUnknownContentType = "Response did not specify a known content-type.";
        this.httpContentTypeError = "Response type in header did not match generated content type.";
        this.errorProcessingRequest = "There was an error processing your request.";
        this.namespacesBlacklisted = "The action was not invoked due to a blacklisted namespace.";
        this.actionRemovedWhileInvoking = "Action could not be found or may have been deleted.";
        this.actionMismatchWhileInvoking = "Action version is not compatible and cannot be invoked.";
        this.actionFetchErrorWhileInvoking = "Action could not be fetched.";
        this.resourceProvisionError = "Failed to provision resources to run the action.";
    }
}

