/*
 * Copyright 2018 NAVER Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.navercorp.pinpoint.batch.common;

import org.springframework.batch.item.ExecutionContext;

import java.util.HashMap;
import java.util.Map;

/**
 * @author minwoo.jung
 */
public class DefaultDivider implements Divider {
    @Override
    public Map<String, ExecutionContext> divide(String partitionNamePrefix, String batchName) {
        Map<String, ExecutionContext> mapContext = new HashMap<>();
        ExecutionContext emptyExecutionContext = new ExecutionContext();
        mapContext.put(partitionNamePrefix + 1, emptyExecutionContext);
        return mapContext;
    }
}
