/*
 * Copyright 2018 Naver Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.navercorp.pinpoint.collector.mapper.thrift.stat;

import com.navercorp.pinpoint.common.server.bo.stat.AgentStatBo;
import com.navercorp.pinpoint.common.server.bo.stat.DirectBufferBo;
import com.navercorp.pinpoint.thrift.dto.TAgentStat;
import com.navercorp.pinpoint.thrift.dto.TDirectBuffer;
import org.springframework.stereotype.Component;

/**
 * @author Roy Kim
 */
@Component
public class ThriftDirectBufferBoMapper implements ThriftStatMapper<DirectBufferBo, TDirectBuffer> {

    @Override
    public DirectBufferBo map(TDirectBuffer tOpenDirectBuffer) {
        DirectBufferBo directBufferBo = new DirectBufferBo();
        directBufferBo.setDirectCount(tOpenDirectBuffer.getDirectCount());
        directBufferBo.setDirectMemoryUsed(tOpenDirectBuffer.getDirectMemoryUsed());
        directBufferBo.setMappedCount(tOpenDirectBuffer.getMappedCount());
        directBufferBo.setMappedMemoryUsed(tOpenDirectBuffer.getMappedMemoryUsed());
        return directBufferBo;
    }

    @Override
    public void map(AgentStatBo.Builder.StatBuilder agentStatBo, TAgentStat tAgentStat) {
        // directBuffer
        if (tAgentStat.isSetDirectBuffer()) {
            DirectBufferBo directBufferBo = this.map(tAgentStat.getDirectBuffer());
            agentStatBo.addDirectBuffer(directBufferBo);
        }
    }
}