/*
 * Copyright 2016 Naver Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.navercorp.pinpoint.collector.mapper.thrift.stat;

import com.navercorp.pinpoint.common.server.bo.stat.AgentStatBo;
import com.navercorp.pinpoint.common.server.bo.stat.JvmGcDetailedBo;
import com.navercorp.pinpoint.thrift.dto.TAgentStat;
import com.navercorp.pinpoint.thrift.dto.TJvmGcDetailed;
import org.springframework.stereotype.Component;

/**
 * @author HyunGil Jeong
 */
@Component
public class ThriftJvmGcDetailedBoMapper implements ThriftStatMapper<JvmGcDetailedBo, TJvmGcDetailed> {

    @Override
    public JvmGcDetailedBo map(TJvmGcDetailed tJvmGcDetailed) {
        JvmGcDetailedBo jvmGcDetailedBo = new JvmGcDetailedBo();
        jvmGcDetailedBo.setGcNewCount(tJvmGcDetailed.getJvmGcNewCount());
        jvmGcDetailedBo.setGcNewTime(tJvmGcDetailed.getJvmGcNewTime());
        jvmGcDetailedBo.setCodeCacheUsed(tJvmGcDetailed.getJvmPoolCodeCacheUsed());
        jvmGcDetailedBo.setNewGenUsed(tJvmGcDetailed.getJvmPoolNewGenUsed());
        jvmGcDetailedBo.setOldGenUsed(tJvmGcDetailed.getJvmPoolOldGenUsed());
        jvmGcDetailedBo.setSurvivorSpaceUsed(tJvmGcDetailed.getJvmPoolSurvivorSpaceUsed());
        jvmGcDetailedBo.setPermGenUsed(tJvmGcDetailed.getJvmPoolPermGenUsed());
        jvmGcDetailedBo.setMetaspaceUsed(tJvmGcDetailed.getJvmPoolMetaspaceUsed());
        return jvmGcDetailedBo;
    }

    @Override
    public void map(AgentStatBo.Builder.StatBuilder agentStatBo, TAgentStat tAgentStat) {
        // jvmGcDetailed
        if (tAgentStat.isSetGc()) {
            if (tAgentStat.getGc().isSetJvmGcDetailed()) {
                JvmGcDetailedBo jvmGcDetailedBo = this.map(tAgentStat.getGc().getJvmGcDetailed());
                agentStatBo.addJvmGcDetailed(jvmGcDetailedBo);
            }
        }
    }
}