/*
 * Copyright 2016 Pinpoint contributors and NAVER Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.navercorp.pinpoint.plugin.weblogic;

import java.util.Collections;
import java.util.List;

import com.navercorp.pinpoint.bootstrap.resolver.condition.MainClassCondition;
/**
 * 
 * @author andyspan
 *
 */
public class WeblogicDetector {

    private static final String DEFAULT_EXPECTED_MAIN_CLASSES = "weblogic.Server";
    
    private final List<String> expectedMainClasses;

    public WeblogicDetector(List<String> expectedMainClasses) {
        if (expectedMainClasses == null || expectedMainClasses.isEmpty()) {
            this.expectedMainClasses = Collections.singletonList(DEFAULT_EXPECTED_MAIN_CLASSES);
        } else {
            this.expectedMainClasses = expectedMainClasses;
        }
    }

    public boolean detect() {
        String bootstrapMainClass = MainClassCondition.INSTANCE.getValue();
        return expectedMainClasses.contains(bootstrapMainClass);
    }
}
