/*
 * Copyright 2019 NAVER Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.navercorp.pinpoint.profiler.context.grpc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;

/**
 * @author jaehong.kim
 */
public class GrpcStatMessageConverterProvider implements Provider<MessageConverter<GeneratedMessageV3>> {

    @Inject
    public GrpcStatMessageConverterProvider() {
    }


    @Override
    public MessageConverter<GeneratedMessageV3> get() {
        return new GrpcStatMessageConverter();
    }
}
