var g_animationManager = new AnimationManager( 50 );
var g_current_slide = 0;
var g_slides = [];
var g_directions = [
{ sx: [ -30, 0 ], ex: [ 5, 40 ], sy: [ -30, 0 ], ey: [ 5, 40 ] }, // nw -> se
{ sx: [ 5, 40 ], ex: [ -30, 0 ], sy: [ 5, 40 ], ey: [ -30, 0 ] }, // ne -> sw
{ sx: [ 5, 40 ], ex: [ -30, 0 ], sy: [ 5, 40 ], ey: [ -30, 0 ] }, // se -> nw
{ sx: [ -30, 0 ], ex: [ 5, 40 ], sy: [ 5, 40 ], ey: [ -30, 0 ] } // sw -> ne
];

g_animationManager.on_finished = function()
{
  g_current_slide++;
  if ( g_current_slide >= g_slides.length )
    g_current_slide = 0;
  g_slides[ g_current_slide ].start();
}

function rnd( start, end )
{
  return ( Math.random() * ( end - start ) ) + start;
}

function load_slides( images )
{
  var ic = document.getElementById( 'imgContainer' );

  for( var i in images )
  {
    var img = images[i];

    var imgObj = document.createElement( 'img' );
    imgObj.style.position = 'absolute';
    imgObj.style.left = '0px';
    imgObj.style.top = '0px';
    imgObj.style.visibility = 'hidden';
    ic.appendChild( imgObj );

    var ii = new ImageInfo( img.src, img.width, img.height, imgObj );

  var szoom = rnd( 50, 100 );
  var ezoom = rnd( 70, 120 );

  var d = parseInt( ( Math.random() * g_directions.length ).toString() );
  var di = g_directions[ d ];
  var sx = rnd( di.sx[0], di.sx[1] );
  var sy = rnd( di.sy[0], di.sy[1] );
  var ex = rnd( di.ex[0], di.ex[1] );
  var ey = rnd( di.ey[0], di.ey[1] );

    g_slides.push( 
      new Animation( g_animationManager, ii, 10,
    [ new KenBurnsZoomer( ii, szoom, ezoom, ic.clientWidth, ic.clientHeight ),
      new KenBurnsMover( ii, sx, sy, ex, ey, ic.clientWidth, ic.clientHeight ),
          new KenBurnsFader( ii, 30 ) ] )
    );
  }
}

function start_slides()
{
  g_slides[ g_current_slide ].start();
}
