/* calendar.js
 * by Michael Bailey
 *
 * This module will generate a calendar which is associated with
 * a set of form elements in an HTML file, of the month, day, and 
 * year.  The only two functions which should ever be called outside
 * of the module are displayCalendar and setDateToday.  The first
 * function, displayCalendar, is called to display the calendar to the
 * viewer.  The function requires one parameter which is a two character
 * string which designates the form elements to which it refers.  The
 * second function, setDateToday, also requires the same two character
 * id string.  This will cause the specified date to be set to the current
 * date.
 * 
 * The only two required files for this module are calendar.js and calendar.css,
 * though there is also a file included named calendar.html which displays a 
 * demo of how the module works.
 * 
 * I hope that this module proves useful.  If you have any questions or any
 * suggestions, feel free to contact me.  Also, if anyone wants to make this 
 * functional for Netscape, it would be much appreciated since I believe that
 * that module currently only works in IE.
 * 
 * -Michael Bailey <jinxidoru@yahoo.com>
 * 3 June 2002
 */

var CALENDAR = new Calendar();

function setDateToday(id) {
	var d = new Date();

	document.all[id + 'Month'].value = d.getMonth() + 1;
	document.all[id + 'Day'].value = d.getDay();
	document.all[id + 'Year'].value = d.getYear();
}


function displayCalendar(id) {
	var date_table = document.all[id + 'Month'];
	var p = date_table.offsetParent;
	var left = date_table.offsetLeft+2, top = date_table.offsetTop + date_table.offsetHeight + 2;
	while (p != null) {
		left += p.offsetLeft;
		top  += p.offsetTop;
		p = p.offsetParent;
	}

	CALENDAR.show(id, left, top);
}

function Calendar() {

	this.setDay = setDay;
	this.incMonth = incMonth;
	this.decMonth = decMonth;
	this.setMonth = setMonth;
	this.setYear = setYear;
	this.setDate = setDate;
	this.init = init;
	this.show = show;
	this.update = update;
	
	this.init();
	
	this.selectDay = selectDay;
	function selectDay(cell)
	{
		var day = cell.innerHTML;

		if (cell.className == 'cal_grey') {
			if (day > 15) {
				this.setDate(day, this.calDate.getMonth()-1, this.calDate.getYear());
			} else {
				this.setDate(day, this.calDate.getMonth()+1, this.calDate.getYear());
			}
			this.update();
		} else {
			this.setDay(day);		
		}
	}
		
	function setYear(year) { this.calDate.setYear(year); this.update(); }
		
	function incMonth() { this.setMonth(this.calDate.getMonth()+1); }
	function decMonth() { this.setMonth(this.calDate.getMonth()-1); }
	function setMonth(month) 
	{ 
		if (month < 0) {
			month = 11;
			this.calDate.setYear(this.calDate.getYear()-1);
		} else if (month > 11) {
			month = 0;
			this.calDate.setYear(this.calDate.getYear()+1);
		}
			
		this.calDate.setMonth(month); 
		if (this.calDate.getMonth() != month)  this.calDate.setDate(0);
		this.update(); 
	}
	
	function setDay(day) { this.calDate.setDate(day); this.update(); }
	
	function setDate(day, month, year) 
	{
		this.calDate.setYear(year);
		this.calDate.setMonth(month);
		this.calDate.setDate(day);
	}
	
	function update()
	{
		var doc = this.calPopup.document.all;
		
		var tmpDate = new Date(this.calDate);
		tmpDate.setDate(1);
		var first_day = tmpDate.getDay();

		tmpDate.setMonth(tmpDate.getMonth()+1);
		tmpDate.setDate(0);
		var last_day = tmpDate.getDate();

		tmpDate.setDate(1 - first_day);
		var day_number = tmpDate.getDate();		
		
		var selected_day = this.calDate.getDate();

		
		var cell;
		var i=0,j=2;
		for (; i<first_day; day_number++,i++) {
			cell = doc.calendar.rows[j].cells[i];
			cell.innerHTML = day_number;
			cell.className = 'cal_grey';
		}
		for (day_number=1; day_number<=last_day; day_number++,i++) {
			if (i>=7) { j++; i=0; }
			cell = doc.calendar.rows[j].cells[i];
			if (selected_day == day_number)
				cell.className = 'cal_selected';
			else
				cell.className = 'cal';
			cell.innerHTML = day_number;
		}
		for (day_number=1; j<doc.calendar.rows.length-1 || i<7; day_number++,i++) {
			if (i>=7) { j++; i=0; }
			cell = doc.calendar.rows[j].cells[i];
			cell.innerHTML = day_number;
			cell.className = 'cal_grey';
		}

		var year = this.calDate.getYear();
		if (year < 100)  year += 1900;
		doc.month.value = this.calDate.getMonth();
		doc.year.value  = year

		document.all[this.id + 'Month'].value =	this.calDate.getMonth() + 1;
		document.all[this.id + 'Year'].value  = year;
		document.all[this.id + 'Day'].value = this.calDate.getDate();
	}

	function init() 
	{
		this.calDate = new Date();
		
		this.calPopup = window.createPopup();
		this.calPopup.document.createStyleSheet("calendar.css");

		var calPopBody = this.calPopup.document.body;
		calPopBody.margin = 0;

		var html = "";
		html += "<TABLE ID=calendar Cellpadding=0 Cellspacing=0 Class=cal>";
		html += "<TR Class=cal_header><TD Class=cal_header Colspan=7>";
		html += "<INPUT Type=Button Value='&lt;' Class=cal_button OnClick='parent.CALENDAR.decMonth();'> ";
		html += "<SELECT ID=month Class=cal_month OnChange='parent.CALENDAR.setMonth(this.value);'>";
		html += "<OPTION Value=0>January</OPTION>";
		html += "<OPTION Value=1>February</OPTION>";
		html += "<OPTION Value=2>March</OPTION>";
		html += "<OPTION Value=3>April</OPTION>";
		html += "<OPTION Value=4>May</OPTION>";
		html += "<OPTION Value=5>June</OPTION>";
		html += "<OPTION Value=6>July</OPTION>";
		html += "<OPTION Value=7>August</OPTION>";
		html += "<OPTION Value=8>September</OPTION>";
		html += "<OPTION Value=9>October</OPTION>";
		html += "<OPTION Value=10>November</OPTION>";
		html += "<OPTION Value=11>December</OPTION>";
		html += "</SELECT> ";
		html += "<INPUT Type=Text ID=year Class=cal_year Size=4 MaxLength=4'> ";
		html += "<INPUT Type=Button Value='&gt;' Class=cal_button OnClick='parent.CALENDAR.incMonth();'>";
		html += "</TD></TR>";
		html += "<TR Class=cal>";
		html += "<TH Class=cal>Sun</TH>";
		html += "<TH Class=cal>Mon</TH>";
		html += "<TH Class=cal>Tue</TH>";
		html += "<TH Class=cal>Wed</TH>";
		html += "<TH Class=cal>Thu</TH>";
		html += "<TH Class=cal>Fri</TH>";
		html += "<TH Class=cal>Sat</TH>";
		html += "</TR>";

		for (var i=0; i<6; i++) {
			html += "<TR Class=cal>";
			for (var j=0; j<7; j++) {
				html += "<TD Class=cal OnClick='parent.CALENDAR.selectDay(this);'>&nbsp;</TD>";
			}
			html += "</TR>";
		}

		html += "</TABLE>";
		calPopBody.innerHTML = html;
	}

	function show(id, left, top)
	{
		this.id = id;
		day = document.all[id + "Day"].value;
		month = document.all[id + "Month"].value;
		year = document.all[id + "Year"].value;
		this.calDate = new Date();
		this.setDate(day, month-1, year);
		
		if (this.calDate.toString() == 'NaN') {
			alert("Unable to open Calendar.\nYou have entered an invalid date.");
			return;
		}

		this.calPopup.show(left,top,180,180,document.body);
		this.update();
	}
}	


// Copyright  2002 Michael Bailey.  All Rights Reserved.
