(function(){"use strict";var Spectra,a=this,b=a.Spectra,c={},d={white:"#ffffff",silver:"#c0c0c0",gray:"#808080",black:"#000000",red:"#ff0000",maroon:"#800000",yellow:"#ffff00",olive:"#808000",lime:"#00ff00",green:"#008000",aqua:"#00ffff",teal:"#008080",blue:"#0000ff",navy:"#000080",fuschia:"#ff00ff",purple:"#800080",orange:"#ffa500"};c.clamp=function(a,b,c){return a=void 0===a?0:a,b=void 0!==b?b:0,c=void 0!==c?c:1,Math.max(b,Math.min(c,a))},c.rgbToHsv=function(a){var b={},c=Number(void 0===a.r?0:a.r)/255,d=Number(void 0===a.g?0:a.g)/255,e=Number(void 0===a.b?0:a.b)/255,f=Math.max(c,d,e),g=Math.min(c,d,e),h=f-g;return b.v=f,0===b.v?(b.h=0,b.s=0):(b.s=(f-g)/f,0===b.s?b.h=0:(f===c?b.h=(d-e)/h:f===d?b.h=2+(e-c)/h:b.h=4+(c-d)/h,b.h*=60,b.h<0&&(b.h+=360))),b},c.hsvToRgb=function(a){var b={r:0,g:0,b:0},d=c.clamp(a.h||a.hue,0,360),e=c.clamp(a.s||a.saturation,0,1),f=c.clamp(a.v||a.value),g=e*f,h=d/60,i=g*(1-Math.abs(h%2-1));1>h?(b.r=g,b.g=i):2>h?(b.r=i,b.g=g):3>h?(b.g=g,b.b=i):4>h?(b.g=i,b.b=g):5>h?(b.r=i,b.b=g):(b.r=g,b.b=i);var j=f-g;return b.r+=j,b.g+=j,b.b+=j,b.r*=255,b.g*=255,b.b*=255,b},c.rgbToHsl=function(a){var b=c.rgbToHsv(a),d={};return d.h=b.h,d.l=(2-b.s)*b.v,d.s=b.s*b.v,d.s/=d.l<=1?d.l:2-d.l,d.l/=2,isNaN(d.s)&&(d.s=0),d},c.hslToRgb=function(a){var b=c.clamp(a.h||a.hue,0,360),d=c.clamp(a.s||a.saturation),e=c.clamp(a.l||a.lightness),f={};return f.h=b,d*=.5>e?e:1-e,f.s=2*d/(e+d),f.v=e+d,c.hsvToRgb(f)},c.rgbToLab=function(a){a={r:a.r/255,g:a.g/255,b:a.b/255};var b,c;for(c in a)a.hasOwnProperty(c)&&(a[c]>.04045?a[c]=Math.pow((a[c]+.055)/1.055,2.4):a[c]/=12.92,a[c]=100*a[c]);b={x:.4124*a.r+.3576*a.g+.1805*a.b,y:.2126*a.r+.7152*a.g+.0722*a.b,z:.0193*a.r+.1192*a.g+.9505*a.b};var d={},e={x:95.047,y:100,z:108.883};for(c in b)b.hasOwnProperty(c)&&(d[c]=b[c]/e[c],d[c]>.008856?d[c]=Math.pow(d[c],1/3):d[c]=7.787*d[c]+16/116);return{l:116*d.y-16,a:500*(d.x-d.y),b:200*(d.y-d.z)}},c.labToRgb=function(a){var b={},d={};b.y=((a.l||a.L)+16)/116,b.x=a.a/500+b.y,b.z=b.y-a.b/200;for(var e in b)b.hasOwnProperty(e)&&(Math.pow(b[e],3)>.008856?b[e]=Math.pow(b[e],3):b[e]=(b[e]-16/116)/7.787);return b.x*=95.047/100,b.y*=1,b.z*=1.08883,d.r=3.2406*b.x+-1.5372*b.y+b.z*-.4986,d.g=b.x*-.9689+1.8758*b.y+.0415*b.z,d.b=.0557*b.x+b.y*-.204+1.057*b.z,d.r>.0031308?d.r=1.055*Math.pow(d.r,1/2.4)-.055:d.r*=12.92,d.g>.0031308?d.g=1.055*Math.pow(d.g,1/2.4)-.055:d.g*=12.92,d.b>.0031308?d.b=1.055*Math.pow(d.b,1/2.4)-.055:d.b*=12.92,d.r=c.clamp(255*d.r,0,255),d.g=c.clamp(255*d.g,0,255),d.b=c.clamp(255*d.b,0,255),d},c.parseCss=function(a){var b={},d=/^#[0-9a-f]{3}$/i,e=a.match(d);if(e)return b={r:17*parseInt(a.charAt(1),16),g:17*parseInt(a.charAt(2),16),b:17*parseInt(a.charAt(3),16)},c.normalize(b);var f=/^#[0-9a-f]{6}$/i,g=a.match(f);if(g)return b={r:parseInt(a.slice(1,3),16),g:parseInt(a.slice(3,5),16),b:parseInt(a.slice(5,7),16)},c.normalize(b);var h=/^rgb\(\s*([0-9]+),\s*([0-9]+),\s*([0-9]+)\s*\)$/i,i=a.match(h);if(i)return b={r:parseInt(i[1],10),g:parseInt(i[2],10),b:parseInt(i[3],10)},c.normalize(b);var j=/^rgba\(\s*([0-9]+),\s*([0-9]+),\s*([0-9]+),\s*([0-9\.]+)\s*\)$/i,k=a.match(j);if(k)return b={r:parseInt(k[1],10),g:parseInt(k[2],10),b:parseInt(k[3],10),a:parseFloat(k[4])},c.normalize(b);throw new TypeError(a+" is not a valid CSS string for Spectra.")},c.parsePredefinedColor=function(a){return new Spectra.fn(d[a])},c.normalize=function(a){a.a=void 0===a.a?1:a.a;var b=a;return void 0!==b.hsv?(b=c.hsvToRgb(b.hsv),b.a=a.a):void 0!==b.hsl?(b=c.hslToRgb(b.hsl),b.a=a.a):void 0!==b.css?b=c.parseCss(b.css):void 0!==b.lab&&(b=c.labToRgb(b.lab),b.a=a.a),b.r=b.red||b.r,b.g=b.green||b.g,b.b=b.blue||b.b,b.a=b.alpha||b.a,b.r=c.clamp(b.r,0,255),b.g=c.clamp(b.g,0,255),b.b=c.clamp(b.b,0,255),b.a=c.clamp(b.a,0,1),b},Spectra=function(a){return new Spectra.fn(a)},Spectra.fn=function(a){if(null===a||void 0===a)throw new TypeError("Spectra argument must be defined.");if(a instanceof Spectra.fn)return a;if("object"==typeof a)if(void 0!==a.r||void 0!==a.red)this.color=c.normalize({r:a.r,g:a.g,b:a.b,a:a.a});else if(void 0!==a.v||void 0!==a.value)this.color=c.normalize({hsv:a,a:a.a});else if(void 0===a.l&&void 0===a.lightness||void 0===a.s&&void 0===a.saturation){if(void 0===a.l&&void 0===a.L||void 0===a.a)throw new TypeError("Spectra argument "+a+" is invalid.");this.color=c.normalize({lab:a,a:a.a||a.alpha})}else this.color=c.normalize({hsl:a,a:a.a||a.alpha});else{if("string"!=typeof a)throw new TypeError("Spectra argument "+a+" is invalid.");if(a.toLowerCase()in d)return c.parsePredefinedColor(a);this.color=c.normalize({css:a})}return this},Spectra.fn.prototype.red=function(a){var b=this.color;return arguments.length?(b.r=a,this.color=c.normalize(b),this):Math.round(b.r)},Spectra.fn.prototype.green=function(a){var b=this.color;return arguments.length?(b.g=a,this.color=c.normalize(b),this):Math.round(b.g)},Spectra.fn.prototype.blue=function(a){var b=this.color;return arguments.length?(b.b=a,this.color=c.normalize(b),this):Math.round(b.b)},Spectra.fn.prototype.hue=function(a){var b=c.rgbToHsv(this.color);return arguments.length?(b.h=a,this.color=c.normalize({hsv:b,a:this.color.a}),this):Math.round(b.h)},Spectra.fn.prototype.saturationv=function(a){var b=c.rgbToHsv(this.color);return arguments.length?(b.s=a,this.color=c.normalize({hsv:b,a:this.color.a}),this):b.s},Spectra.fn.prototype.value=function(a){var b=c.rgbToHsv(this.color);return arguments.length?(b.v=a,this.color=c.normalize({hsv:b,a:this.color.a}),this):b.v},Spectra.fn.prototype.saturation=function(a){var b=c.rgbToHsl(this.color);return arguments.length?(b.s=a,this.color=c.normalize({hsl:b,a:this.color.a}),this):b.s},Spectra.fn.prototype.lightness=function(a){var b=c.rgbToHsl(this.color);return arguments.length?(b.l=a,this.color=c.normalize({hsl:b,a:this.color.a}),this):b.l},Spectra.fn.prototype.alpha=function(a){var b=this.color;return arguments.length?(b.a=a,this):b.a},Spectra.fn.prototype.hex=function(){var a=("0"+this.red().toString(16)).slice(-2),b=("0"+this.green().toString(16)).slice(-2),c=("0"+this.blue().toString(16)).slice(-2);return"#"+a+b+c},Spectra.fn.prototype.rgbaString=function(){return"rgba("+this.red()+","+this.green()+","+this.blue()+","+this.alpha()+")"},Spectra.fn.prototype.hslString=function(){return"hsl("+this.hue()+","+this.saturation()+","+Math.round(100*this.lightness())/100+")"},Spectra.fn.prototype.hslaString=function(){return"hsla("+this.hue()+","+this.saturation()+","+Math.round(100*this.lightness())/100+","+this.alpha()+")"},Spectra.fn.prototype.rgbNumber=function(){return this.red()<<16|this.green()<<8|this.blue()},Spectra.fn.prototype.labObject=function(){return c.rgbToLab(this.color)},Spectra.fn.prototype.toString=Spectra.fn.prototype.hex,Spectra.fn.prototype.equals=function(a){var b=this,c=a;return arguments.length<1?b===c:b.near(c,0)},Spectra.fn.prototype.near=function(a,b){var c=this,d=a;b=Math.abs(void 0===b?0:b);var e=255*(b/100);return Math.abs(d.red()-c.red())<=e&&Math.abs(d.green()-c.green())<=e&&Math.abs(d.blue()-c.blue())<=e&&Math.abs(d.alpha()-c.alpha())<=b/100},Spectra.fn.prototype.complement=function(){var a=new Spectra(this.color);return a.hue((a.hue()+180)%360),a},Spectra.fn.prototype.negate=function(){var a=new Spectra(this.color);return a.red(255-a.red()),a.green(255-a.green()),a.blue(255-a.blue()),a},Spectra.fn.prototype.lighten=function(a){var b=new Spectra(this.color),d=c.clamp(b.lightness()+a/100,0,1);return b.lightness(d),b},Spectra.fn.prototype.darken=function(a){return this.lighten(-a)},Spectra.fn.prototype.randomColorRange=function(a){var b=(2*Math.random()-1)*a,c=new Spectra(this.color);return c=c.lighten(b)},Spectra.fn.prototype.saturate=function(a){var b=a/100,c=new Spectra(this.color);return c.saturation(c.saturation()+b),c},Spectra.fn.prototype.desaturate=function(a){var b=a/100,c=new Spectra(this.color);return c.saturation(c.saturation()-b),c},Spectra.fn.prototype.fadeIn=function(a){var b=a/100,c=new Spectra(this.color);return c.alpha(c.alpha()+b),c},Spectra.fn.prototype.fadeOut=function(a){var b=a/100,c=new Spectra(this.color);return c.alpha(c.alpha()-b),c},Spectra.fn.prototype.luma=function(){return.2126*this.red()+.7152*this.green()+.0722*this.blue()},Spectra.fn.prototype.grayscale=function(){return this.desaturate(100)},Spectra.fn.prototype.isDark=function(){var a=(299*this.red()+587*this.green()+144*this.blue())/1e3;return 131.5>a},Spectra.fn.prototype.isLight=function(){return!this.isDark()},Spectra.fn.prototype.mix=function(a,b){a=new Spectra(a);var c=arguments.length<2?.5:b/100;return new Spectra({r:this.red()*(1-c)+a.red()*c,g:this.green()*(1-c)+a.green()*c,b:this.blue()*(1-c)+a.blue()*c,a:this.alpha()*(1-c)+a.alpha()*c})},Spectra.fn.prototype.contrast=function(a){a=new Spectra(a);var b=Math.max(this.red(),a.red())-Math.min(this.red(),a.red())+Math.max(this.green(),a.green())-Math.min(this.green(),a.green())+Math.max(this.blue(),a.blue())-Math.min(this.blue(),a.blue());return b/765},Spectra.fn.prototype.gradient=function(a,b){a=new Spectra(a);for(var c=[],d=this.red(),e=this.green(),f=this.blue(),g=(a.red()-this.red())/(b-1),h=(a.green()-this.green())/(b-1),i=(a.blue()-this.blue())/(b-1),j=0;b>j;j++)c.push(new Spectra({r:d,g:e,b:f})),d+=g,e+=h,f+=i;return c},Spectra.fn.prototype.harmony=function(a,b){b="number"==typeof b?Math.abs(parseInt(b,10)):0;var d=[],e=c.rgbToHsv(this.color),f=[0,180];switch(a){case"analogous":f=[0,30,60];break;case"triad":f=[0,120,240];break;case"split-complementary":f=[0,150,210];break;case"rectangle":f=[0,60,180,240];break;case"square":f=[0,90,180,270];break;case"complementary":f=[0,180]}for(var g=f.length,h=f[b%g],i=0;g>i;i++)d.push(new Spectra({h:(e.h+f[i]-h)%360,s:e.s,v:e.v,a:this.color.a}));return d},Spectra.noConflict=function(){return a.Spectra=b,Spectra},Spectra.random=function(){return new Spectra({r:Math.floor(255*Math.random()),g:Math.floor(255*Math.random()),b:Math.floor(255*Math.random())})},"undefined"!=typeof exports?("undefined"!=typeof module&&(exports=module.exports=Spectra),exports.Spectra=Spectra):a.Spectra=Spectra}).call(this);