<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
if(!defined('IN_DZZ') || !defined('IN_ADMIN')) {
	exit('Access Denied');
}
error_reporting(E_ERROR);
require_once libfile('function/user','','user');
$do=trim($_GET['do']);
$uid=intval($_GET['uid']);
if(!$uid) $do='add';
if(empty($do) && $uid) $do='edit';

if($do=='add'){
	
	if(submitcheck('accountadd')){
		$username=trim($_GET['username']);
		$usernamelen = dstrlen($_GET['username']);
			if($usernamelen < 3) {
				showmessage('profile_username_tooshort');
			} elseif($usernamelen > 15) {
				showmessage('profile_username_toolong');
			}
			
			if($_G['setting']['pwlength']) {
				if(strlen($_GET['password']) < $_G['setting']['pwlength']) {
					showmessage('profile_password_tooshort', '', array('pwlength' => $_G['setting']['pwlength']));
				}
			}
			
			$email = strtolower(trim($_GET['email']));
			checkemail($_GET['email']);
			
			if($_GET['password'] !== $_GET['password2']) {
				showmessage('profile_passwd_notmatch');
			}

			if(!$_GET['password'] || $_GET['password'] != addslashes($_GET['password'])) {
				showmessage('profile_passwd_illegal');
			}
			$password = $_GET['password'];
			

			$censorexp = '/^('.str_replace(array('\\*', "\r\n", ' '), array('.*', '|', ''), preg_quote(($_G['setting']['censoruser'] = trim($_G['setting']['censoruser'])), '/')).')$/i';

			if($_G['setting']['censoruser'] && @preg_match($censorexp, $username)) {
				showmessage('profile_username_protect');
			}
		
				
				$result = uc_user_register(addslashes($username), $password, $email, $questionid, $answer, $_G['clientip']);
				if(is_array($result)){
					$uid=$result['uid'];
					$password=$result['password'];
				}else{
					$uid=$result;
				}
				if($uid <= 0) {
					if($uid == -1) {
						showmessage('profile_username_illegal');
					} elseif($uid == -2) {
						showmessage('profile_username_protect');
					} elseif($uid == -3) {
						showmessage('profile_username_duplicate');
					} elseif($uid == -4) {
						showmessage('profile_email_illegal');
					} elseif($uid == -5) {
						showmessage('profile_email_domain_illegal');
					} elseif($uid == -6) {
						showmessage('profile_email_duplicate');
					} else {
						showmessage('undefined_action');
					}
				}else{
					//处理机构
					$orgids=$_GET['orgid'];
					foreach($orgids as $orgid){
						C::t('organization_user')->insert($uid,$orgid,0);
					}
				}
				if($_GET['sendemail']){
					$email_register_message = lang('email', 'email_register_message', array(
						'bbname' => $_G['setting']['bbname'],
						'siteurl' => $_G['siteurl'],
						'url' => $password
					));
					if(!sendmail("$_GET[email] <$_GET[email]>", lang('email', 'email_register_subject'), $email_register_message)) {
						runlog('sendmail', "$_GET[email] sendmail failed.");
					}
					showmessage('do_success',BASESCRIPT.'?mod=member&op=edituser&do=edit&uid='.$uid);
				}else{
					showmessage('do_success',BASESCRIPT.'?mod=member&op=edituser&uid='.$uid);
				}
			
	}else{
		$active=array('add'=>'class="active"');
		$orglist=C::t('organization')->fetch_all_by_forgid(0);
		include template('adduser');
	}
	
}elseif($do=='edit'){
	if(submitcheck('accountedit')){
		$username=trim($_GET['username']);
		$usernamelen = dstrlen($_GET['username']);
			if($usernamelen < 3) {
				showmessage('profile_username_tooshort');
			} elseif($usernamelen > 15) {
				showmessage('profile_username_toolong');
			}
			
			if($_GET['password'] && $_G['setting']['pwlength']) {
				if(strlen($_GET['password']) < $_G['setting']['pwlength']) {
					showmessage('profile_password_tooshort', '', array('pwlength' => $_G['setting']['pwlength']));
				}
			}
			
			$email = strtolower(trim($_GET['email']));
			if(!isemail($email)) {
				showmessage('profile_email_illegal', '', array(), array('handle' => false));
			} elseif(!check_emailaccess($email)) {
				showmessage('profile_email_domain_illegal', '', array(), array('handle' => false));
			}
			
			if($_GET['password'] && $_GET['password'] !== $_GET['password2']) {
				showmessage('profile_passwd_notmatch');
			}

			$password = $_GET['password'];

			$censorexp = '/^('.str_replace(array('\\*', "\r\n", ' '), array('.*', '|', ''), preg_quote(($_G['setting']['censoruser'] = trim($_G['setting']['censoruser'])), '/')).')$/i';

			if($_G['setting']['censoruser'] && @preg_match($censorexp, $username)) {
				showmessage('profile_username_protect');
			}
			
			if($password){
				$salt=substr(uniqid(rand()), -6);
				$setarr=array(
								'salt'=>$salt,
								'password'=>md5(md5($password).$salt),
								'username'=>$username,
								'secques'=>'',
								'email'=>$email,
								'status'=>intval($_GET['status'])>0?0:1,
								);
			}else{
				$setarr=array(
						'username'=>$username,
						'email'=>$email,
						'status'=>intval($_GET['status'])>0?0:1
						);
			}
			C::t('user')->update($uid,$setarr);
		//处理用户部门
		$delids=$_GET['del'];
		if($delids){
			DB::delete('organization_user',"uid='{$uid}' and orgid IN(".dimplode($delids).")");
		}
		$orgids=$_GET['orgid'];
		foreach($orgids as $orgid){
			C::t('organization_user')->insert($uid,$orgid,0);
		}
		showmessage('do_success',dreferer());	
	}else{
		require_once libfile('function/organization');
		$active=array('edit'=>'class="active"');
		$orglist=C::t('organization')->fetch_all_by_forgid(0);
		$user=C::t('user')->fetch($uid);
		//$user['status']=$user['status']>0?0:1;
		$departs=array();
		$departs=getDepartmentByUid($uid);
		$data_depart=array();
		foreach($departs as $key => $value){
			$data_depart[$key]['org']=$orglist[$value[0]['orgid']];
			if(count($value)>1) $data_depart[$key]['depart']=$value[count($value)-1];
			$data_depart[$key]['tree']=getDepartmentOption($value[0]['orgid']);
		}
		
		include template('edituser');
	}
	
}elseif($do=='profile'){
	include_once libfile('function/profile','','user');
	include_once libfile('function/profile');
	$space = getuserbyuid($uid);
	space_merge($space, 'profile');
	loadcache('profilesetting');
	if(empty($_G['cache']['profilesetting'])) {
		require_once libfile('function/cache');
		updatecache('profilesetting');
		loadcache('profilesetting');
	}
	if(submitcheck('profilesubmit')){
		$setarr=array();
		foreach($_GET as $key => $value) {
			$field = $_G['cache']['profilesetting'][$key];
			if(empty($field)) {
				continue;
			}elseif(profile_check($key, $value, $space)) {
				$setarr[$key] = dhtmlspecialchars(trim($value));
			}
		}
		if(isset($_POST['birthmonth']) && ($space['birthmonth'] != $_POST['birthmonth'] || $space['birthday'] != $_POST['birthday'])) {
			$setarr['constellation'] = get_constellation($_POST['birthmonth'], $_POST['birthday']);
		}
		if(isset($_POST['birthyear']) && $space['birthyear'] != $_POST['birthyear']) {
			$setarr['zodiac'] = get_zodiac($_POST['birthyear']);
		}
		
		if($setarr) {
			$setarr['uid']=$uid;
			C::t('user_profile')->insert($setarr,0,1);
		}
		showmessage('do_success',dreferer());
	}else{
		$allowitems = array();
		foreach($_G['cache']['profilesetting'] as $key => $value){
			if($value['available']>0) $allowitems[]=$key;
		}
		$htmls = $settings = array();
		
		$space['realname']=$space['username'];
		foreach($allowitems as $fieldid) {
			if(!in_array($fieldid, array('sightml', 'customstatus', 'timeoffset'))) {
				$html = profile_setting($fieldid, $space, $vid ? false : true);
				if($html) {
					$settings[$fieldid] = $_G['cache']['profilesetting'][$fieldid];
					$htmls[$fieldid] = $html;
				}
			}
		}
		$active=array('profile'=>'class="active"');
		
		include template('profile');
	}
}elseif($do=='deluser'){
	$uid=intval($_GET['uid']);
	//删除用户的非机构内的目录
	foreach(DB::fetch_all("select fid from %t where uid=%d and gid<1 ",array('folder',$uid)) as $value){
		C::t('folder')->delete_by_fid($value['fid'],true);
	}
	//删除用户主表
	C::t('user')->delete($uid);
	C::t('user_field')->delete($uid);
	C::t('user_profile')->delete($uid);
	DB::delete('user_thame',"uid='{$uid}'");//删除用户主题
	C::t('organization_user')->delete_by_uid($uid);//删除机构用户
	DB::delete('user_playlist',"uid='{$uid}'"); //删除播放列表
	//删除用户云链接
	foreach(DB::fetch_all("select * from %t where 1",array('connect')) as $cloud){
		DB::delete($cloud['dname'],"uid='{$uid}'");
	}
	showmessage('do_success',dreferer());	
}
exit();
?>
