<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
if(!defined('IN_DZZ') || !defined('IN_ADMIN')) {
	exit('Access Denied');
}
$oparr=array('updatecache','database',/*'security','patch','update',*/'cron','log');
$leftmenu=array();
foreach($oparr as $key => $value){
	 $leftmenu[$value]=array('title'=>lang('message',$value),'active'=>'');
	 if($value==$op) $leftmenu[$value]['active']='class="active"';
}
$page=max(1,intval($_GET['page']));
$lpp = empty($_GET['lpp']) ? 20 : $_GET['lpp'];
$checklpp = array();
$checklpp[$lpp] = 'selected="selected"';
$extrainput = '';

$operation = in_array($_GET['operation'], array('illegal', 'rate', 'credit', 'mods', 'medal', 'ban', 'cp', 'magic', 'error', 'invite', 'payment', 'warn', 'crime', 'sendmail')) ? $_GET['operation'] : 'illegal';
$navtitle=lang('template','nav_logs_'.$operation).' - '.$lang['admin_navtitle'];

$logdir = DZZ_ROOT.'./data/log/';
$logfiles = get_log_files($logdir, $operation.($operation == 'sendmail' ? '' : 'log'));
$logs = array();
$lastkey = count($logfiles) - 1;
$lastlog = $logfiles[$lastkey];
krsort($logfiles);
if($logfiles) {
	if(!isset($_GET['day']) || strexists($_GET['day'], '_')) {
		list($_GET['day'], $_GET['num']) = explode('_', $_GET['day']);
		$logs = file(($_GET['day'] ? $logdir.$_GET['day'].'_'.$operation.($operation == 'sendmail' ? '' : 'log').($_GET['num'] ? '_'.$_GET['num'] : '').'.php' : $logdir.$lastlog));
	} else {
		$logs = file($logdir.$_GET['day'].'_'.$operation.($operation == 'sendmail' ? '' : 'log').'.php');
	}
}

$start = ($page - 1) * $lpp;
$logs = array_reverse($logs);

if(empty($_GET['keyword']) && empty($_GET['filteract'])) {
	$num = count($logs);
	$multipage = multi($num, $lpp, $page, ADMINSCRIPT."?mod=system&op=log&operation=$operation&lpp=$lpp".(!empty($_GET['day']) ? '&day='.$_GET['day'] : ''), 0, 3);
	$logs = array_slice($logs, $start, $lpp);
} else {
	foreach($logs as $key => $value) {
		if(!empty($_GET['filteract'])) {
			$log = explode("\t", $value);
			preg_match("/operation=(.[^;]*)/i", $log[6], $operationInfo);
			$logExplain = $operationInfo[1] ? rtrim($log[5]).'_'.$operationInfo[1] : rtrim($log[5]) ;
			$logPostion = strpos($logExplain, $_GET['filteract']);
			if($logPostion === false || $logPostion != 0) {
				unset($logs[$key]);
			}
		}
		if(!empty($_GET['keyword']) && strpos($value, $_GET['keyword']) === FALSE) {
			unset($logs[$key]);
		}
	}
	$multipage = '';
}


$usergroup = array();

if(in_array($operation, array('rate', 'mods', 'ban', 'cp'))) {
	foreach(C::t('usergroup')->range() as $group) {
		$usergroup[$group['groupid']] = $group['grouptitle'];
	}
}

if($logfiles) {
	$sel = '<select style="margin-right:20px;" onchange="location.href=\''.BASESCRIPT.'?mod=system&op=log&operation='.$operation.'&keyword='.$_GET['keyword'].'&day=\'+this.value">';
	foreach($logfiles as $logfile) {
		list($date, $logtype, $num) = explode('_', $logfile);
		if(is_numeric($date)) {
			$num = intval($num);
			$sel .= '<option value="'.$date.'_'.$num.'"'.($date.'_'.$num == $_GET['day'].'_'.intval($_GET['num']) ? ' selected="selected"' : '').'>'.($num ? '&nbsp;&nbsp;'.$date.' '.cplang('logs_archive').' '.$num : $date).'</option>';
		} else {
			list($logtype) = explode('.', $logtype);
			$sel .= '<option value="'.$logtype.'"'.($logtype == $_GET['day'] ? ' selected="selected"' : '').'>'.$logtype.'</option>';
		}
	}
	$sel .= '</select>';
} else {
	$sel = '';
}

$filters = '';
$list=array();
if($operation == 'illegal') {
	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1] = dgmdate($log[1], 'y-n-j H:i');
		if(strtolower($log[2]) == strtolower($_G['member']['username'])) {
			$log[2] = "<b>$log[2]</b>";
		}
		$log[5] = $log[5];
		$list[]=$log;
	}
} elseif($operation == 'sendmail') {


	$logarr = $logemail = array();
	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[5] = trim(str_replace('sendmail failed.', '', $log[5]));
		if(!$log[5]) {
			continue;
		}
		$logemail[] = $log[5];
		$logarr[] = $log;
	}

	$members = C::t('user')->fetch_all_by_email($logemail);

	foreach($logarr as $log) {
		$log[6] = $members[$log[5]]['username'];
		if(strtolower($log[6]) == strtolower($_G['member']['username'])) {
			$log[6] = "<b>$log[6]</b>";
		}
		$list[]=$log;
		
	}

} elseif($operation == 'cp') {

	
	foreach($logs as $k => $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			//continue;
		}
		$log[1] = dgmdate($log[1], 'y-n-j H:i');
		$log[2] = $log[2];
		$log[2] = ($log[2] != $_G['member']['username'] ? "<b>$log[2]</b>" : $log[2]);
		$log[3] = $usergroup[$log[3]];
 		
		$list[$k]=$log;
	}
} elseif($operation == 'error') {

	foreach($logs as $logrow) {
		$log = explode("\t", $logrow);
		if(empty($log[1])) {
			continue;
		}
		$log[1]=dgmdate($log[1], 'Y-m-d H:i:s');
		$log[2]=$log[2].'<br>'.$log[4].'<br>'.$log[5];
		$list[]=$log;
	}

} elseif($operation == 'invite') {

	if(!submitcheck('invitesubmit')) {

		$where = '1';
		$pageadd = '';
		$uid = $fuid = 0;
		if($srch_uid = trim($_GET['srch_uid'])) {
			if($uid = max(0, intval($srch_uid))) {
				$where .= " AND i.`uid`='$uid'";
				$pageadd .= '&srch_uid='.$uid;
			} else {
				$srch_uid = '';
			}
		} elseif($srch_username = trim($_GET['srch_username'])) {
			$uid = ($uid = C::t('member')->fetch_uid_by_username($srch_username)) ? $uid : C::t('member_archive')->fetch_uid_by_username($srch_username);
			if($uid) {
				$where .= " AND i.`uid`='$uid'";
				$pageadd .= '&srch_username='.rawurlencode($srch_username);
			} else {
				$srch_username = '';
			}
		}
		if($srch_fuid = trim($_GET['srch_fuid'])) {
			if($fuid = max(0, intval($srch_fuid))) {
				$where .= " AND i.`fuid`='$fuid'";
				$pageadd .= '&srch_fuid='.$fuid;
			} else {
				$srch_fuid = '';
			}
		}
		if($srch_fusername = trim($_GET['srch_fusername'])) {
			$where .= " AND i.`fusername`='$srch_fusername'";
			$pageadd .= '&srch_fusername='.rawurlencode($srch_fusername);
		}
		if($srch_buydate_start = trim($_GET['srch_buydate_start'])) {
			if($buydate_start = strtotime($srch_buydate_start)) {
				$where .= " AND i.`dateline`>'$buydate_start'";
				$pageadd .= '&srch_buydate_start='.$srch_buydate_start;
			} else {
				$srch_buydate_start = '';
			}
		}
		if($srch_buydate_end = trim($_GET['srch_buydate_end'])) {
			if($buydate_end = strtotime($srch_buydate_end)) {
				$where .= " AND i.`dateline`<'$buydate_end'";
				$pageadd .= '&srch_buydate_end='.$srch_buydate_end;
			} else {
				$srch_buydate_end = '';
			}
		}
		if($srch_ip = trim($_GET['srch_ip'])) {
			$pageadd .= '&srch_ip='.rawurlencode($srch_ip);
			$inviteip = str_replace('*', '%', addcslashes($srch_ip, '%_'));
			$srch_ip = dhtmlspecialchars($srch_ip);
			$where .= " AND i.`inviteip` LIKE '$inviteip%'";
		}
		if($srch_code = trim($_GET['srch_code'])) {
			$pageadd .= '&srch_ip='.rawurlencode($srch_code);
			$where .= " AND i.`code`='$srch_code'";
			$srch_code = dhtmlspecialchars($srch_code);
		}

		showtableheader('search', 'fixpadding');
		showtablerow('', array('class="td23"', 'width="150"', 'class="td23"'),
			array(
				cplang('username'), '<input type="text" name="srch_username" class="txt" value="'.$srch_username.'" />',
				cplang('logs_invite_ip'), '<input type="text" name="srch_ip" class="txt" value="'.$srch_ip.'" size="5" />',
			)
		);
		showtablerow('', array('class="td23"', 'width="150"', 'class="td23"'),
			array(
				cplang('uid'), '<input type="text" name="srch_uid" class="txt" value="'.$srch_uid.'" />',
				cplang('logs_invite_code'), '<input type="text" name="srch_code" class="txt" value="'.$srch_code.'" size="5" />',
			)
		);
		showtablerow('', array('class="td23"', 'width="150"', 'class="td23"'),
			array(
				cplang('logs_invite_target'), '<input type="text" name="srch_fusername" class="txt" value="'.$srch_fusername.'" />',
				cplang('logs_invite_buydate'), '<input type="text" name="srch_buydate_start" class="txt" value="'.$srch_buydate_start.'" onclick="showcalendar(event, this)" />- <input type="text" name="srch_buydate_end" class="txt" value="'.$srch_buydate_end.'" onclick="showcalendar(event, this)" />',
			)
		);
		showtablerow('', array('class="td23"', 'width="150"', 'class="td23"'),
			array(
				cplang('logs_invite_target').cplang('uid'), '<input type="text" name="srch_fuid" class="txt" value="'.$srch_fuid.'" />',
				'', '',
			)
		);
		showtablerow('', array('colspan="4"'), array('<input type="submit" name="srchlogbtn" class="btn" value="'.$lang['search'].'" />'));
		showtablefooter();
		echo '<script src="static/js/calendar.js" type="text/javascript"></script>';
		showtableheader('', 'fixpadding');
		showtablerow('class="header"', array('width="35"','class="td23"','class="td24"','class="td24"','class="td23"','class="td24"','class="td24"'), array(
			'',
			cplang('logs_invite_buyer'),
			cplang('logs_invite_buydate'),
			cplang('logs_invite_expiration'),
			cplang('logs_invite_ip'),
			cplang('logs_invite_code'),
			cplang('logs_invite_status'),
		));

		$tpp = $_GET['lpp'] ? intval($_GET['lpp']) : $_G['tpp'];
		$start_limit = ($page - 1) * $tpp;

		$dels = array();
		$invitecount = C::t('invite')->count_by_search($uid, $fuid, $srch_fusername, $buydate_start, $buydate_end, $inviteip, $srch_code);
		if($invitecount) {
			$multipage = multi($invitecount, $tpp, $page, ADMINSCRIPT."?mod=system&op=log&operation=invite&lpp=$lpp$pageadd", 0, 3);

			$invitearr = C::t('invite')->fetch_all_by_search($uid, $fuid, $srch_fusername, $buydate_start, $buydate_end, $inviteip, $srch_code, $start_limit, $tpp);
			$members = C::t('member')->fetch_all(C::t('invite')->get_uids());
			foreach($invitearr as $invite) {
				$invite['username'] = $members[$invite['uid']]['username'];
				if(!$invite['fuid'] && $_G['timestamp'] > $invite['endtime']) {
					$dels[] = $invite['id'];
					continue;
				}

				$invite['statuslog'] = $lang['logs_invite_status_'.$invite['status']];
				$username = "<a href=\"home.php?mod=space&uid=$invite[uid]\">$invite[username]</a>";
				$invite['dateline'] = dgmdate($invite['dateline'], 'Y-n-j H:i');
				$invite['expiration'] = dgmdate($invite['endtime'], 'Y-n-j H:i');
				$stats = $invite['statuslog'].($invite['status'] == 2 ? '&nbsp;[<a href="home.php?mod=space&uid='.$invite['fuid'].'" target="_blank">'.$lang['logs_invite_target'].':'.$invite['fusername'].'</a>]' : '');

				showtablerow('', array('', 'class="bold"'), array(
					'<input type="checkbox" class="checkbox" name="delete[]" value="'.$invite['id'].'" />',
					$username,
					$invite['dateline'],
					$invite['expiration'],
					$invite['inviteip'],
					$invite['code'],
					$stats
				));
			}
			showhiddenfields(array('pageadd' => $pageadd));

			if($dels) {
				C::t('invite')->delete($dels);
			}
		}

	} else {

		if($_GET['delete']) {
			C::t('invite')->delete($_GET['delete']);
		}

		header("Location: $_G[siteurl]".ADMINSCRIPT."?mod=system&op=log&operation=invite&lpp=$_GET[lpp]$_GET[pageadd]");
	}


} elseif($operation == 'payment') {

	showtablerow('class="header"', array('width="30%"','class="td23"','class="td23"','class="td24"','class="td23"','class="td24"','class="td24"'), array(
		cplang('subject'),
		cplang('logs_payment_amount'),
		cplang('logs_payment_seller'),
		cplang('logs_payment_buyer'),
		cplang('logs_payment_dateline'),
		cplang('logs_payment_buydateline'),
	));

	$tpp = $_GET['lpp'] ? intval($_GET['lpp']) : $_G['tpp'];
	$start_limit = ($page - 1) * $tpp;

	$threadcount = C::t('credit_log')->count_by_operation('BTC');
	if($threadcount) {
		$multipage = multi($threadcount, $tpp, $page, ADMINSCRIPT."?mod=system&op=log&operation=payment&lpp=$lpp", 0, 3);
		$logs = C::t('credit_log')->fetch_all_by_operation('BTC', $start_limit, $tpp);
		$ltids = $luid = array();
		foreach($logs as $log) {
			$luid[$log['uid']] = $log['uid'];
			$ltids[$log['relatedid']] = $log['relatedid'];
		}
		$members = C::t('member')->fetch_all($luid);
		$threads = C::t('forum_thread')->fetch_all($ltids);
		foreach($logs as $paythread) {
			$thread = $threads[$paythread['relatedid']];
			$paythread['username'] = $members[$paythread['uid']]['username'];
			$paythread['tid'] = $thread['tid'];
			$paythread['subject'] = $thread['subject'];
			$paythread['postdateline'] = $thread['dateline'];
			$paythread['author'] = $thread['author'];
			$paythread['tauthorid'] = $thread['authorid'];

			$paythread['seller'] = $paythread['tauthorid'] ? "<a href=\"home.php?mod=space&uid=$paythread[tauthorid]\">$paythread[author]</a>" : cplang('logs_payment_del')."(<a href=\"home.php?mod=space&uid=$paythread[authorid]\">".cplang('logs_payment_view')."</a>)";
			$paythread['buyer'] = "<a href=\"home.php?mod=space&uid=$paythread[uid]\">$paythread[username]</a>";
			$paythread['subject'] = $paythread['subject'] ? "<a href=\"forum.php?mod=viewthread&tid=$paythread[tid]\">$paythread[subject]</a>" : cplang('logs_payment_del');
			$paythread['dateline'] = dgmdate($paythread['dateline'], 'Y-n-j H:i');
			$paythread['postdateline'] = $paythread['postdateline'] ? dgmdate($paythread['postdateline'], 'Y-n-j H:i') : cplang('logs_payment_del');
			foreach($_G['setting']['extcredits'] as $id => $credits) {
				if($paythread['extcredits'.$id]) {
					$paythread['amount'] = $credits['title'].':'.abs($paythread['extcredits'.$id]);
					break;
				}
			}
			showtablerow('', array('', 'class="bold"'), array(
				$paythread['subject'],
				$paythread['amount'],
				$paythread['seller'],
				$paythread['buyer'],
				$paythread['postdateline'],
				$paythread['dateline']
			));
		}
	}
}
function getactionarray() {
	$isfounder = true;
	//require './source/admincp/admincp_menu.php';
	//require './source/admincp/admincp_perm.php';
	unset($topmenu['index'], $menu['index']);
	$actioncat = $actionarray = array();
	$actioncat[] = 'setting';
	$actioncat = array_merge($actioncat, array_keys($topmenu));
	foreach($menu as $tkey => $items) {
		foreach($items as $item) {
			$actionarray[$tkey][] = $item;
		}
	}
	return array('actions' => $actionarray, 'cats' => $actioncat);
}
function get_log_files($logdir = '', $action = 'action') {
	$dir = opendir($logdir);
	$files = array();
	while($entry = readdir($dir)) {
		$files[] = $entry;
	}
	closedir($dir);

	if($files) {
		sort($files);
		$logfile = $action;
		$logfiles = array();
		$ym = '';
		foreach($files as $file) {
			if(strpos($file, $logfile) !== FALSE) {
				if(substr($file, 0, 6) != $ym) {
					$ym = substr($file, 0, 6);
				}
				$logfiles[$ym][] = $file;
			}
		}
		if($logfiles) {
			$lfs = array();
			foreach($logfiles as $ym => $lf) {
				$lastlogfile = $lf[0];
				unset($lf[0]);
				$lf[] = $lastlogfile;
				$lfs = array_merge($lfs, $lf);
			}
			return $lfs;
		}
		return array();
	}
	return array();
}


include template('log');

?>
