<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */

if(!defined('IN_DZZ')) {
	exit('Access Denied');
}
include_once(DZZ_ROOT.'./core/api/BaiduPCS/BaiduPCS.class.php');
class io_baiduPCS extends io_api
{
	
	const T ='connect_pan';
	const PERM =5; //目录权限 5：读写权限；3：只读;
	private $icosdatas=array();
	/*
	*初始化百度pcs 返回pcs 操作符
	*/
	public function init($path){
		global $_G;
		$bzarr=explode(':',$path);
		$bd_uid=trim($bzarr[1]);
		
		if($baidu=DB::fetch_first("select * from ".DB::table(self::T)." where uid='{$_G[uid]}' and id='{$bd_uid}'")){
			$access_token = $baidu['access_token'];
		}else{
			return array('error'=>'need authorize to baiduPCS');
		}
		return new BaiduPCS($access_token);
	}
	public function authorize(){
		global $_G,$_GET;
		if(empty($_G['uid'])) {
			dsetcookie('_refer', rawurlencode(BASESCRIPT.'?mod=connect&op=oauth&bz=baiduPCS'));
			showmessage('to_login', '', array(), array('showmsg' => true, 'login' => 1));
		}
		require_once(DZZ_ROOT.'./core/api/BaiduPCS/BaiduOAuth2.php');
		$cloud=DB::fetch_first("select `id` , `secret` from ".DB::table('connect')." where bz='baiduPCS'");
		$auth=new BaiduOAuth2($cloud['id'],$cloud['secret']);
		$auth->setRedirectUri();
		if($_GET['code'] && (authcode($_GET['state'],'DECODE')==$auth->getClientId()) && $token=$auth->getAccessTokenByAuthorizationCode($_GET['code'])){
			$token['refreshtime']=TIMESTAMP;
			$token['uid']=$_G['uid'];
			if($token['access_token'] && $userinfo= $auth->getLoggedInUser($token['access_token'])){
				$token['cuid']=$userinfo['uid'];
				$token['cusername']=$userinfo['uname'];
				$token['portrait']=$userinfo['portrait'];
			}
			if($token['cuid']){
				if($id=DB::result_first("select id from ".DB::table(self::T)." where uid='{$_G[uid]}' and cuid='{$token[cuid]}' and bz='baiduPCS'")){
					DB::update(self::T,$token,"id ='{$id}'");
				}else{
					$token['bz']='baiduPCS';
					$token['dateline']=TIMESTAMP;
					DB::insert(self::T,$token);
				}
			}
			include template('oauth');
			exit();
		}
		$state=authcode($auth->getClientId(),'ENCODE');
		$authorizeurl=$auth->getAuthorizeUrl('code','basic netdisk',$state);
		header('Location: ' . $authorizeurl);
	}
	public function parsePath($path){
		$bzarr=explode(':',$path);
		return array('bz'=>$bzarr[0].':'.$bzarr[1].':','path'=>$bzarr[2]);
	}
	
	//获取文件流；
	//$path: 路径
	function getStream($path){
		$bzarr=self::parsePath($path); 
		$pcs=self::init($path);
		if(is_array($pcs) && $pcs['error']) return $pcs;
		return $pcs->getStreamUri($bzarr['path']);
	}
	//获取文件流地址；
	//$path: 路径
	function getFileUri($path){
		$bzarr=self::parsePath($path); 
		$pcs=self::init($path);
		if(is_array($pcs) && $pcs['error']) return $pcs;
		return $pcs->getStreamUri($bzarr['path']);
	}
	//获取缩略图
	public function getThumb($path,$width,$height){
		global $_G;
		$enable_cache=true; //是否启用缓存
		$quality = 80;
		$imgcachePath='./imgcache/';
		$cachepath=str_replace('//','/',str_replace(':','/',$path));
		
		$target=$imgcachePath.($cachepath).'.'.$width.'_'.$height.'.jpeg';
		if($enable_cache && @getimagesize($_G['setting']['attachdir'].$target)){
			header('Content-Type: image/JPEG');
			@ob_end_clean();
			@readfile($_G['setting']['attachdir'].$target);
			@flush(); @ob_flush();
			exit();
		}
		//获取缩略图
		$bzarr=self::parsePath($path); 
		$pcs=self::init($path);
		if(is_array($pcs) && $pcs['error']) return $pcs;
		
		$result = $pcs->thumbnail($bzarr['path'], $width, $height, $quality);
		$targetpath = dirname($_G['setting']['attachurl'].$target);
		dmkdir($targetpath);
		if($enable_cache) file_put_contents($_G['setting']['attachdir'].$target,$result);
		
		header('Content-Type: image/JPEG');
		@ob_end_clean();
		echo $result;
		@flush(); @ob_flush();
	}
	//重写文件内容
	//@param number $path  文件的路径
	//@param string $data  文件的新内容
	public function setFileContent($path,$data){
		$patharr=explode('/',$path);
		$filename=$patharr[count($patharr)-1];
		unset($patharr[count($patharr)-1]);
		$path1=implode('/',$patharr);
		return self::upload($data,$path1,$filename,false,'overwrite');
	}
	/**
	 * 获取当前用户空间配额信息
	 * @return string
	 */
	public function getQuota($bz) {
		$pcs=self::init($bz);
		if(is_array($pcs) && $pcs['error']) return $pcs;
		return $pcs->getQuota();
	}
	/**
	 * 移动文件到目标位置
	 * @param string $opath 被移动的文件路径
	 * @param string $path 目标位置（可能是同一api内或跨api，这两种情况分开处理）
	 * @return icosdatas
	 */
	public function CopyTo($opath,$path,$iscopy){
		$oarr=self::parsePath($opath);
		$arr=IO::parsePath($path);
	try{
		$pcs=self::init($opath);
		if(is_array($pcs) && $pcs['error']) return $pcs;
			if($arr['bz']==$oarr['bz']){ //同一api内
			    $data=self::getMeta($opath);
				$response=$pcs->moveSingle($oarr['path'],$arr['path'].'/'.$data['name']);
		
				$result=json_decode($response,true);
				if($result['error_code']){
					$data['success']=$result['error_msg'];
					return $data;
				}
				$meta=$pcs->getMeta($arr['path'].'/'.$data['name']);
				$meta=json_decode($meta,true);
				//if($meta['error_msg']) return array('error'=>$meta['error_msg']);
				$meta=$meta['list'][0];
				
				$data['newdata']=self::_formatMeta($meta,$arr['bz']);
				$data['success']=true;
				return $data;
			}else{
				$data=self::getMeta($opath);
				switch($data['type']){
					case 'folder'://创建目录
						if($re=IO::CreateFolder($path,$data['name'])){
							if(isset($re['error']) && intval($re['error_code'])!=31061){
								$data['success']=$re['error'];
							}else{
								$data['newdata']=$re['icoarr'];
								$data['success']=true;
								 $contents=self::listFiles($opath);
							//	 print_r($contents);
								 foreach($contents as $key=>$value){
									$data['contents'][$key]=self::CopyTo($value['path'],$re['icoarr']['path']);
								 }
							}
						}
						break;
					default:
						
						//$fileContent=IO::getFileContent($opath);
						if($re=IO::multiUpload($opath,$path,$data['name'])){
							if($re['error']) $data['success']=$re['error'];
							else{
								$data['newdata']=$re;
								$data['success']=true;
							}
						}
				}
			}
		}catch(Exception $e){
			//var_dump($e);
			$data['success']=$e->getMessage();
			return $data;
		}
		return $data;
	}
	
	public function multiUpload($opath,$path,$filename,$ondup="newcopy"){
		global $_G;
	/* 
	 * 分块上传文件
	 * param $file:文件路径（可以是url路径，需要服务器开启allow_url_fopen);
	*/
		@set_time_limit(0);
		$partsize=1024*1024*2; //分块大小2M
		$data=IO::getMeta($opath);
		if($data['error']) return $data;
		$size=$data['size'];
		if(!$filepath=IO::getFileUri($opath)){
			return array('error'=>'文件不存在');
		}
		if($size<$partsize){
			//获取文件内容
			$handle=fopen($filepath, 'rb');
			while(!feof($handle)){
				$fileContent.= fread($handle, 8192);
				//if(strlen($fileContent)==0) return array('error'=>'文件不存在');
			}
			return self::upload($fileContent,$path,$filename);
		}else{ //分片上传
			self::deleteCache($path.$filename);
			$handle=fopen($filepath, 'rb');
			$fileContent='';
			while (!feof($handle)) {
			  	$fileContent.= fread($handle, 8192);
				//if(strlen($fileContent)==0) return array('error'=>'文件不存在');
				if($fileContent>=$partsize){
					$re=self::upload($fileContent,$path,$filename,true);
					if($re['error']){
						 @unlink($cachefile);
						 return $re;
					}
					$fileContent='';
				}
			}
			fclose($handle);
			if(!empty($fileContent)){
				$re=self::upload($fileContent,$path,$filename,true);
				if($re['error']){
					 @unlink($cachefile);
					 return $re;
				}
			}
			//分片上传结束，合并分片文件
			return self::createSuperFile($path,$filename,$ondup);
		}
	}
	/**
	 * 获取指定文件夹下的文件列表
	 * @param string $path 文件路径
	 * @param string $by 排序字段，缺省根据文件类型排序，time（修改时间），name（文件名），size（大小，注意目录无大小）
	 * @param string $order asc或desc，缺省采用降序排序
	 * @param string $limit 返回条目控制，参数格式为：n1-n2。返回结果集的[n1, n2)之间的条目，缺省返回所有条目。n1从0开始。
	 * @param string $force 读取缓存，大于0：忽略缓存，直接调用api数据，常用于强制刷新时。
	 * @return icosdatas
	 */
	function listFiles($path,$by='time',$order='desc',$limit='',$force=0){ 
		global $_G,$_GET,$documentexts,$imageexts;
		
		try{	
			$bzarr=self::parsePath($path);
			$bz=$bzarr['bz'];
			$path1=$bzarr['path'];
			$pcs=self::init($path);
			if(is_array($pcs) && $pcs['error']) return $pcs;
			
			$data=array();
			if($result = $pcs->listFiles($path1, $by, $order, $limit)){
				$result=json_decode($result,true);
				if($result['error_code']){
					return array('error'=>$result['error_msg']);
				}
				else $data=$result['list'];
			}	
			$icosdata=array();
			foreach($data as $key => $value){
				$icoarr=self::_formatMeta($value,$bz);
				$icosdata[$icoarr['icoid']]=$icoarr;
			}
			return $icosdata;
		}catch(Exception $e){
			return array('error'=>$e->getMessage());
		}
	}
	/*
	 *获取文件的meta数据
	 *返回标准的icosdata
	 *$force>0 强制刷新，不读取缓存数据；
	*/
	function getMeta($path,$force=0){ 
		global $_G,$_GET,$documentexts,$imageexts;
		$icosdata=array();
		$bzarr=explode(':',$path);
		$bz=$bzarr[0].':'.$bzarr[1].':';
		$data=array();
		$path1=$bzarr[2];
		// Get the metadata for the file/folder specified in $path
		$pcs=self::init($bz);
		if(is_array($pcs) && $pcs['error']) return $pcs;
		//exit($path1.'==='.$path.'==='.$bz);
		$meta=$pcs->getMeta($path1);
		$meta=json_decode($meta,true);
		//print_r($meta);
		//print_r($baidu);
		//exit($access_token);
		if($meta['error_msg']) return array('error'=>$meta['error_msg']);
		$meta=$meta['list'][0];
		
		$icosdata=self::_formatMeta($meta,$bz);
		return $icosdata;
	}
	//将api获取的meta数据转化为icodata
	function _formatMeta($meta,$bz){ 
		global $_G,$documentexts,$imageexts;
		
		$icosdata=array();
		$bzarr=explode(':',$bz);
		if($meta['isdir']){
			$icoarr=array(
				  'icoid'=>md5(($bz.$meta['path'])),
				  'path'=>$bz.$meta['path'],
				  'bz'=>($bz),
				  'gid'=>0,
				  'name'=>substr(strrchr($meta['path'], '/'), 1),
				  'username'=>$_G['username'],
				  'uid'=>$_G['uid'],
				  'oid'=>md5(($bz.$meta['path'])),
				  'img'=>'dzz/images/sysicon/foldericon/1.png',
				  'type'=>'folder',
				  'ext'=>'',
				  'pfid'=>md5(str_replace(strrchr($meta['path'], '/'), '',$bz.$meta['path'])),
				  'size'=>0,
				  'dateline'=>intval($meta['mtime']),
				   'flag'=>''
				 );
				$icoarr['fsize']=formatsize($icoarr['size']);
				$icoarr['ftype']=getFileTypeName($icoarr['type'],$icoarr['ext']);
				$icoarr['fdateline']=dgmdate($icoarr['dateline']);
				$icosdata=$icoarr;
			
		}else{
			$ext=strtoupper(substr(strrchr($meta['path'], '.'), 1));
			if(in_array($ext,$imageexts)) $type='image';
			elseif(in_array($ext,$documentexts)) $type='document';
			else $type='attach';
			if($type=='image'){
				$img=$_G['siteurl'].DZZSCRIPT.'?mod=io&op=thumbnail&width=256&height=256&path='.rawurlencode($bz.$meta['path']);
				$url=$_G['siteurl'].DZZSCRIPT.'?mod=io&op=thumbnail&width=1440&height=900&path='.rawurlencode($bz.$meta['path']);
			}else{
				$img=geticonfromext($ext,$type);
				$url=$_G['siteurl'].DZZSCRIPT.'?mod=io&op=getStream&path='.rawurlencode($bz.$meta['path']);
			}
			$icoarr=array(
						  'icoid'=>md5(($bz.$meta['path'])),
						  'path'=>($bz.$meta['path']),
						  'bz'=>($bz),
						  'gid'=>0,
						  'name'=>substr(strrchr($meta['path'], '/'), 1),
						  'username'=>$_G['username'],
						  'uid'=>$_G['uid'],
						  'oid'=>md5(($bz.$meta['path'])),
						  'img'=>$img,
						  'url'=>$url,
						  'type'=>$type,
						  'ext'=>strtolower($ext),
						  'pfid'=>md5(str_replace(strrchr($meta['path'], '/'), '',$bz.$meta['path'])),
						  'size'=>$meta['size'],
						  'dateline'=>intval($meta['mtime']),
						  'flag'=>''
						  );
			$icoarr['fsize']=formatsize($icoarr['size']);
			$icoarr['ftype']=getFileTypeName($icoarr['type'],$icoarr['ext']);
			$icoarr['fdateline']=dgmdate($icoarr['dateline']);
			$icosdata=$icoarr;
		}
				
		return $icosdata;
	}
	//通过icosdata获取folderdata数据
	function getFolderByIcosdata($icosdata){
		global $_GET;
		$folder=array();
		if($icosdata['type']=='folder'){
			$folder=array('fid'=>$icosdata['oid'],
						  'path'=>$icosdata['path'],
						  'fname'=>$icosdata['name'],
						  'uid'=>$icosdata['uid'],
						  'pfid'=>md5(str_replace(strrchr($icosdata['path'], '/'), '',$icosdata['path'])),
						  'iconview'=>$_GET['iconview']?intval($_GET['iconview']):1,
						  'disp'=>$_GET['disp']?intval($_GET['disp']):1,
						  'perm'=>self::PERM,
						  'hash'=>$icosdata['hash'],
						  'bz'=>$icosdata['bz'],
						  'gid'=>$icosdata['gid'],
						  'fsperm'=>perm_FolderSPerm::flagPower('baiduPCS')
						);
			
		}
		return $folder;
	}
	//获得文件内容；
	function getFileContent($path){
		$bzarr=explode(':',$path);
		$bz=$bzarr[0].':'.$bzarr[1].';';
		$path1=$bzarr[2];
		try{
			$pcs=self::init($bz);
			if(is_array($pcs) && $pcs['error']) return $pcs;
			return $pcs->download($path1);
		}catch(Exception $e){
			return $e->getMessage();
		}
	}
	//下载文件
	public function download($path){
		global $_G;
		$path=rawurldecode($path);
		$url=self::getStream($path);
		try {
			// Download the file
			$file=self::getMeta($path);
			//$file['data'] = self::getFileContent($path);
			//if($file['data']['error']) IO::topshowmessage($file['data']['error']);
			$file['name'] = '"'.(strtolower(CHARSET) == 'utf-8' && strexists($_SERVER['HTTP_USER_AGENT'], 'MSIE') ? urlencode($file['name']) : $file['name']).'"';
			
			dheader('Date: '.gmdate('D, d M Y H:i:s', $file['dateline']).' GMT');
			dheader('Last-Modified: '.gmdate('D, d M Y H:i:s', $file['dateline']).' GMT');
			dheader('Content-Encoding: none');
			dheader('Content-Disposition: attachment; filename='.$file['name']);
			dheader('Content-Type: application/octet-stream');
			dheader('Content-Length: '.$file['size']);
			
			!$_G['config']['output']['gzip'] && ob_end_clean();
			@readfile($url);
			@flush(); @ob_flush();
			exit();
		} catch (Exception $e) {
			// The file wasn't found at the specified path/revision
			//echo 'The file was not found at the specified path/revision';
			IO::topshowmessage($e->getMessage());
		}
	}
	
	/**
		 * 上传文件
		 * 注意：此方法适用于上传不大于2G的单个文件。
		 * @param string $fileContent 文件内容字符串
		 * @param string $path 上传文件的目标保存路径
		 * @param string $fileName 文件名
		 * @param string $newFileName 新文件名
		 * @param string $ondup overwrite：表示覆盖同名文件；newcopy：表示生成文件副本并进行重命名，命名规则为“文件名_日期.后缀”。 
		 * @param boolean $isCreateSuperFile 是否分片上传
		 * @return string
		 */
	function upload($fileContent,$path,$filename,$isCreateSuperFile=false,$ondup='newcopy'){
		global $_G;
		@set_time_limit(0);
		$bzarr=explode(':',($path));
		$bz=$bzarr[0].':'.$bzarr[1].':';
		$path=$bzarr[2].'/';
		try{
			$pcs=self::init($bz);
			if(is_array($pcs) && $pcs['error']) return $pcs;
			$response = $pcs->upload($fileContent, $path, $filename,null,$isCreateSuperFile,$ondup);
			
			$response=json_decode($response,true);
			if($response['error_msg']){
				return array('error'=>$response['error_msg']);
			}
			if($isCreateSuperFile===true){
				$path0=$bz.$path.$filename;
				if($response['md5']){
					self::saveCache($path0,$response['md5']);
					return true;
				}else{
					return array('error'=>' part upload error');
				}
				
			}else{
				$icoarr=self::_formatMeta($response,$bz);
				return $icoarr;
			}
		}catch(Exception $e){
			return array('error'=>$e->getMessage());
		}
		
	}
	
	function createSuperFile($path,$filename,$ondup='newcopy'){
		global $_G;
		@set_time_limit(0);
		$bzarr=explode(':',($path));
		$bz=$bzarr[0].':'.$bzarr[1].':';
		$path=$bzarr[2].'/';
		try{
			$pcs=self::init($bz);
			if(is_array($pcs) && $pcs['error']) return $pcs;
			$path0=$bz.$path.$filename;
			if(!($params=array_values(self::getCache($path0)))){
				return array('error'=>'文件合并出差错');
			}
			$response = $pcs->createSuperFile($path, $filename,$params,null,$ondup);
			$response=json_decode($response,true);
			if($response['error_msg']){
				return array('error'=>$response['error_msg']);
			}
			
			self::deleteCache($path0);
			$icoarr=self::_formatMeta($response,$bz);
			return $icoarr;
		}catch(Exception $e){
			return array('error'=>$e->getMessage());
		}
	}
	
	
	//删除原内容
	//$path: 删除的路径
	//$bz: 删除的api;
	//$data：可以删除的id数组（当剪切的时候，为了保证数据不丢失，目标位置添加成功后将此id添加到data数组，
	//删除时如果$data有数据，将会只删除id在$data中的数据；
	//如果删除的是目录或下级有目录，需要判断此目录内是否所有元素都在删除的id中，如果有未删除的元素，则此目录保留不会删除；
	//$force 真实删除，不放入回收站
	public function Delete($path,$force=false){
		//global $dropbox;
		$bzarr=explode(':',($path));
		$bz=$bzarr[0].':'.$bzarr[1].':';
		$path1=$bzarr[2];
		try{
			$pcs=self::init($bz);
			if(is_array($pcs) && $pcs['error']) return $pcs;
			$response = $pcs->deleteSingle($path1);
			$response=json_decode($response,true);
			if($response['error_msg']){
				return array('icoid'=>md5(($path)),'error'=>$response['error_msg']);
			}
			return array('icoid'=>md5(($path)),
						 'name'=>substr(strrchr($path, '/'), 1),
						);
		}catch(Exception $e){
			return array('icoid'=>md5($path),'error'=>$e->getMessage());
		}
	}
	//添加目录
	//$fname：目录路径;
	//$container：目标容器
	//$bz：api;
	public function CreateFolder($path,$fname){
		global $_G;
		$bzarr=explode(':',($path));
		$bz=$bzarr[0].':'.$bzarr[1].':';
		$path1=$bzarr[2].'/'.$fname;
		//echo('createrfolder==='.$fname.'===='.$path1.'===='.$bz);
		//echo $path1.'===========';
		$return=array();
		try {
			$pcs=self::init($bz);
			if(is_array($pcs) && $pcs['error']) return $pcs;
			
			$response=$pcs->makeDirectory($path1);
			
			$result=json_decode($response,true);
			if($result['error_code']){
				return array('error'=>$result['error_msg'],'error_code'=>$result['error_code']);
			}
			$result['isdir']=1;
			
			$icoarr=self::_formatMeta($result,$bz);
			$folderarr=self::getFolderByIcosdata($icoarr);
			$return= array('folderarr'=>$folderarr,'icoarr'=>$icoarr);
		}catch(Exception $e){
			//var_dump($e);
			$return=array('error'=>$e->getMessage());
		}
		return $return;
	}
	//获取不重复的目录名称
	public function getFolderName($name,$path){
		static $i=0;
		if(!$this->icosdatas) $this->icosdatas=self::listFiles($path);
		$names=array();
		foreach($icosdatas as $value){
			$names[]=$value['name'];
		}
		if(in_array($name,$names)){
			$name=str_replace('('.$i.')','',$name).'('.($i+1).')';
			$i+=1;
			return self::getFolderName($name,$path);
		}else {
			return $name;
		}
	}
	private function getPartInfo($content_range){
		$arr=array();
		if(!$content_range){
			 $arr['ispart']=false;
			 $arr['iscomplete']=true;
		}elseif(is_array($content_range)){
			$arr['ispart']=true;
			$partsize=2000000;
			$arr['partnum']=ceil(($content_range[2]+1)/$partsize);
			if(($content_range[2]+1)>=$content_range[3]){
			 	$arr['iscomplete']=true;
			}else{
				$arr['iscomplete']=false;
			}
		}else{
			return false;
		}
		return $arr;
	}
	private function getCache($path){
		$cachekey='baidu_upload_'.md5($path);
		$cache=C::t('cache')->fetch($cachekey);
		return (unserialize($cache['cachevalue']));
	}
	private function saveCache($path,$str){
		global $_G;
		$cachekey='baidu_upload_'.md5($path);
		$cachevalue=self::getCache($path);
		$cachevalue[$str]=$str;
		C::t('cache')->insert(array(
							'cachekey' => $cachekey,
							'cachevalue' => serialize($cachevalue),
							'dateline' => $_G['timestamp'],
						), false, true);
	}
	private function deleteCache($path){
		$cachekey='baidu_upload_'.md5($path);
		C::t('cache')->delete($cachekey);
	}
	public function uploadStream($file,$filename,$path,$relativePath,$content_range){
		$data=array();
		//exit($path.'===='.$filename);
		
		//处理目录(没有分片或者最后一个分片时创建目录
		$arr=self::getPartInfo($content_range);
		
		if($relativePath && ($arr['iscomplete'])){
			$path1=$path;
			$patharr=explode('/',$relativePath);
			foreach($patharr as $key=> $value){
				if(!$value){
					unset($patharr[$key]);
					 continue;
				}
				if($patharr[$key-1]) $path1.='/'.$patharr[$key-1];
				
				$re=self::CreateFolder($path1,$value);
				
				if(intval($re['error_code'])==31061){
					continue;
				}else{
					if(isset($re['error'])){
						return $re;
					}else{
						if($key==0){
							$data['icoarr'][]=$re['icoarr'];
							$data['folderarr'][]=$re['folderarr'];
						}
					}
				}
			}
			//$path.='/'.implode('/',$patharr);
		}
		if($relativePath) $path=$path.'/'.$relativePath;
		
		//获取文件内容
		$fileContent='';
		$handle=fopen($file, 'r');
		while (!feof($handle)) {
		  $fileContent .= fread($handle, 8192);
		}
		fclose($handle);
		if($arr['ispart']){
			if($re1=self::upload($fileContent,$path,$filename,true)){
				if($re1['error']){
					return $re1;
				}
				if($arr['iscomplete']){
					$re1=self::createSuperFile($path, $filename);
					if(empty($re1['error'])){
						$data['icoarr'][] = $re1;
						return $data;
					}else{
						$data['error'] = $re1['error'];
						return $data;
					}
				}else{
					return true;
				}
			}
		}else{
			
			$re1=self::upload($fileContent,$path,$filename);
			
			if(empty($re1['error'])){
				$data['icoarr'][] = $re1;
				return $data;
			}else{
				$data['error'] = $re1['error'];
				return $data;
			}
		}
	}
}
?>
