<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */

if(!defined('IN_DZZ')) {
	exit('Access Denied');
}

class io_dzz extends io_api
{
	
	public function parsePath($path){
		return $path;
	}
	//获取文件流地址
	public function getStream($icoid){
		global $_G;
		$icoarr=C::t('icos')->fetch_by_icoid($icoid);
		if($icoarr['remote']) $icoarr['url']=getAttachUrl($icoarr,true);
		else $icoarr['url']=$_G['siteurl'].$_G['setting']['attachurl'].$icoarr['attachment'];
		return ($icoarr['url']);
	}
	//获取文件流地址
	public function getThumb($icoid,$width,$height){
		global $_G;
		$data=C::t('icos')->fetch_by_icoid($icoid);
		if($width>256){
			$url=getAttachUrl($data,true);
			if($data['thumb']>1){
				$url=getimgthumbname($url.'.1440x900');
			}
		}else{
			if($data['thumb']>0) $url=$_G['siteurl'].getimgthumbname($_G['setting']['attachurl'].$data['attachment']);
			else $url=getAttachUrl($data,true);
		}
		header('Content-Type: image/JPEG');
			@ob_end_clean();
			@readfile($url);
			@flush(); @ob_flush();
			exit();
	}
	//获取文件的真实地址
	public function getFileUri($icoid){
		global $_G;
		$icoarr=C::t('icos')->fetch_by_icoid($icoid);
		if($icoarr['remote']){
			 $file=getAttachUrl($icoarr,true);
		}else{
			 $file=$_G['setting']['attachdir'].$icoarr['attachment'];
			 if(!is_file($file)) $file='';
		}
		return $file;
	}
	//获取文件内容
	public function getFileContent($icoid){
		global $_G;
		$icoarr=C::t('icos')->fetch_by_icoid($icoid);
		if($icoarr['remote']) $icoarr['url']=getAttachUrl($icoarr,true);
		else $icoarr['url']=$_G['setting']['attachdir'].$icoarr['attachment'];
		return file_get_contents($icoarr['url']);
	}
	
		
	//重写文件内容
	//@param number $icoid  文件的icoid
	//@param string $message  文件的新内容
	public function setFileContent($icoid,$message){
		global $_G,$space;
		if(!$icoarr=C::t('icos')->fetch_by_icoid($icoid)){
			return array('error' => lang('message','file_not_exist'));
		}
		$gid=DB::result_first("select fid from %t where fid=%d",array('folder',$icoarr['pfid']));
		if(!perm_check::checkperm('admin',$icoarr)){
			return array('error' => lang('message','no_privilege'));
		}
		if(!$attach=getTxtAttachByMd5($message,$icoarr['name'])){
			return array('error' => lang('message','file_save_failure'));
		}
		//计算用户新的空间大小
		$csize=$attach['filesize']-$icoarr['size'];
		//重新计算用户空间
		if($csize){
			if($space['maxspacesize']>0 && !SpaceSize($csize,$gid)){
				return array('error' => lang('message','inadequate_capacity_space'));
			}
			SpaceSize($csize,$gid ,1);
		}
		$oldaid=$icoarr['aid'];
		//更新附件数量
		if($oldaid !=$attach['aid']){
			if($icoarr['type']=='document'){
				C::t('source_document')->update($icoarr['did'],array('aid'=>$attach['aid']));
			}else{
				C::t('source_attach')->update($icoarr['qid'],array('aid'=>$attach['aid']));
			}
			C::t('attachment')->update($attach['aid'],array('copys'=>$attach['copys']+1));
			C::t('attachment')->delete_by_aid($oldaid);
		}
		return $icoarr;
	}
	//查找目录下的同名文件
	//@param string $filename  文件名称
	//@param number $fid  目录id
	//@param bool $isfolder  查找同名目录
	//return icoid  返回icoid
	public function getRepeatIDByName($filename,$fid,$isfolder=false){
		$sql="pfid='{$fid}' and name='{$filename}' and isdelete<1";
		if($isfolder) $sql.=" and type='folder'";
		else $sql.=" and type!='folder'";
		if($icoid=DB::result_first("select icoid from ".DB::table('icos')." where $sql ")){
			 return $icoid;
		}else return false;
	}
	//获取icosdata
	public function getMeta($icoid){
		return C::t('icos')->fetch_by_icoid($icoid);
	}
	public function getFolderByIcosdata($data){
		if($data['type']=='folder'){
			return C::t('folder')->fetch_by_fid($data['oid']);	
		}
		return array();
	}
	
	//下载
	public function download($icoid){
		global $_G;
		
		$attachexists = FALSE;
		$icoid=intval($icoid);
		$icoarr = DB::fetch_first("SELECT * FROM ".DB::table('icos')." WHERE icoid='{$icoid}'");
		//topshowmessage(strpos($refer,'share').'==='.$refer.'==='.$icoarr['urlsid']);
		
		if(!$icoarr['icoid']){
			topshowmessage(lang('message','attachment_nonexistence'));
		}elseif($icoarr['type']=='attach'){
			if(!$attach = DB::fetch_first("SELECT * FROM ".DB::table('source_attach')." WHERE qid='{$icoarr[oid]}'")){
				topshowmessage(lang('message','attachment_nonexistence'));
			}
		}elseif($icoarr['type']=='document'){
			if(!$attach = DB::fetch_first("SELECT * FROM ".DB::table('source_document')." WHERE did='{$icoarr[oid]}'")){
				topshowmessage(lang('message','attachment_nonexistence'));
			}
		}elseif($icoarr['type']=='image'){
			if(!$attach = DB::fetch_first("SELECT * FROM ".DB::table('source_image')." WHERE picid='{$icoarr[oid]}'")){
				topshowmessage(lang('message','attachment_nonexistence'));
			}
		}else{
			topshowmessage(lang('message','attachment_nonexistence'));
		}
		if(!$attachment=DB::fetch_first("select * from ".DB::table('attachment')." where aid='{$attach[aid]}'")){
			topshowmessage(lang('message','attachment_nonexistence'));
		}
		$filename = $_G['setting']['attachdir'].$attachment['attachment'];
		!$_G['config']['output']['gzip'] && ob_end_clean();
		$filesize = !$attachment['remote'] ? filesize($filename) : $attachment['filesize'];
		if(strpos(strtolower($attach['filename']),$attach['filetype'])===false){
			$attach['filename'].='.'.$attachment['filetype'];
		}
		$db = DB::object();
		$db->close();
		$attach['filename'] = '"'.(strtolower(CHARSET) == 'utf-8' && strexists($_SERVER['HTTP_USER_AGENT'], 'MSIE') ? urlencode($attach['title']) : $attach['title']).'"';
		dheader('Date: '.gmdate('D, d M Y H:i:s', $attach['dateline']).' GMT');
		dheader('Last-Modified: '.gmdate('D, d M Y H:i:s', $attach['dateline']).' GMT');
		dheader('Content-Encoding: none');
		dheader('Content-Disposition: attachment; filename='.$attach['filename']);
		dheader('Content-Type: application/octet-stream');
		dheader('Content-Length: '.$filesize);
		
		!$_G['config']['output']['gzip'] && ob_end_clean();
		
		$attachment['remote'] ? self::getremotefile($attachment) : self::getlocalfile($filename);
		exit();
	}
	public function getremotefile($attachment) {
		global $_G;
		@set_time_limit(0);
		/*$file=$_G['setting']['attachdir'].'cache/'.$attachment['attachment'];
		if(!is_file($file)){
			$attachurl=getAttachUrl($attachment,true);
			$data=file_get_contents($attachurl);
			$targetpath=dirname($file);
			@dmkdir($targetpath);
			file_put_contents($file,$data);
		}*/
		$attachurl=getAttachUrl($attachment,true);
		@readfile($attachurl);
		@flush(); @ob_flush();
	}

	public function getlocalfile($filename, $readmod = 2, $range = 0) {
		@readfile($filename);
		@flush(); @ob_flush();
	}
	//删除
	//当文件在回收站时，彻底删除；
	//$force 真实删除，不放入回收站
	public function Delete($icoid,$force=false){
		try{
			
			if(!$icoarr= C::t('icos')->fetch($icoid)){
				C::t('icos')->delete_by_icoid($icoid,true);
				return array('icoid'=>$icoid,'name'=>$icoarr['name']);
			}
			
			if($force || $icoarr['isdelete']){
				if(perm_check::checkperm('realdelete',$icoarr)){
					C::t('icos')->delete_by_icoid($icoid,true);
				}else{
					return array('icoid'=>$icoarr['icoid'],'error'=>'no privilege');
				}
			}else{
				if(perm_check::checkperm('delete',$icoarr)){
					 C::t('icos')->update($icoid,array('isdelete'=>1,'deldateline'=>TIMESTAMP));
					 if($icoarr['type']=='folder') C::t('folder')->update($icoarr['oid'],array('isdelete'=>1,'deldateline'=>TIMESTAMP));
				}else{
					return array('icoid'=>$icoarr['icoid'],'error'=>'no privilege');
				}
			}
			return array('icoid'=>$icoarr['icoid'],'name'=>$icoarr['name']);
		}catch(Exception $e){
			return array('error'=>$e->getMessage());
		}
	}
	//检查名称是否重复
	public function check_name_repeat($name,$pfid){
		return DB::result_first("select icoid from ".DB::table('icos')." where name='{$name}' and  pfid='{$pfid}'");
	}
	//过滤文件名称
	public function name_filter($name){
		return str_replace(array('/','\\',':','*','?','<','>','|','"'),'',$name);
	}
	
	//获取不重复的目录名称
	public function getFolderName($name,$pfid){
		static $i=0;
		$name=self::name_filter($name);
		//echo("select COUNT(*) from ".DB::table('folder')." where fname='{$name}' and  pfid='{$pfid}'");
		if(DB::result_first("select COUNT(*) from ".DB::table('icos')." where type='folder' and name='{$name}' and  pfid='{$pfid}' and isdelete<1")){
			$name=preg_replace("/\(\d+\)/i",'',$name).'('.($i+1).')';
			$i+=1;
			return self::getFolderName($name,$pfid);
		}else{
			return $name;
		}
	}
	//获取不重复的目录名称
	public function getFileName($name,$pfid){
		static $i=0;
		$name=self::name_filter($name);
		//echo("select COUNT(*) from ".DB::table('folder')." where fname='{$name}' and  pfid='{$pfid}'");
		if(DB::result_first("select COUNT(*) from ".DB::table('icos')." where type!='folder'  and name='{$name}' and isdelete<1 and  pfid='{$pfid}'")){
			$ext='';
			$namearr=explode('.',$name);
			if(count($namearr)>1){
				$ext=$namearr[count($namearr)-1];
				unset($namearr[count($namearr)-1]);
				$ext=$ext?('.'.$ext):'';
			}
			$tname=implode('.',$namearr);
			$name=preg_replace("/\(\d+\)/i",'',$tname).'('.($i+1).')'.$ext;
			$i+=1;
			return self::getFileName($name,$pfid);
		}else{
			return $name;
		}
	}
	 //获取系统默认目录图标
	public function get_folder_sysicon(){
			$icon=DB::result_first("select icon from ".DB::table('icon_sys')." where  `default`=1 LIMIT 1");
			if(!$icon){
				$icon=DB::result_first("select icon from ".DB::table('icon_sys')." where 1 ORDER BY disp LIMIT 1");
			}
			if($icon){
				return SYSICON_FOLDER.$icon;
			}else{
				return 'dzz/images/default/folder.png';
			}
	}
	
	//创建目录
	public function CreateFolder($pfid,$fname,$perm,$ondup='newcopy'){
		global $_G,$_GET;
		if(!$folder=DB::fetch_first("select fid,pfid,iconview,disp,gid from %t where fid=%d",array('folder',$pfid))){
			return array('error'=>'父目录不存在');
		}
		if(!perm_check::checkperm_Container($pfid,'folder')){
			return array('error'=>lang('message','no_privilege'));
		}
		if($icoid=self::getRepeatIDByName($fname,$pfid,true)){//如果目录下有同名目录
			if($ondup='overwrite'){//覆盖
				$data=array();
				$data['icoarr']=C::t('icos')->fetch_by_icoid($icoid);
				$data['folderarr']=self::getFolderByIcosdata($data['icoarr']);
				 return $data;
			}else $fname=self::getFolderName($fname,$pfid); //重命名
		}
		$setarr=array('fname'=>$fname,
					  'uid'=>$_G['uid'],
					  'username'=>$_G['username'],
					  'pfid'=>$folder['fid'],
					  'iconview'=>$folder['iconview'],
					  'disp'=>$folder['disp'],
					  'perm'=>$perm,
					  'flag'=>'folder',
					  'dateline'=>$_G['timestamp'],
					  'gid'=>$folder['gid'],
					  'ficon'=>''
					 );
		if($setarr['fid']=C::t('folder')->insert($setarr,true)){
			$setarr['path']=$setarr['fid'];
		
			$setarr['title']=$setarr['fname'];
			$setarr['ext']='';
			$setarr['size']=0;
			
			$setarr1=array(
							'uid'=>$_G['uid'],
							'username'=>$_G['username'],
							'oid'=>$setarr['fid'],
							'name'=>$setarr['fname'],
							'type'=>'folder',
							'flag'=>'',
							'dateline'=>$_G['timestamp'],
							'pfid'=>$folder['fid'],
							'gid'=>$folder['gid'],
							'ext'=>'',
							'size'=>0,
							);
			if($setarr1['icoid']=DB::insert('icos',($setarr1),1)){
				//$setarr1=array_merge($setarr,$setarr1);
				//if(empty($setarr1['img'])) $setarr1['img']=$setarr['icon'];
				$setarr1['path']=$setarr1['icoid'];
				$setarr1['bz']='';
				addtoconfig($setarr1);
					
					$setarr1['fsize']=formatsize($setarr1['size']);
					$setarr1['ftype']=getFileTypeName($setarr1['type'],$setarr1['ext']);
					$setarr1['fdateline']=dgmdate($setarr1['dateline']);
					//if($gid) C::t('group_log')->setLog($_G['uid'],$_G['gid'],'createfolder',lang('message','xiezuo_log_createfolder',array('username'=>$_G['username'],'position'=>getPositionName($pfid),'name'=>$setarr['fname'])));
					return array('icoarr'=>$setarr1,'folderarr'=>$setarr);
				/*}else{
					C::t('icos')->delete_by_icoid($setarr1['icoid']);
					return false;
				}*/
				
			}
		}
		return false;
	}
	public function getPath($ext,$dir='dzz'){
		global $_G;
		    $subdir = $subdir1 = $subdir2 = '';
			$subdir1 = date('Ym');
			$subdir2 = date('d');
			$subdir = $subdir1.'/'.$subdir2.'/';
			$target1=$dir.'/'.$subdir.'index.html';
			$target=$dir.'/'.$subdir;
			$target_attach=$_G['setting']['attachdir'].$target1;
			$targetpath = dirname($target_attach);
			dmkdir($targetpath);
			return $target.date('His').''.strtolower(random(16)).$ext;
	 }
	public function save($target,$filename) {
	 global $_G;
	 	$filepath=$_G['setting']['attachdir'].$target;
        $md5=md5_file($filepath);
		if($md5 && $attach=DB::fetch_first("select * from ".DB::table('attachment')." where md5='{$md5}'")){
			$attach['filename']=$filename;
			$pathinfo = pathinfo($filename);
			$ext = $pathinfo['extension']?$pathinfo['extension']:'';
			$attach['filetype']=$ext;
			@unlink($filepath);
			return $attach;
		}else{
			$pathinfo = pathinfo($filename);
			$ext = $pathinfo['extension']?$pathinfo['extension']:'';
			$filesize=filesize($filepath);
			$remote=MoveAttachToAliyun(str_replace('/','-',$target),$filepath);
			$needpdfArr=array('doc','xls','ppt','docx','xlsx','pptx','doc','xls','ppt','odt','ods','odg','rtf','et','dps','wps','pdf');
			if(in_array(strtolower($ext),$needpdfArr)){
				$ispdf=0;
				$needpdf=1;
			}else $needpdf=0;
        	$attach=array(
			
				'filesize'=>$filesize,
				'attachment'=>$target,
				'filetype'=>strtolower($ext),
				'filename' =>$filename,
				'remote'=>$remote,
				'copys' => 0,
				'md5'=>$md5,
				'needpdf'=>$needpdf,
				'pdf'=>$ispdf,
				'dateline' => $_G['timestamp'],
			);
			if($attach['aid']=DB::insert('attachment',($attach),1)){
				//if($needpdf) dfsockopen(CONVERTURL,0, '', '', FALSE, '',1);
				return $attach;
			}else{
				return false;
			}
		}
    }
	public function uploadToattachment($attach,$fid){
		global $_G,$documentexts,$space;
		
		$gid=DB::result_first("select gid from ".DB::table('folder')." where fid='{$fid}'");
		
		$filename=trim(rtrim($attach['filename'],$attach['filetype']),'.');
		$attach['filename']=self::getFolderName($filename,$fid).'.'.$attach['filetype'];
		
		$imgexts  = array('jpg', 'jpeg', 'gif', 'png', 'bmp');
		//图片文件时
		if(in_array(($attach['filetype']),$imgexts)){
			/*if(!perm_check::checkperm_Container($fud,'image')){ //判断容器图片权限
				return array('error' => lang('message','target_not_accept_image'));		
			}*/
			//生成缩略图
			require_once libfile('class/image');
			$attachment=getAttachUrl($attach,true);
			$image = new image;
			$thumb1=$thumb2=0;
				if($thumb = $image->Thumb($attachment,getimgthumbname($attach['attachment']),256, 256,1)){
					$thumb1=1;
				}
				if(in_array($attach['filetype'],array('jpg','jpeg')) && $thumb = $image->Thumb($attachment,getimgthumbname($attach['attachment'].'.1440x900'),1441,901,1)){
					if(MoveAttachToAliyun(str_replace('/','-',getimgthumbname($attach['attachment'].'.1440x900')),$_G['setting']['attachdir'].getimgthumbname($attach['attachment'].'.1440x900'))){
						$thumb2=1;
					}
				}
			if($thumb=$thumb1+$thumb2) DB::update('attachment',array('thumb'=>$thumb),"aid='{$attach[aid]}'");
			$imginfo=@getimagesize($attachment);
			$sourcedata=array(
								'uid'=>$_G['uid'],
								'username'=>$_G['username'],
								'dateline' => $_G['timestamp'],
								'postip' => $_G['clientip'],
								'title' => $attach['filename'],
								'desc'=>'',
								'aid'=>$attach['aid'],
								'width'=>$imginfo[0],
								'height'=>$imginfo[1],
								'gid'=>$gid
			);
			if($sourcedata['picid']=DB::insert('source_image',($sourcedata),1)){
				C::t('attachment')->update($attach['aid'],array('copys'=>$attach['copys']+1));
				//$sourcedata=array_merge($attach,$sourcedata);
				$sourcedata['url']=getAttachUrl($attach,true);
				if($sourcedata['thumb']) $sourcedata['icon']=getimgthumbname($_G['setting']['attachurl'].$attach['attachment']);
				else $sourcedata['icon']=$sourcedata['url'];
				if($sourcedata['thumb']>1){
					$sourcedata['url']=getimgthumbname($sourcedata['url'].'.1440x900');
				}
				$icoarr=array(
						'uid'=>$_G['uid'],
						'username'=>$_G['username'],
						'oid'=>$sourcedata['picid'],
						'name'=>$sourcedata['title'],
						'img'=>'',
						'dateline'=>$_G['timestamp'],
						'pfid'=>$fid,
						'type'=>'image',
						'flag'=>'',
						'opuid'=>$_G['uid'],
						'gid'=>$gid,
						'ext'=>$attach['filetype'],
						'size'=>$attach['filesize']
				);
				if($icoarr['icoid']=DB::insert('icos',($icoarr),1)){
					$icoarr['url']=$sourcedata['url'];
					$icoarr['img']=$sourcedata['icon'];
					$icoarr['bz']='';
					$icoarr['path']=$icoarr['icoid'];
					//$icoarr=array_merge($sourcedata,$icoarr);
				}else{
					C::t('source_image')->delete_by_picid($sourcedata['picid']);
				}
			}
	
		}elseif(in_array(strtoupper($attach['filetype']),$documentexts)){
			/*if(!dzz_checkperm_Container($container,'document')){
				return array('error' => lang('message','target_not_accept_document'));		
			}*/
			$sourcedata=array(
								'uid'=>$_G['uid'],
								'username'=>$_G['username'],
								'title'=>$attach['filename'],
								'desc'=>'',
								'dateline' => $_G['timestamp'],
								'aid'=>$attach['aid'],
								'gid'=>$gid
			
			);
			if($sourcedata['did']=DB::insert('source_document',($sourcedata),1)){
				C::t('attachment')->update($attach['aid'],array('copys'=>$attach['copys']+1));
				//$sourcedata=array_merge($attach,$sourcedata);
				$sourcedata['icon']=geticonfromext($attach['filetype'],'document');
				$sourcedata['title']=$attach['filename'];
				$sourcedata['url']=getAttachUrl($attach,true);
				$icoarr=array(
								'uid'=>$_G['uid'],
								'username'=>$_G['username'],
								'oid'=>$sourcedata['did'],
								'name'=>$attach['filename'],
								'img'=>'',
								'type'=>'document',
								'opuid'=>$_G['uid'],
								'dateline'=>$_G['timestamp'],
								'pfid'=>$fid,
								'flag'=>'',
								'gid'=>$gid,
								'ext'=>$attach['filetype'],
								'size'=>$attach['filesize']
								
				);
			
				if($icoarr['icoid']=DB::insert('icos',($icoarr),1)){
					$icoarr['url']=$sourcedata['url'];
					$icoarr['img']=$sourcedata['icon'];
					$icoarr['bz']='';
					$icoarr['path']=$icoarr['icoid'];
					
					//$icoarr=array_merge($sourcedata,$icoarr);
				}else{
					C::t('source_document')->delete_by_did($sourcedata['aid']);
				}
					
			}
		}else{
			/*if(!dzz_checkperm_Container($container,'attach')){
				return array('error' => lang('message','target_not_accept_attach'));		
			}*/
			$sourcedata=array(
								'uid'=>$_G['uid'],
								'username'=>$_G['username'],
								'title'=>$attach['filename'],
								'desc'=>'',
								'dateline' => $_G['timestamp'],
								'aid'=>$attach['aid'],
								'gid'=>$gid
			
			);
			if($sourcedata['qid']=DB::insert('source_attach',($sourcedata),1)){
				C::t('attachment')->update($attach['aid'],array('copys'=>$attach['copys']+1));
				//$sourcedata=array_merge($attach,$sourcedata);
				$sourcedata['icon']=geticonfromext($attach['filetype'],'attach');
				$sourcedata['url']=getAttachUrl($attach,true);
				
				$icoarr=array(
								'uid'=>$_G['uid'],
								'username'=>$_G['username'],
								'oid'=>$sourcedata['qid'],
								'name'=>$attach['filename'],
								'img'=>'',
								'type'=>'attach',
								'flag'=>'',
								'opuid'=>$_G['uid'],
								'dateline'=>$_G['timestamp'],
								'pfid'=>$fid,
								'gid'=>$gid,
								'ext'=>$attach['filetype'],
								'size'=>$attach['filesize']
								
				);
				
				if($icoarr['icoid']=DB::insert('icos',($icoarr),1)){
					$icoarr['url']=$sourcedata['url'];
					$icoarr['img']=$sourcedata['icon'];
					$icoarr['bz']='';
					$icoarr['path']=$icoarr['icoid'];
					//$icoarr=array_merge($sourcedata,$icoarr);
				}else{
					C::t('source_attach')->delete_by_did($sourcedata['aid']);
				}
				
			}
		}
		
				
		if($icoarr['icoid'] ){
			if($icoarr['size']) SpaceSize($icoarr['size'],$gid,true);
			addtoconfig($icoarr);
			//$icoarr['container']=$container;
			$icoarr['fsize']=formatsize($icoarr['size']);
			$icoarr['ftype']=getFileTypeName($icoarr['type'],$icoarr['ext']);
			$icoarr['fdateline']=dgmdate($icoarr['dateline']);
			//if($gid) C::t('group_log')->setLog($gid,$_G['uid'],'upload',lang('message','xiezuo_log_uploadto',array('username'=>$_G['username'],'position'=>getPositionName($fid),'name'=>$icoarr['name'])));
			return $icoarr;
		}else{
			return array('error' => lang('message','data error'));			
		}
	}
	protected function createFolderByPath($path,$pfid){
		$data=array('pfid'=>$pfid);
		if(!$path){
			$data['pfid']=$pfid;
		}else{
			$patharr=explode('/',$path);
			//生成目录
			foreach($patharr as $fname){
				if(!$fname) continue;
				//判断是否含有此目录
				if($fid=DB::result_first("select fid from ".DB::table('folder')." where pfid='{$pfid}' and isdelete<1 and fname='{$fname}'")){
					$data['pfid']=$fid;
				}else{
					if($re=$this->CreateFolder($data['pfid'],$fname)){
						$data['icoarr'][]=$re['icoarr'];
						$data['folderarr'][]=$re['folderarr'];
						$data['pfid']=$re['folderarr']['fid'];
					}else{
						$data['error']='create folder error!';
						return $data;
					}
				}
			}
		}
		return $data;
	}
	private function getCache($path){
		$cachekey='dzz_upload_'.md5($path);
		$cache=C::t('cache')->fetch($cachekey);
		return $cache['cachevalue'];
	}
	private function saveCache($path,$str){
		global $_G;
		$cachekey='dzz_upload_'.md5($path);
		C::t('cache')->insert(array(
							'cachekey' => $cachekey,
							'cachevalue' => $str,
							'dateline' => $_G['timestamp'],
						), false, true);
	}
	private function deleteCache($path){
		$cachekey='dzz_upload_'.md5($path);
		C::t('cache')->delete($cachekey);
	}
	private function getPartInfo($content_range){
		$arr=array();
		if(!$content_range){
			 $arr['ispart']=false;
			 $arr['iscomplete']=true;
		}elseif(is_array($content_range)){
			$arr['ispart']=true;
			$partsize=2000000;
			$arr['partnum']=ceil(($content_range[2]+1)/$partsize);
			if(($content_range[2]+1)>=$content_range[3]){
			 	$arr['iscomplete']=true;
			}else{
				$arr['iscomplete']=false;
			}
		}else{
			return false;
		}
		return $arr;
	}
	public function uploadStream($file,$filename,$pfid,$relativePath,$content_range){
		$data=array();
		//处理目录(没有分片或者最后一个分片时创建目录
		$arr=self::getPartInfo($content_range);
		$data['pfid']=$pfid;
		if($arr['iscomplete']){
			$data=self::createFolderByPath($relativePath,$pfid);
			if(isset($data['error'])){
				return array('error'=>$data['error']);
			}
		}
		$arr['flag']=$pfid.'_'.$relativePath;
		
		//获取文件内容
		$fileContent='';
		$handle=fopen($file, 'r');
		while (!feof($handle)) {
		  $fileContent .= fread($handle, 8192);
		}
		fclose($handle);
		if($arr['ispart']){
			$re=self::upload($fileContent,$data['pfid'],$filename,$arr);
			if($arr['iscomplete']){
				if(empty($re['error'])){
					$data['icoarr'][] = $re;
					return $data;
				}else{
					$data['error'] = $re['error'];
					return $data;
				}
			}else{
				return true;	
			}
		}else{
			$re=self::upload($fileContent,$data['pfid'],$filename);
			if(empty($re['error'])){
				$data['icoarr'][] = $re;
				return $data;
			}else{
				$data['error'] = $re['error'];
				return $data;
			}
		}
	}
	/**
		 * 上传文件
		 * 注意：此方法适用于上传不大于2G的单个文件。
		 * @param string $fileContent 文件内容字符串
		 * @param string $fid 上传文件的目标保存目录fid
		 * @param string $fileName 文件名
		 * @param string $ondup overwrite：表示覆盖同名文件；newcopy：表示生成文件副本并进行重命名，命名规则为“文件名_日期.后缀”。 
		 * @param boolean $isCreateSuperFile 是否分片上传
		 * @return string
		 */
	public function upload($fileContent,$fid,$filename,$partinfo=array(),$ondup='newcopy'){
		global $_G;
		@set_time_limit(0);
		if(!$fileContent){
			return array('error'=>'文件内容不能为空');
		}
		if($icoid=self::getRepeatIDByName($filename,$fid)){//如果目录下有同名文件
			if($ondup=='overwrite') return self::overwriteUpload($fileContent,$icoid,$filename,$partinfo);//覆盖
			else $filename=self::getFileName($filename,$fid); //重命名
		}
		 if($partinfo['ispart']){
			 
			 if($partinfo['partnum']==1){
				 $pathinfo = pathinfo($filename);
				$ext = $pathinfo['extension'];
				$target=$this->getPath($ext?('.'.$ext):'','dzz');
				self::saveCache($partinfo['flag'].'_'.md5($filename),$target);
			 }else{
				 $target=self::getCache($partinfo['flag'].'_'.md5($filename));
			 }
			
			 file_put_contents(
                        $_G['setting']['attachdir'].$target,
                        $fileContent,
                        FILE_APPEND
                    );
			if(!$partinfo['iscomplete']) return true;
			else{
				self::deleteCache($partinfo['flag'].'_'.md5($filename));
			}
		 }else{
			    $pathinfo = pathinfo($filename);
				$ext = $pathinfo['extension'];
				$target=$this->getPath($ext?('.'.$ext):'','dzz');
				if(!file_put_contents($_G['setting']['attachdir'].$target,$fileContent)){
					return array('error'=>'缓存文件到本地出现错误，请确认缓存目录有写入权限');
				}
		}
		
	   
		if($attach=$this->save($target,$filename)){
			if($attach['error']){
				  return array('error'=>$attach['error']);
			}else{
				$re=$this->uploadToattachment($attach,$fid);
				if(!empty($re['error'])){
					$data['error'] = $re['error'];
					return $data;
				}else{
					return $re;
				}
			}
		} else {
			return array('error'=>'Could not save uploaded file. The upload was cancelled, or server error encountered');
		}
		
	}
	public function overwriteUpload($fileContent,$icoid,$filename,$partinfo=array()){
		global $_G,$space;
		@set_time_limit(0);
		if(!$fileContent){
			return array('error'=>'文件内容不能为空');
		}
		if(!$icoarr=C::t('icos')->fetch_by_icoid($icoid)){
			return array('error' => lang('message','文件不存在'));
		}
		$gid=DB::result_first("select fid from %t where fid=%d",array('folder',$icoarr['pfid']));
		if(!perm_check::checkperm('admin',$icoarr)){
			return array('error' => lang('message','no_privilege'));
		}
		$target=$icoarr['attachment'];
		if($partinfo['ispart']){
			 if($partinfo['partnum']==1){
				  file_put_contents( $_G['setting']['attachdir'].$target, $fileContent);
			 }else{
				 file_put_contents(
							$_G['setting']['attachdir'].$target,
							$fileContent,
							FILE_APPEND
						);
				if(!$partinfo['iscomplete']) return true;
			 }
		}else{
		   file_put_contents($_G['setting']['attachdir'].$target,$fileContent);
		}
	
		
		if(!$attach=self::save($target,$icoarr['name'])){
			return array('error' => lang('message','文件保存错误'));
		}
		//计算用户新的空间大小
		$csize=$attach['filesize']-$icoarr['size'];
		//重新计算用户空间
		if($csize){
			if(!SpaceSize($csize,$gid)){
				return array('error' => lang('message','inadequate_capacity_space'));
			}
			SpaceSize($csize,$gid ,1);
		}
		$oldaid=$icoarr['aid'];
		//更新附件数量
		if($oldaid !=$attach['aid']){
			if($icoarr['type']=='document'){
				C::t('source_document')->update($icoarr['did'],array('aid'=>$attach['aid']));
			}else{
				C::t('source_attach')->update($icoarr['qid'],array('aid'=>$attach['aid']));
			}
			C::t('attachment')->update($attach['aid'],array('copys'=>$attach['copys']+1));
			C::t('attachment')->delete_by_aid($oldaid);
		}
		$icoarr['size']=$attach['filesize'];
		$icoarr['aid']=$attach['aid'];
		return $icoarr;
	}
	
	//判断附件是否已经存在，返回附件数组
	public function dzz_imagetoattach($link,$gid){
		global $_G;
		$md5=md5_file($link);
		if($md5 && $attach=C::t('attachment')->fetch_by_md5($md5)){
			  //判断空间大小
			  if(!SpaceSize($attach['filesize'],$gid)){
				 return array('error' => lang('message','inadequate_capacity_space'));
			 }
			return $attach;
		}else{
			if($target=imagetolocal($link,'dzz')){
				//判断空间大小
				$size=@filesize($_G['setting']['attachdir'].$target);
				//判断空间大小
				 if(!SpaceSize($size,$gid)){
					@unlink($_G['setting']['attachdir'].$target);
					return array('error' => lang('message','inadequate_capacity_space'));
				 }
				 $object=str_replace('/','-',$target);
				 $remote=$remote=MoveAttachToAliyun($object,$_G['setting']['attachdir'].$target);
				
				$attach=array(
								'filesize'=>intval($size),
								'attachment'=>$target,
								'filetype'=>strtolower(substr(strrchr($link, '.'), 1, 10)),
								'filename' =>substr(strrchr($link, '/'), 1, 50),
								'remote'=>$remote,
								'copys' => 1,
								'md5'=>$md5,
								'dateline' => $_G['timestamp'],
				);
				if($attach['aid']=DB::insert('attachment',($attach),1)){
					return $attach;
				}
			}
		}
		return false;
	}
	public function linktoimage($link,$pfid){
		global $_G,$space;
		$fid=$pfid;
		$gid=DB::result_first("select gid from %t where fid =%d",array('folder',$pfid));
		if(!$cimage=DB::fetch_first("select * from ".DB::table('cai_image')." where ourl='{$link}'")){
			if($attach=self::dzz_imagetoattach($link,$gid)){
				if($attach['error']) return $attach;
				//生成缩略图
				$attachment=getAttachUrl($attach,true);
				require_once libfile('class/image');
				$image = new image;
				$thumb1=$thumb2=0;
				if($thumb = $image->Thumb($attachment,getimgthumbname($attach['attachment']),256, 256,1)){
					$thumb1=1;
				}
				if(in_array($attach['filetype'],array('jpg','jpeg')) && $thumb = $image->Thumb($attachment,getimgthumbname($attach['attachment'].'.1440x900'),1441,901,1)){
					if(MoveAttachToAliyun(str_replace('/','-',getimgthumbname($attach['attachment'].'.1440x900')),$_G['setting']['attachdir'].getimgthumbname($attach['attachment'].'.1440x900'))){
						$thumb2=1;
					}
				}
				if($thumb=$thumb1+$thumb2) C::t('attachment')->update($attach['aid'],array('thumb'=>$thumb));
				
				$cimage=array(	
								'ourl'=>$link,
								'aid'=>$attach['aid'],
								'copys'=>0,
								'dateline'=>$_G['timestamp']
								);
				$cimage['cid']=DB::insert('cai_image',($cimage),1);
				
			}else{
				return array('error' => lang('message','image_to_local_error'));
			}
		}else{
			$attach=C::t('attachment')->fetch($cimage['aid']);
		}
		//判断空间大小
		  if($space['maxspacesize']>0 && !SpaceSize($attach['filesize'],$gid)){
			 return array('error' => lang('message','inadequate_capacity_space'));
		 }
		$imginfo=@getimagesize($attachment);
		$sourcedata=array(
					'uid'=>$_G['uid'],
					'username'=>$_G['username'],
					'dateline' => $_G['timestamp'],
					'title' =>$attach['filename'],
					'desc'=>'',
					'postip' => $_G['clientip'],
					'desc' => $cimage['title'],
					'cid'=>$cimage['cid'],
					'aid'=>$cimage['aid'],
					'width'=>$imginfo[0],
					'height'=>$imginfo[1],
					'gid'=>$gid
		);
		if($sourcedata['picid']=DB::insert('source_image',($sourcedata),1)){
			C::t('cai_image')->update($cimage['cid'],array('copys'=>$cimage['copys']+1));
			if($cimage['aid']) C::t('attachment')->update($cimage['aid'],array('copys'=>$attach['copys']+1));
			//$sourcedata=array_merge($attach,$sourcedata);
	
			$sourcedata['url']=getAttachUrl($attach,true);
			if($attach['thumb']) $sourcedata['icon']=getimgthumbname($_G['setting']['attachurl'].$attach['attachment']);
			else $sourcedata['icon']=$sourcedata['url'];
			if($sourcedata['thumb']>1){
				$sourcedata['url']=getimgthumbname($sourcedata['url'].'.1440x900');
			}
			
			$icoarr=array(
							'uid'=>$_G['uid'],
							'username'=>$_G['username'],
							'oid'=>$sourcedata['picid'],
							'name'=>self::getFileName(strtolower(substr(strrchr($link, '/'), 1, 50)),$fid),
							'img'=>'',
							'flag'=>'',
							'type'=>'image',
							'dateline'=>$_G['timestamp'],
							'pfid'=>$fid,
							'opuid'=>$_G['uid'],
							'gid'=>$gid,
							'ext'=>$attach['filetype'],
							'size'=>$attach['filesize'],
			);
			
			if($icoarr['icoid']=DB::insert('icos',($icoarr),1)){
				$icoarr['url']=$sourcedata['url'];
				$icoarr['img']=$sourcedata['icon'];
				$icoarr['bz']='';
				$icoarr['path']=$icoarr['icoid'];
				$icoarr=array_merge($sourcedata,$icoarr);
				if($icoarr['size']) SpaceSize($icoarr['size'],$gid,true);
				addtoconfig($icoarr);
				$icoarr['fsize']=formatsize($icoarr['size']);
				$icoarr['ftype']=getFileTypeName($icoarr['type'],$icoarr['ext']);
				$icoarr['fdateline']=dgmdate($icoarr['dateline']);
				//if($gid) C::t('group_log')->setLog($gid,$_G['uid'],'addimage',lang('message','xiezuo_log_addimage',array('username'=>$_G['username'],'position'=>getPositionName($fid),'name'=>$icoarr['name'])));
			}else{
				C::t('source_image')->delete_by_picid($sourcedata['picid']);
			}
		}
		if($icoarr['icoid'] ){
			return $icoarr;
		}else{
			return array('error' => lang('message','linktoimage_error'));
		}
	}
	public function linktomusic($link,$pfid){
		global $_G;
		$fid=$pfid;
		$gid=DB::result_first("select gid from %t where fid =%d",array('folder',$pfid));
		if(!$cmusic=DB::fetch_first("select * from ".DB::table('cai_music')." where ourl='{$link}'")){
				$cmusic=array(	
								'url'=>$link,
								'ourl'=>$link,
								'img'=>'',
								'desc' =>'',
								'title' => strtolower(substr(strrchr($link, '/'), 1, 50)),
								'copys' => 0,
								'dateline'=>$_G['timestamp']
								);
				$cmusic['cid']=DB::insert('cai_music',($cmusic),1);	
		}
		$sourcedata=array(
							'uid'=>$_G['uid'],
							'username'=>$_G['username'],
							'icon'=>$cmusic['img'],
							'desc' =>$cmusic['desc'],
							'title' =>$cmusic['title'],
							'cid'=>$cmusic['cid'],
							'dateline' => $_G['timestamp'],
							'gid'=>$gid
		
		);
		if($sourcedata['mid']=DB::insert('source_music',($sourcedata),1)){
			C::t('cai_music')->update($cmusic['cid'],array('copys'=>$cmusic['copys']+1));
			$sourcedata['icon']=$sourcedata['icon']?$sourcedata['icon']:geticonfromext('','music');
			$icoarr=array(
							'uid'=>$_G['uid'],
							'username'=>$_G['username'],
							'oid'=>$sourcedata['mid'],
							'name'=>self::getFileName($sourcedata['title'],$fid),
							'img'=>'',
							'flag'=>'',
							'type'=>'music',
							'pfid'=>$fid,
							'opuid'=>$_G['uid'],
							'dateline'=>$_G['timestamp'],
							'gid'=>$gid,
							'ext'=>'',
							'size'=>0
			);
			if($icoarr['icoid']=DB::insert('icos',($icoarr),1)){
				$icoarr['url']=$sourcedata['url'];
				$icoarr['img']=$sourcedata['icon'];
				$icoarr['bz']='';
				$icoarr['path']=$icoarr['icoid'];
				addtoconfig($icoarr);
				$icoarr['fsize']=formatsize($icoarr['size']);
				$icoarr['ftype']=getFileTypeName($icoarr['type'],$icoarr['ext']);
				$icoarr['fdateline']=dgmdate($icoarr['dateline']);
				//if($gid) C::t('group_log')->setLog($gid,$_G['uid'],'addmusic',lang('message','xiezuo_log_addmusic',array('username'=>$_G['username'],'position'=>getPositionName($fid),'name'=>$icoarr['name'])));
			}else{
				DB::delete('music',"mid='{$sourcedata[mid]}'");
			}
		}
		
		if($icoarr['icoid'] ){
			return $icoarr;
		}else{
			return array('error' => lang('message','linketomusic_error'));
		}
	}
	public function linktovideo($link,$pfid){
		global $_G;
		$videoext  = array('swf', 'flv');
		$fid=$pfid;
		$gid=DB::result_first("select gid from %t where fid =%d",array('folder',$pfid));
		if(!$cvideo=DB::fetch_first("select * from ".DB::table('cai_video')." where ourl='{$link}'")){
			$arr=array();
			require_once dzz_libfile('function/video');
			if(!$arr=parseflv($link)){
				return false;
			}
			//采集标题和描述
			if(!$arr['title'] || !$arr['description']){
				require_once dzz_libfile('class/caiji');
				$caiji=new caiji($link);
				$arr['title']=$caiji->getTitle();
				$arr['description']=$caiji->getDescription();
			}
			$cvideo=array(	
							'url'=>$arr['url'],
							'ourl'=>$link,
							'img'=>$arr['img'],
							'desc' =>$arr['description'],
							'title' => $arr['title'],
							'copys' => 0,
							'dateline'=>$_G['timestamp']
							);
			$cvideo['cid']=DB::insert('cai_video',($cvideo),1);
		}
		//如果原先的标题和描述没采集到，重新采集
		if(!$cvideo['title'] || !$cvideo['desc']){
			require_once dzz_libfile('class/caiji');
			$caiji=new caiji($link);
			$cvideo['title']=$caiji->getTitle();
			$cvideo['description']=$caiji->getDescription();
			 DB::update('cai_video',(array('title'=>$cvideo['title'],'desc'=>$cvideo['desc'])),"cid='{$cvideo[cid]}'");
		}
		$sourcedata=array(
				'uid'=>$_G['uid'],
				'username'=>$_G['username'],
				'url'=>$cvideo['url'],
				'icon'=>$cvideo['img'],
				'desc' =>$cvideo['desc'],
				'title' =>$cvideo['title'],
				'cid'=>$cvideo['cid'],
				'dateline' => $_G['timestamp'],
				'gid'=>$gid
		);
		if($sourcedata['vid']=DB::insert('source_video',($sourcedata),1)){
			C::t('cai_video')->update($cvideo['cid'],array('copys'=>$cvideo['copys']+1));
			$sourcedata['icon']=$sourcedata['icon']?$sourcedata['icon']:geticonfromext('','video');
			
			$icoarr=array(
							'uid'=>$_G['uid'],
							'username'=>$_G['username'],
							'oid'=>$sourcedata['vid'],
							'name'=>self::getFileName($sourcedata['title'],$fid),
							'img'=>'',
							'type'=>'video',
							'dateline'=>$_G['timestamp'],
							'pfid'=>$fid,
							'opuid'=>$_G['uid'],
							'gid'=>$gid,
							'ext'=>'swf',
							'flag'=>'',
							'size'=>0
						  );
			if($icoarr['icoid']=DB::insert('icos',($icoarr),1)){
				$icoarr['url']=$sourcedata['url'];
				$icoarr['img']=$sourcedata['icon'];
				$icoarr['bz']='';
				$icoarr['path']=$icoarr['icoid'];
				addtoconfig($icoarr);
				$icoarr['fsize']=formatsize($icoarr['size']);
				$icoarr['ftype']=getFileTypeName($icoarr['type'],$icoarr['ext']);
				$icoarr['fdateline']=dgmdate($icoarr['dateline']);
				//if($gid) C::t('group_log')->setLog($gid,$_G['uid'],'addvideo',lang('message','xiezuo_log_addvideo',array('username'=>$_G['username'],'position'=>getPositionName($fid),'name'=>$icoarr['name'])));
			}else{
				C::t('source_video')->delete_by_vid($sourcedata['vid']);
			}
		}
		if($icoarr['icoid'] ){
			return $icoarr;
		}else{
			return array('error' => lang('message','linktovideo_error'));
		}
	}
	
	public function linktourl($link,$pfid){
		global $_G;
		$fid=$pfid;
		$gid=DB::result_first("select gid from %t where fid =%d",array('folder',$pfid));
		$clink=array();
		if(!$clink=DB::fetch_first("select * from ".DB::table("cai_link")." where url='{$link}'")){
			$arr=array();
			require_once dzz_libfile('class/caiji');
			$caiji=new caiji($link);
			$arr['title']=$caiji->getTitle();
			$arr['description']=$caiji->getDescription();
			if($arr['title']){
				$clink=array(
					'url'=>$link,
					'img'=>'',
					'desc' =>$arr['description'],
					'title' => $arr['title'],
					'copys' => 0,
					'dateline'=>$_G['timestamp']
				);
				$clink['cid']=DB::insert('cai_link',($clink),1);
			}
		}
		$icondata=getUrlIcon($link);
		$sourcedata=array(
					'uid'=>$_G['uid'],
					'username'=>$_G['username'],
					'url'=>$link,
					'desc' =>$clink['desc'],
					'title' => $clink['title'],
					'cid'=>$clink['cid'],
					'did'=>$icondata['did'],
					'icon'=>$icondata['img'],
					'dateline'=>$_G['timestamp'],
					'gid'=>$gid
					
					);
		if($sourcedata['lid']=DB::insert('source_link',($sourcedata),1)){
			if($sourcedata['did']) C::t('icon')->update_copys_by_did($soucedata['did'],1);
			if($sourcedata['cid']) C::t('cai_link')->update($clink['cid'],array('copys'=>$clink['copys']+1));
			
			$icoarr=array(
							'uid'=>$_G['uid'],
							'username'=>$_G['username'],
							'oid'=>$sourcedata['lid'],
							'name'=>self::getFileName($sourcedata['title']?$sourcedata['title']:$link,$fid),
							'img'=>'',
							'flag'=>'',
							'type'=>'link',
							'dateline'=>$_G['timestamp'],
							'pfid'=>$fid,
							'opuid'=>$_G['uid'],
							'gid'=>$gid,
							'ext'=>'',
							'size'=>0
						);
			if($icoarr['icoid']=DB::insert('icos',($icoarr),1)){
				//$icoarr=array_merge($sourcedata,$icoarr);
				$icoarr['url']=$sourcedata['url'];
				$icoarr['img']=$sourcedata['icon'];
				$icoarr['bz']='';
				$icoarr['path']=$icoarr['icoid'];
				addtoconfig($icoarr);
				$icoarr['container']=$container;
				
				$icoarr['fsize']=formatsize($icoarr['size']);
				$icoarr['ftype']=getFileTypeName($icoarr['type'],$icoarr['ext']);
				$icoarr['fdateline']=dgmdate($icoarr['dateline']);
				//if($gid) C::t('group_log')->setLog($gid,$_G['uid'],'addlink',lang('message','xiezuo_log_addlink',array('username'=>$_G['username'],'position'=>getPositionName($fid),'name'=>$icoarr['name'])));
			}else{
				DB::delete('link',"lid='{$sourcedata[lid]}'");	
			}
		}
		if($icoarr['icoid'] ){
			return $icoarr;
		}else{
			return array('error' => lang('message','linktourl_error'));
		}
		
	}
		
	/**
	 * 移动文件到目标位置
	 * @param string $opath 被移动的文件路径
	 * @param string $path 目标位置（可能是同一api内或跨api，这两种情况分开处理）
	 * @return icosdatas
	 */
	public function CopyTo($icoid,$path,$iscopy){
		@set_time_limit(0);
		try{
			$data=self::getMeta($icoid);
			
			if(is_numeric($path)){//如果目标位置也是本地
				if(!$iscopy){
					
					if(!$tfolder=DB::fetch_first("select * from ".DB::table('folder')." where fid='{$path}'")){
						return array('error'=>' 目标位置不存在');
					}
					$newdata=$data;
					$newdata['pfid']=$tfolder['fid'];
					$newdata['gid']=$tfolder['gid'];
					$newdata['isdelete']=0;				
					C::t('icos')->update($icoid,array('pfid'=>$path,'isdelete'=>0,'gid'=>$tfolder['gid']));
					if($data['type']=='folder'){
						C::t('folder')->update($data['oid'],array('pfid'=>$path,'isdelete'=>0,'gid'=>$tfolder['gid']));
					}
					$data['newdata']=$newdata;
					$data['success']=true;
					
				}else{
					
					$re=self::FileCopy($icoid,$path,true);
					
					$data['newdata']=$re['icoarr'];
					$data['success']=true;
				}
				
			}else{
				
				switch($data['type']){
					case 'folder'://创建目录
						if($re=IO::CreateFolder($path,$data['name'])){
							//print_r($re);
							
							if(isset($re['error']) && intval($re['error_code'])!=31061){
								$data['success']=$arr['error'];
							}else{
								$data['newdata']=$re['icoarr'];
								$data['success']=true;
							
								 $contents=C::t('icos')->fetch_all_by_pfid($data['oid']);
								
								 foreach($contents as $key=>$value){
									$data['contents'][$key]=self::CopyTo($value['icoid'],$re['icoarr']['path']);
								 }
							}
						}
						break;
					case 'user':case 'link':case 'music':case 'video':case 'topic':case 'app'://这些内容不能移动到api网盘内；
						$data['success']=lang('message','datatype_not_accept');
						break;
					default:
						//echo('dddddddd='.$path.$data['name']);
						/*if(is_numeric($path)){//如果目标位置也是本地
							$re=self::FileCopy($icoid,$path);
							if($re['error']) $data['success']=$re['error'];
							else{
								$data['newdata']=$re['icoarr'];
								$data['success']=true;
							}
						}else{*/
						
							$re=IO::multiUpload($icoid,$path,$data['name']);
							//print_r($re);exit('dddddddd='.$path.$data['name']);	
							if($re['error']) $data['success']=$re['error'];
							else{
								$data['newdata']=$re;
								$data['success']=true;
							}
						//}
						break;
				}
			}
			//exit($opath);
		}catch(Exception $e){
			//var_dump($e);
			$data['success']=$e->getMessage();
			return $data;
		}
		return $data;
	}
	
	//本地文件复制到本地其它区域
	public function FileCopy($icoid,$pfid,$first=true){
		global $_G,$GET;
		if($icoarr=C::t('icos')->fetch($icoid)){
			//if(dzz_checkviewperm($icoarr)){
			$success=0;
			//判断空间大小
			if($icoarr['size'] && !SpaceSize($icoarr['size'],$gid)){ 
				return array('error' => lang('message','inadequate_capacity_space'));
			}
			//判断重复
			if($ricoid=self::getRepeatIDByName($icoarr['name'],$pfid)){//如果目录下有同名文件
				if($_GET['overwrite']){//覆盖
					 return array('icoarr'=>C::t('icos')->fetch_by_icoid($ricoid));
				}else $icoarr['name']=self::getFileName($icoarr['name'],$pfid); //重命名
			}
			switch($icoarr['type']){
				case 'folder':
					if($folder=C::t('folder')->fetch($icoarr['oid'])){
						$oldfid=$folder['fid'];
						$oldfolder=$folder;
						unset($folder['fid']);
						$folder['uid']=$_G['uid'];
						$folder['username']=$_G['username'];
						$folder['pfid']=$pfid;
						$folder['fname']=$icoarr['name'];
						$folder['gid']=$gid;
						//$folder['perm']=0;//拷贝时默认权限改为继承上级；
						
						if($folder['fid']=C::t("folder")->insert($folder,1)){
						  
							foreach(C::t('icos')->fetch_all_by_pfid($oldfid) as $value){
								self::FileCopy($value['icoid'],$folder['fid'],false);
							}
							$return['folderarr']=$folder;
							$icoarr['oid']=$folder['fid'];
							$success=1;
						}
					}else{
						return array('error',lang('message','folder_not_exist'));
					}
					break;
				case 'user':
					$success=1;
					break;
				case 'app':
					/*if($app=C::t('app_market')->fetch($icoarr['oid'])){
						DB::query("update ".DB::table('apps')." set setupnum=setupnum+1 where  appid='{$icoarr[oid]}'");
						C::t('app_market')->update($icoarr['oid'],array('setupnum'=>$app['setupnum']+1));
						$success=1;
					}else{
						return array('error',lang('message','app_not_exist'));
					}*/
					$success=1;
					break;
				
				case 'image':
					if($image=C::t('source_image')->fetch($icoarr['oid'])){
						$opicid=$image['picid'];
						unset($image['picid']);
						$image['uid']=$_G['uid'];
						$image['gid']=$gid;
						$image['username']=$_G['username'];
						if($image['picid']=DB::insert('source_image',$image,1)){
							if($image['aid'] && DB::query("update ".DB::table('attachment')." set copys=copys+1 where aid='{$image[aid]}'")){
								// C::t('attachment')->clear_cache($image['aid']);
							}
							$icoarr['oid']=$image['picid'];
							$success=1;
						}
					}else{
						return array('error',lang('message','image_not_exist'));
					}
					
					break;
				case 'video':
					if($video=C::t('source_video')->fetch($icoarr['oid'])){
						$video['uid']=$_G['uid'];
						$video['gid']=$gid;
						unset($video['vid']);
						$video['username']=$_G['username'];
						if($video['vid']=DB::insert('source_video',$video,1)){
							if($video['cid'] ) DB::query("update ".DB::table('cai_video')." set copys=copys+1 where cid='{$video[cid]}'");
								
							$icoarr['oid']=$video['vid'];
							$success=1;
						}
					}else{
						return array('error',lang('message','video_not_exist'));
					}
					break;
				case 'music':
					if($music=C::t('source_music')->fetch($icoarr['oid'])){
						unset($music['mid']);
						$music['uid']=$_G['uid'];
						$music['gid']=$gid;
						$music['username']=$_G['username'];
						if($music['mid']=DB::insert('source_music',$music,1)){
							if($music['cid']) DB::query("update ".DB::table('cai_music')." set copys=copys+1 where cid='{$music[cid]}'");
								
							$icoarr['oid']=$music['mid'];
							$success=1;
						}
					}else{
						return array('error',lang('message','video_not_exist'));
					}
					break;
				case 'link':
					if($link=C::t('source_link')->fetch($icoarr['oid'])){
						$olink=$link['lid'];
						unset($link['lid']);
						$link['uid']=$_G['uid'];
						$link['username']=$_G['username'];
						$link['gid']=$gid;
						if($link['lid']=DB::insert('source_link',$link,1)){
							if($link['cid']) DB::query("update ".DB::table('cai_link')." set copys=copys+1 where cid='{$link[cid]}'");
							if($link['did']) DB::query("update ".DB::table('icon')." set copys=copys+1 where did='{$link[did]}'");	
							$icoarr['oid']=$link['lid'];
							$success=1;
						}
					}else{
						return array('error',lang('message','link_not_exist'));
					}
					break;
				case 'attach':
					if($attach1=C::t('source_attach')->fetch($icoarr['oid'])){
						$oqid=$attach1['qid'];
						unset($attach1['qid']);
						$attach1['uid']=$_G['uid'];
						$attach1['username']=$_G['username'];
						$attach1['gid']=$gid;
						if($attach1['qid']=DB::insert('source_attach',$attach1,1)){
							if($attach1['aid'] && DB::query("update ".DB::table('attachment')." set copys=copys+1 where  aid='{$attach1[aid]}'")){
								C::t('attachment')->clear_cache($attach1['aid']);
							}
							
							$icoarr['oid']=$attach1['qid'];
							$success=1;
						}
					}else{
						return array('error',lang('message','attach_not_exist'));
					}
					break;
				case 'document':
					if($document=C::t('source_document')->fetch($icoarr['oid'])){
						$odid=$document['did'];
						unset($document['did']);
						$document['uid']=$_G['uid'];
						$document['username']=$_G['username'];
						$document['gid']=$gid;
						if($document['did']=DB::insert('source_document',$document,1)){
							if($document['aid'] && DB::query("update ".DB::table('attachment')." set copys=copys+1 where  aid='{$document[aid]}'")){
								C::t('attachment')->clear_cache($document['aid']);
							}
							$icoarr['oid']=$document['did'];
							$success=1;
						}
					}else{
						return array('error',lang('message','document_not_exist'));
					}
					break;
			}
			if($success){
				unset($icoarr['icoid']);
				$icoarr['gid']=$gid;
				$icoarr['uid']=$_G['uid'];
				$icoarr['username']=$_G['username'];
				$icoarr['pfid']=$pfid;
				
				if($icoarr['icoid']=DB::insert('icos',$icoarr,1) ){
					if($icoarr['size']>0){
						SpaceSize($icoarr['size'],$gid,1);
					}
					if(!$first){
						addtoconfig($icoarr);
					}else{
						$return['icoarr']=C::t('icos')->fetch_by_icoid($icoarr['icoid']);
						
						return $return;
					}
				}else{
					return array('error'=>'此类文件不允许复制');
				}
			}
		}
		return array('error'=>'copy error');
	}
	
	
	/*
		表单上传文件保存到attachment表，返回attach数组
	*/
	 function UploadSave($FILE,$target,$filename,$ext) {
	 global $_G;
	 	set_time_limit(0);
		if(!save_to_local($FILE['tmp_name'], $_G['setting']['attachurl'].$target.$filename.'.'.$ext)){
            return false;
        }
        $md5=md5_file($_G['setting']['attachurl'].$target.$filename.'.'.$ext);
	
		if($md5 && $attach=DB::fetch_first("select * from ".DB::table('attachment')." where md5='{$md5}'")){
			$attach['filename']=$FILE['name'];
			@unlink($_G['setting']['attachdir'].$target.$filename.'.'.$ext);
			return $attach;
		}else{
			$remote=MoveAttachToAliyun(str_replace('/','-',$target.$filename.'.'.$ext),$_G['setting']['attachdir'].$target.$filename.'.'.$ext);
			
        	$attach=array(
				'filesize'=>$FILE['size'],
				'attachment'=>$target.$filename.'.'.$ext,
				'filetype'=>strtolower($ext),
				'filename' =>$FILE['name'],
				'remote'=>$remote,
				'copys' => 0,
				'md5'=>$md5,
				'needpdf'=>0,
				'pdf'=>0,
				'dateline' => $_G['timestamp'],
			);
			if($attach['aid']=DB::insert('attachment',($attach),1)){
				if($needpdf) dfsockopen(CONVERTURL,0, '', '', FALSE, '',1);
				return $attach;
			}else{
				return false;
			}
		}
    }


	public function multiUpload($opath,$path,$filename,$ondup="newcopy"){
	/* 
	 * 分块上传文件
	 * param $file:文件路径（可以是url路径，需要服务器开启allow_url_fopen);
	*/
		@set_time_limit(0);
		$partsize=1024*1024*2; //分块大小2M
		$data=IO::getMeta($opath);
		if($data['error']) return $data;
		$size=$data['size'];
		if(!$filepath=IO::getFileUri($opath)){
			return array('error'=>'文件不存在');
		}
		if($size<$partsize){
			//获取文件内容
			$fileContent='';
			$handle=fopen($filepath, 'rb');
			while (!feof($handle)) {
			  $fileContent .= fread($handle, 8192);
			 // if(strlen($fileContent)==0) return array('error'=>'文件不存在');
			}
			fclose($handle);
			return self::upload($fileContent,$path,$filename);
		}else{ //分片上传
		
			$partinfo=array('ispart'=>true,'partnum'=>0,'flag'=>$path,'iscomplete'=>false);
			$handle=fopen($filepath, 'rb');
			stream_set_timeout($handle,5);
			$fileContent='';
			while (!feof($handle)) {
			  $fileContent .= fread($handle, 8192);
			 // if(strlen($fileContent)==0) return array('error'=>'文件不存在');
			  if(strlen($fileContent)>=$partsize){
				  $partinfo['partnum']+=1;
			  	  if($partinfo['partnum']*$partsize>=$size) $partinfo['iscomplete']=true;
				  if($re=self::upload($fileContent,$path,$filename,$partinfo)){
					  if($re['error']) return $re;
					 if($partinfo['iscomplete']) return $re;
				  }
				  $fileContent='';
			  }
			}
			fclose($handle); 
			if(!empty($fileContent)){
				$partinfo['partnum']+=1;
				$partinfo['iscomplete']=true;
				if($re=self::upload($fileContent,$path,$filename,$partinfo)){
					if($re['error']) return $re;
					if($partinfo['iscomplete']) return $re;
				}
			}
				  
		}
	}
}
?>
