<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */

//php 权限控制类
	
/*权限表说明:
位   描述       	权限值  描述
1    delete			1       不允许删除；
2 	 edit     		2		不允许编辑	
3 	 rename   		4		不允许重命名
4	 move			8		不允许移动
5 	 down			16		不允许下载
6	 share			32		不允许分享
7 	 widget			64		不允许添加挂件
8 	 wallpaper		128		不允许设为壁纸



有新的权限在这里添加 
由于数据库存储是smallint(6),最大支持16位权限；（32位系统最多支持32位，64位系统最多支持64位；
 */ 
class perm_FileSPerm{  
  public function getPerm($action){
	  $powerarr=array(  	'delete	'	=>	1,       // 不允许删除；
							'edit'     	=>	2,		//不允许编辑	
							'rename'   	=>	4,		//不允许重命名
							'move'		=>	8,		//不允许移动
							'down'		=>	16,		//不允许下载
							'share'		=>	32,		//不允许分享
							'widget'	=>	64,		//不允许添加挂件
							'wallpaper'	=>	128,	//不允许设为壁纸
					);
	return  intval($powerarr[$action]);
  }
  public function isPower($perm,$action){  
    //权限比较时，进行与操作，得到0的话，表示没有权限
	if(self::getPerm($action)<1) return true;
    if((intval($perm) & self::getPerm($action)) == self::getPerm($action) ) return false;  
    return true;  
  }  
 
 public function typePower($type,$ext){ //返回类型的权限
 	global $textexts;
	  switch($type){
		 case 'document'://不能设为壁纸
		 	if(in_array(strtoupper($ext),$textexts)) return 192;
			return 194;
		case 'attach'://edit,widget,wallpaper
			return 194;
		case 'app'://不能设为壁纸，不能下载，不能编辑
			return 146;
		case 'user'://不能设为壁纸，不能下载，不能编辑，不能设为挂件，不能分享
			return 242;
		case 'image': //edit
			return 2;
		case 'video': case 'music':case 'link'://edit,down,wallpaper
			return 146;
		case 'folder': //edit，down,widget,wallpaper
			return 210;
		default:
			return 0;
	  }
  }
  public function flagPower($flag){ //返回默认目录的权限
	  switch($flag){
		  case 'home':case 'document': case 'image': case 'video': case 'music': case 'app':case 'desktop':case 'dock':case 'recycle':
			return 255;
		case 'dropbox':
			return 255;
		default:
			return 255;
	  }
  }
}  
?>
