<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */

//php 权限控制类
	
/*权限表说明:
位   描述       	权限值  描述
1    delete			1       不允许删除；
2 	 newfolder     	2		不允许新建文件夹	
3 	 newlink   		4		不允许新建链接
4	 upload			8		不允许上传
5 	 newdoc			16		不允许新建文档
6	 newtopic		32		不允许新建话题
7 	 newapp			64		不允许添加应用
8 	 newwidget		128		不允许添加挂件
9    newuser		256



有新的权限在这里添加 
由于数据库存储是smallint(6),最大支持16位权限；（32位系统最多支持32位，64位系统最多支持64位；
 */ 
class perm_FolderSPerm{  
 public function getPerm($action){
	 $powerarr=array( 'delete'    	=> 1,		//标志位为1表示权限设置,否则表示未设置，继承上级；
  					  'folder' 		=> 2,		//允许上传
					  'link'   		=> 4,		//允许新建文件
					  'upload'   	=> 8,		//允许添加网址
					  'document'    => 16,	//允许添加文档
					  'topic'  		=> 32,	//允许添加图片
					  'app'	  		=> 64,	//允许添加音乐
					  'widget' 		=> 128,	//允许添加视频	
					  'user'        => 256,
					);
	return  intval($powerarr[$action]);
  }
 
  public function isPower($perm,$action){  
    //权限比较时，进行与操作，得到0的话，表示没有权限
	if(self::getPerm($action)<1) return true;
    if((intval($perm) & self::getPerm($action)) == self::getPerm($action) ) return false;  
    return true;  
  }  
 public function flagPower($flag){ //返回默认目录的权限
	  switch($flag){
		 case 'home':case 'dock':
			return 0;
		case 'recycle':
			return 510;
		/* case 'document': case 'image': case 'video': case 'music': case 'app':case 'desktop':case 'dock':
			return 0;*/
		 case 'dropbox': //不能 link(4),app(64),topic(32),widget(128),user(256)
		 	return 484;
		case 'baiduPCS': //不能 link(4),app(64),topic(32),widget(128),user(256)
			return 484;
		case 'ALIOSS': //不能 link(4),app(64),topic(32),widget(128),user(256)
			return 484;
		
		case 'ALIOSS_root': //全不能 
			return 511;
		default:
			return 0;
	  }
  }
}  
?>
