<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */

if(!defined('IN_DZZ')) {
	exit('Access Denied');
}

class table_app_market extends dzz_table
{
	public function __construct() {

		$this->_table = 'app_market';
		$this->_pk    = 'appid';
		$this->_pre_cache_key = 'app_market_';
		$this->_cache_ttl = 0;

		parent::__construct();
	}
	public function fetch_by_appid($appid,$havecount=false){ //返回一条数据同时加载统计表数据
	 global $_G;
		$appid = intval($appid);
		if(!$data=self::fetch($appid)) return array();
		if($data['appico']!='dzz/images/default/icodefault.png' && !preg_match("/^(http|ftp|https|mms)\:\/\/(.+?)/i", $data['appico'])){
			$data['appico']=$_G['setting']['attachurl'].$data['appico'];
		}
		$data['fileext']=$data['fileext']?explode(',',$data['fileext']):array();
		$data['icon']=$data['appico'];
		$data['title']=$data['appname'];
		$data['url']=replace_canshu($data['appurl']);
		if($havecount){
			$count=C::t('count')->fetch_by_type($appid,'app');
			$data['viewnum']=intval($count['viewnum']);
			$data['replynum']=intval($count['replynum']);
			$data['downnum']=intval($count['downnum']);
			$data['star']=intval($count['star']);
			$data['starnum']=intval($count['starnum']);
		}
		return $data;
	}
	public function fetch_all_by_appid($appids,$havecount=false){ //返回数据同时加载统计表数据
		 global $_G;
		 if(!$appids) return false;
		 if(!is_array($appids)){
			 $appids=array($appids);
		 }
		 $return=array();
		 foreach($appids as $appid){
			$appid = intval($appid);
			if(!$data=self::fetch($appid)) continue;
			if($data['appico']!='dzz/images/default/icodefault.png' && !preg_match("/^(http|ftp|https|mms)\:\/\/(.+?)/i", $data['appico'])){
				$data['appico']=$_G['setting']['attachurl'].$data['appico'];
			}
			$data['fileext']=$data['fileext']?explode(',',$data['fileext']):array();
			$data['icon']=$data['appico'];
			$data['title']=$data['appname'];
			$data['url']=replace_canshu($data['appurl']);
			if($havecount){
				$count=C::t('count')->fetch_by_type($appid,'app');
				$data['viewnum']=intval($count['viewnum']);
				$data['replynum']=intval($count['replynum']);
				$data['downnum']=intval($count['downnum']);
				$data['star']=intval($count['star']);
				$data['starnum']=intval($count['starnum']);
			}
			$return[$appid]=$data;
		}
		return $return;
	}
	public function delete_by_appid($appids){ //删除应用
	    if(!is_array($appids)) $appids=array(intval($appids));
		
		$data=DB::fetch_all("SELECT * FROM %t WHERE appid IN(%n)",array($this->_table,$appids));
		foreach($data as $value){
			
			C::t('app_pic')->delete_by_appid($value['appid']);
			
			C::t('icos')->delete_by_appid($value['appid']);
			C::t('app_open')->delete_by_appid($value['appid']);
			C::t('app_relative')->delete_by_appid($value['appid']);
			C::t('app_organization')->delete_by_appid($value['appid']);
		}
		$this->delete($appids);
		return true;
	}
	/*public function fetch_all_by_tagid($classid,$count=false,$force=false){
		if($force || ($data = $this->fetch_cache(intval($classid),'app_market_class_') === false)) {
			$data=DB::fetch_all("select * from %t where classid= %d ",array($this->_table,$classid));
			if(!empty($data)) $this->store_cache(intval($classid), $data, 3600,'app_market_class_');
		}
		return $count?count($data):$data;
	}*/
	
	public function get_appid_by_appurl($appurl){ //删除应用
	  	return DB::fetch_all("select appid from %t where appurl=%s",array($this->_table,$appurl));
		
	}
	public function fetch_all_by_notdelete($uid){ //取得所有默认不能删除的应用
		if($space=getuserbyuid($uid)){
			if($space['adminid']==1) $sql="`position`>0 "; //系统管理员
			else{								//普通成员
				//属于普通用户应用但不属于特定部门的应用
				$sql="`position`>0 and (`group`='1' or `group`='0')";
					//获取所有部门的应用
				if($paichu_appids=C::t('app_organization')->fetch_notin_appids_by_uid($uid)){
					$sql.=" and appid NOT IN (".dimplode($paichu_appids).") ";
				}	
			}
		}else{ //游客
			$sql="`position`>0 and (`group`='-1' or `group`='0')";
		}
	  	return DB::fetch_all("select * from %t where $sql and  notdelete>0 ",array($this->_table),'appid');
	}
	public function fetch_all_by_default($uid){ //取得所有默认的应用
		if($space=getuserbyuid($uid)){
			if($space['adminid']==1) $sql="`position`>0 "; //系统管理员
			else{								//普通成员
				//属于普通用户应用但不属于特定部门的应用
				$sql="`position`>0 and (`group`='1' or `group`='0')";
					//获取所有部门的应用
				if($paichu_appids=C::t('app_organization')->fetch_notin_appids_by_uid($uid)){
					$sql.=" and appid NOT IN (".dimplode($paichu_appids).") ";
				}	
				
			}
		}else{ //游客
			$sql="`position`>0 and (`group`='-1' or `group`='0')";
		}
		//exit($sql);
	  	return DB::fetch_all("select * from %t where $sql order by disp ",array($this->_table),'appid');
	}
}

?>
