<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
if(!defined('IN_DZZ')) {
	exit('Access Denied');
}

class table_app_open extends dzz_table
{
	public function __construct() {
		$this->_table = 'app_open';
		$this->_pk    = 'extid';
		$this->_pre_cache_key = 'app_open_';
		$this->_cache_ttl =0;
		parent::__construct();
	}
	public function delete_by_appid($appid){
		if(!$appid) return false;
		$this->clear_cache('ext_all');
		$this->clear_cache('all');
		return DB::delete($this->_table," appid='{$appid}'");
	}

	public function insert_by_exts($appid,$exts){
		if(!$exts || !$appid) return false;
		if(!is_array($exts)) $exts=array($exts);
		//删除原来的ext
		self::delete_by_appid($appid);
		foreach($exts as $ext){
			DB::insert('app_open',array('ext'=>$ext,'appid'=>$appid));
		}
		$this->clear_cache('ext_all');
		$this->clear_cache('all');
		return true;
	}
	
	public function fetch_all_ext(){
		$data = array();
		if(($data = $this->fetch_cache('all')) === false) {
			$data = array();
			$query=DB::query("SELECT * FROM %t WHERE 1 ",array($this->_table));
			while($value=DB::fetch($query)){
				if($value['appid']){
					 if($app=C::t('app_market')->fetch_by_appid($value['appid'],false)){
						 if(!$value['icon']) $value['icon']=$app['appico'];
						 if(!$value['name']) $value['name']=$app['appname'];
						 if(!$value['url']) $value['url']=$app['appurl'];
						 if(!$value['nodup']) $value['nodup']=$app['nodup'];
						 if(!$value['feature']) $value['feature']=$app['feature'];
					 }else{
						continue; 
					 }
				}
				$value['url']=replace_canshu($value['url']);
				$data[$value['extid']]=$value;
			}
			if(!empty($data)) $this->store_cache('all', $data);
		}
		return $data;
	}
	public function fetch_all_orderby_ext($uid){
		$data = array();
		if(($data = $this->fetch_cache('ext_all')) === false) {
			$appids=C::t('icos')->fetch_appids_by_uid($uid);
			$query=DB::query("SELECT ext,extid,appid FROM %t WHERE 1 ORDER BY ext,isdefault DESC , disp ",array($this->_table));
			while($value=DB::fetch($query)){
				if($value['appid'] && !in_array($value['appid'],$appids)){
					continue;
				}
				$data[$value['ext']][]=$value['extid'];
			}
			if(!empty($data)) $this->store_cache('ext_all', $data);
		}
		return $data;
		
	}
	
}
?>
