<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */

if(!defined('IN_DZZ')) {
	exit('Access Denied');
}

class table_app_organization extends dzz_table
{
	public function __construct() {

		$this->_table = 'app_organization';
		$this->_pk    = '';
		parent::__construct();
	}
	public function insert($appid, $orgid) {
		return DB::insert($this->_table, array("orgid"=>$orgid,'appid'=>$appid,'dateline'=>TIMESTAMP),1,1);
	}
	public function delete_by_appid($appid) {
		return DB::delete($this->_table, "appid='{$appid}'");
	}
	public function delete_by_orgid($orgids) {
		if(!$orgids) return;
		if(!is_array($orgids)) $orgids=array($orgids);
		return DB::delete($this->_table, "orgid IN (".dimplode($orgids).")");
	}
	public function fetch_appids_by_orgid($orgids){
		$uids=array();
		if(!is_array($orgids)) $orgids=array($orgids);
		$query=DB::query("select appid from %t where orgid IN(%n)",array($this->_table,$orgids));
		while($value=DB::fetch($query)){
			$appids[]=$value['appid'];
		}
		return $appids;
	}
	public function fetch_notin_appids_by_uid($uid){
		//获取所有部门的应用
		$Oappids=array();$paichu_appids=array();
		foreach(DB::fetch_all("select appid from %t where 1 ",array($this->_table)) as $value){
			$Oappids[$value['appid']]=$value['appid'];
		}
		if($Oappids ){
			//获取属于当前用户所在部门的应用
			//获取次用户所在的部门orgids;
			$orgids=array();
			include_once libfile('function/organization');
			foreach(C::t('organization_user')->fetch_orgids_by_uid($uid) as $orgid => $value){
				$parentids=getUpOrgidTree($orgid);
				$orgids=array_merge($orgids,$parentids);
			};
			$appids=array();
			$appids=C::t('app_organization')->fetch_appids_by_orgid($orgids);
			foreach($Oappids as $appid){
				if(!in_array($appid ,$appids)){
					$paichu_appids[]=$appid;	
				}
			}
		}
		return $paichu_appids;	
	}
	public function fetch_orgids_by_appid($appid){
		$orgids=array();
		$arr=DB::fetch_all("select orgid from %t where appid = %d ",array($this->_table,$appid));
		foreach($arr as $value){
			$orgids[]=$value['orgid'];
		}
		return $orgids;
	}
	
	
}
?>
