<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */

if(!defined('IN_DZZ')) {
	exit('Access Denied');
}

class table_organization extends dzz_table
{
	private $_uids = array();
	public function __construct() {

		$this->_table = 'organization';
		$this->_pk    = 'orgid';
		$this->_pre_cache_key = 'organization_';
		$this->_cache_ttl = 0;
		parent::__construct();
	}
	public function fetch_all_by_forgid($forgid,$count){
		if($count) return DB::result_first("SELECT COUNT(*) FROM %t WHERE forgid= %d",array($this->_table,$forgid));
		return DB::fetch_all("SELECT * FROM %t WHERE forgid= %d ORDER BY disp DESC",array($this->_table,$forgid),'orgid');
	}
	public function delete_by_orgid($orgid){
		$org=parent::fetch($orgid);
		if($org['fid']){
			C::t('folder')->delete_by_fid($org['fid']);
		}
		C::t('organization_user')->delete_by_orgid($orgid);
		return parent::delete($orgid);
	}

	public function insert_by_forgid($setarr){
		
		if($setarr['orgid']=self::insert($setarr,true)){
			$toporgid=self::getTopOrgid($setarr['orgid']);
			if($toporgid==$setarr['orgid']){
				$pfid=0;
			}else{
				$pfid=DB::result_first("select fid from ".DB::table($this->_table)." where orgid='{$toporgid}'");
			}
			if($fid=DB::result_first("select fid from ".DB::table('folder')." where gid='{$setarr[orgid]}' and uid='0'  and flag='organization'")){
				C::t('folder')->update($fid,array('fname'=>$setarr['orgname'],'display'=>$setarr['disp'],'pfid'=>$pfid,'perm'=>3));
				self::update($setarr['orgid'],array('fid'=>$fid));
			}else{
				$folder=array('fname'=>$setarr['orgname'],
						  'pfid'=>$pfid,
						  'display'=>$setarr['disp'],
						  'flag'=>'organization',
						  'gid'=>$setarr['orgid'],
						  'perm'=>3,
						  );
				$fid=C::t('folder')->insert($folder,true);
			}
			if($fid){
				self::update($setarr['orgid'],array('fid'=>$fid));
				return true;
			}else{
				return false;
			}
		}
		return false;
	}
	public function update_by_orgid($orgid,$setarr){
		if(!$org=self::fetch($orgid)) return false;
		$toporgid=self::getTopOrgid($orgid);
		if($toporgid==$orgid){
			$pfid=0;
		}else{
			$pfid=DB::result_first("select fid from ".DB::table($this->_table)." where orgid='{$toporgid}'");
		}
		if($fid=DB::result_first("select fid from ".DB::table('folder')." where gid='{$orgid}' and uid='0'  and flag='organization'")){
			C::t('folder')->update($fid,array('fname'=>$setarr['orgname'],'display'=>$setarr['disp'],'pfid'=>$pfid,'perm'=>3));
			$setarr['fid']=$fid;
			self::update($orgid,$setarr);
			return true;
		}else{
			$folder=array('fname'=>$setarr['orgname'],
						  'pfid'=>$pfid,
						  'display'=>$setarr['disp'],
						  'flag'=>'organization',
						  'gid'=>$orgid,
						   'perm'=>3,
						 );
			if($setarr['fid']=C::t('folder')->insert($folder,true)){
				self::update($setarr['orgid'],$setarr);
				return true;
			}
		}
		return false;
	}
	public function getTopOrgid($orgid){
		
		$ids=getUpOrgidTree($orgid);
		$ids=array_reverse($ids);
		return $ids[0];
	}
}

?>
