<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
if(!defined('IN_DZZ')) {
	exit('Access Denied');
}

class table_organization_user extends dzz_table
{
	public function __construct() {

		$this->_table = 'organization_user';
		$this->_pk    = '';
		parent::__construct();
	}
	public function insert($uid, $orgid,$ismoderator=0) {
		return DB::insert($this->_table, array("orgid"=>$orgid,'uid'=>$uid,'ismoderator'=>$ismoderator,'dateline'=>TIMESTAMP),1,1);
	}
	public function delete_by_uid($uid) {
		return DB::delete($this->_table, "uid='{$uid}'");
	}
	public function delete_by_orgid($orgids) {
		if(!$orgids) return;
		if(!is_array($orgids)) $orgids=array($orgids);
		return DB::delete($this->_table, "orgid IN (".dimplode($orgids).")");
	}
	public function fetch_uids_by_orgid($orgids){
		$uids=array();
		if(!is_array($orgids)) $orgids=array($orgids);
		$query=DB::query("select uid from %t where orgid IN(%n)",array($this->_table,$orgids));
		while($value=DB::fetch($query)){
			$uids[]=$value['uid'];
		}
		return $uids;
	}
	public function fetch_orgids_by_uid($uid){
		$orgids=array();
		$arr=DB::fetch_all("select orgid from %t where uid = %d ",array($this->_table,$uid));
		foreach($arr as $value){
			$orgids[]=$value['orgid'];
		}
		return $orgids;
	}
	public function fetch_moderators_by_orgid($orgids,$onlyuid=false){
		$uids=array();
		if(!is_array($orgids)) $orgids=array($orgids);
	
		$arr=DB::fetch_all("select uid from %t where ismoderator>0 and orgid IN(%n)",array($this->_table,$orgids));
		foreach($arr as $value){
			$uids[]=$value['uid'];
		}
		if($onlyuid) return $uids;
		else return C::t('user')->fetch_all($uids);
	}
	public function remove_moderators_by_orgid($orgids){
		if(!$orgids) return false;
		if($orgids && !is_array($orgids)) $orgids=array($orgids);
		return DB::update($this->_table,array('ismoderator'=>0),"orgid IN (".dimplode($orgids).")");
	}
}

?>
