<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */

if(!defined('IN_DZZ')) {
	exit('Access Denied');
}

class table_usergroup_field extends dzz_table
{
	public function __construct() {

		$this->_table = 'usergroup_field';
		$this->_pk    = 'groupid';

		parent::__construct();
	}

	

	public function fetch_all() {
		return DB::fetch_all("SELECT * FROM %t where 1", array($this->_table),$this->_pk);
	}

	public function count_by_field($field, $val, $glue = '=') {
		$allowedfield = array('allowposttrade');
		if(!in_array($field, $allowedfield)) {
			return null;
		}
		return DB::result_first('SELECT count(*) FROM %t WHERE %i', array($this->_table, DB::field($field, $val, $glue)));
	}

	public function fetch_table_struct($result = 'FIELD') {
		$datas = array();
		$query = DB::query('DESCRIBE %t', array($this->_table));
		while($data = DB::fetch($query)) {
			$datas[$data['Field']] = $result == 'FIELD' ? $data['Field'] : $data;
		}
		return $datas;
	}

}

?>
